/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDF3DLightingScheme
extends PDFCosDictionary {
    public static final ASName k_Artwork = ASName.create("Artwork");
    public static final ASName k_None = ASName.create("None");
    public static final ASName k_White = ASName.create("White");
    public static final ASName k_Day = ASName.create("Day");
    public static final ASName k_Night = ASName.create("Night");
    public static final ASName k_Hard = ASName.create("Hard");
    public static final ASName k_Primary = ASName.create("Primary");
    public static final ASName k_Blue = ASName.create("Blue");
    public static final ASName k_Red = ASName.create("Red");
    public static final ASName k_Cube = ASName.create("Cube");
    public static final ASName k_CAD = ASName.create("CAD");
    public static final ASName k_Headlamp = ASName.create("Headlamp");

    private PDF3DLightingScheme(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DLightingScheme newInstance(PDFDocument pdfDocument, ASName key_Subtype) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Subtype == null) {
            throw new PDFInvalidDocumentException("Subtype is required when creating newInstance of PDF3DLightingScheme.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDF3DLightingScheme pdfObject = new PDF3DLightingScheme(cosObject);
        pdfObject.setSubtype(key_Subtype);
        return pdfObject;
    }

    public static PDF3DLightingScheme getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DLightingScheme pdfObject = (PDF3DLightingScheme)PDFCosObject.getCachedInstance(cosObject, PDF3DLightingScheme.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DLightingScheme(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(ASName.k_3DLightingScheme)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Type.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Subtype);
    }

    public void setSubtype(ASName subtype) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (subtype == null) {
            throw new PDFInvalidParameterException("Subtype is a required key therefore cannot be removed.");
        }
        if (!(subtype.equals(k_Artwork) || subtype.equals(k_None) || subtype.equals(k_White) || subtype.equals(k_Day) || subtype.equals(k_Night) || subtype.equals(k_Hard) || subtype.equals(k_Primary) || subtype.equals(k_Blue) || subtype.equals(k_Red) || subtype.equals(k_Cube) || subtype.equals(k_CAD) || subtype.equals(k_Headlamp))) {
            throw new PDFInvalidParameterException("Value " + subtype + " is outside of bound for Subtype.");
        }
        this.setDictionaryNameValue(ASName.k_Subtype, subtype);
    }

    public ASName requireSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_Subtype);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Subtype.");
        }
        return name;
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Subtype);
    }
}

