/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.webcapture;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.webcapture.PDFSPSObjectArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.webcapture.PDFSpiderContentSet;

public class PDFSpiderContentSetSPS
extends PDFSpiderContentSet {
    private PDFSpiderContentSetSPS(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFSpiderContentSetSPS(PDFDocument pdfDoc, ASName subType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(pdfDoc, subType);
    }

    public static PDFSpiderContentSetSPS newInstance(PDFDocument pdfDocument, PDFSPSObjectArray key_Objects) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Objects == null) {
            throw new PDFInvalidParameterException("Objects is required when creating newInstance of PDFSpiderContentSetSPS.");
        }
        PDFSpiderContentSetSPS pdfObject = new PDFSpiderContentSetSPS(pdfDocument, ASName.k_SPS);
        pdfObject.setO(key_Objects);
        return pdfObject;
    }

    public static PDFSpiderContentSetSPS getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSpiderContentSetSPS pdfObject = (PDFSpiderContentSetSPS)PDFCosObject.getCachedInstance(cosObject, PDFSpiderContentSetSPS.class);
        if (pdfObject == null) {
            pdfObject = new PDFSpiderContentSetSPS(cosObject);
        }
        return pdfObject;
    }

    @Override
    public PDFSPSObjectArray getO() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSPSObjectArray.getInstance(this.getDictionaryCosObjectValue(ASName.k_O));
    }

    public void setO(PDFSPSObjectArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (children == null) {
            throw new PDFInvalidParameterException("O is a required key therefore cannot be removed.");
        }
        this.setDictionaryArrayValue(ASName.k_O, children.getCosArray());
    }

    public ASString getTitle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_T);
    }

    public void setTitle(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_T, value);
    }

    public void setTitle(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_T, value);
    }

    public boolean hasTitle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_T);
    }

    public ASString getTextID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_TID);
    }

    public void setTextID(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_TID, value);
    }

    public void setTextID(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryByteArrayValue(ASName.k_TID, value);
    }

    public boolean hasTextID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_TID);
    }
}

