/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidStructureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCID;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCR;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureOBJR;

public class PDFStructureContentFactory {
    public static PDFStructureContentInterface getInstance(CosObject cosObject) throws PDFInvalidStructureException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosUtils.checkNullCosObject(cosObject) == null) {
            return null;
        }
        switch (cosObject.getType()) {
            case 5: {
                return PDFStructureContentArray.getInstance(cosObject);
            }
            case 6: {
                if (((CosDictionary)cosObject).containsKey(ASName.k_Type)) {
                    ASName type = ((CosDictionary)cosObject).getName(ASName.k_Type);
                    if (type == ASName.k_OBJR) {
                        return PDFStructureOBJR.getInstance(cosObject);
                    }
                    if (type == ASName.k_MCR) {
                        return PDFStructureMCR.getInstance(cosObject);
                    }
                    if (type == ASName.k_StructElem) {
                        return PDFStructureElement.getInstance(cosObject);
                    }
                    throw new PDFInvalidStructureException("Invalid structure: unknown content item type");
                }
                return PDFStructureElement.getInstance(cosObject);
            }
            case 1: {
                return PDFStructureMCID.getInstance(cosObject);
            }
            case 0: {
                return null;
            }
        }
        throw new PDFInvalidStructureException("Invalid structure: unknown content item type");
    }
}

