/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.PDFDocEncoding;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedEmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionColors;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionField;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionFieldType;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionFolder;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionItemData;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSchema;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionSubItem;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFPortableCollection;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.pdf.utils.UTF16Support;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class PDFCollectionUtil {
    static final long FOLDER_FREE_ID_MIN = 0L;
    static final long FOLDER_FREE_ID_MAX = Integer.MAX_VALUE;

    static void setColor(double[] color, ASName name, PDFCollectionColors pdfCollectionColors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (color == null) {
            pdfCollectionColors.removeValue(name);
            return;
        }
        if (color.length != 3) {
            throw new PDFInvalidDocumentException(name.toString() + " is not an array of 3 numbers");
        }
        ArrayList<CosNumeric> l = new ArrayList<CosNumeric>(3);
        for (int i = 0; i < 3; ++i) {
            if (color[i] < 0.0 || color[i] > 1.0) {
                throw new PDFInvalidDocumentException(name.toString() + " color needs to be in the range 0 to 1");
            }
            l.add(i, pdfCollectionColors.getCosObject().getDocument().createCosNumeric(color[i]));
        }
        pdfCollectionColors.setDictionaryValue(name, PDFCosUtils.newCosArray(pdfCollectionColors.getPDFDocument(), l));
    }

    static double[] getColor(ASName name, PDFCollectionColors pdfCollectionColors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfCollectionColors.dictionaryContains(name)) {
            CosArray colorCosArray = pdfCollectionColors.getDictionaryArrayValue(name);
            if (colorCosArray.size() != 3) {
                throw new PDFInvalidDocumentException(name.toString() + " is not an array of 3 numbers");
            }
            double[] colorArray = colorCosArray.getArrayDouble();
            for (int i = 0; i < 3; ++i) {
                if (!(colorArray[i] < 0.0) && !(colorArray[i] > 1.0)) continue;
                throw new PDFInvalidDocumentException(name.toString() + " color needs to be in the range 0 to 1");
            }
            return colorArray;
        }
        return null;
    }

    static boolean checkPDFCollectionItemData(ASName name, PDFCollectionItemData collectionItemData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject data = collectionItemData.getCosObject();
        if (collectionItemData.mChecked) {
            return collectionItemData.mIsValid;
        }
        if (name.equals(ASName.k_Type)) {
            return false;
        }
        boolean goodData = false;
        PDFPortableCollection collection = collectionItemData.getPDFDocument().requireCatalog().getCollection();
        if (collection == null) {
            return goodData;
        }
        PDFCollectionSchema schema = collection.getSchema();
        if (schema == null) {
            return goodData;
        }
        PDFCollectionField field = schema.get(name);
        if (field == null) {
            return goodData;
        }
        PDFCollectionFieldType fieldType = field.getFieldType();
        if (fieldType.equal(PDFCollectionFieldType.text) && data.getType() == 4) {
            collectionItemData.mIsText = true;
            goodData = true;
        }
        if (fieldType.equal(PDFCollectionFieldType.date) && data.getType() == 4) {
            collectionItemData.mIsDate = true;
            goodData = true;
        }
        if (fieldType.equal(PDFCollectionFieldType.number) && data.getType() == 1) {
            collectionItemData.mIsNumber = true;
            goodData = true;
        }
        collectionItemData.mIsValid = goodData;
        collectionItemData.mChecked = true;
        return goodData;
    }

    public static PDFCollectionItemData copyTo(PDFDocument targetDoc, PDFCollectionItemData srcData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionItemData targetData = null;
        if (srcData.isDate()) {
            targetData = PDFCollectionItemData.newInstance(targetDoc, srcData.getDate(), srcData.mFieldName);
        } else if (srcData.isNumber()) {
            targetData = PDFCollectionItemData.newInstance(targetDoc, srcData.getNumber(), srcData.mFieldName);
        } else if (srcData.isText()) {
            targetData = PDFCollectionItemData.newInstance(targetDoc, srcData.getText(), srcData.mFieldName);
        }
        return targetData;
    }

    public static PDFCollectionSubItem copyTo(PDFDocument targetDoc, PDFCollectionSubItem srcSubItem) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionItemData srcData = srcSubItem.getData();
        return PDFCollectionSubItem.newInstance(targetDoc, srcData != null ? PDFCollectionUtil.copyTo(targetDoc, srcData) : null, srcSubItem.getPrefix(), srcSubItem.mFieldKey);
    }

    public static List<PDFTree.Entry> getEmbeddedFilesFromPDFDoc(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNameDictionary names = pdfDoc.requireCatalog().getNameDictionary();
        if (names == null) {
            return null;
        }
        PDFNamedEmbeddedFiles embeddedFilesTree = names.getNamedEmbeddedFiles();
        if (embeddedFilesTree == null) {
            return null;
        }
        ArrayList<PDFTree.Entry> embeddedFiles = new ArrayList<PDFTree.Entry>();
        Iterator<PDFTree.Entry> filesIter = embeddedFilesTree.iterator();
        while (filesIter.hasNext()) {
            embeddedFiles.add(filesIter.next());
        }
        return embeddedFiles;
    }

    public static List<PDFTree.Entry> sortEmbeddedFiles(List<PDFTree.Entry> embeddedFiles, Comparator<PDFTree.Entry> itemComparator) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Collections.sort(embeddedFiles, itemComparator);
        return embeddedFiles;
    }

    public static ArrayList<Object> sortFolders(ArrayList<?> folders, Comparator<Object> itemComparator) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Object[] foldersArray = folders.toArray();
        Arrays.sort(foldersArray, itemComparator);
        ArrayList<Object> sortedFolders = new ArrayList<Object>();
        for (int i = 0; i < foldersArray.length; ++i) {
            sortedFolders.add(foldersArray[i]);
        }
        return sortedFolders;
    }

    static ArrayList<Long> compileUsedIDList(PDFCollectionFolder root) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Long> IDList = new ArrayList<Long>();
        if (root == null) {
            return IDList;
        }
        IDList.add(Long.valueOf(root.getID()));
        ArrayList<PDFCollectionFolder> children = root.getChildren();
        for (PDFCollectionFolder child : children) {
            ArrayList<Long> childIDList = PDFCollectionUtil.compileUsedIDList(child);
            IDList.addAll(childIDList);
        }
        return IDList;
    }

    static long getNewFolderID(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        long ID = 1L;
        PDFPortableCollection coll = pdfDoc.requireCatalog().getCollection();
        if (coll == null) {
            throw new PDFInvalidDocumentException("Document does not have a Collections dictionary");
        }
        PDFCollectionFolder root = coll.getRootFolder();
        if (root == null) {
            throw new PDFInvalidDocumentException("Document does not have a Root Folder");
        }
        CosArray freeIDObj = root.getFree();
        if (freeIDObj != null) {
            long[] freeIDs = freeIDObj.getArrayLong();
            if (freeIDs.length % 2 != 0) {
                throw new PDFInvalidDocumentException("Free in Root Folder in Collection dictionary should have an even number of elements");
            }
            long min = freeIDs[0];
            long max = freeIDs[1];
            if (min <= max) {
                ID = min++;
                if (min > max) {
                    freeIDs[0] = -1L;
                    freeIDs[1] = -1L;
                } else {
                    freeIDs[0] = min;
                }
            } else {
                throw new PDFInvalidDocumentException("Free in Root folder has invalid values");
            }
            ArrayList<CosNumeric> newFreeList = new ArrayList<CosNumeric>();
            for (int i = 0; i < freeIDs.length; ++i) {
                if (freeIDs[i] < 0L) continue;
                newFreeList.add(pdfDoc.getCosDocument().createCosNumeric(freeIDs[i]));
            }
            CosArray newFreeObj = pdfDoc.getCosDocument().createCosArray(newFreeList);
            root.setFree(newFreeObj);
        } else {
            ArrayList<Long> usedIDList = PDFCollectionUtil.compileUsedIDList(root);
            for (long i = 0L; i < Integer.MAX_VALUE; ++i) {
                boolean used = false;
                for (int j = 0; j < usedIDList.size() && !used; ++j) {
                    Long usedID = usedIDList.get(j);
                    if (usedID != i) continue;
                    used = true;
                }
                if (used) continue;
                ID = i;
                break;
            }
        }
        if (ID < 0L) {
            throw new PDFInvalidDocumentException("Could not allocate a valid ID for the folder");
        }
        return ID;
    }

    public static boolean isRootFolder(PDFCollectionFolder folder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPortableCollection coll;
        CosObject rootFolderCosObj;
        CosObject folderCosObj = folder.getCosObject();
        return folderCosObj == (rootFolderCosObj = (coll = folder.getPDFDocument().requireCatalog().getCollection()).getRootFolder().getCosObject());
    }

    public static List<PDFTree.Entry> getEmbeddedFiles(PDFCollectionFolder folder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFParseException {
        if (folder == null) {
            return null;
        }
        long ID = folder.getID();
        String IDStr = "<" + ID + ">";
        PDFNameDictionary names = folder.getPDFDocument().requireCatalog().getNameDictionary();
        if (names == null) {
            return null;
        }
        PDFNamedEmbeddedFiles embeddedFilesTree = names.getNamedEmbeddedFiles();
        if (embeddedFilesTree == null) {
            return null;
        }
        ArrayList<PDFTree.Entry> embeddedFiles = new ArrayList<PDFTree.Entry>();
        Iterator<PDFTree.Entry> filesIter = embeddedFilesTree.iterator();
        while (filesIter.hasNext()) {
            PDFTree.Entry curEmbeddedFile = filesIter.next();
            ASString key = (ASString)curEmbeddedFile.getKey();
            boolean isPDFTextStr = true;
            String keyStr = null;
            try {
                keyStr = PDFDocEncoding.toUnicodeString(key.getBytes());
            }
            catch (PDFParseException e) {
                isPDFTextStr = false;
            }
            if (PDFCollectionUtil.isRootFolder(folder)) {
                if (isPDFTextStr && !keyStr.startsWith(IDStr) && PDFCollectionUtil.hasValidFolderID(keyStr)) continue;
                embeddedFiles.add(curEmbeddedFile);
                continue;
            }
            if (keyStr == null || !keyStr.startsWith(IDStr)) continue;
            embeddedFiles.add(curEmbeddedFile);
        }
        return embeddedFiles;
    }

    static boolean hasValidFolderID(String key) {
        String regex = "<[0-9]*>.*";
        return key.matches(regex);
    }

    static PDFNamedEmbeddedFiles getNEFTree(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNameDictionary nameDictionary = pdfDocument.requireCatalog().getNameDictionary();
        if (nameDictionary != null) {
            return nameDictionary.getNamedEmbeddedFiles();
        }
        return null;
    }

    static String makeNamedEmbeddedFileKey(String key, PDFCollectionFolder pdfCollectionFolder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return "<" + pdfCollectionFolder.getID() + ">" + key;
    }

    public static void addFileToPDFCollectionFolder(String key, PDFFileSpecification value, PDFCollectionFolder folder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFNameDictionary names = folder.getPDFDocument().requireCatalog().getNameDictionary();
        PDFNamedEmbeddedFiles nef = null;
        if (names == null) {
            names = PDFNameDictionary.newInstance(folder.getPDFDocument());
            folder.getPDFDocument().requireCatalog().setNameDictionary(names);
            nef = PDFNamedEmbeddedFiles.newInstance(folder.getPDFDocument());
            names.setNamedEmbeddedFiles(nef);
        } else {
            nef = names.getNamedEmbeddedFiles();
            if (nef == null) {
                nef = PDFNamedEmbeddedFiles.newInstance(folder.getPDFDocument());
                names.setNamedEmbeddedFiles(nef);
            }
        }
        nef.addEntry(new ASString(UTF16Support.toUTF16(PDFCollectionUtil.makeNamedEmbeddedFileKey(key, folder))), value);
    }

    public static void deleteFile(String key, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNameDictionary names = pdfDoc.requireCatalog().getNameDictionary();
        if (names == null) {
            return;
        }
        PDFNamedEmbeddedFiles embeddedFilesTree = names.getNamedEmbeddedFiles();
        byte[] keyFound = embeddedFilesTree.findKey(key);
        if (keyFound.length != 0) {
            ASString asName = new ASString(keyFound);
            embeddedFilesTree.removeEntry(asName);
        }
        pdfDoc.requireCatalog().getNameDictionary().setNamedEmbeddedFiles(embeddedFilesTree);
    }

    public static void deleteAllFilesInPDFCollectionFolder(PDFCollectionFolder collectionFolder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFParseException {
        PDFNameDictionary names = collectionFolder.getPDFDocument().requireCatalog().getNameDictionary();
        if (names == null) {
            return;
        }
        PDFNamedEmbeddedFiles embeddedFilesTree = names.getNamedEmbeddedFiles();
        List<PDFTree.Entry> embFiles = PDFCollectionUtil.getEmbeddedFiles(collectionFolder);
        for (int i = 0; i < embFiles.size(); ++i) {
            ASString asName = (ASString)embFiles.get(i).getKey();
            embeddedFilesTree.removeEntry(asName);
        }
        collectionFolder.getPDFDocument().requireCatalog().getNameDictionary().setNamedEmbeddedFiles(embeddedFilesTree);
    }

    private static void deleteFilesRecursively(PDFCollectionFolder folder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFParseException {
        PDFCollectionUtil.deleteAllFilesInPDFCollectionFolder(folder);
        ArrayList<PDFCollectionFolder> children = folder.getChildren();
        Iterator<PDFCollectionFolder> iter = children.iterator();
        while (iter.hasNext()) {
            PDFCollectionUtil.deleteFilesRecursively(iter.next());
        }
    }

    public static void removePDFCollectionFolder(PDFCollectionFolder folder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFParseException {
        PDFCollectionUtil.deleteFilesRecursively(folder);
        PDFPortableCollection collection = folder.getPDFDocument().requireCatalog().getCollection();
        if (PDFCollectionUtil.isRootFolder(folder)) {
            collection.setRootFolder(null);
        } else {
            PDFCollectionFolder parent = folder.getParent();
            if (parent == null) {
                throw new PDFInvalidDocumentException("parent of non-root folder cannot be null");
            }
            PDFCollectionFolder child = parent.getChild();
            if (PDFUtil.isPDFCosObjectRefEqual(child, folder)) {
                PDFCollectionFolder nextChild = child.getNext();
                parent.setChild(nextChild);
            } else {
                PDFCollectionFolder prevChild = child;
                for (child = child.getNext(); child != null; child = child.getNext()) {
                    if (child.equals(folder)) {
                        prevChild.setNext(child.getNext());
                        break;
                    }
                    prevChild = child;
                }
            }
        }
    }

    public static void replace(String key, PDFFileSpecification value, PDFCollectionFolder collectionFolder) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        PDFNamedEmbeddedFiles nefTree = PDFCollectionUtil.getNEFTree(collectionFolder.getPDFDocument());
        byte[] keyFound = nefTree.findKey(key);
        if (PDFCollectionUtil.isRootFolder(collectionFolder) && keyFound.length != 0) {
            PDFText pdfKey = PDFText.newInstance(key, true, collectionFolder.getPDFDocument());
            nefTree.replaceEntry(new ASString(pdfKey.stringValue()), value);
            return;
        }
        String keyStr = "<" + collectionFolder.getID() + ">" + key;
        PDFText pdfKey = PDFText.newInstance(keyStr, true, collectionFolder.getPDFDocument());
        nefTree.replaceEntry(new ASString(pdfKey.stringValue()), value);
    }
}

