/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import java.util.ArrayList;

public interface PDFAnnotationWithFringe {
    public double[] getFringe() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public void setFringe(String var1, String var2) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException;

    public void setFringe(double[] var1) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException;

    public boolean hasFringe() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public void transformFringe(ASMatrix var1, double var2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException;

    public static final class FringeGetterSetter {
        protected static double[] getFringe(PDFAnnotationMarkup annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosArray cosFringe = annot.getDictionaryArrayValue(ASName.k_RD);
            if (cosFringe == null) {
                return null;
            }
            return cosFringe.getArrayDouble();
        }

        protected static void setFringe(PDFAnnotationMarkup annot, double[] fringe) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            ArrayList<Double> listFringe = null;
            if (fringe != null) {
                listFringe = new ArrayList<Double>(4);
                for (int i = 0; i < 4; ++i) {
                    listFringe.add(fringe[i]);
                }
            }
            annot.setDictionaryArrayValue(ASName.k_RD, listFringe);
        }

        protected static void setFringe(PDFAnnotationMarkup annot, String fringe, String separator) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            annot.setDictionaryArrayValue(ASName.k_RD, PDFUtil.parseNumbers(fringe, separator));
        }
    }
}

