/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderLabel;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderListContent;
import java.util.Iterator;

public class PDFOCOrderList
extends PDFCosArrayList<PDFOCOrderListContent>
implements PDFOCOrderListContent {
    private PDFOCOrderList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOCOrderList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOCOrderList pdfObject = (PDFOCOrderList)PDFCosObject.getCachedInstance(cosObject, PDFOCOrderList.class);
        if (pdfObject == null) {
            pdfObject = new PDFOCOrderList(cosObject);
        }
        return pdfObject;
    }

    public static PDFOCOrderList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        return new PDFOCOrderList(cosObject);
    }

    public static PDFOCOrderList newInstance(PDFDocument pdfDocument, PDFOCGroupList ocgList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCOrderList orderList = PDFOCOrderList.newInstance(pdfDocument);
        Iterator iter = ocgList.iterator();
        while (iter.hasNext()) {
            PDFOCGroup elem = (PDFOCGroup)iter.next();
            orderList.add(elem);
        }
        return orderList;
    }

    @Override
    protected PDFOCOrderListContent itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (cosObject.getType() == 6) {
            return PDFOCGroup.getInstance(cosObject);
        }
        if (cosObject.getType() == 4) {
            return PDFOCOrderLabel.getInstance(cosObject);
        }
        if (cosObject.getType() == 5) {
            return PDFOCOrderList.getInstance(cosObject);
        }
        return null;
    }

    public void setLabel(PDFOCOrderLabel label) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeLabel();
        this.add(0, label);
    }

    public PDFOCOrderLabel removeLabel() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCOrderLabel existingLabel = this.getLabel();
        if (existingLabel != null) {
            this.remove(0);
        }
        return existingLabel;
    }

    public PDFOCOrderLabel getLabel() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosArray().isEmpty()) {
            return null;
        }
        PDFCosObject label = (PDFCosObject)this.get(0);
        if (label instanceof PDFOCOrderLabel) {
            return (PDFOCOrderLabel)label;
        }
        return null;
    }

    public void addOCG(PDFOCGroup ocg) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.add(ocg);
    }

    public PDFOCGroup getOCG(int index) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (PDFOCGroup)super.get(index);
    }

    public void addOCGList(PDFOCGroupList ocgList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray obj = this.getCosArray();
        if (obj != null) {
            Iterator iter = ocgList.iterator();
            while (iter.hasNext()) {
                PDFOCGroup elem = (PDFOCGroup)iter.next();
                obj.add(elem.getCosObject());
            }
        }
    }

    public void addOrderList(PDFOCOrderList orderList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator orderIter = orderList.iterator();
        while (orderIter.hasNext()) {
            this.add((PDFCosObjectContainer)orderIter.next());
        }
    }
}

