/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCMembership;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;

public abstract class PDFOCObject
extends PDFCosDictionary {
    protected PDFOCObject(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOCObject getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        if (!(cosObject instanceof CosDictionary)) {
            throw new PDFInvalidDocumentException("CosDictionary expected");
        }
        ASName type = ((CosDictionary)cosObject).getName(ASName.k_Type);
        if (type == null) {
            return null;
        }
        PDFOCObject result = null;
        if (type.equals(ASName.k_OCG)) {
            result = PDFOCGroup.getInstance(cosObject);
        } else if (type.equals(ASName.k_OCMD)) {
            result = PDFOCMembership.getInstance(cosObject);
        }
        return result;
    }

    public static boolean isOCObject(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean result = false;
        if (cosObject instanceof CosDictionary) {
            CosObject typeObj;
            ASName type = null;
            if (((CosDictionary)cosObject).containsKey(ASName.k_Type) && (typeObj = ((CosDictionary)cosObject).get(ASName.k_Type)) instanceof CosName) {
                type = typeObj.nameValue();
            }
            if (type != null && (type.equals(ASName.k_OCG) || type.equals(ASName.k_OCMD))) {
                result = true;
            }
        }
        return result;
    }

    public static boolean hasOC(PDFXObject xObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return xObject.dictionaryContains(ASName.k_OC);
    }

    public static PDFOCObject getOC(PDFXObject xObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFOCObject.getInstance(xObject.getDictionaryCosObjectValue(ASName.k_OC));
    }

    public static void setOC(PDFXObject xObject, PDFOCObject ocObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        xObject.setDictionaryValue(ASName.k_OC, ocObj);
    }

    public static boolean removeOC(PDFXObject xObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return xObject.removeValue(ASName.k_OC);
    }

    public static boolean hasOC(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return annot.dictionaryContains(ASName.k_OC);
    }

    public static PDFOCObject getOC(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFOCObject.getInstance(annot.getDictionaryCosObjectValue(ASName.k_OC));
    }

    public static void setOC(PDFAnnotation annot, PDFOCObject ocObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        annot.setDictionaryValue(ASName.k_OC, ocObj);
    }

    public static boolean removeOC(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return annot.removeValue(ASName.k_OC);
    }

    public boolean isOCG() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ASName.k_OCG.equals(this.getDictionaryNameValue(ASName.k_Type));
    }

    public boolean isOCMD() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ASName.k_OCMD.equals(this.getDictionaryNameValue(ASName.k_Type));
    }

    public abstract ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;
}

