/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.color.Function;
import com.adobe.internal.pdftoolkit.color.FunctionCache;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDomain;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionType2;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRange;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.ExtendedPostScriptTokenManager;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.FunctionManager;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PDFFunctionIdentity;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PDFFunctionUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PostScriptCalculator;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.SimpleCharStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;

public class FunctionCacheImpl
implements FunctionCache {
    private Function function;
    private byte[] sampledData = null;
    private double[] domain;
    private double[] range;
    private double[] decode;
    private double[] encode;
    private double[] size;
    private int bps = -1;
    private int valToBeInterpolated = -1;
    private int functionType = -1;
    private PostScriptCalculator postScriptCalculator = null;
    HashMap<FunctionCacheKey, double[]> computedValMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FunctionCacheImpl(Function function) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        this.function = function;
        this.computedValMap = new HashMap();
        if (function instanceof PDFFunctionIdentity) {
            return;
        }
        PDFFunction pdfFunction = (PDFFunction)function;
        this.functionType = pdfFunction.getFunctionType();
        PDFDomain pdfDomain = pdfFunction.getFunctionDomain();
        if (pdfDomain != null) {
            this.domain = pdfDomain.getCosArray().getArrayDouble();
        }
        try {
            PDFFunctionUtils.validateDomainORRangeArray(this.domain);
        }
        catch (PDFInvalidParameterException e1) {
            throw new PDFInvalidDocumentException("Invalid domain entry.");
        }
        PDFRange pdfRange = pdfFunction.getFunctionRange();
        if (pdfRange != null) {
            this.range = pdfRange.getCosArray().getArrayDouble();
        }
        try {
            if (this.functionType == 0) {
                InputByteStream is = null;
                try {
                    is = pdfFunction.getCosStream().getStreamDecoded();
                    this.sampledData = new byte[(int)is.length()];
                    is.read(this.sampledData);
                    this.decode = ((PDFFunctionType0)function).getDecode() != null ? ((PDFFunctionType0)function).getDecode().getArrayDouble() : this.range;
                    this.size = ((PDFFunctionType0)function).getSize().getArrayDouble();
                    this.encode = null;
                    if (((PDFFunctionType0)function).getEncode() != null) {
                        this.encode = ((PDFFunctionType0)function).getEncode().getArrayDouble();
                    } else {
                        this.encode = new double[this.size.length * 2];
                        for (int i = 0; i < this.size.length; ++i) {
                            this.encode[2 * i] = 0.0;
                            this.encode[2 * i + 1] = this.size[i];
                        }
                    }
                    this.bps = ((PDFFunctionType0)function).getBitsPerSample();
                    this.valToBeInterpolated = (2 << this.bps - 1) - 1;
                    return;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        throw new PDFRuntimeException(null, e);
                    }
                }
            }
            if (this.functionType != 4) return;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    @Override
    public double[] apply(double[] inputData) {
        try {
            double[] result = this.computedValMap.get(new FunctionCacheKey(inputData, this.function));
            if (result != null) {
                return result;
            }
            if (this.functionType == 0) {
                result = FunctionManager.applyFunction0(inputData, this.sampledData, this.domain, this.range, this.decode, this.encode, this.size, this.bps, this.valToBeInterpolated);
            } else if (this.functionType == 2) {
                CosArray C0 = ((PDFFunctionType2)this.function).getC0();
                CosArray C1 = ((PDFFunctionType2)this.function).getC1();
                double N = ((PDFFunctionType2)this.function).getInterpolationExponent();
                int n = 1;
                if (this.range != null) {
                    n = this.range.length / 2;
                } else if (C0 != null) {
                    n = C0.size();
                } else if (C1 != null) {
                    n = C1.size();
                }
                double[] c0Array = null;
                double[] c1Array = null;
                if (C0 == null) {
                    c0Array = FunctionManager.getDefaultArray(0.0, n);
                } else {
                    c0Array = C0.getArrayDouble();
                    if (c0Array.length != n) {
                        throw new PDFInvalidDocumentException("The length of the C0 Array shoule be " + n);
                    }
                }
                if (C1 == null) {
                    c1Array = FunctionManager.getDefaultArray(1.0, n);
                } else {
                    c1Array = C1.getArrayDouble();
                    if (c1Array.length != n) {
                        throw new PDFInvalidDocumentException("The length of the C1 Array shoule be " + n);
                    }
                }
                result = FunctionManager.applyFunction2(inputData, c0Array, c1Array, N, n, this.range);
            } else if (this.functionType == 3) {
                result = FunctionManager.applyFunction3(this.domain, ((PDFFunctionType3)this.function).getBounds().getArrayDouble(), ((PDFFunctionType3)this.function).getEncode().getArrayDouble(), inputData, FunctionManager.pdfFunctionsArrayToInterfaceArray(((PDFFunctionType3)this.function).getFunctions()));
            } else {
                if (this.functionType == 4) {
                    InputByteStream decodedData = null;
                    InputStream byteStream = null;
                    try {
                        if (this.postScriptCalculator == null) {
                            decodedData = ((PDFFunction)this.function).getCosStream().getStreamDecoded();
                            byteStream = decodedData.toInputStream();
                            this.postScriptCalculator = new PostScriptCalculator(new ExtendedPostScriptTokenManager(new SimpleCharStream(byteStream, null, 1, 1)));
                        }
                        result = FunctionManager.applyFunction4(this.range, this.domain, this.postScriptCalculator, inputData);
                    }
                    catch (IOException e) {
                        throw new PDFRuntimeException("Exception occured while applying function type 4 with object no = " + ((PDFFunction)this.function).getCosObject().getObjNum(), e);
                    }
                    finally {
                        if (byteStream != null) {
                            try {
                                byteStream.close();
                            }
                            catch (IOException e) {
                                throw new PDFRuntimeException("Exception occured while closing stream during application of function type 4 with object no = " + ((PDFFunction)this.function).getCosObject().getObjNum(), e);
                            }
                        }
                        if (decodedData != null) {
                            try {
                                decodedData.close();
                            }
                            catch (IOException e) {
                                throw new PDFRuntimeException("Exception occured while closing stream during application of function type 4 with object no = " + ((PDFFunction)this.function).getCosObject().getObjNum(), e);
                            }
                        }
                    }
                }
                if (this.function instanceof PDFFunctionIdentity) {
                    result = this.function.apply(inputData);
                } else {
                    return null;
                }
            }
            this.computedValMap.put(new FunctionCacheKey(inputData, this.function), result);
            return result;
        }
        catch (PDFCosParseException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
    }

    class FunctionCacheKey {
        double[] inputData = null;
        private PDFFunction function;

        public FunctionCacheKey(double[] input, Function function) {
            this.inputData = new double[input.length];
            System.arraycopy(input, 0, this.inputData, 0, input.length);
            this.function = (PDFFunction)function;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
            result = 31 * result + Arrays.hashCode(this.inputData);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionCacheKey other = (FunctionCacheKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.function == null ? other.function != null : !this.function.equals(other.function)) {
                return false;
            }
            return Arrays.equals(this.inputData, other.inputData);
        }

        private FunctionCacheImpl getOuterType() {
            return FunctionCacheImpl.this;
        }
    }
}

