/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CMapObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFWritingMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PredefinedCMAPCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.Encoding;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class PDFType0FontEncoding
extends PDFCosObject
implements Encoding {
    private PDFCMap mPDFCMap;
    public static final ASName k_CMAP = ASName.create("CMap");

    private PDFType0FontEncoding(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFType0FontEncoding getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFType0FontEncoding pdfObject = (PDFType0FontEncoding)PDFCosObject.getCachedInstance(cosObject, PDFType0FontEncoding.class);
        if (pdfObject == null) {
            pdfObject = new PDFType0FontEncoding(cosObject);
        }
        return pdfObject;
    }

    public static PDFType0FontEncoding newInstance(PDFDocument pdfDocument, ASName encoding) throws PDFInvalidDocumentException {
        CosName cosObject = PDFCosObject.newCosName(pdfDocument, encoding);
        return new PDFType0FontEncoding(cosObject);
    }

    public static PDFType0FontEncoding newInstance(CosStream stream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        stream.put(ASName.k_Type, k_CMAP);
        return new PDFType0FontEncoding(stream);
    }

    public boolean isPredefinedCMap() {
        return this.getCosObject() instanceof CosName;
    }

    public ASName getCMapName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosObject() instanceof CosName) {
            return ((CosName)this.getCosObject()).nameValue();
        }
        return ((CosDictionary)this.getCosObject()).getName(ASName.k_CMapName);
    }

    public CIDSystemInfo getCIDSystemInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosObject() instanceof CosName) {
            CMapObject cmapObject = this.getPDFCMap().getCharCodeCMap();
            if (cmapObject == null) {
                return null;
            }
            String registry = cmapObject.getRegistry();
            String ordering = cmapObject.getOrdering();
            int supplement = cmapObject.getSupplement();
            return new PredefinedCMAPCIDSystemInfo(new ASString(registry), new ASString(ordering), supplement);
        }
        return PDFCIDSystemInfo.getInstance(((CosDictionary)this.getCosObject()).get(ASName.k_CIDSystemInfo));
    }

    public PDFWritingMode getWMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getPDFCMap().getWritingMode();
    }

    public PDFWritingMode getWModeFromCMapDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosObject() instanceof CosDictionary) {
            if (((CosDictionary)this.getCosObject()).containsKey(ASName.k_WMode)) {
                int mode = ((CosDictionary)this.getCosObject()).get(ASName.k_WMode).intValue();
                try {
                    return PDFWritingMode.getWritingModeForValue(mode);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException("incorrect WMode value in CMap dictionary", e);
                }
            }
            return PDFWritingMode.HORIZONTAL;
        }
        return null;
    }

    public int getCID(int charcode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getPDFCMap().getCID(charcode);
    }

    public int getCIDFromCharBytes(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getPDFCMap().getCID(charCodeBytes);
    }

    public PDFType0FontEncoding getUseCMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosObject() instanceof CosName) {
            return PDFType0FontEncoding.newInstance(this.getPDFDocument(), ASName.create(this.getPDFCMap().getUseCMap()));
        }
        if (((CosDictionary)this.getCosObject()).containsKey(ASName.k_UseCMap)) {
            return PDFType0FontEncoding.getInstance(((CosDictionary)this.getCosObject()).get(ASName.k_UseCMap));
        }
        return null;
    }

    @Override
    public String toUnicode(ASString string) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return null;
    }

    @Override
    public String toUnicode(byte[] bytes, int start, int length) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return null;
    }

    @Override
    public char[] toUnicode(byte charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return null;
    }

    @Override
    public char[] toUnicode(byte charCode, ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return null;
    }

    @Override
    public int fromUnicode(char unicodeChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return 0;
    }

    @Override
    public String getGlyphName(int charCode) {
        return null;
    }

    public PDFType0FontEncoding createEmbeddedInstance() throws PDFInvalidDocumentException, PDFInvalidParameterException, PDFIOException, PDFSecurityException {
        if (!this.isPredefinedCMap()) {
            throw new PDFInvalidParameterException("Instance already embedded");
        }
        CosStream cmapStream = PDFType0FontEncoding.createCMapStream((CosName)this.getCosObject());
        return PDFType0FontEncoding.getInstance(cmapStream);
    }

    public static CosStream createCMapStream(CosName cmapName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CMapObject preDef = new PDFCMap(cmapName.nameValue().asString(true)).getCharCodeCMap();
        CosDocument cosDoc = cmapName.getDocument();
        CosStream cmapObj = cosDoc.createCosStream();
        cmapObj.put(ASName.k_Type, ASName.create("CMap"));
        cmapObj.put(ASName.k_CMapName, cmapName.nameValue());
        CosDictionary sysInfo = cosDoc.createDirectCosDictionary();
        sysInfo.put(ASName.k_Registry, new ASString(preDef.getRegistry()));
        sysInfo.put(ASName.k_Ordering, new ASString(preDef.getOrdering()));
        sysInfo.put(ASName.k_Supplement, preDef.getSupplement());
        cmapObj.put(ASName.k_CIDSystemInfo, sysInfo);
        String wMode = preDef.getWritingMode();
        cmapObj.put(ASName.k_WMode, "1".equals(wMode) ? 1 : 0);
        String baseCMap = preDef.getBaseName();
        InputByteStream data = null;
        if (baseCMap != null) {
            cmapObj.put(ASName.k_UseCMap, PDFType0FontEncoding.createCMapStream(cosDoc.createCosName(ASName.create(baseCMap))));
        }
        try {
            InputStream cmapStream = preDef.getClass().getResourceAsStream(cmapName.nameValue().asString(true));
            InputStreamByteReader reader = new InputStreamByteReader(cmapStream);
            data = cosDoc.getStreamManager().getInputByteStream(reader);
        }
        catch (IOException e) {
            throw new PDFIOException("Cannot create CMap stream", e);
        }
        cmapObj.newDataDecoded(data);
        cmapObj.put(ASName.k_Filter, ASName.k_FlateDecode);
        return cmapObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDFCMap getPDFCMap() throws PDFInvalidDocumentException {
        if (this.mPDFCMap == null) {
            if (this.getCosObject() instanceof CosName) {
                this.mPDFCMap = new PDFCMap(((CosName)this.getCosObject()).nameValue().asString(true));
            } else {
                if (this.getCosObject() instanceof CosStream) {
                    HashMap<String, InputStream> useCMaps = new HashMap<String, InputStream>();
                    InputByteStream rootCMapByteStream = null;
                    try {
                        rootCMapByteStream = ((CosStream)this.getCosObject()).getStreamDecoded();
                        InputStream rootCMap = rootCMapByteStream.toInputStream();
                        CosObject nextMap = ((CosStream)this.getCosObject()).get(ASName.k_UseCMap);
                        InputByteStream inputByteStream = null;
                        InputStream nextIs = null;
                        while (nextMap instanceof CosStream) {
                            ASName nextName = ((CosStream)nextMap).getName(ASName.k_CMapName);
                            inputByteStream = ((CosStream)nextMap).getStreamDecoded();
                            try {
                                nextIs = inputByteStream.toInputStream();
                            }
                            finally {
                                try {
                                    if (inputByteStream != null) {
                                        inputByteStream.close();
                                    }
                                }
                                catch (IOException iOException) {}
                            }
                            useCMaps.put(nextName.asString(), nextIs);
                            nextMap = ((CosStream)nextMap).get(ASName.k_UseCMap);
                        }
                        this.mPDFCMap = new PDFCMap(rootCMap, useCMaps);
                    }
                    catch (Exception e) {
                        throw new PDFInvalidDocumentException("Cannot read CMap stream", e);
                    }
                    finally {
                        try {
                            if (rootCMapByteStream != null) {
                                rootCMapByteStream.close();
                            }
                        }
                        catch (IOException e) {
                            throw new PDFInvalidDocumentException(e);
                        }
                    }
                }
                throw new PDFInvalidDocumentException("Illegal encoding object type");
            }
        }
        return this.mPDFCMap;
    }
}

