/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontStyle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontStretch;
import java.util.List;

public class PDFCosFontDescriptor
extends PDFCosDictionary {
    private PDFCosFontDescriptor(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCosFontDescriptor getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCosFontDescriptor pdfObject = (PDFCosFontDescriptor)PDFCosObject.getCachedInstance(cosObject, PDFCosFontDescriptor.class);
        if (pdfObject == null) {
            pdfObject = new PDFCosFontDescriptor(cosObject);
        }
        return pdfObject;
    }

    public static PDFCosFontDescriptor newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosDictionary = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFCosFontDescriptor(cosDictionary);
    }

    ASName getFontName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_FontName);
    }

    void setFontName(ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_FontName, fontName);
    }

    void setType(ASName fontName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, fontName);
    }

    ASString getFontFamily() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_FontFamily);
    }

    PDFFontStretch getFontStretch() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName fontStretch = this.getDictionaryNameValue(ASName.k_FontStretch);
        if (fontStretch == null) {
            return null;
        }
        try {
            return PDFFontStretch.newInstance(fontStretch);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Invalid value for font stretch.", e);
        }
    }

    int getFontWeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int kNormalWeight = 400;
        if (this.containsKey(ASName.k_FontWeight)) {
            return this.getDictionaryIntValue(ASName.k_FontWeight);
        }
        return kNormalWeight;
    }

    int getFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Flags);
    }

    void setFlags(int flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Flags, flags);
    }

    boolean containsFontBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.containsKey(ASName.k_FontBBox);
    }

    PDFRectangle getFontBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRectangle.getInstance(this.getDictionaryValue(ASName.k_FontBBox));
    }

    void setFontBBox(PDFRectangle fontBBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_FontBBox, fontBBox.getCosObject());
    }

    double getItalicAngle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_ItalicAngle);
    }

    void setItalicAngle(double angle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_ItalicAngle, angle);
    }

    boolean containsAscent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.containsKey(ASName.k_Ascent);
    }

    public double getAscent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsAscent()) {
            return this.getDictionaryDoubleValue(ASName.k_Ascent);
        }
        return 0.0;
    }

    void setAscent(double ascent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_Ascent, ascent);
    }

    boolean containsDescent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.containsKey(ASName.k_Descent);
    }

    public double getDescent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsDescent()) {
            return this.getDictionaryDoubleValue(ASName.k_Descent);
        }
        return 0.0;
    }

    void setDescent(double descent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_Descent, descent);
    }

    double getLeading() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsKey(ASName.k_Leading)) {
            return this.getDictionaryDoubleValue(ASName.k_Leading);
        }
        return 0.0;
    }

    boolean containsCapHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.containsKey(ASName.k_CapHeight);
    }

    public double getCapHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsCapHeight()) {
            return this.getDictionaryDoubleValue(ASName.k_CapHeight);
        }
        return 0.0;
    }

    void setCapHeight(double capHight) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_CapHeight, capHight);
    }

    double getXHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsKey(ASName.k_XHeight)) {
            return this.getDictionaryDoubleValue(ASName.k_XHeight);
        }
        return 0.0;
    }

    void setXHeight(double xHeight) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_XHeight, xHeight);
    }

    boolean containsStemV() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.containsKey(ASName.k_StemV);
    }

    double getStemV() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsStemV()) {
            return this.getDictionaryDoubleValue(ASName.k_StemV);
        }
        return 0.0;
    }

    void setStemV(double stemV) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_StemV, stemV);
    }

    double getStemH() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsKey(ASName.k_StemH)) {
            return this.getDictionaryDoubleValue(ASName.k_StemH);
        }
        return 0.0;
    }

    double getAvgWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsKey(ASName.k_AvgWidth)) {
            return this.getDictionaryDoubleValue(ASName.k_AvgWidth);
        }
        return 0.0;
    }

    double getMaxWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsKey(ASName.k_MaxWidth)) {
            return this.getDictionaryDoubleValue(ASName.k_MaxWidth);
        }
        return 0.0;
    }

    public double getMissingWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.containsKey(ASName.k_MissingWidth)) {
            return this.getDictionaryDoubleValue(ASName.k_MissingWidth);
        }
        return 0.0;
    }

    boolean containsEmbeddedFont() {
        CosDictionary dict = this.getCosDictionary();
        return dict.containsKey(ASName.k_FontFile) || dict.containsKey(ASName.k_FontFile2) || dict.containsKey(ASName.k_FontFile3);
    }

    public PDFFontFile getFontFile() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(ASName.k_FontFile);
        if (cosObject != null) {
            return PDFFontFile.getInstance(cosObject);
        }
        return null;
    }

    void setFontFile(PDFFontFile fontFile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_FontFile, fontFile);
    }

    PDFFontFile getFontFile2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFontFile.getInstance(this.getDictionaryValue(ASName.k_FontFile2));
    }

    void setFontFile2(PDFFontFile fontFile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_FontFile2, fontFile);
    }

    PDFFontFile getFontFile3() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFontFile.getInstance(this.getDictionaryValue(ASName.k_FontFile3));
    }

    void setFontFile3(PDFFontFile fontFile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_FontFile3, fontFile);
    }

    ASString getCharSet() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_CharSet);
    }

    PDFCIDFontStyle getStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCIDFontStyle.getInstance(this.getDictionaryValue(ASName.k_Style));
    }

    public ASName getLang() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Lang);
    }

    List<ASName> getFDKeys() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDictionaryValue(ASName.k_FD).getKeys();
    }

    PDFFontDescriptor getFD(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary fdDict = this.getDictionaryDictionaryValue(ASName.k_FD);
        if (fdDict != null) {
            return PDFFontDescriptor.getInstance(fdDict.get(name));
        }
        return null;
    }

    InputByteStream getCIDSet() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStreamValue(ASName.k_CIDSet);
    }
}

