/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PDFDeviceNAttributes {
    private final CosDictionary dictionary;
    private CosArray array;

    public PDFDeviceNAttributes(CosArray cArray) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.array = cArray;
        this.dictionary = this.array.getDocument().createCosDictionary();
    }

    public PDFDeviceNAttributes(CosDictionary attributes) {
        this.dictionary = attributes;
    }

    public Map getColorants() throws IOException, PDFIOException, PDFCosParseException, PDFSecurityException, PDFInvalidDocumentException {
        HashMap<Object, PDFColorSpace> actuals = new HashMap<Object, PDFColorSpace>();
        CosDictionary colorants = this.dictionary.getCosDictionary(ASName.create("Colorants"));
        if (colorants == null) {
            colorants = this.array.getDocument().createCosDictionary();
            this.dictionary.put(ASName.create("Colorants"), colorants);
        }
        Iterator<ASName> iter = colorants.keyIterator();
        while (iter.hasNext()) {
            CosName name = (CosName)((Object)iter.next());
            CosObject value = colorants.get(name.nameValue());
            actuals.put(name.getValue(), PDFColorSpaceFactory.getInstance(value));
        }
        return actuals;
    }

    public void setColorants(Map colorants) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject colorantDict = null;
        this.dictionary.put(ASName.create("Colorants"), colorantDict);
    }
}

