/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceCalGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceCalRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceN;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceICCBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceIndexed;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceLab;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpacePattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceSeparation;

public class PDFColorSpaceFactory {
    public static PDFColorSpace getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosColorSpace = null;
        if (cosObject == null || cosObject.getType() == 0) {
            return null;
        }
        ASName subtype = null;
        if (cosObject.getType() == 5) {
            cosColorSpace = (CosArray)cosObject;
            subtype = cosColorSpace.getName(0);
        } else if (cosObject.getType() == 3) {
            subtype = ((CosName)cosObject).nameValue();
        } else {
            throw new PDFInvalidDocumentException("Bad ColorSpace. Object Number:" + cosObject.getObjNum());
        }
        if (subtype == ASName.k_DeviceGray) {
            return PDFColorSpaceDeviceGray.getInstance(cosObject);
        }
        if (subtype == ASName.k_DeviceRGB) {
            return PDFColorSpaceDeviceRGB.getInstance(cosObject);
        }
        if (subtype == ASName.k_DeviceCMYK) {
            return PDFColorSpaceDeviceCMYK.getInstance(cosObject);
        }
        if (subtype == ASName.k_CalGray) {
            return PDFColorSpaceCalGray.getInstance(cosObject);
        }
        if (subtype == ASName.k_CalRGB) {
            return PDFColorSpaceCalRGB.getInstance(cosObject);
        }
        if (subtype == ASName.k_Lab) {
            return PDFColorSpaceLab.getInstance(cosObject);
        }
        if (subtype == ASName.k_ICCBased) {
            return PDFColorSpaceICCBased.getInstance(cosObject);
        }
        if (subtype == ASName.k_Indexed) {
            return PDFColorSpaceIndexed.getInstance(cosObject);
        }
        if (subtype == ASName.k_Separation) {
            return PDFColorSpaceSeparation.getInstance(cosObject);
        }
        if (subtype == ASName.k_DeviceN) {
            return PDFColorSpaceDeviceN.getInstance(cosObject);
        }
        if (subtype == ASName.k_Pattern) {
            return PDFColorSpacePattern.getInstance(cosObject);
        }
        throw new PDFInvalidDocumentException("Bad ColorSpace. Object Number:" + cosObject.getObjNum());
    }
}

