/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDomain;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRange;

public class PDFFunctionType0
extends PDFFunction {
    private PDFFunctionType0(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFunctionType0 newInstance(PDFDocument pdfDocument, CosArray key_Size, PDFRange key_Range, int key_BitsPerSample, PDFDomain key_Domain) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Size == null) {
            throw new PDFInvalidParameterException("Size is required when creating newInstance of PDFFunctionType0.");
        }
        if (key_Range == null) {
            throw new PDFInvalidParameterException("Range is required when creating newInstance of PDFFunctionType0.");
        }
        if (key_Domain == null) {
            throw new PDFInvalidParameterException("Domain is required when creating newInstance of PDFFunctionType0.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFFunctionType0 pdfObject = new PDFFunctionType0(cosObject);
        pdfObject.setSize(key_Size);
        pdfObject.setFunctionRange(key_Range);
        pdfObject.setBitsPerSample(key_BitsPerSample);
        pdfObject.setFunctionDomain(key_Domain);
        pdfObject.setFunctionType();
        return pdfObject;
    }

    public static PDFFunctionType0 getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFunctionType0 pdfObject = (PDFFunctionType0)PDFCosObject.getCachedInstance(cosObject, PDFFunctionType0.class);
        if (pdfObject == null) {
            pdfObject = new PDFFunctionType0(cosObject);
        }
        return pdfObject;
    }

    public int getOrder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Order);
    }

    public void setOrder(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Order, value);
    }

    public boolean hasOrder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Order);
    }

    public int getBitsPerSample() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_BitsPerSample);
    }

    public void setBitsPerSample(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_BitsPerSample, value);
    }

    public int requireBitsPerSample() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_BitsPerSample);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get BitsPerSample.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasBitsPerSample() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BitsPerSample);
    }

    public CosArray getSize() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Size);
    }

    public void setSize(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Size is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Size, value);
    }

    public boolean hasSize() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Size);
    }

    private void setFunctionType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_FunctionType, 0L);
    }

    public int requireFunctionType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_FunctionType);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get FunctionType.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public CosArray getDecode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Decode);
    }

    public void setDecode(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryArrayValue(ASName.k_Decode, value);
    }

    public boolean hasDecode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Decode);
    }

    public CosArray getEncode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_Encode);
    }

    public void setEncode(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Encode, value);
    }

    public boolean hasEncode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Encode);
    }
}

