/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameTree;
import com.adobe.internal.pdftoolkit.pdf.utils.UTF16Support;

public class PDFNamedEmbeddedFiles
extends PDFNameTree<PDFFileSpecification> {
    private PDFNamedEmbeddedFiles(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFNamedEmbeddedFiles newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFNamedEmbeddedFiles(cosObject);
    }

    public static PDFNamedEmbeddedFiles getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFNamedEmbeddedFiles pdfObject = (PDFNamedEmbeddedFiles)PDFCosObject.getCachedInstance(cosObject, PDFNamedEmbeddedFiles.class);
        if (pdfObject == null) {
            pdfObject = new PDFNamedEmbeddedFiles(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFFileSpecification makeValueType(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return PDFFileSpecification.getInstance(cosObject);
    }

    @Override
    public PDFFileSpecification getEntry(ASString key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString asName = new ASString(UTF16Support.toUTF16(key.asString()));
        PDFFileSpecification fileSpec = (PDFFileSpecification)super.getEntry(asName);
        if (fileSpec != null) {
            return fileSpec;
        }
        return (PDFFileSpecification)super.getEntry(key);
    }

    public static String getFolderFileKey(ASString key) {
        String keyStr = key.asString();
        int pos = keyStr.indexOf(62);
        if (pos < 1) {
            return keyStr;
        }
        return keyStr.substring(pos + 1);
    }

    @Override
    protected CosObject getCosObjectFromValue(PDFFileSpecification value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return value.getCosObject();
    }
}

