/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFBuildData;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFSigQBuildData
extends PDFBuildData {
    private PDFSigQBuildData(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFSigQBuildData getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSigQBuildData pdfObject = (PDFSigQBuildData)PDFCosObject.getCachedInstance(cosObject, PDFSigQBuildData.class);
        if (pdfObject == null) {
            pdfObject = new PDFSigQBuildData(cosObject);
        }
        return pdfObject;
    }

    public static PDFSigQBuildData newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument);
        PDFSigQBuildData pdfObject = new PDFSigQBuildData(cosObject);
        return pdfObject;
    }

    public String getNote() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName note = this.getDictionaryNameValue(ASName.k_Note);
        if (note != null) {
            return note.asString(true);
        }
        return null;
    }

    public void setNote(String note) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Note, note);
    }

    public boolean getPreview() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getCosDictionary().get(ASName.k_Preview);
        if (cosObject != null) {
            return cosObject.booleanValue();
        }
        return false;
    }

    public void setPreview(Boolean flag) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_Preview, flag);
    }
}

