/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASQuad;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ActualText;
import com.adobe.internal.pdftoolkit.pdf.content.processor.CharacterIDGenerator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GState;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PDFCharacter;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PDFSimpleFontData;
import com.adobe.internal.pdftoolkit.pdf.content.processor.SimpleFontDataCache;
import com.adobe.internal.pdftoolkit.pdf.content.processor.StringContainer;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextState;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFToUnicodeCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFWritingMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.CharSetEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.StandardCharSetEncodings;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFCMapUtils;
import com.adobe.internal.pdftoolkit.services.textextraction.Word;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TextRun
implements StringContainer {
    private ASArray tjArray;
    private ASMatrix tm;
    private ASMatrix ctm;
    private GState gState;
    private TextState tState;
    private double xScale;
    private double yScale;
    private ASCoordinate tsOrigin;
    private ASCoordinate tsUnitBaseline;
    private Double tsBaselineAngle = null;
    protected PDFFont font;
    public double fs;
    private double h;
    private double c;
    private double rise;
    private boolean fontIsType3;
    private ASMatrix type3FontMatrix;
    private double fsh;
    private double ch;
    private double wh;
    private PDFWritingMode writingMode;
    private boolean glyphExtentsCached = false;
    private ArrayList<PDFCharacter> pdteChars;
    private ArrayList<Double> origins;
    private ArrayList<Double> ends;
    private ArrayList<Double> spacingEnds;
    private String unicodeStr;
    private ActualText actualText;
    double txDelta;
    double tyDelta;
    private boolean ignoreErrors;
    private CharacterIDGenerator characterIDGenerator;
    private SimpleFontDataCache simpleFontDataCache;
    private Double spaceCharWidth;
    private double avgCharWidth;

    private TextRun(ASString string, ASMatrix tm, GState gState, boolean noInit, PDFDocument pdfDocument, boolean ignoreErrors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.tjArray = new ASArray();
        this.tjArray.add(string);
        this.tm = new ASMatrix(tm);
        this.gState = new GState(gState);
        this.tState = new TextState(gState.getTextState());
        this.ignoreErrors = ignoreErrors;
        this.characterIDGenerator = CharacterIDGenerator.getInstance(pdfDocument);
        this.simpleFontDataCache = SimpleFontDataCache.getInstance(pdfDocument);
    }

    private TextRun(ASArray tjArray, ASMatrix tm, GState gState, boolean noInit, PDFDocument pdfDocument, boolean ignoreErrors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.tjArray = tjArray;
        this.tm = new ASMatrix(tm);
        this.gState = new GState(gState);
        this.tState = new TextState(gState.getTextState());
        this.ignoreErrors = ignoreErrors;
        this.characterIDGenerator = CharacterIDGenerator.getInstance(pdfDocument);
        this.simpleFontDataCache = SimpleFontDataCache.getInstance(pdfDocument);
    }

    protected TextRun(ASString string, ASMatrix tm, GState gState, PDFDocument pdfDocument, boolean ignoreErrors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this(string, tm, gState, true, pdfDocument, ignoreErrors);
        this.init();
    }

    TextRun(ASString string, ASMatrix tm, GState gState, ActualText actualText, PDFDocument pdfDocument, boolean ignoreErrors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this(string, tm, gState, true, pdfDocument, ignoreErrors);
        this.actualText = actualText;
        if (actualText != null) {
            actualText.incrementTextRunCount();
        }
        this.init();
    }

    protected TextRun(ASArray tjArray, ASMatrix tm, GState gState, PDFDocument pdfDocument, boolean ignoreErrors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this(tjArray, tm, gState, true, pdfDocument, ignoreErrors);
        this.init();
    }

    TextRun(ASArray tjArray, ASMatrix tm, GState gState, ActualText actualText, PDFDocument pdfDocument, boolean ignoreErrors) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this(tjArray, tm, gState, true, pdfDocument, ignoreErrors);
        this.actualText = actualText;
        if (actualText != null) {
            actualText.incrementTextRunCount();
        }
        this.init();
    }

    TextRun(TextRun textRun) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.tjArray = new ASArray();
        for (ASObject obj : textRun.tjArray) {
            if (obj instanceof ASString) {
                this.tjArray.add(new ASString(((ASString)obj).getBytes()));
                continue;
            }
            this.tjArray.add(new ASNumber((ASNumber)obj));
        }
        this.tm = new ASMatrix(textRun.getTextMatrix());
        this.gState = new GState(textRun.getGState());
        this.tState = new TextState(this.gState.getTextState());
        this.characterIDGenerator = textRun.characterIDGenerator;
        this.simpleFontDataCache = textRun.simpleFontDataCache;
        this.init();
    }

    private void init() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.font = this.tState.getFont();
        if (this.font == null) {
            throw new PDFInvalidDocumentException("No font available in the text state");
        }
        this.fs = this.tState.getFontSize();
        this.h = this.tState.getHorizScaling() / 100.0;
        this.c = this.tState.getCharSpacing();
        double w = this.tState.getWordSpacing();
        this.rise = this.tState.getRise();
        this.fontIsType3 = this.font instanceof PDFFontType3;
        if (this.fontIsType3) {
            this.type3FontMatrix = ((PDFFontType3)this.font).getFontMatrix();
        }
        this.fsh = this.fs * this.h;
        this.ch = this.c * this.h;
        this.wh = w * this.h;
        this.writingMode = this.font.getWritingMode();
        this.ctm = this.getTextSpaceToDeviceSpaceCTM();
        ASCoordinate origin = new ASCoordinate(0.0, 0.0);
        ASCoordinate xVector = new ASCoordinate(1.0, 0.0);
        ASCoordinate yVector = new ASCoordinate(0.0, 1.0);
        ASCoordinate originTransformed = origin.transform(this.ctm);
        ASCoordinate xVectorTransformed = xVector.transform(this.ctm);
        ASCoordinate yVectorTransformed = yVector.transform(this.ctm);
        this.xScale = xVectorTransformed.distanceTo(originTransformed);
        this.yScale = yVectorTransformed.distanceTo(originTransformed);
        this.tsOrigin = origin.transform(this.tm);
        this.tsUnitBaseline = yVector.transform(this.tm);
        this.cacheGlyphInfo();
        this.avgCharWidth = 0.0;
    }

    public String toString() {
        try {
            return this.getUnicodeString();
        }
        catch (PDFException e) {
            return "";
        }
    }

    public ArrayList<PDFCharacter> getCharacters() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdteChars;
    }

    @Override
    public ASString getEncodedString() {
        ASObject obj;
        if (this.tjArray.size() > 1) {
            int size = 0;
            for (ASObject obj2 : this.tjArray) {
                if (!(obj2 instanceof ASString)) continue;
                size += ((ASString)obj2).getBytes().length;
            }
            byte[] bytes = new byte[size];
            int offset = 0;
            for (ASObject obj3 : this.tjArray) {
                if (!(obj3 instanceof ASString)) continue;
                byte[] strBytes = ((ASString)obj3).getBytes();
                int length = strBytes.length;
                System.arraycopy(strBytes, 0, bytes, offset, length);
                offset += length;
            }
            return new ASString(bytes);
        }
        if (this.tjArray.size() != 0 && (obj = this.tjArray.get(0)) instanceof ASString) {
            return (ASString)obj;
        }
        return new ASString("");
    }

    public void setUnicodeString(String unicode) {
        this.unicodeStr = unicode;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getUnicodeString(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.font instanceof PDFFontSimple) {
            PDFSimpleFontEncoding fontEncoding;
            PDFToUnicodeCMap toUnicodeCMap = ((PDFFontSimple)this.font).getToUnicodeCMap();
            if (toUnicodeCMap != null) {
                this.unicodeStr = toUnicodeCMap.toUnicode(charCodeBytes, 0, charCodeBytes.length);
            }
            if (toUnicodeCMap != null) {
                if (!this.unicodeStr.equals("\ufffd")) return this.unicodeStr;
            }
            if ((fontEncoding = ((PDFFontSimple)this.font).getEncoding()) != null) {
                this.unicodeStr = fontEncoding.toUnicode(charCodeBytes, 0, charCodeBytes.length, this.font.getBaseFont());
                return this.unicodeStr;
            }
            CharSetEncoding stdEnc = StandardCharSetEncodings.getDefaultCharsetForFont(this.font.getBaseFont());
            return stdEnc.toUnicode(charCodeBytes, 0, charCodeBytes.length);
        }
        if (!(this.font instanceof PDFFontType0)) return this.unicodeStr;
        PDFToUnicodeCMap toUnicodeCMap = ((PDFFontType0)this.font).getToUnicodeCMap();
        PDFType0FontEncoding fontEnc = ((PDFFontType0)this.font).getEncoding();
        if (toUnicodeCMap != null) {
            long charCode = PDFCMapUtils.getCharCode(charCodeBytes);
            this.unicodeStr = new String(toUnicodeCMap.toUnicode((int)charCode));
            return this.unicodeStr;
        }
        PDFCMap pdfCMap = fontEnc.getPDFCMap();
        ASName cmapName = fontEnc.getCMapName();
        if (cmapName != ASName.k_Identity_H && cmapName != ASName.k_Identity_V) {
            this.unicodeStr = pdfCMap.getUnicodeString(charCodeBytes);
            return this.unicodeStr;
        }
        PDFCIDSystemInfo sysInfo = ((PDFFontType0)this.font).getDescendantFont().getCIDSystemInfo();
        this.unicodeStr = pdfCMap.getUnicodeStringIdentity(sysInfo.getRegistry().toString(), sysInfo.getOrdering().toString(), charCodeBytes);
        return this.unicodeStr;
    }

    @Override
    public String getUnicodeString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.unicodeStr == null) {
            return this.getUnicodeString(this.getEncodedString().getBytes());
        }
        return this.unicodeStr;
    }

    public boolean isHorizontalWritingMode() {
        return this.writingMode == PDFWritingMode.HORIZONTAL;
    }

    private int getCharCodeCount() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCharCodeCount(this.getEncodedString().getBytes());
    }

    private int getCharCodeCount(byte[] bytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List charCodes = this.getCharCodesFromFont(bytes, false);
        return charCodes.size();
    }

    double getCharWidth(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getGlyphWidth(this.font, charCodeBytes);
    }

    private double getCharHeight(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.font.getGlyphHeight(charCodeBytes);
    }

    public Double getSpaceCharacterWidth() {
        return this.spaceCharWidth;
    }

    public void setSpaceCharWidth(Double spaceCharWidth) {
        this.spaceCharWidth = spaceCharWidth;
    }

    public double getScaledCharWidth(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double width;
        byte[] bytes = this.font.getSpaceCharCode();
        if (this.font instanceof PDFFontSimple && Arrays.equals(bytes, charCodeBytes) && (this.simpleFontDataCache.isEnabled() && this.simpleFontDataCache.getPDFSimpleFontData((PDFFontSimple)this.font).applyHeuristicsToGetSpaceCharWidth((PDFFontSimple)this.font) || !this.simpleFontDataCache.isEnabled() && this.font.applyHeuristicsToGetSpaceCharWidth())) {
            try {
                double w = this.simpleFontDataCache.getCharacterWidthEstimator().getCharacterWidth((int)PDFCMapUtils.getCharCode(bytes), (PDFFontSimple)this.font);
                if (w >= 0.0) {
                    return (w / 1000.0 * this.fs + this.c) * this.h * this.xScale;
                }
            }
            catch (InvalidFontException e) {
                new PDFInvalidDocumentException(e);
            }
            catch (UnsupportedFontException e) {
                new PDFInvalidDocumentException(e);
            }
            catch (FontLoadingException e) {
                new PDFInvalidDocumentException(e);
            }
        }
        if (this.fontIsType3) {
            double a = this.type3FontMatrix.geta();
            width = (this.font.getGlyphWidth(charCodeBytes) * a * this.fs + this.c) * this.h;
            if (width == 0.0) {
                ASRectangle bbox = ((PDFFontType3)this.font).getBBox();
                width = bbox.width() * a * 0.3;
            }
        } else {
            double fontWidth = 0.0;
            try {
                fontWidth = this.getGlyphWidth(this.font, charCodeBytes);
                if (fontWidth == 0.0 && this.font instanceof PDFFontSimple) {
                    fontWidth = ((PDFFontSimple)this.font).getGlyphWidthFromEmbeddedFontFile(charCodeBytes);
                }
            }
            catch (PDFIOException pDFIOException) {
                // empty catch block
            }
            width = (fontWidth / 1000.0 * this.fs + this.c) * this.h;
        }
        return width * this.xScale;
    }

    public double getScaledCharHeight(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double height = this.fontIsType3 ? this.font.getGlyphHeight(charCodeBytes) * this.type3FontMatrix.getd() * this.fs : this.font.getGlyphHeight(charCodeBytes) / 1000.0 * this.fs;
        return height * this.yScale;
    }

    private double getFontAscent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double ascent;
        ASRectangle rect = this.font.getBBox();
        if (rect == null) {
            return 0.0;
        }
        double bboxTop = rect.top();
        return bboxTop > (ascent = this.font.getAscent()) ? bboxTop : ascent;
    }

    private double getFontDescent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double descent;
        ASRectangle rect = this.font.getBBox();
        if (rect == null) {
            return 0.0;
        }
        double bboxBottom = rect.bottom();
        return bboxBottom < (descent = this.font.getDescent()) ? bboxBottom : descent;
    }

    private double getFontWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASRectangle bbox = this.font.getBBox();
        if (bbox == null) {
            return 0.0;
        }
        return Math.abs(bbox.right() - bbox.left());
    }

    public double getScaledFontSizeVertical() {
        return this.fs * this.yScale;
    }

    public double getScaledFontSizeHorizontal() {
        return this.fs * this.xScale;
    }

    ASCoordinate getDeviceSpaceOrigin() {
        ASCoordinate origin = new ASCoordinate(0.0, 0.0);
        origin = origin.transform(this.getFontMatrix());
        return origin.transform(this.ctm);
    }

    private ASMatrix getFontMatrix() {
        return new ASMatrix(this.fsh, 0.0, 0.0, this.fs, 0.0, this.rise);
    }

    public ASMatrix getTextSpaceToDeviceSpaceCTM() {
        return this.tm.concat(this.getGState().getCTM());
    }

    public boolean isRotatedOrSkewed() {
        return this.ctm.getb() != 0.0 || this.ctm.getc() != 0.0;
    }

    public boolean isTextPerpendicularToWritingDirection() {
        double epsilon = 1.0E-4;
        return Math.abs(Math.abs(this.getTsBaselineAngle()) - 1.5707963267948966) < 1.0E-4;
    }

    private void cacheGlyphInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.glyphExtentsCached) {
            return;
        }
        if (this.isHorizontalWritingMode()) {
            this.cacheHorizontalGlyphInfo();
        } else {
            this.cacheVerticalGlyphInfo();
        }
        this.glyphExtentsCached = true;
    }

    protected List getCharCodesFromFont(byte[] bytes, boolean fetchUnicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.font instanceof PDFFontSimple && this.simpleFontDataCache.isEnabled()) {
            return this.simpleFontDataCache.getPDFSimpleFontData((PDFFontSimple)this.font).getCharCodesFromFont(bytes, fetchUnicode, (PDFFontSimple)this.font);
        }
        return this.font.getCharCodes(bytes, fetchUnicode);
    }

    private void cacheHorizontalGlyphInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String actualTextString;
        this.pdteChars = new ArrayList();
        this.origins = new ArrayList();
        this.ends = new ArrayList();
        this.spacingEnds = new ArrayList();
        this.txDelta = 0.0;
        this.tyDelta = 0.0;
        double leftEdge = 0.0;
        double rightEdge = 0.0;
        int trCharIndex = 0;
        Iterator<ASObject> iter = this.tjArray.iterator();
        char[] actualTextChars = null;
        String string = actualTextString = this.processOnlyCharacterPosition() ? null : this.getActualTextString();
        if (actualTextString != null) {
            actualTextChars = actualTextString.toCharArray();
        }
        while (iter.hasNext()) {
            ASObject obj = iter.next();
            if (obj instanceof ASNumber) {
                double tj = ((ASNumber)obj).intValue();
                this.txDelta += -tj / 1000.0 * this.fsh;
                continue;
            }
            if (!(obj instanceof ASString)) continue;
            List charCodes = null;
            charCodes = !this.processOnlyCharacterPosition() || this.wh != 0.0 ? this.getCharCodesFromFont(((ASString)obj).getBytes(), true) : this.getCharCodesFromFont(((ASString)obj).getBytes(), false);
            int count = actualTextString != null ? 1 : charCodes.size();
            for (int j = 0; j < count; ++j) {
                byte[] charCodeBytes = (byte[])((List)charCodes.get(j)).get(0);
                int[] unicodes = null;
                if (!(actualTextString != null || this.processOnlyCharacterPosition() && this.wh == 0.0)) {
                    unicodes = (int[])((List)charCodes.get(j)).get(1);
                } else {
                    unicodes = new int[actualTextChars == null ? 0 : actualTextChars.length];
                    for (int k = 0; k < unicodes.length; ++k) {
                        unicodes[k] = actualTextChars[k];
                    }
                }
                if (this.txDelta < leftEdge) {
                    leftEdge = this.txDelta;
                }
                this.origins.add(trCharIndex, this.txDelta);
                ASCoordinate origin = new ASCoordinate(this.txDelta, 0.0);
                double w0 = 0.0;
                if (actualTextString != null) {
                    double w1 = 0.0;
                    for (int l = 0; l < charCodes.size(); ++l) {
                        byte[] charCodeBytes1 = (byte[])((List)charCodes.get(l)).get(0);
                        w1 += this.getWidth(charCodeBytes1);
                    }
                    w0 = w1;
                } else {
                    w0 = this.getWidth(charCodeBytes);
                }
                this.txDelta += w0 * this.fsh;
                ASCoordinate end = new ASCoordinate(this.txDelta, 0.0);
                this.ends.add(trCharIndex, this.txDelta);
                if (this.txDelta > rightEdge) {
                    rightEdge = this.txDelta;
                }
                this.txDelta += this.ch;
                if (unicodes != null && this.isSpace(unicodes)) {
                    this.txDelta += this.wh;
                }
                this.spacingEnds.add(trCharIndex, this.txDelta);
                ASCoordinate originTransformed = origin.transform(this.ctm);
                ASCoordinate endTransformed = end.transform(this.ctm);
                if (this.isCharacterInsideClipPath(originTransformed, endTransformed)) {
                    for (int i = 0; i < unicodes.length; ++i) {
                        if (Character.isValidCodePoint(unicodes[i])) continue;
                        unicodes[i] = 65533;
                    }
                    PDFCharacter pdeChar = new PDFCharacter(this, trCharIndex++, charCodeBytes, unicodes, originTransformed, endTransformed, this.characterIDGenerator.getNewCharacterID());
                    if (unicodes.length > 0 && Character.isSupplementaryCodePoint(unicodes[0])) {
                        pdeChar.setUnicodeString(new String(unicodes, 0, unicodes.length - 1));
                    } else {
                        pdeChar.setUnicodeString(new String(unicodes, 0, unicodes.length));
                    }
                    this.pdteChars.add(pdeChar);
                    continue;
                }
                ++trCharIndex;
            }
        }
    }

    private double getWidth(byte[] charCodeBytes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double w0 = 0.0;
        w0 = this.fontIsType3 ? this.getCharWidth(charCodeBytes) * this.type3FontMatrix.geta() : this.getCharWidth(charCodeBytes) / 1000.0;
        return w0;
    }

    private boolean isCharacterInsideClipPath(ASCoordinate origin, ASCoordinate end) {
        return this.gState.pointInsideClippingPath(origin) && this.gState.pointInsideClippingPath(end);
    }

    private void cacheVerticalGlyphInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String actualTextString;
        this.pdteChars = new ArrayList();
        this.origins = new ArrayList();
        this.ends = new ArrayList();
        this.spacingEnds = new ArrayList();
        this.txDelta = 0.0;
        this.tyDelta = 0.0;
        double topEdge = 0.0;
        double bottomEdge = 0.0;
        int trCharIndex = 0;
        char[] actualTextChars = null;
        int actualTextCharArrSize = 0;
        String string = actualTextString = this.processOnlyCharacterPosition() ? null : this.getActualTextString();
        if (actualTextString != null) {
            actualTextChars = actualTextString.toCharArray();
            actualTextCharArrSize = actualTextChars.length;
        }
        Iterator<ASObject> iter = this.tjArray.iterator();
        while (iter.hasNext()) {
            int tj = 0;
            ASObject obj = iter.next();
            if (obj instanceof ASNumber) {
                tj = ((ASNumber)obj).intValue();
                this.tyDelta += (double)(-tj) / 1000.0 * this.fs;
                continue;
            }
            if (!(obj instanceof ASString)) continue;
            List charCodes = null;
            charCodes = !this.processOnlyCharacterPosition() || this.wh != 0.0 ? this.getCharCodesFromFont(((ASString)obj).getBytes(), true) : this.getCharCodesFromFont(((ASString)obj).getBytes(), false);
            int count = actualTextString != null ? 1 : charCodes.size();
            for (int j = 0; j < count; ++j) {
                byte[] charCodeBytes = (byte[])((List)charCodes.get(j)).get(0);
                int[] unicodes = null;
                if (!(actualTextString != null || this.processOnlyCharacterPosition() && this.wh == 0.0)) {
                    unicodes = (int[])((List)charCodes.get(j)).get(1);
                } else {
                    unicodes = new int[actualTextCharArrSize];
                    for (int k = 0; k < actualTextCharArrSize; ++k) {
                        unicodes[k] = actualTextChars[k];
                    }
                }
                if (this.tyDelta > topEdge) {
                    topEdge = this.tyDelta;
                }
                this.origins.add(trCharIndex, this.tyDelta);
                ASCoordinate origin = new ASCoordinate(0.0, this.tyDelta);
                double w1 = this.fontIsType3 ? this.getCharHeight(charCodeBytes) * this.type3FontMatrix.getd() : this.getCharHeight(charCodeBytes) / 1000.0;
                this.tyDelta += w1 * this.fs;
                ASCoordinate end = new ASCoordinate(0.0, this.tyDelta);
                this.ends.add(trCharIndex, this.tyDelta);
                if (this.tyDelta < bottomEdge) {
                    bottomEdge = this.tyDelta;
                }
                this.tyDelta += this.ch;
                if (unicodes != null && this.isSpace(unicodes)) {
                    this.tyDelta += this.wh;
                }
                this.spacingEnds.add(trCharIndex, this.tyDelta);
                ASCoordinate originTransformed = origin.transform(this.ctm);
                ASCoordinate endTransformed = end.transform(this.ctm);
                if (this.isCharacterInsideClipPath(originTransformed, endTransformed)) {
                    PDFCharacter pdeChar = new PDFCharacter(this, trCharIndex++, charCodeBytes, unicodes, originTransformed, endTransformed, this.characterIDGenerator.getNewCharacterID());
                    if (unicodes.length > 0 && Character.isSupplementaryCodePoint(unicodes[0])) {
                        pdeChar.setUnicodeString(new String(unicodes, 0, unicodes.length - 1));
                    } else {
                        pdeChar.setUnicodeString(new String(unicodes, 0, unicodes.length));
                    }
                    this.pdteChars.add(pdeChar);
                    continue;
                }
                ++trCharIndex;
            }
        }
    }

    protected boolean processOnlyCharacterPosition() {
        return false;
    }

    public ASRectangle getRectangleForCharCodeIndex(int index) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isHorizontalWritingMode()) {
            double descent;
            double ascent;
            if (this.fontIsType3) {
                double d = this.type3FontMatrix.getd();
                ascent = this.getFontAscent() * d * this.fs;
                descent = this.getFontDescent() * d * this.fs;
            } else {
                ascent = this.getFontAscent() / 1000.0 * this.fs;
                descent = this.getFontDescent() / 1000.0 * this.fs;
            }
            ASCoordinate ll = new ASCoordinate(this.origins.get(index), descent);
            ASCoordinate ur = new ASCoordinate(this.ends.get(index), ascent);
            return new ASRectangle(ll, ur);
        }
        double rightEdge = this.fontIsType3 ? this.getFontWidth() * this.type3FontMatrix.geta() / 2.0 * this.fs : this.getFontWidth() / 1000.0 / 2.0 * this.fs;
        double leftEdge = -rightEdge;
        ASCoordinate ll = new ASCoordinate(leftEdge, this.ends.get(index));
        ASCoordinate ur = new ASCoordinate(rightEdge, this.origins.get(index));
        return new ASRectangle(ll, ur);
    }

    public ASRectangle getRectangleForTextRun(boolean singleTj, boolean getSpacingEnd) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int spacingEndsLength = this.spacingEnds.size();
        int endsLength = this.ends.size();
        if (this.isHorizontalWritingMode()) {
            double descent;
            double ascent;
            if (this.fontIsType3) {
                double d = this.type3FontMatrix.getd();
                ascent = this.getFontAscent() * d * this.fs;
                descent = this.getFontDescent() * d * this.fs;
            } else {
                ascent = this.getFontAscent() / 1000.0 * this.fs;
                descent = this.getFontDescent() / 1000.0 * this.fs;
            }
            if (singleTj) {
                ASCoordinate ll = new ASCoordinate(this.origins.get(0), descent);
                ASCoordinate ur = null;
                ur = getSpacingEnd ? new ASCoordinate(this.spacingEnds.get(spacingEndsLength - 1), ascent) : new ASCoordinate(this.ends.get(endsLength - 1), ascent);
                return new ASRectangle(ll, ur);
            }
            return this.getTextSpaceRectHorizontal(0, endsLength, false, ascent, descent);
        }
        double rightEdge = this.fontIsType3 ? this.getFontWidth() * this.type3FontMatrix.geta() / 2.0 * this.fs : this.getFontWidth() / 1000.0 / 2.0 * this.fs;
        double leftEdge = -rightEdge;
        if (singleTj) {
            ASCoordinate ur = new ASCoordinate(rightEdge, this.origins.get(0));
            ASCoordinate ll = null;
            ll = getSpacingEnd ? new ASCoordinate(leftEdge, this.spacingEnds.get(spacingEndsLength - 1)) : new ASCoordinate(leftEdge, this.ends.get(endsLength - 1));
            return new ASRectangle(ll, ur);
        }
        return this.getTextSpaceRectVertical(0, endsLength, false, leftEdge, rightEdge);
    }

    private ASRectangle getTextSpaceRectHorizontal(int start, int length, boolean includeLastSpacing, double ascent, double descent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASCoordinate ur;
        ASCoordinate ll;
        double leftEdge = this.origins.get(start);
        double rightEdge = this.ends.get(start);
        double spacingEdge = this.spacingEnds.get(start);
        if (length > 1) {
            for (int i = start + 1; i < start + length; ++i) {
                if (this.origins.get(i) < leftEdge) {
                    leftEdge = this.origins.get(i);
                }
                if (this.ends.get(i) > rightEdge) {
                    rightEdge = this.ends.get(i);
                }
                if (!(this.spacingEnds.get(i) > spacingEdge)) continue;
                spacingEdge = this.spacingEnds.get(i);
            }
        }
        if (!includeLastSpacing) {
            ll = new ASCoordinate(leftEdge, descent);
            ur = new ASCoordinate(rightEdge, ascent);
        } else {
            ll = new ASCoordinate(leftEdge, descent);
            ur = new ASCoordinate(spacingEdge, ascent);
        }
        return new ASRectangle(ll, ur);
    }

    private ASRectangle getTextSpaceRectVertical(int start, int length, boolean includeLastSpacing, double leftEdge, double rightEdge) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASCoordinate ur;
        ASCoordinate ll;
        double topEdge = this.origins.get(start);
        double bottomEdge = this.ends.get(start);
        double spacingEdge = this.spacingEnds.get(start);
        if (length > 1) {
            for (int i = start + 1; i < start + length; ++i) {
                if (this.origins.get(i) > topEdge) {
                    topEdge = this.origins.get(i);
                }
                if (this.ends.get(i) < bottomEdge) {
                    bottomEdge = this.ends.get(i);
                }
                if (!(this.spacingEnds.get(i) < spacingEdge)) continue;
                spacingEdge = this.spacingEnds.get(i);
            }
        }
        if (!includeLastSpacing) {
            ll = new ASCoordinate(leftEdge, bottomEdge);
            ur = new ASCoordinate(rightEdge, topEdge);
        } else {
            ll = new ASCoordinate(leftEdge, spacingEdge);
            ur = new ASCoordinate(rightEdge, topEdge);
        }
        return new ASRectangle(ll, ur);
    }

    public ASQuad getTextSpaceBoundingQuad(int start, int length, boolean includeLastSpacing) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isHorizontalWritingMode()) {
            double descent;
            double ascent;
            if (this.fontIsType3) {
                double d = this.type3FontMatrix.getd();
                ascent = this.getFontAscent() * d * this.fs;
                descent = this.getFontDescent() * d * this.fs;
            } else {
                ascent = this.getFontAscent() / 1000.0 * this.fs;
                descent = this.getFontDescent() / 1000.0 * this.fs;
            }
            return new ASQuad(this.getTextSpaceRectHorizontal(start, length, includeLastSpacing, ascent, descent));
        }
        double rightEdge = this.fontIsType3 ? this.getFontWidth() * this.type3FontMatrix.geta() / 2.0 * this.fs : this.getFontWidth() / 1000.0 / 2.0 * this.fs;
        double leftEdge = -rightEdge;
        return new ASQuad(this.getTextSpaceRectVertical(start, length, includeLastSpacing, leftEdge, rightEdge));
    }

    public ASQuad getTextSpaceBoundingQuadMin() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getTextSpaceBoundingQuad(0, this.getCharCodeCount(), false);
    }

    public ASQuad getTextSpaceBoundingQuadMax() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getTextSpaceBoundingQuad(0, this.getCharCodeCount(), true);
    }

    @Override
    public List<ASQuad> getBoundingQuadsMin() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<ASQuad> list = new ArrayList<ASQuad>(1);
        ASQuad quad = this.getTextSpaceBoundingQuadMin().transform(this.ctm);
        list.add(quad);
        return list;
    }

    @Override
    public List<ASQuad> getBoundingQuadsMax() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<ASQuad> list = new ArrayList<ASQuad>(1);
        ASQuad quad = this.getTextSpaceBoundingQuadMax().transform(this.ctm);
        list.add(quad);
        return list;
    }

    public boolean isSpace(int[] unicodes) {
        if (unicodes.length != 1) {
            return false;
        }
        return Character.getType(unicodes[0]) == 12;
    }

    public boolean isMe(int[] unicodes) {
        if (unicodes == null) {
            return false;
        }
        if (unicodes.length != 1) {
            return false;
        }
        int type = Character.getType(unicodes[0]);
        return type == 7 || type == 6 || type == 8;
    }

    public static boolean isCharacterRTL(int[] unicodes) {
        if (unicodes == null) {
            return false;
        }
        if (unicodes.length == 0) {
            return false;
        }
        byte direction = Character.getDirectionality(unicodes[0]);
        return direction == 1 || direction == 2 || direction == 16 || direction == 17;
    }

    public ASMatrix getTextMatrix() {
        return this.tm;
    }

    public TextState getTextState() {
        return this.tState;
    }

    public GState getGState() {
        return this.gState;
    }

    public ActualText getActualText() {
        return this.actualText;
    }

    public String getActualTextString() {
        return this.actualText == null ? null : this.actualText.getActualTextString();
    }

    private double getGlyphWidth(PDFFont font, byte[] charCodeBytes) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (font instanceof PDFFontSimple && this.simpleFontDataCache.isEnabled()) {
            long charCode = PDFCMapUtils.getCharCode(charCodeBytes);
            PDFSimpleFontData fontData = this.simpleFontDataCache.getPDFSimpleFontData((PDFFontSimple)font);
            return fontData.getWidth((int)charCode, (PDFFontSimple)font);
        }
        return font.getGlyphWidth(charCodeBytes);
    }

    public double getH() {
        return this.h;
    }

    public void setH(double h) {
        this.h = h;
    }

    public double getRise() {
        return this.rise;
    }

    public void setRise(double rise) {
        this.rise = rise;
    }

    public double getAvgCharWidth() {
        return this.avgCharWidth;
    }

    public void setAvgCharWidth(double avgCharWidth) {
        this.avgCharWidth = avgCharWidth;
    }

    public double getTsBaselineAngle() {
        if (this.tsBaselineAngle == null) {
            this.tsBaselineAngle = this.tsOrigin.angleTo(this.tsUnitBaseline);
        }
        return this.tsBaselineAngle;
    }

    public ArrayList<Double> getSpacingEnds() {
        return this.spacingEnds;
    }

    public double getTotalXShift() {
        return this.txDelta;
    }

    public double getTotalYShift() {
        return this.tyDelta;
    }

    public boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    public ASRectangle getTextRunGlyphBounds() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        GeneralPath glyphOutlines = Word.getSublistGlyphOutline(this.getCharacters());
        if (glyphOutlines == null) {
            return null;
        }
        Rectangle2D textRunBounds = glyphOutlines.getBounds2D();
        ASRectangle textRunRectangle = new ASRectangle(textRunBounds.getMinX(), textRunBounds.getMinY(), textRunBounds.getMaxX(), textRunBounds.getMaxY());
        return textRunRectangle;
    }
}

