/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;

class SpecialGStateOperator
extends ContentOperator {
    static final int q = 1;
    static final int Q = 2;
    static final int cm = 3;

    SpecialGStateOperator(int type, ASName name) {
        super(type, name);
    }

    @Override
    public void process(Instruction instruction, IOperatorHandler opHandlers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        OperandStack opStack = instruction.getReadonlyOperands();
        switch (this.getType()) {
            case 1: {
                opHandlers.q(instruction);
                break;
            }
            case 2: {
                opHandlers.Q(instruction);
                break;
            }
            case 3: {
                double f = opStack.popNumber().doubleValue();
                double e = opStack.popNumber().doubleValue();
                double d = opStack.popNumber().doubleValue();
                double c = opStack.popNumber().doubleValue();
                double b = opStack.popNumber().doubleValue();
                double a = opStack.popNumber().doubleValue();
                opHandlers.cm(a, b, c, d, e, f, instruction);
            }
        }
    }
}

