/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.processor.Path;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDashPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFLineCap;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFLineJoin;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import java.awt.geom.Area;

public class GState {
    private PDFOCObject ocGroup;
    private ASMatrix ctm = ASMatrix.createIdentityMatrix();
    protected Area clippingArea;
    private double lineWidth = 1.0;
    private PDFLineCap lineCap = PDFLineCap.BUTT_CAP;
    private PDFLineJoin lineJoin = PDFLineJoin.MITER_JOIN;
    private double miterLimit = 10.0;
    private PDFDashPattern dashPattern = new PDFDashPattern();
    private PDFRenderingIntent renderingIntent = PDFRenderingIntent.RELATIVE_COLORIMETRIC;
    private boolean strokeAdjustment = false;
    private ASName[] blendMode = null;
    private CosDictionary softMask = null;
    private double strokeAlpha = 1.0;
    private double nonStrokeAlpha = 1.0;
    private boolean alphaSource = false;
    private double alphaConstant = 1.0;
    private boolean strokeOverprint = false;
    private boolean nonStrokeOverprint = false;
    private int overprintMode = 0;
    private double flatness = 1.0;
    private double smoothness = 0.0;
    private boolean textKnockout = true;
    private TextState textState = new TextState();
    private ASName useBlackPTComp = ASName.k_Default;
    protected boolean isClipAreaInfinite = false;

    public GState(ASRectangle clipRect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.clippingArea = new Area(new Path(clipRect).getShape());
    }

    public GState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.isClipAreaInfinite = true;
    }

    protected void initClippingArea() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASRectangle rect = new ASRectangle(-3.4028234663852886E38, -3.4028234663852886E38, 3.4028234663852886E38, 3.4028234663852886E38);
        this.clippingArea = new Area(new Path(rect).getShape());
    }

    public GState(GState gState) {
        this.ctm = gState.ctm;
        if (gState.clippingArea != null) {
            this.clippingArea = new Area(gState.clippingArea);
        }
        this.lineWidth = gState.lineWidth;
        this.lineCap = gState.lineCap;
        this.lineJoin = gState.lineJoin;
        this.miterLimit = gState.miterLimit;
        this.dashPattern = new PDFDashPattern(gState.dashPattern);
        this.renderingIntent = gState.renderingIntent;
        this.strokeAdjustment = gState.strokeAdjustment;
        this.strokeAlpha = gState.strokeAlpha;
        this.nonStrokeAlpha = gState.nonStrokeAlpha;
        this.alphaSource = gState.alphaSource;
        this.alphaConstant = gState.alphaConstant;
        this.strokeOverprint = gState.strokeOverprint;
        this.nonStrokeOverprint = gState.nonStrokeOverprint;
        this.flatness = gState.flatness;
        this.smoothness = gState.smoothness;
        this.ocGroup = gState.ocGroup;
        this.textState = new TextState(gState.textState);
        this.isClipAreaInfinite = gState.isClipAreaInfinite;
        this.blendMode = gState.getBlendMode();
        this.softMask = gState.getSoftMask();
        this.overprintMode = gState.getOverprintMode();
    }

    public ASMatrix getCTM() {
        return this.ctm;
    }

    public void setCTM(ASMatrix ctm) {
        this.ctm = ctm;
    }

    public void addPathToClip(Path clipPath) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.isClipAreaInfinite = false;
        if (this.clippingArea == null) {
            this.initClippingArea();
        }
        this.clippingArea.intersect(clipPath.getArea());
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public PDFLineCap getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(PDFLineCap lineCap) {
        this.lineCap = lineCap;
    }

    public PDFLineJoin getLineJoin() {
        return this.lineJoin;
    }

    public void setLineJoin(PDFLineJoin lineJoin) {
        this.lineJoin = lineJoin;
    }

    public double getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(double miterLimit) {
        this.miterLimit = miterLimit;
    }

    public PDFDashPattern getDashPattern() {
        return this.dashPattern;
    }

    public void setDashPattern(PDFDashPattern dashPattern) {
        this.dashPattern = dashPattern;
    }

    public PDFRenderingIntent getRenderingIntent() {
        return this.renderingIntent;
    }

    public void setRenderingIntent(PDFRenderingIntent intent) {
        this.renderingIntent = intent;
    }

    public boolean getStrokeAdjustment() {
        return this.strokeAdjustment;
    }

    public void setStrokeAdjustment(boolean strokeAdjustment) {
        this.strokeAdjustment = strokeAdjustment;
    }

    public double getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public void setStrokeAlpha(double alpha) {
        this.strokeAlpha = alpha;
    }

    public double getNonStrokeAlpha() {
        return this.nonStrokeAlpha;
    }

    public void setNonStrokeAlpha(double alpha) {
        this.nonStrokeAlpha = alpha;
    }

    public boolean getAlphaSource() {
        return this.alphaSource;
    }

    public void setAlphaSource(boolean alphaSource) {
        this.alphaSource = alphaSource;
    }

    public double getAlphaConstant() {
        return this.alphaConstant;
    }

    public void setAlphaConstant(double alphaConstant) {
        this.alphaConstant = alphaConstant;
    }

    public boolean getStrokeOverprint() {
        return this.strokeOverprint;
    }

    public void setStrokeOverprint(boolean overprint) {
        this.strokeOverprint = overprint;
    }

    public boolean getNonStrokeOverprint() {
        return this.nonStrokeOverprint;
    }

    public void setNonStrokeOverprint(boolean overprint) {
        this.nonStrokeOverprint = overprint;
    }

    public int getOverprintMode() {
        return this.overprintMode;
    }

    public void setOverprintMode(int overprintMode) {
        this.overprintMode = overprintMode;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public void setFlatness(double flatness) {
        this.flatness = flatness;
    }

    public double getSmoothness() {
        return this.smoothness;
    }

    public void setSmoothness(double smoothness) {
        this.smoothness = smoothness;
    }

    public CosDictionary getSoftMask() {
        return this.softMask;
    }

    public void setSoftMask(CosDictionary softMask) {
        this.softMask = softMask;
    }

    public boolean getTextKnockout() {
        return this.textKnockout;
    }

    public void setTextKnockout(boolean textKnockout) {
        this.textKnockout = textKnockout;
    }

    public TextState getTextState() {
        return this.textState;
    }

    public void setTextState(TextState textState) {
        this.textState = textState;
    }

    public ASName getUseBlackPTComp() {
        return this.useBlackPTComp;
    }

    public void setUseBlackPTComp(ASName useBlackPTComp) {
        this.useBlackPTComp = useBlackPTComp;
    }

    public PDFOCObject getOcGroup() {
        return this.ocGroup;
    }

    public void setOcGroup(PDFOCObject ocGroup) {
        this.ocGroup = ocGroup;
    }

    public void setBlendMode(ASName[] bleandMode) {
        this.blendMode = bleandMode;
    }

    public ASName[] getBlendMode() {
        return this.blendMode;
    }

    public void loadExtGState(PDFExtGState extGState) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (extGState != null) {
            if (extGState.hasLineWidth()) {
                this.setLineWidth(extGState.getLineWidth());
            }
            if (extGState.hasLineCap()) {
                try {
                    this.setLineCap(PDFLineCap.getInstance(extGState.getLineCap()));
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException(e);
                }
            }
            if (extGState.hasLineJoin()) {
                try {
                    this.setLineJoin(PDFLineJoin.getInstance(extGState.getLineJoin()));
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException(e);
                }
            }
            if (extGState.hasMiterLimit()) {
                this.setMiterLimit(extGState.getMiterLimit());
            }
            if (extGState.hasRenderingIntent()) {
                PDFRenderingIntent intent = PDFRenderingIntent.getIntentForValue(extGState.getRenderingIntent());
                if (intent == null) {
                    throw new PDFInvalidDocumentException("unrecognized rendering intent");
                }
                this.setRenderingIntent(intent);
            }
            if (extGState.hasOverprintStroke()) {
                this.setStrokeOverprint(extGState.getOverprintStroke());
            }
            if (extGState.hasOverprintFill()) {
                this.setNonStrokeOverprint(extGState.getOverprintFill());
            } else if (extGState.hasOverprintStroke()) {
                this.setNonStrokeOverprint(extGState.getOverprintStroke());
            }
            if (extGState.hasOverprintMode()) {
                this.setOverprintMode(extGState.getOverprintMode());
            }
            if (extGState.hasFlatness()) {
                this.setFlatness(extGState.getFlatness());
            }
            if (extGState.hasSmoothness()) {
                this.setSmoothness(extGState.getSmoothness());
            }
            if (extGState.haStrokeAdjustment()) {
                this.setStrokeAdjustment(extGState.getStrokeAdjustment());
            }
            if (extGState.hasOpacityStroke()) {
                this.setStrokeAlpha(extGState.getOpacityStroke());
            }
            if (extGState.hasOpacityFill()) {
                this.setNonStrokeAlpha(extGState.getOpacityFill());
            }
            if (extGState.hasAlphaSource()) {
                this.setAlphaSource(extGState.getAlphaSource());
            }
            if (extGState.hasTextKnockout()) {
                this.setTextKnockout(extGState.getTextKnockout());
            }
            if (extGState.hasBlendMode()) {
                this.setBlendMode(extGState.getBlendMode());
            }
            if (extGState.hasSoftMask()) {
                CosObject value = extGState.getCosDictionary().get(ASName.k_SMask);
                if (value instanceof CosDictionary) {
                    this.setSoftMask((CosDictionary)value);
                } else if (value instanceof CosName && value.nameValue() == ASName.k_None) {
                    this.setSoftMask(null);
                }
            }
        }
    }

    public boolean pointInsideClippingPath(ASCoordinate point) {
        return this.isClipAreaInfinite || this.clippingArea.contains(point.x(), point.y());
    }
}

