/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASBoolean;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASHexString;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNull;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.core.util.ParseOps;
import com.adobe.internal.pdftoolkit.pdf.content.Token;
import java.io.IOException;
import java.util.HashSet;

class Tokenizer {
    private static final byte[] closeDictionary = new byte[]{62, 62};
    private static final byte[] closeArray = new byte[]{93};
    private static final byte[] endOfStream = new byte[]{-1};
    private InputByteStream ibs;
    private HashSet<ASName> operators;
    private boolean ignoreThisToken = true;
    private long lastInstrPos = 0L;
    private final boolean skipOperators;

    public Tokenizer(InputByteStream ibs, HashSet<ASName> operators) {
        this.ibs = ibs;
        this.operators = operators;
        this.skipOperators = operators != null && !operators.isEmpty();
    }

    Token nextToken() throws PDFParseException, PDFIOException {
        if (this.skipOperators) {
            return this.nextTokenWithSkipping();
        }
        return this.getNextToken();
    }

    private Token getNextToken() throws PDFParseException, PDFIOException {
        try {
            if (this.ibs == null) {
                return null;
            }
            if (this.ibs.eof()) {
                return null;
            }
            byte cur = ParseOps.skipWhitespace(this.ibs);
            if (ByteOps.isWhitespace(cur) || cur == 37) {
                return null;
            }
            if (ByteOps.isDigit(cur) || cur == 43 || cur == 45 || cur == 46) {
                return Token.newOperand(ParseOps.readNumber(cur, this.ibs));
            }
            if (cur == 47) {
                return Token.newOperand(ParseOps.readName(this.ibs));
            }
            if (cur == 40) {
                return Token.newOperand(new ASString(ParseOps.readLiteral(this.ibs)));
            }
            if (cur != 60 && cur != 62 && cur != 91 && cur != 93) {
                this.ibs.unget();
                ASName bareWord = ParseOps.readName(this.ibs);
                if (bareWord.getBytes().length == 0) {
                    throw new PDFParseException("Error in tokenizing content stream.");
                }
                if (bareWord == ASName.k_true) {
                    return Token.newOperand(new ASBoolean(true));
                }
                if (bareWord == ASName.k_false) {
                    return Token.newOperand(new ASBoolean(false));
                }
                if (bareWord == ASName.k_null) {
                    return Token.newOperand(new ASNull());
                }
                if (!this.ignoreThisToken) {
                    this.ignoreThisToken = true;
                }
                return Token.newOperator(bareWord);
            }
            if (cur == 60) {
                cur = (byte)this.ibs.read();
                if (cur == 60) {
                    return Token.newOperand(this.readDictionary());
                }
                this.ibs.unget();
                byte[] str = ParseOps.readHex(this.ibs);
                return Token.newOperand(new ASHexString(str));
            }
            if (cur == 62) {
                cur = (byte)this.ibs.read();
                if (cur == 62) {
                    return Token.newOperand(closeDictionary);
                }
                throw new PDFParseException("Expected '>' - " + Long.toString(this.ibs.getPosition()));
            }
            if (cur == 91) {
                return Token.newOperand(this.readArray());
            }
            if (cur == 93) {
                return Token.newOperand(closeArray);
            }
            throw new PDFParseException("Unexpected token - " + Long.toString(this.ibs.getPosition()));
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    Token nextTokenWithSkipping() throws PDFParseException, PDFIOException {
        try {
            while (this.ibs != null && !this.ibs.eof() && this.ignoreThisToken) {
                this.skipNextToken();
            }
            return this.getNextToken();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    Token skipNextToken() throws PDFParseException, PDFIOException {
        block20: {
            try {
                if (this.ibs == null) {
                    return Token.newOperand(endOfStream);
                }
                if (this.ibs.eof()) {
                    return Token.newOperand(endOfStream);
                }
                byte cur = ParseOps.skipWhitespace(this.ibs);
                if (ByteOps.isWhitespace(cur)) {
                    return null;
                }
                if (ByteOps.isDigit(cur) || cur == 43 || cur == 45 || cur == 46) {
                    ParseOps.skipNumber(cur, this.ibs);
                    return null;
                }
                if (cur == 47) {
                    ParseOps.skipName(this.ibs);
                    return null;
                }
                if (cur == 40) {
                    ParseOps.skipLiteral(this.ibs);
                    return null;
                }
                if (cur != 60 && cur != 62 && cur != 91 && cur != 93) {
                    this.ibs.unget();
                    ASName bareWord = ParseOps.readName(this.ibs);
                    if (bareWord == ASName.k_true) {
                        return null;
                    }
                    if (bareWord == ASName.k_false) {
                        return null;
                    }
                    if (bareWord == ASName.k_null) {
                        return null;
                    }
                    if (bareWord.getBytes().length == 0) {
                        this.ibs.read();
                        return null;
                    }
                    long lastPos = this.lastInstrPos;
                    this.lastInstrPos = this.ibs.getPosition();
                    if (this.operators.contains(bareWord)) {
                        this.ignoreThisToken = false;
                        this.ibs.seek(lastPos);
                        return null;
                    }
                    break block20;
                }
                if (cur == 60) {
                    cur = (byte)this.ibs.read();
                    if (cur == 60) {
                        this.skipDictionary();
                        return null;
                    }
                    this.ibs.unget();
                    ParseOps.skipHex(this.ibs);
                    return null;
                }
                if (cur == 62) {
                    cur = (byte)this.ibs.read();
                    if (cur == 62) {
                        return Token.newOperand(closeDictionary);
                    }
                    throw new PDFParseException("Expected '>' - " + Long.toString(this.ibs.getPosition()));
                }
                if (cur == 91) {
                    this.skipArray();
                    return null;
                }
                if (cur == 93) {
                    return Token.newOperand(closeArray);
                }
                throw new PDFParseException("Unexpected token - " + Long.toString(this.ibs.getPosition()));
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        return null;
    }

    private void skipDictionary() throws PDFParseException, PDFIOException {
        Token keyToken;
        while ((keyToken = this.skipNextToken()) == null || keyToken.getValue() != closeDictionary && keyToken.getValue() != endOfStream) {
            this.skipNextToken();
        }
        return;
    }

    private ASDictionary readDictionary() throws PDFParseException, PDFIOException {
        try {
            ASDictionary asDictionary = new ASDictionary();
            while (true) {
                Token keyToken;
                if ((keyToken = this.getNextToken()) == null || keyToken.getValue() == closeDictionary) {
                    return asDictionary;
                }
                if (!(keyToken.getValue() instanceof ASName)) {
                    throw new PDFParseException("name expected" + Long.toString(this.ibs.getPosition()));
                }
                Token valueToken = this.nextToken();
                asDictionary.put((ASName)keyToken.getValue(), (ASObject)valueToken.getValue());
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private void skipArray() throws PDFParseException, PDFIOException {
        Token token;
        while ((token = this.skipNextToken()) == null || token.getValue() != closeArray && token.getValue() != endOfStream) {
        }
    }

    private ASArray readArray() throws PDFParseException, PDFIOException {
        ASArray asArray = new ASArray();
        Token token;
        while ((token = this.getNextToken()) != null && token.getValue() != closeArray) {
            asArray.add((ASObject)token.getValue());
        }
        return asArray;
    }
}

