/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASHexString;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import java.util.Set;

public class InstructionFactory {
    private InstructionFactory() {
    }

    public static Instruction newGSave() {
        return new Instruction(ASName.k_q);
    }

    public static Instruction newGRestore() {
        return new Instruction(ASName.k_Q);
    }

    public static Instruction newConcatMatrix(double a, double b, double c, double d, double x, double y) {
        Instruction inst = new Instruction(ASName.k_cm);
        inst.push(a);
        inst.push(b);
        inst.push(c);
        inst.push(d);
        inst.push(x);
        inst.push(y);
        return inst;
    }

    public static Instruction newColorStroke(double[] colorComponents) throws PDFInvalidParameterException {
        Instruction colorInstruction = null;
        if (colorComponents != null) {
            switch (colorComponents.length) {
                case 0: {
                    break;
                }
                case 1: {
                    colorInstruction = InstructionFactory.newDeviceGrayStroke(colorComponents[0]);
                    break;
                }
                case 3: {
                    colorInstruction = InstructionFactory.newDeviceRGBStroke(colorComponents[0], colorComponents[1], colorComponents[2]);
                    break;
                }
                case 4: {
                    colorInstruction = InstructionFactory.newDeviceCMYKStroke(colorComponents[0], colorComponents[1], colorComponents[2], colorComponents[3]);
                    break;
                }
                default: {
                    throw new PDFInvalidParameterException("Invalid length '" + colorComponents.length + "' of color component array, should be 1 (DeviceGray), 3 (DeviceRGB) or 4 (DeviceCMYK)");
                }
            }
        }
        return colorInstruction;
    }

    public static Instruction newColorFill(double[] colorComponents) throws PDFInvalidParameterException {
        Instruction colorInstruction = null;
        if (colorComponents != null) {
            switch (colorComponents.length) {
                case 0: {
                    break;
                }
                case 1: {
                    colorInstruction = InstructionFactory.newDeviceGrayFill(colorComponents[0]);
                    break;
                }
                case 3: {
                    colorInstruction = InstructionFactory.newDeviceRGBFill(colorComponents[0], colorComponents[1], colorComponents[2]);
                    break;
                }
                case 4: {
                    colorInstruction = InstructionFactory.newDeviceCMYKFill(colorComponents[0], colorComponents[1], colorComponents[2], colorComponents[3]);
                    break;
                }
                default: {
                    throw new PDFInvalidParameterException("Invalid length '" + colorComponents.length + "' of color component array, should be 1 (DeviceGray), 3 (DeviceRGB) or 4 (DeviceCMYK)");
                }
            }
        }
        return colorInstruction;
    }

    public static Instruction newDeviceGrayStroke(double gray) {
        Instruction inst = new Instruction(ASName.k_G);
        inst.push(gray);
        return inst;
    }

    public static Instruction newDeviceGrayFill(double gray) {
        Instruction inst = new Instruction(ASName.k_g);
        inst.push(gray);
        return inst;
    }

    public static Instruction newDeviceRGBStroke(double red, double green, double blue) {
        Instruction inst = new Instruction(ASName.k_RG);
        inst.push(red);
        inst.push(green);
        inst.push(blue);
        return inst;
    }

    public static Instruction newDeviceRGBFill(double red, double green, double blue) {
        Instruction inst = new Instruction(ASName.k_rg);
        inst.push(red);
        inst.push(green);
        inst.push(blue);
        return inst;
    }

    public static Instruction newDeviceCMYKStroke(double c, double m, double y, double k) {
        Instruction inst = new Instruction(ASName.k_K);
        inst.push(c);
        inst.push(m);
        inst.push(y);
        inst.push(k);
        return inst;
    }

    public static Instruction newDeviceCMYKFill(double c, double m, double y, double k) {
        Instruction inst = new Instruction(ASName.k_k);
        inst.push(c);
        inst.push(m);
        inst.push(y);
        inst.push(k);
        return inst;
    }

    public static Instruction newLineWidth(double lineWidth) {
        Instruction inst = new Instruction(ASName.k_w);
        inst.push(lineWidth);
        return inst;
    }

    public static Instruction newLineCapStyle(int style) {
        Instruction inst = new Instruction(ASName.k_J);
        inst.push(style);
        return inst;
    }

    public static Instruction newLineJoin(int join) {
        Instruction inst = new Instruction(ASName.k_j);
        inst.push(join);
        return inst;
    }

    public static Instruction newMiterLimit(double miter) {
        Instruction inst = new Instruction(ASName.k_M);
        inst.push(miter);
        return inst;
    }

    public static Instruction newLineDashPattern(double[] dash, int phase) {
        Instruction inst = new Instruction(ASName.k_d);
        ASArray dashArray = new ASArray();
        for (int i = 0; i < dash.length; ++i) {
            ASNumber dashDbl = new ASNumber(dash[i]);
            dashArray.add(dashDbl);
        }
        inst.push(dashArray);
        inst.push(phase);
        return inst;
    }

    public static Instruction newInvokeNamedXObject(ASName xobjectName) {
        Instruction inst = new Instruction(ASName.k_Do);
        inst.push(xobjectName);
        return inst;
    }

    public static Instruction newInvokeNamedExtGState(ASName extgstateName) {
        Instruction inst = new Instruction(ASName.k_gs);
        inst.push(extgstateName);
        return inst;
    }

    public static Instruction newBeginText() {
        return new Instruction(ASName.k_BT);
    }

    public static Instruction newEndText() {
        return new Instruction(ASName.k_ET);
    }

    public static Instruction newCharactorSpacing(double charSpace) {
        Instruction inst = new Instruction(ASName.k_Tc);
        inst.push(charSpace);
        return inst;
    }

    public static Instruction newWordSpacing(double wordSpace) {
        Instruction inst = new Instruction(ASName.k_Tw);
        inst.push(wordSpace);
        return inst;
    }

    public static Instruction newHorizontalScaling(double horizontalScale) {
        Instruction inst = new Instruction(ASName.k_Tz);
        inst.push(horizontalScale);
        return inst;
    }

    public static Instruction newTextLeading(double textLeading) {
        Instruction inst = new Instruction(ASName.k_TL);
        inst.push(textLeading);
        return inst;
    }

    public static Instruction newTextFont(ASName fontName, double fontSize) {
        Instruction inst = new Instruction(ASName.k_Tf);
        inst.push(fontName);
        inst.push(fontSize);
        return inst;
    }

    public static Instruction newTextFont(ASName fontName, ASNumber fontSize) {
        Instruction inst = new Instruction(ASName.k_Tf);
        inst.push(fontName);
        inst.push(fontSize);
        return inst;
    }

    public static Instruction newTextRenderingMode(int renderingMode) {
        Instruction inst = new Instruction(ASName.k_Tr);
        inst.push(renderingMode);
        return inst;
    }

    public static Instruction newTextRise(double textRise) {
        Instruction inst = new Instruction(ASName.k_Ts);
        inst.push(textRise);
        return inst;
    }

    public static Instruction newTextPosition(double tX, double tY) {
        Instruction inst = new Instruction(ASName.k_Td);
        inst.push(tX);
        inst.push(tY);
        return inst;
    }

    public static Instruction newTextPositionAndLeading(double tX, double tY) {
        Instruction inst = new Instruction(ASName.k_TD);
        inst.push(tX);
        inst.push(tY);
        return inst;
    }

    public static Instruction newTextMatrix(double a, double b, double c, double d, double e, double f) {
        Instruction inst = new Instruction(ASName.k_Tm);
        inst.push(a);
        inst.push(b);
        inst.push(c);
        inst.push(d);
        inst.push(e);
        inst.push(f);
        return inst;
    }

    public static Instruction newTextNextLine() {
        return new Instruction(ASName.k_TStar);
    }

    public static Instruction newShowText(byte[] text) {
        Instruction inst = new Instruction(ASName.k_Tj);
        inst.push(new ASString(text));
        return inst;
    }

    public static Instruction newShowText(ASHexString hexStr) {
        Instruction inst = new Instruction(ASName.k_Tj);
        inst.push(hexStr);
        return inst;
    }

    public static Instruction newShowText(ASString str) {
        Instruction inst = new Instruction(ASName.k_Tj);
        inst.push(str);
        return inst;
    }

    private static Instruction newShowWithCCode(int[] text, int startIndex, int endIndex, int numBytes) throws PDFIOException, PDFParseException {
        Instruction inst = new Instruction(ASName.k_Tj);
        try {
            inst.push(new ASString(text, startIndex, endIndex, numBytes, 0));
        }
        catch (PDFInvalidParameterException e) {
            throw new RuntimeException("Internal coding error.", e);
        }
        return inst;
    }

    public static Instruction newShow2BytesCIDs(int[] text) throws PDFIOException, PDFParseException {
        return InstructionFactory.newShowWithCCode(text, 0, text.length - 1, 2);
    }

    public static Instruction newShow2ByteCCodes(int[] text, int startIndex, int endIndex) throws PDFIOException, PDFParseException {
        return InstructionFactory.newShowWithCCode(text, startIndex, endIndex, 2);
    }

    public static Instruction newShow1ByteCIDs(int[] text) throws PDFIOException, PDFParseException {
        return InstructionFactory.newShowWithCCode(text, 0, text.length - 1, 1);
    }

    public static Instruction newShow1ByteCCodes(int[] text, int startIndex, int endIndex) throws PDFIOException, PDFParseException {
        return InstructionFactory.newShowWithCCode(text, startIndex, endIndex, 1);
    }

    public static Instruction newShowTextNextLine(byte[] text) {
        Instruction inst = new Instruction(ASName.k_SingleQuote);
        inst.push(new ASString(text));
        return inst;
    }

    public static Instruction newShowTextNextLine(double aW, double aC, byte[] text) {
        Instruction inst = new Instruction(ASName.k_DoubleQuote);
        inst.push(aW);
        inst.push(aC);
        inst.push(new ASString(text));
        return inst;
    }

    public static Instruction newMoveTo(double x, double y) {
        Instruction inst = new Instruction(ASName.k_m);
        inst.push(x);
        inst.push(y);
        return inst;
    }

    public static Instruction newLineTo(double x, double y) {
        Instruction inst = new Instruction(ASName.k_l);
        inst.push(x);
        inst.push(y);
        return inst;
    }

    public static Instruction newCurveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        Instruction inst = new Instruction(ASName.k_c);
        inst.push(x1);
        inst.push(y1);
        inst.push(x2);
        inst.push(y2);
        inst.push(x3);
        inst.push(y3);
        return inst;
    }

    public static Instruction newRectangle(double x, double y, double w, double h) {
        Instruction inst = new Instruction(ASName.k_re);
        inst.push(x);
        inst.push(y);
        inst.push(w);
        inst.push(h);
        return inst;
    }

    public static Instruction newClosePath() {
        return new Instruction(ASName.k_h);
    }

    public static Instruction newStrokePath() {
        return new Instruction(ASName.k_S);
    }

    public static Instruction newFillAndStrokePath() {
        return new Instruction(ASName.k_B);
    }

    public static Instruction newCloseFillAndStrokePath() {
        return new Instruction(ASName.k_b);
    }

    public static Instruction newCloseAndStrokePath() {
        return new Instruction(ASName.k_s);
    }

    public static Instruction newFillPath() {
        return new Instruction(ASName.k_f);
    }

    public static Instruction newShading(ASName name) {
        Instruction inst = new Instruction(ASName.k_sh);
        inst.push(name);
        return inst;
    }

    public static Instruction newFlatness(double tolerance) {
        Instruction inst = new Instruction(ASName.k_i);
        inst.push(tolerance);
        return inst;
    }

    public static Instruction newBeginMarkedContent(ASName name, ASName namedResource) {
        Instruction inst = new Instruction(ASName.k_BDC);
        inst.push(name);
        inst.push(namedResource);
        return inst;
    }

    public static Instruction newBeginMarkedContent(ASName name, ASDictionary properties) {
        Instruction inst = new Instruction(ASName.k_BDC);
        inst.push(name);
        inst.push(properties);
        return inst;
    }

    public static Instruction newBeginMarkedContent(ASName name) {
        Instruction inst = new Instruction(ASName.k_BMC);
        inst.push(name);
        return inst;
    }

    public static Instruction newEndMarkedContent() {
        return new Instruction(ASName.k_EMC);
    }

    public static Instruction newMarkedPoint(ASName name, ASName namedResource) {
        Instruction inst = new Instruction(ASName.k_DP);
        inst.push(name);
        inst.push(namedResource);
        return inst;
    }

    public static Instruction newMarkedPoint(ASName name, ASDictionary property) {
        Instruction inst = new Instruction(ASName.k_DP);
        inst.push(name);
        inst.push(property);
        return inst;
    }

    public static Instruction newMarkedPoint(ASName name) {
        Instruction inst = new Instruction(ASName.k_MP);
        inst.push(name);
        return inst;
    }

    public static Instruction newStrokeColorSpace(ASName namedResource) {
        Instruction inst = new Instruction(ASName.k_CS);
        inst.push(namedResource);
        return inst;
    }

    public static Instruction newFillColorSpace(ASName namedResource) {
        Instruction inst = new Instruction(ASName.k_cs);
        inst.push(namedResource);
        return inst;
    }

    public static Instruction newStrokeColorSpace(double[] colorValues) {
        Instruction inst = new Instruction(ASName.k_SCN);
        for (int i = 0; i < colorValues.length; ++i) {
            inst.push(colorValues[i]);
        }
        return inst;
    }

    public static Instruction newFillColorSpace(double[] colorValues) {
        Instruction inst = new Instruction(ASName.k_scn);
        for (int i = 0; i < colorValues.length; ++i) {
            inst.push(colorValues[i]);
        }
        return inst;
    }

    public static Instruction newStrokeColorSpace(double[] colorValues, ASName namedResource) {
        Instruction inst = new Instruction(ASName.k_SCN);
        for (int i = 0; i < colorValues.length; ++i) {
            inst.push(colorValues[i]);
        }
        inst.push(namedResource);
        return inst;
    }

    public static Instruction newFillColorSpace(double[] colorValues, ASName namedResource) {
        Instruction inst = new Instruction(ASName.k_scn);
        for (int i = 0; i < colorValues.length; ++i) {
            inst.push(colorValues[i]);
        }
        inst.push(namedResource);
        return inst;
    }

    public static Instruction newClipPath() {
        return new Instruction(ASName.k_W);
    }

    public static Instruction newClipPathStar() {
        return new Instruction(ASName.k_WStar);
    }

    public static Instruction newEndPathNoOp() {
        return new Instruction(ASName.k_n);
    }

    public static Instruction newRelativeColorimetric() {
        Instruction inst = new Instruction(ASName.k_ri);
        inst.push(ASName.k_RelativeColorimetric);
        return inst;
    }

    public static Instruction newInlineImageBegin() {
        return new Instruction(ASName.k_BI);
    }

    public static Instruction newInlineImageDict(ASDictionary imageDict, InputByteStream imageData) {
        Instruction inst = new Instruction(ASName.k_ID);
        OperandStack operands = inst.getOperands();
        operands.pushInputByteStream(imageData);
        Set<ASName> keys = imageDict.keySet();
        for (ASName key : keys) {
            operands.pushName(key);
            operands.push(imageDict.get(key));
        }
        return inst;
    }

    public static Instruction newInlineImageEnd() {
        return new Instruction(ASName.k_EI);
    }
}

