/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.graphicsDOM;

import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.graphicsDOM.AbstractContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentType;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.PrimitiveContentItem;
import com.adobe.internal.pdftoolkit.image.ARGBImage;
import java.awt.geom.Rectangle2D;

public abstract class ContentImageItem<G extends GraphicsState>
extends AbstractContentItem<G>
implements PrimitiveContentItem<G> {
    private boolean isImageMask = false;
    private double[] transformationMatrix;
    private ARGBImage image = null;
    private ARGBImage sMask = null;
    private Rectangle2D boundingBox = null;

    public ContentImageItem(G graphicsState, int id) {
        super(graphicsState, id);
    }

    public boolean getIsImageMask() {
        return this.isImageMask;
    }

    public void setIsImageMask(boolean isImageMask) {
        this.isImageMask = isImageMask;
    }

    public ARGBImage getImage() {
        return this.image;
    }

    public void setImage(ARGBImage image) {
        this.image = image;
    }

    public ARGBImage getSoftMask() {
        return this.sMask;
    }

    public void setSoftMask(ARGBImage sMask) {
        this.sMask = sMask;
    }

    public void setTransformationMatrix(double[] matrix) {
        this.transformationMatrix = matrix;
    }

    public double[] getTransformationMatrix() {
        return this.transformationMatrix;
    }

    @Override
    public ContentType getType() {
        return ContentType.Image;
    }

    @Override
    public Rectangle2D getBoundingBox(DocumentContext context) {
        if (this.boundingBox != null) {
            return this.boundingBox;
        }
        ASMatrix ctm = new ASMatrix(this.transformationMatrix);
        ASCoordinate coord1 = new ASCoordinate(0.0, 0.0).transform(ctm);
        ASCoordinate coord2 = new ASCoordinate(0.0, 1.0).transform(ctm);
        ASCoordinate coord3 = new ASCoordinate(1.0, 0.0).transform(ctm);
        ASCoordinate coord4 = new ASCoordinate(1.0, 1.0).transform(ctm);
        double x = Math.min(Math.min(coord1.x(), coord2.x()), Math.min(coord3.x(), coord4.x()));
        double y = Math.min(Math.min(coord1.y(), coord2.y()), Math.min(coord3.y(), coord4.y()));
        double w = Math.max(Math.max(coord1.x(), coord2.x()), Math.max(coord3.x(), coord4.x())) - x;
        double h = Math.max(Math.max(coord1.y(), coord2.y()), Math.max(coord3.y(), coord4.y())) - y;
        this.boundingBox = new Rectangle2D.Double(x, y, w, h);
        return this.boundingBox;
    }
}

