/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.ASCIIHexFilterException;
import com.adobe.internal.pdftoolkit.core.filter.DecodeInputStream;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import java.io.InputStream;

public class ASCIIHexInputStream
extends DecodeInputStream {
    private static final byte WS = 85;
    private static final byte ED = 87;
    private static final byte IL = 88;
    private static byte[] ascHxDecodeTable = new byte[128];

    public ASCIIHexInputStream(InputStream in, int inSize, int outSize, FilterParams diparams) {
        super(in, inSize, outSize, 1, diparams);
    }

    public ASCIIHexInputStream(InputStream in, FilterParams p) {
        super(in, 1, p);
    }

    public ASCIIHexInputStream(InputStream in) {
        this(in, null);
    }

    @Override
    public void fill() {
        block4: while (this.outCount <= this.outBuf.length - 1 && !this.pendingEOF && this.pendingException == null) {
            int value = 0;
            int dp = 4;
            block5: while (dp >= 0) {
                int newChar;
                byte digitVal;
                if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                    this.pendingEOF = true;
                    if (dp != 4) break;
                    break block4;
                }
                if ((digitVal = ascHxDecodeTable[newChar = this.inBuf[this.inPos++] & 0x7F]) < 16) {
                    value += digitVal << dp;
                    dp -= 4;
                    continue;
                }
                switch (digitVal) {
                    case 85: {
                        continue block5;
                    }
                    case 87: {
                        this.pendingEOF = true;
                        if (dp != 4) break block5;
                        break block4;
                    }
                    default: {
                        this.pendingException = new ASCIIHexFilterException("AscHx illegal char");
                        break block5;
                    }
                }
            }
            this.outBuf[this.outCount++] = (byte)value;
        }
    }

    static {
        block11: for (int i = 0; i < 128; ++i) {
            switch ((char)i) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 85;
                    continue block11;
                }
                case '>': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 87;
                    continue block11;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = (byte)(i - 48);
                    continue block11;
                }
                case 'A': 
                case 'a': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 10;
                    continue block11;
                }
                case 'B': 
                case 'b': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 11;
                    continue block11;
                }
                case 'C': 
                case 'c': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 12;
                    continue block11;
                }
                case 'D': 
                case 'd': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 13;
                    continue block11;
                }
                case 'E': 
                case 'e': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 14;
                    continue block11;
                }
                case 'F': 
                case 'f': {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 15;
                    continue block11;
                }
                default: {
                    ASCIIHexInputStream.ascHxDecodeTable[i] = 88;
                }
            }
        }
    }
}

