/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.pdftoolkit.core.encryption.JCECipherEncryptionHandler;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandlerState;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public final class JCEEncryptionHandlerState
implements EncryptionHandlerState {
    private JCECipherEncryptionHandler mParentHandler;
    private boolean mInited;
    private Cipher mCipher;

    public JCEEncryptionHandlerState(JCECipherEncryptionHandler parent) throws PDFSecurityConfigurationException {
        this.mParentHandler = parent;
        this.mInited = false;
        try {
            this.mCipher = Cipher.getInstance(this.mParentHandler.mCipher.getAlgorithm(), this.mParentHandler.mCipher.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFSecurityConfigurationException("Cannot instantiate Cipher object", e);
        }
        catch (NoSuchPaddingException e) {
            throw new PDFSecurityConfigurationException("Cannot instantiate Cipher object", e);
        }
    }

    @Override
    public byte[] init(byte[] buffer, int start, int len, byte[] additionKey, int mode) throws PDFSecurityException {
        byte[] mKey = this.mParentHandler.calculateCompleteKey(additionKey);
        byte[] firstPart = this.mParentHandler.initCipher(this.mCipher, buffer, len, mKey, mode);
        this.mInited = true;
        return this.mCipher.update(firstPart);
    }

    @Override
    public byte[] update(byte[] buffer, int start, int len) throws PDFSecurityException {
        if (!this.mInited) {
            throw new PDFSecurityConfigurationException("EncryptionHandlerState is not initialized");
        }
        return this.mCipher.update(buffer, start, len);
    }

    @Override
    public byte[] finish() throws PDFSecurityException {
        if (!this.mInited) {
            throw new PDFSecurityConfigurationException("EncryptionHandlerState is not initialized");
        }
        try {
            return this.mCipher.doFinal();
        }
        catch (IllegalStateException e) {
            throw new PDFSecurityConfigurationException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new PDFSecurityConfigurationException(e);
        }
        catch (BadPaddingException e) {
            throw new PDFSecurityConfigurationException(e);
        }
    }
}

