/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.StringOps;
import java.io.IOException;

public class CosName
extends CosScalar {
    private ASName name;

    CosName(CosDocument doc, ASName value, CosObjectInfo info) {
        super(doc, info);
        this.name = value;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public ASName nameValue() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name.toString();
    }

    @Override
    void writeOut(OutputByteStream outStream, boolean inString, boolean inDebugMode) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        if (inString && inDebugMode) {
            outStream.write(StringOps.toByteArray(this.name.asString(inDebugMode)));
        } else {
            this.name.write(outStream);
        }
    }

    @Override
    public Object getValue() {
        return this.name.asString(true);
    }

    @Override
    public boolean equals(CosObject value) {
        if (!(value instanceof CosName) || value.getDocument() != this.getDocument()) {
            return false;
        }
        if (value == this) {
            return true;
        }
        return value.nameValue() == this.nameValue();
    }
}

