/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.util.StringOps;
import java.io.IOException;

public class CosBoolean
extends CosScalar {
    private Boolean mValue;

    CosBoolean(CosDocument doc, boolean value, CosObjectInfo info) {
        super(doc, info);
        this.mValue = value;
    }

    CosBoolean(CosDocument doc, Boolean value, CosObjectInfo info) {
        super(doc, info);
        this.mValue = value;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean booleanValue() {
        return this.mValue;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    void writeOut(OutputByteStream outStream, boolean inString, boolean inDebugMode) throws IOException {
        outStream.write(StringOps.toByteArray(this.mValue.toString()));
    }

    @Override
    public boolean equals(CosObject value) {
        if (!(value instanceof CosBoolean) || value.getDocument() != this.getDocument()) {
            return false;
        }
        if (value == this) {
            return true;
        }
        return value.booleanValue() == this.booleanValue();
    }
}

