/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.afml;

import com.adobe.agl.util.StringTokenizer;
import com.adobe.internal.afml.AFMLAnomalies;
import com.adobe.internal.afml.AFMLAttributeMap;
import com.adobe.internal.afml.AFMLAttribute_Color;
import com.adobe.internal.afml.AFMLAttribute_EMLength;
import com.adobe.internal.afml.AFMLAttribute_Integer;
import com.adobe.internal.afml.AFMLAttribute_Keyword;
import com.adobe.internal.afml.AFMLAttribute_Leader;
import com.adobe.internal.afml.AFMLAttribute_Length;
import com.adobe.internal.afml.AFMLAttribute_Name;
import com.adobe.internal.afml.AFMLAttribute_Number;
import com.adobe.internal.afml.AFMLAttribute_Percentage;
import com.adobe.internal.afml.AFMLAttribute_String;
import com.adobe.internal.afml.AFMLAttribute_TabRuler;
import com.adobe.internal.afml.AFMLAttribute_TabStop;
import com.adobe.internal.afml.AFMLAttribute__Abstract;
import com.adobe.internal.afml.AFMLAttribute__TypeId;
import com.adobe.internal.afml.AFMLExceptionInvalidParameter;
import com.adobe.internal.afml.AFMLExceptionUnsupportedFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AFMLAttributeInheritanceStack {
    private String textFormatterCompatibility;
    public final String AFML_LENGTH_DEFAULT_UNITS = "pt";
    private List<AFMLAttributeMap> pvt_AFMLAttributeStack = new ArrayList<AFMLAttributeMap>(512);

    public AFMLAttributeInheritanceStack() {
    }

    public AFMLAttributeInheritanceStack(String textFormatterCompatibility) {
        this();
        this.textFormatterCompatibility = textFormatterCompatibility;
    }

    public void pushAll(AFMLAttributeMap in_newMap) {
        this.pushAll();
        if (in_newMap != null) {
            AFMLAttributeMap var_currentTop = this.getStackTop();
            Set var_entries = in_newMap.entrySet();
            for (Map.Entry var_entry : var_entries) {
                AFMLAttribute__Abstract var_currentAttribute = (AFMLAttribute__Abstract)var_entry.getValue();
                var_currentTop.setAttribute(var_currentAttribute);
            }
        }
    }

    public void pushAll() {
        AFMLAttributeMap var_currentTop;
        AFMLAttributeMap var_newAttributeMap = new AFMLAttributeMap();
        if (this.pvt_AFMLAttributeStack.size() > 0 && (var_currentTop = this.getStackTop()) != null) {
            Set var_entries = var_currentTop.entrySet();
            for (Map.Entry var_entry : var_entries) {
                AFMLAttribute__Abstract var_currentAttribute = (AFMLAttribute__Abstract)var_entry.getValue();
                var_newAttributeMap.setAttribute(var_currentAttribute);
            }
        }
        this.pvt_AFMLAttributeStack.add(var_newAttributeMap);
    }

    public void pushInheritable(AFMLAttributeMap in_newMap) {
        this.pushInheritable();
        if (in_newMap != null) {
            AFMLAttributeMap var_currentTop = this.getStackTop();
            Set var_entries = in_newMap.entrySet();
            for (Map.Entry var_entry : var_entries) {
                AFMLAttribute__Abstract var_currentAttribute = (AFMLAttribute__Abstract)var_entry.getValue();
                var_currentTop.setAttribute(var_currentAttribute);
            }
        }
    }

    public void pushInheritable() {
        AFMLAttributeMap var_currentTop;
        AFMLAttributeMap var_newAttributeMap = new AFMLAttributeMap();
        if (this.pvt_AFMLAttributeStack.size() > 0 && (var_currentTop = this.getStackTop()) != null) {
            Set var_entries = var_currentTop.entrySet();
            for (Map.Entry var_entry : var_entries) {
                AFMLAttribute__Abstract var_currentAttribute = (AFMLAttribute__Abstract)var_entry.getValue();
                if (!var_currentAttribute.isInheritable()) continue;
                var_newAttributeMap.setAttribute(var_currentAttribute);
            }
        }
        this.pvt_AFMLAttributeStack.add(var_newAttributeMap);
    }

    public void pop() {
        if (this.pvt_AFMLAttributeStack.size() > 0) {
            this.pvt_AFMLAttributeStack.remove(this.pvt_AFMLAttributeStack.size() - 1);
        }
    }

    public AFMLAttributeMap getStackLevel(int in_level) {
        if (in_level < this.pvt_AFMLAttributeStack.size()) {
            return this.pvt_AFMLAttributeStack.get(in_level);
        }
        return null;
    }

    public AFMLAttributeMap getStackTop() {
        return this.getStackLevel(this.pvt_AFMLAttributeStack.size() - 1);
    }

    public int size() {
        return this.pvt_AFMLAttributeStack.size();
    }

    public AFMLAttribute__Abstract getAttributeFromStackTop(AFMLAttribute__TypeId in_AttributeId) {
        if (this.getStackTop() != null) {
            return this.getStackTop().getAttribute(in_AttributeId);
        }
        return null;
    }

    public void setAttributeOnStackTop(AFMLAttribute__Abstract in_Attribute) {
        if (this.getStackTop() != null) {
            this.getStackTop().setAttribute(in_Attribute);
        } else {
            AFMLAnomalies.AFMLErrorStop("AFMLAttributeInheritanceStack: Attempt to add property when no attribute stack is available");
        }
    }

    private boolean internalApplyBasicAttributeFromBoolean(AFMLAttribute__TypeId in_attributeTypeId, String in_attributeValue, String in_defaultValue, boolean in_isInheritable) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = in_defaultValue;
        }
        if (in_attributeValue.equalsIgnoreCase("true") || in_attributeValue.equalsIgnoreCase("yes") || in_attributeValue.equalsIgnoreCase("enable")) {
            in_attributeValue = "true";
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(in_attributeTypeId, in_attributeValue, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        if (in_attributeValue.equalsIgnoreCase("false") || in_attributeValue.equalsIgnoreCase("no") || in_attributeValue.equalsIgnoreCase("disable")) {
            in_attributeValue = "false";
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(in_attributeTypeId, in_attributeValue, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        return false;
    }

    private boolean internalApplyBasicAttributeFromBorderStyle(AFMLAttribute__TypeId in_attributeTypeIdStyle, AFMLAttribute__TypeId in_attributeTypeIdSeparation, AFMLAttribute__TypeId in_attributeTypeIdCount, String in_attributeValue, String in_defaultValue, boolean in_isInheritable) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = in_defaultValue;
        }
        if (in_attributeValue.equalsIgnoreCase("solid") || in_attributeValue.equalsIgnoreCase("dotted") || in_attributeValue.equalsIgnoreCase("dashed") || in_attributeValue.equalsIgnoreCase("dot-dash") || in_attributeValue.equalsIgnoreCase("dot-dash") || in_attributeValue.equalsIgnoreCase("dot-dot-dash") || in_attributeValue.equalsIgnoreCase("wave") || in_attributeValue.equalsIgnoreCase("groove") || in_attributeValue.equalsIgnoreCase("ridge") || in_attributeValue.equalsIgnoreCase("inset") || in_attributeValue.equalsIgnoreCase("outset")) {
            AFMLAttribute_Keyword var_AFMLStyleAttribute = new AFMLAttribute_Keyword(in_attributeTypeIdStyle, in_attributeValue.toLowerCase(), false);
            this.setAttributeOnStackTop(var_AFMLStyleAttribute);
            AFMLAttribute_Integer var_AFMLCountAttribute = new AFMLAttribute_Integer(in_attributeTypeIdCount, 1, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLCountAttribute);
            AFMLAttribute_Length var_AFMLSeparationAttribute = new AFMLAttribute_Length(in_attributeTypeIdSeparation, "0.25pt", in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLSeparationAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("double")) {
            AFMLAttribute_Keyword var_AFMLStyleAttribute = new AFMLAttribute_Keyword(in_attributeTypeIdStyle, "solid", in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLStyleAttribute);
            AFMLAttribute_Integer var_AFMLCountAttribute = new AFMLAttribute_Integer(in_attributeTypeIdCount, 2, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLCountAttribute);
            AFMLAttribute_Length var_AFMLSeparationAttribute = new AFMLAttribute_Length(in_attributeTypeIdSeparation, "0.25pt", in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLSeparationAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("triple")) {
            AFMLAttribute_Keyword var_AFMLStyleAttribute = new AFMLAttribute_Keyword(in_attributeTypeIdStyle, "solid", in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLStyleAttribute);
            AFMLAttribute_Integer var_AFMLCountAttribute = new AFMLAttribute_Integer(in_attributeTypeIdCount, 3, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLCountAttribute);
            AFMLAttribute_Length var_AFMLSeparationAttribute = new AFMLAttribute_Length(in_attributeTypeIdSeparation, "0.25pt", in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLSeparationAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("double-dotted")) {
            AFMLAttribute_Keyword var_AFMLStyleAttribute = new AFMLAttribute_Keyword(in_attributeTypeIdStyle, "dotted", in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLStyleAttribute);
            AFMLAttribute_Integer var_AFMLCountAttribute = new AFMLAttribute_Integer(in_attributeTypeIdCount, 2, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLCountAttribute);
            AFMLAttribute_Length var_AFMLSeparationAttribute = new AFMLAttribute_Length(in_attributeTypeIdSeparation, "0.25pt", in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLSeparationAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("triple-dotted")) {
            AFMLAttribute_Keyword var_AFMLStyleAttribute = new AFMLAttribute_Keyword(in_attributeTypeIdStyle, "dotted", in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLStyleAttribute);
            AFMLAttribute_Integer var_AFMLCountAttribute = new AFMLAttribute_Integer(in_attributeTypeIdCount, 3, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLCountAttribute);
            AFMLAttribute_Length var_AFMLSeparationAttribute = new AFMLAttribute_Length(in_attributeTypeIdSeparation, "0.25pt", in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLSeparationAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("none")) {
            AFMLAttribute_Keyword var_AFMLStyleAttribute = new AFMLAttribute_Keyword(in_attributeTypeIdStyle, "none", in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLStyleAttribute);
            AFMLAttribute_Integer var_AFMLCountAttribute = new AFMLAttribute_Integer(in_attributeTypeIdCount, 0, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLCountAttribute);
            AFMLAttribute_Length var_AFMLSeparationAttribute = new AFMLAttribute_Length(in_attributeTypeIdSeparation, "0.0pt", in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLSeparationAttribute);
        } else {
            return false;
        }
        return true;
    }

    private boolean internalApplyBasicAttributeFromColor(AFMLAttribute__TypeId in_attributeTypeId, String in_attributeValue, String in_defaultValue, boolean in_isInheritable) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = in_defaultValue;
        }
        if (in_attributeValue.equalsIgnoreCase("use-current-color")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(in_attributeTypeId, in_attributeValue, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        AFMLAttribute_Color var_AFMLAttribute = new AFMLAttribute_Color(in_attributeTypeId, in_attributeValue, in_isInheritable);
        this.setAttributeOnStackTop(var_AFMLAttribute);
        return true;
    }

    private boolean internalApplyBasicAttributeFromInteger(AFMLAttribute__TypeId in_attributeTypeId, String in_attributeValue, String in_defaultValue, boolean in_isInheritable, boolean in_allowNegativeValues) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = in_defaultValue;
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLAttribute = new AFMLAttribute_Integer(in_attributeTypeId, in_attributeValue, in_isInheritable);
            if (!in_allowNegativeValues && var_AFMLAttribute.getInteger() < 0) {
                return false;
            }
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        return false;
    }

    private boolean internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId in_attributeTypeId, String in_attributeValue, String in_defaultValue, boolean in_isInheritable, String[] in_allowedKeywordList) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = in_defaultValue;
        }
        for (int i = 0; i < in_allowedKeywordList.length; ++i) {
            if (!in_attributeValue.equalsIgnoreCase(in_allowedKeywordList[i])) continue;
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(in_attributeTypeId, in_attributeValue, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        return false;
    }

    private boolean internalApplyBasicAttributeFromKeywordIntegerOrNumber(AFMLAttribute__TypeId in_attributeTypeId, String in_attributeValue, String in_defaultValue, boolean in_isInheritable, String[] in_allowedKeywordList, boolean in_allowNegativeValues) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = in_defaultValue;
        }
        for (int i = 0; i < in_allowedKeywordList.length; ++i) {
            if (!in_attributeValue.equalsIgnoreCase(in_allowedKeywordList[i])) continue;
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(in_attributeTypeId, in_attributeValue, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLAttribute = new AFMLAttribute_Integer(in_attributeTypeId, in_attributeValue, in_isInheritable);
            if (!in_allowNegativeValues && var_AFMLAttribute.getInteger() < 0) {
                return false;
            }
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue)) {
            AFMLAttribute_Number var_AFMLAttribute = new AFMLAttribute_Number(in_attributeTypeId, in_attributeValue, in_isInheritable);
            if (!in_allowNegativeValues && var_AFMLAttribute.getNumber() < 0.0) {
                return false;
            }
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        return false;
    }

    private boolean internalApplyBasicAttributeFromKeywordIntegerNumberOrPercent(AFMLAttribute__TypeId in_attributeTypeId, String in_attributeValue, String in_defaultValue, boolean in_isInheritable, String[] in_allowedKeywordList, boolean in_allowNegativeValues) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = in_defaultValue;
        }
        for (int i = 0; i < in_allowedKeywordList.length; ++i) {
            if (!in_attributeValue.equalsIgnoreCase(in_allowedKeywordList[i])) continue;
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(in_attributeTypeId, in_attributeValue, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLAttribute = new AFMLAttribute_Integer(in_attributeTypeId, in_attributeValue, in_isInheritable);
            if (!in_allowNegativeValues && var_AFMLAttribute.getInteger() < 0) {
                return false;
            }
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue)) {
            AFMLAttribute_Number var_AFMLAttribute = new AFMLAttribute_Number(in_attributeTypeId, in_attributeValue, in_isInheritable);
            if (!in_allowNegativeValues && var_AFMLAttribute.getNumber() < 0.0) {
                return false;
            }
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        if (AFMLAttribute__Abstract.isAFMLAttributePercentage(in_attributeValue)) {
            AFMLAttribute_Percentage var_AFMLAttribute = new AFMLAttribute_Percentage(in_attributeTypeId, in_attributeValue, in_isInheritable);
            if (!in_allowNegativeValues && var_AFMLAttribute.getFactor() < 0.0) {
                return false;
            }
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        return false;
    }

    private boolean internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId in_attributeTypeId, String in_attributeValue, String in_defaultValue, boolean in_isInheritable, String[] in_allowedKeywordList, String in_unitlessLengthExtension, boolean in_allowNegativeValues) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = in_defaultValue;
        }
        for (int i = 0; i < in_allowedKeywordList.length; ++i) {
            if (!in_attributeValue.equalsIgnoreCase(in_allowedKeywordList[i])) continue;
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(in_attributeTypeId, in_attributeValue, in_isInheritable);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        if (!in_unitlessLengthExtension.equalsIgnoreCase("") && AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue) && AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue)) {
            String var_attributeValue = in_attributeValue + in_unitlessLengthExtension;
            AFMLAttribute_Length var_AFMLAttribute = new AFMLAttribute_Length(in_attributeTypeId, var_attributeValue, in_isInheritable);
            if (!in_allowNegativeValues && var_AFMLAttribute.getLength() < 0.0) {
                return false;
            }
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue)) {
            AFMLAttribute_Length var_AFMLAttribute = new AFMLAttribute_Length(in_attributeTypeId, in_attributeValue, in_isInheritable);
            if (!in_allowNegativeValues && var_AFMLAttribute.getLength() < 0.0) {
                return false;
            }
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeEMLength(in_attributeValue)) {
            AFMLAttribute_EMLength var_AFMLAttribute = new AFMLAttribute_EMLength(in_attributeTypeId, in_attributeValue, in_isInheritable);
            if (!in_allowNegativeValues && var_AFMLAttribute.getEMLengthFactor() < 0.0) {
                return false;
            }
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        if (!in_unitlessLengthExtension.equalsIgnoreCase("") && AFMLAttribute__Abstract.isAFMLAttributePercentage(in_attributeValue)) {
            AFMLAttribute_Percentage var_AFMLAttribute = new AFMLAttribute_Percentage(in_attributeTypeId, in_attributeValue, in_isInheritable);
            if (!in_allowNegativeValues && var_AFMLAttribute.getFactor() < 0.0) {
                return false;
            }
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        if (in_unitlessLengthExtension.equalsIgnoreCase("") && AFMLAttribute__Abstract.isAFMLAttributePercentageOrFactor(in_attributeValue)) {
            AFMLAttribute_Percentage var_AFMLAttribute = new AFMLAttribute_Percentage(in_attributeTypeId, in_attributeValue, in_isInheritable);
            if (!in_allowNegativeValues && var_AFMLAttribute.getFactor() < 0.0) {
                return false;
            }
            this.setAttributeOnStackTop(var_AFMLAttribute);
            return true;
        }
        return false;
    }

    private boolean internalApplyBasicAttributeFromName(AFMLAttribute__TypeId in_attributeTypeId, String in_attributeValue, String in_defaultValue, boolean in_isInheritable) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = in_defaultValue;
        }
        if (in_attributeValue.equalsIgnoreCase("-required-") || in_attributeValue.equalsIgnoreCase("")) {
            return false;
        }
        AFMLAttribute_Name var_AFMLAttribute = new AFMLAttribute_Name(in_attributeTypeId, in_attributeValue, in_isInheritable);
        this.setAttributeOnStackTop(var_AFMLAttribute);
        return true;
    }

    private boolean internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId in_attributeTypeIdMinimum, AFMLAttribute__TypeId in_attributeTypeIdOptimum, AFMLAttribute__TypeId in_attributeTypeIdMaximum, String in_attributeValue, String in_defaultMinimum, String in_defaultOptimum, String in_defaultMaximum, boolean in_isInheritable, String[] in_allowedKeywordList, String in_unitlessLengthExtension, boolean in_allowNegativeValues) throws AFMLExceptionInvalidParameter {
        if (in_attributeTypeIdMinimum != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdMinimum, in_defaultMinimum, in_defaultMinimum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) {
            return false;
        }
        if (in_attributeTypeIdOptimum != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdOptimum, in_defaultOptimum, in_defaultOptimum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) {
            return false;
        }
        if (in_attributeTypeIdMaximum != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdMaximum, in_defaultMaximum, in_defaultMaximum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) {
            return false;
        }
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            return true;
        }
        int var_iterationCount = 1;
        StringTokenizer var_tokenizer = new StringTokenizer(in_attributeValue, " ,");
        while (var_tokenizer.hasMoreTokens()) {
            String var_token = var_tokenizer.nextToken();
            switch (var_iterationCount) {
                case 1: {
                    if (in_attributeTypeIdMinimum != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdMinimum, var_token, in_defaultMinimum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) {
                        return false;
                    }
                    if (in_attributeTypeIdOptimum != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdOptimum, var_token, in_defaultOptimum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) {
                        return false;
                    }
                    if (in_attributeTypeIdMaximum == AFMLAttribute__TypeId.unset || this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdMaximum, var_token, in_defaultMaximum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) break;
                    return false;
                }
                case 2: {
                    if (in_attributeTypeIdOptimum != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdOptimum, var_token, in_defaultOptimum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) {
                        return false;
                    }
                    if (in_attributeTypeIdMaximum == AFMLAttribute__TypeId.unset || this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdMaximum, var_token, in_defaultMaximum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) break;
                    return false;
                }
                case 3: {
                    if (in_attributeTypeIdMaximum == AFMLAttribute__TypeId.unset || this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdMaximum, var_token, in_defaultMaximum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ++var_iterationCount;
        }
        return true;
    }

    private boolean internalApplySpaceAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId in_attributeTypeIdMinimum, AFMLAttribute__TypeId in_attributeTypeIdOptimum, AFMLAttribute__TypeId in_attributeTypeIdMaximum, AFMLAttribute__TypeId in_attributeTypeIdPrecedence, AFMLAttribute__TypeId in_attributeTypeIdConditionality, String in_attributeValue, String in_defaultMinimum, String in_defaultOptimum, String in_defaultMaximum, String in_defaultPrecedence, String in_defaultConditionality, boolean in_isInheritable, String[] in_allowedKeywordList, String in_unitlessLengthExtension, boolean in_allowNegativeValues) throws AFMLExceptionInvalidParameter {
        String[] var_Conditionality;
        if (in_attributeTypeIdConditionality != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdConditionality, in_defaultConditionality, in_defaultConditionality, in_isInheritable, var_Conditionality = new String[]{"discard", "retain"}, in_unitlessLengthExtension, in_allowNegativeValues)) {
            return false;
        }
        String[] var_Precedence = new String[]{"force"};
        if (in_attributeTypeIdPrecedence != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordIntegerOrNumber(in_attributeTypeIdPrecedence, in_defaultPrecedence, in_defaultPrecedence, in_isInheritable, var_Precedence, in_allowNegativeValues)) {
            return false;
        }
        if (in_attributeTypeIdMinimum != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdMinimum, in_defaultMinimum, in_defaultMinimum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) {
            return false;
        }
        if (in_attributeTypeIdOptimum != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdOptimum, in_defaultOptimum, in_defaultOptimum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) {
            return false;
        }
        if (in_attributeTypeIdMaximum != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdMaximum, in_defaultMaximum, in_defaultMaximum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) {
            return false;
        }
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            return true;
        }
        StringTokenizer var_tokenizer = new StringTokenizer(in_attributeValue, " ,");
        int var_iterationCount = 1;
        while (var_tokenizer.hasMoreTokens()) {
            String var_token = var_tokenizer.nextToken();
            if (var_token.equalsIgnoreCase("retain") || var_token.equalsIgnoreCase("discard")) {
                if (in_attributeTypeIdConditionality == AFMLAttribute__TypeId.unset || this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdConditionality, var_token, in_defaultConditionality, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) continue;
                return false;
            }
            if (var_token.equalsIgnoreCase("force") || AFMLAttribute__Abstract.isAFMLAttributeInteger(var_token) || AFMLAttribute__Abstract.isAFMLAttributeNumber(var_token)) {
                if (in_attributeTypeIdPrecedence == AFMLAttribute__TypeId.unset || this.internalApplyBasicAttributeFromKeywordIntegerOrNumber(in_attributeTypeIdPrecedence, var_token, in_defaultPrecedence, in_isInheritable, in_allowedKeywordList, in_allowNegativeValues)) continue;
                return false;
            }
            switch (var_iterationCount) {
                case 1: {
                    if (in_attributeTypeIdMinimum != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdMinimum, var_token, in_defaultMinimum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) {
                        return false;
                    }
                    if (in_attributeTypeIdOptimum != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdOptimum, var_token, in_defaultOptimum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) {
                        return false;
                    }
                    if (in_attributeTypeIdMaximum == AFMLAttribute__TypeId.unset || this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdMaximum, var_token, in_defaultMaximum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) break;
                    return false;
                }
                case 2: {
                    if (in_attributeTypeIdOptimum != AFMLAttribute__TypeId.unset && !this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdOptimum, var_token, in_defaultOptimum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) {
                        return false;
                    }
                    if (in_attributeTypeIdMaximum == AFMLAttribute__TypeId.unset || this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdMaximum, var_token, in_defaultMaximum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) break;
                    return false;
                }
                case 3: {
                    if (in_attributeTypeIdMaximum == AFMLAttribute__TypeId.unset || this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(in_attributeTypeIdMaximum, var_token, in_defaultMaximum, in_isInheritable, in_allowedKeywordList, in_unitlessLengthExtension, in_allowNegativeValues)) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ++var_iterationCount;
        }
        return true;
    }

    public void processAttributeAbsolutePositionLeft_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Layout_AbsolutePositionLeftMinimum, AFMLAttribute__TypeId.Layout_AbsolutePositionLeftOptimum, AFMLAttribute__TypeId.Layout_AbsolutePositionLeftMaximum, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for absolute-position-left: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeAbsolutePositionTop_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Layout_AbsolutePositionTopMinimum, AFMLAttribute__TypeId.Layout_AbsolutePositionTopOptimum, AFMLAttribute__TypeId.Layout_AbsolutePositionTopMaximum, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for absolute-position-top: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBackgroundColor(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromColor(AFMLAttribute__TypeId.Area_BackgroundColor, in_attributeValue, "transparent", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for background-color: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBaselineShift(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("base") || in_attributeValue.equalsIgnoreCase("baseline")) {
            in_attributeValue = "0.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("sub") || in_attributeValue.equalsIgnoreCase("subscript")) {
            in_attributeValue = "subscript";
        } else if (in_attributeValue.equalsIgnoreCase("sup") || in_attributeValue.equalsIgnoreCase("super") || in_attributeValue.equalsIgnoreCase("superscript")) {
            in_attributeValue = "superscript";
        }
        String[] var_allowedKeywords = new String[]{"subscript", "superscript"};
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_BaselineShift, in_attributeValue, "0.0pt", true, var_allowedKeywords, "pt", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for baseline-shift (vertical-align) property : \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBidiDirection(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"auto-bidi", "ltr", "rtl"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.InlineText_Bidi_Direction, in_attributeValue.toLowerCase(), "auto-bidi", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for bidi-direction: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBidiInternalLevel(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromInteger(AFMLAttribute__TypeId.InlineText_Bidi_InternalBidiLevel, in_attributeValue, "0", true, false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for bidi-internal-level: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBidiUnicodeBidi(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"normal", "embed", "bidi-override"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.InlineText_Bidi_UnicodeBidi, in_attributeValue.toLowerCase(), "normal", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for unicode-bidi: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBlockProgressionDimension_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"auto"};
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Layout_BlockProgressionDimensionMinimum, AFMLAttribute__TypeId.Layout_BlockProgressionDimensionOptimum, AFMLAttribute__TypeId.Layout_BlockProgressionDimensionMaximum, in_attributeValue, "auto", "auto", "auto", false, var_allowedKeywords, "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for block-progression-dimension (height): \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBlockVAlign(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("top") || in_attributeValue.equalsIgnoreCase("text-top")) {
            in_attributeValue = "before";
        }
        if (in_attributeValue.equalsIgnoreCase("center")) {
            in_attributeValue = "middle";
        }
        if (in_attributeValue.equalsIgnoreCase("bottom") || in_attributeValue.equalsIgnoreCase("text-bottom")) {
            in_attributeValue = "after";
        }
        String[] var_allowedKeywords = new String[]{"top", "before", "middle", "middle-ascent", "middle-capital", "baseline", "after", "bottom", "spread", "distribute"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Layout_BlockAlign, in_attributeValue.toLowerCase(), "middle", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for block-align (text-valign): \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorder_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            this.processAttributeBorderAfterColor("-default-");
            this.processAttributeBorderBeforeColor("-default-");
            this.processAttributeBorderEndColor("-default-");
            this.processAttributeBorderStartColor("-default-");
            this.processAttributeBorderAfterStyle("-default-");
            this.processAttributeBorderBeforeStyle("-default-");
            this.processAttributeBorderEndStyle("-default-");
            this.processAttributeBorderStartStyle("-default-");
            this.processAttributeBorderAfterThickness("-default-");
            this.processAttributeBorderBeforeThickness("-default-");
            this.processAttributeBorderEndThickness("-default-");
            this.processAttributeBorderStartThickness("-default-");
            return;
        }
        StringTokenizer var_shorthand = new StringTokenizer(in_attributeValue, " ,");
        int var_ThicknessCount = 1;
        int var_StyleCount = 1;
        int var_ColorCount = 1;
        while (var_shorthand.hasMoreTokens()) {
            String var_Token = var_shorthand.nextToken();
            if (AFMLAttribute__Abstract.isAFMLAttributeColor(in_attributeValue)) {
                switch (var_ColorCount) {
                    case 1: {
                        this.processAttributeBorderAfterColor(var_Token);
                        this.processAttributeBorderBeforeColor(var_Token);
                        this.processAttributeBorderEndColor(var_Token);
                        this.processAttributeBorderStartColor(var_Token);
                        break;
                    }
                    case 2: {
                        this.processAttributeBorderStartColor(var_Token);
                        this.processAttributeBorderEndColor(var_Token);
                        break;
                    }
                    case 3: {
                        this.processAttributeBorderAfterColor(var_Token);
                        break;
                    }
                    case 4: {
                        this.processAttributeBorderStartColor(var_Token);
                    }
                }
                ++var_ColorCount;
                continue;
            }
            if (var_Token.equalsIgnoreCase("solid") || var_Token.equalsIgnoreCase("dotted") || var_Token.equalsIgnoreCase("dashed") || var_Token.equalsIgnoreCase("dot-dash") || var_Token.equalsIgnoreCase("dot-dash") || var_Token.equalsIgnoreCase("dot-dot-dash") || var_Token.equalsIgnoreCase("wave") || var_Token.equalsIgnoreCase("double") || var_Token.equalsIgnoreCase("double-dotted") || var_Token.equalsIgnoreCase("double-dashed") || var_Token.equalsIgnoreCase("double-dot-dash") || var_Token.equalsIgnoreCase("double-dot-dash") || var_Token.equalsIgnoreCase("double-dot-dot-dash") || var_Token.equalsIgnoreCase("double-wave") || var_Token.equalsIgnoreCase("triple") || var_Token.equalsIgnoreCase("triple-dotted") || var_Token.equalsIgnoreCase("triple-dashed") || var_Token.equalsIgnoreCase("triple-dot-dash") || var_Token.equalsIgnoreCase("triple-dot-dash") || var_Token.equalsIgnoreCase("triple-dot-dot-dash") || var_Token.equalsIgnoreCase("triple-wave") || var_Token.equalsIgnoreCase("groove") || var_Token.equalsIgnoreCase("ridge") || var_Token.equalsIgnoreCase("inset") || var_Token.equalsIgnoreCase("outset")) {
                switch (var_StyleCount) {
                    case 1: {
                        this.processAttributeBorderAfterStyle(var_Token);
                        this.processAttributeBorderBeforeStyle(var_Token);
                        this.processAttributeBorderEndStyle(var_Token);
                        this.processAttributeBorderStartStyle(var_Token);
                        break;
                    }
                    case 2: {
                        this.processAttributeBorderStartStyle(var_Token);
                        this.processAttributeBorderEndStyle(var_Token);
                        break;
                    }
                    case 3: {
                        this.processAttributeBorderAfterStyle(var_Token);
                        break;
                    }
                    case 4: {
                        this.processAttributeBorderStartStyle(var_Token);
                    }
                }
                ++var_StyleCount;
                continue;
            }
            if (var_Token.equalsIgnoreCase("hairline") || var_Token.equalsIgnoreCase("extra-thin") || var_Token.equalsIgnoreCase("thin") || var_Token.equalsIgnoreCase("medium") || var_Token.equalsIgnoreCase("thick") || var_Token.equalsIgnoreCase("extra-thick") || AFMLAttribute__Abstract.isAFMLAttributeLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributeEMLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributePercentage(var_Token)) {
                switch (var_ThicknessCount) {
                    case 1: {
                        this.processAttributeBorderAfterThickness(var_Token);
                        this.processAttributeBorderBeforeThickness(var_Token);
                        this.processAttributeBorderEndThickness(var_Token);
                        this.processAttributeBorderStartThickness(var_Token);
                        break;
                    }
                    case 2: {
                        this.processAttributeBorderStartThickness(var_Token);
                        this.processAttributeBorderEndThickness(var_Token);
                        break;
                    }
                    case 3: {
                        this.processAttributeBorderAfterThickness(var_Token);
                        break;
                    }
                    case 4: {
                        this.processAttributeBorderStartThickness(var_Token);
                    }
                }
                ++var_ThicknessCount;
                continue;
            }
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderAfter_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            this.processAttributeBorderAfterColor("-default-");
            this.processAttributeBorderAfterStyle("-default-");
            this.processAttributeBorderAfterThickness("-default-");
            return;
        }
        StringTokenizer var_shorthand = new StringTokenizer(in_attributeValue, " ,");
        while (var_shorthand.hasMoreTokens()) {
            String var_Token = var_shorthand.nextToken();
            if (AFMLAttribute__Abstract.isAFMLAttributeColor(in_attributeValue)) {
                this.processAttributeBorderAfterColor(var_Token);
                continue;
            }
            if (var_Token.equalsIgnoreCase("solid") || var_Token.equalsIgnoreCase("dotted") || var_Token.equalsIgnoreCase("dashed") || var_Token.equalsIgnoreCase("dot-dash") || var_Token.equalsIgnoreCase("dot-dash") || var_Token.equalsIgnoreCase("dot-dot-dash") || var_Token.equalsIgnoreCase("wave") || var_Token.equalsIgnoreCase("double") || var_Token.equalsIgnoreCase("double-dotted") || var_Token.equalsIgnoreCase("double-dashed") || var_Token.equalsIgnoreCase("double-dot-dash") || var_Token.equalsIgnoreCase("double-dot-dash") || var_Token.equalsIgnoreCase("double-dot-dot-dash") || var_Token.equalsIgnoreCase("double-wave") || var_Token.equalsIgnoreCase("triple") || var_Token.equalsIgnoreCase("triple-dotted") || var_Token.equalsIgnoreCase("triple-dashed") || var_Token.equalsIgnoreCase("triple-dot-dash") || var_Token.equalsIgnoreCase("triple-dot-dash") || var_Token.equalsIgnoreCase("triple-dot-dot-dash") || var_Token.equalsIgnoreCase("triple-wave") || var_Token.equalsIgnoreCase("groove") || var_Token.equalsIgnoreCase("ridge") || var_Token.equalsIgnoreCase("inset") || var_Token.equalsIgnoreCase("outset")) {
                this.processAttributeBorderAfterStyle(var_Token);
                continue;
            }
            if (var_Token.equalsIgnoreCase("hairline") || var_Token.equalsIgnoreCase("extra-thin") || var_Token.equalsIgnoreCase("thin") || var_Token.equalsIgnoreCase("medium") || var_Token.equalsIgnoreCase("thick") || var_Token.equalsIgnoreCase("extra-thick") || AFMLAttribute__Abstract.isAFMLAttributeLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributeEMLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributePercentage(var_Token)) {
                this.processAttributeBorderAfterThickness(var_Token);
                continue;
            }
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-after shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderBefore_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            this.processAttributeBorderBeforeColor("-default-");
            this.processAttributeBorderBeforeStyle("-default-");
            this.processAttributeBorderBeforeThickness("-default-");
            return;
        }
        StringTokenizer var_shorthand = new StringTokenizer(in_attributeValue, " ,");
        while (var_shorthand.hasMoreTokens()) {
            String var_Token = var_shorthand.nextToken();
            if (AFMLAttribute__Abstract.isAFMLAttributeColor(in_attributeValue)) {
                this.processAttributeBorderBeforeColor(var_Token);
                continue;
            }
            if (var_Token.equalsIgnoreCase("solid") || var_Token.equalsIgnoreCase("dotted") || var_Token.equalsIgnoreCase("dashed") || var_Token.equalsIgnoreCase("dot-dash") || var_Token.equalsIgnoreCase("dot-dash") || var_Token.equalsIgnoreCase("dot-dot-dash") || var_Token.equalsIgnoreCase("wave") || var_Token.equalsIgnoreCase("double") || var_Token.equalsIgnoreCase("double-dotted") || var_Token.equalsIgnoreCase("double-dashed") || var_Token.equalsIgnoreCase("double-dot-dash") || var_Token.equalsIgnoreCase("double-dot-dash") || var_Token.equalsIgnoreCase("double-dot-dot-dash") || var_Token.equalsIgnoreCase("double-wave") || var_Token.equalsIgnoreCase("triple") || var_Token.equalsIgnoreCase("triple-dotted") || var_Token.equalsIgnoreCase("triple-dashed") || var_Token.equalsIgnoreCase("triple-dot-dash") || var_Token.equalsIgnoreCase("triple-dot-dash") || var_Token.equalsIgnoreCase("triple-dot-dot-dash") || var_Token.equalsIgnoreCase("triple-wave") || var_Token.equalsIgnoreCase("groove") || var_Token.equalsIgnoreCase("ridge") || var_Token.equalsIgnoreCase("inset") || var_Token.equalsIgnoreCase("outset")) {
                this.processAttributeBorderBeforeStyle(var_Token);
                continue;
            }
            if (var_Token.equalsIgnoreCase("hairline") || var_Token.equalsIgnoreCase("extra-thin") || var_Token.equalsIgnoreCase("thin") || var_Token.equalsIgnoreCase("medium") || var_Token.equalsIgnoreCase("thick") || var_Token.equalsIgnoreCase("extra-thick") || AFMLAttribute__Abstract.isAFMLAttributeLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributeEMLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributePercentage(var_Token)) {
                this.processAttributeBorderBeforeThickness(var_Token);
                continue;
            }
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-before shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderEnd_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            this.processAttributeBorderEndColor("-default-");
            this.processAttributeBorderEndStyle("-default-");
            this.processAttributeBorderEndThickness("-default-");
            return;
        }
        StringTokenizer var_shorthand = new StringTokenizer(in_attributeValue, " ,");
        while (var_shorthand.hasMoreTokens()) {
            String var_Token = var_shorthand.nextToken();
            if (AFMLAttribute__Abstract.isAFMLAttributeColor(in_attributeValue)) {
                this.processAttributeBorderEndColor(var_Token);
                continue;
            }
            if (var_Token.equalsIgnoreCase("solid") || var_Token.equalsIgnoreCase("dotted") || var_Token.equalsIgnoreCase("dashed") || var_Token.equalsIgnoreCase("dot-dash") || var_Token.equalsIgnoreCase("dot-dash") || var_Token.equalsIgnoreCase("dot-dot-dash") || var_Token.equalsIgnoreCase("wave") || var_Token.equalsIgnoreCase("double") || var_Token.equalsIgnoreCase("double-dotted") || var_Token.equalsIgnoreCase("double-dashed") || var_Token.equalsIgnoreCase("double-dot-dash") || var_Token.equalsIgnoreCase("double-dot-dash") || var_Token.equalsIgnoreCase("double-dot-dot-dash") || var_Token.equalsIgnoreCase("double-wave") || var_Token.equalsIgnoreCase("triple") || var_Token.equalsIgnoreCase("triple-dotted") || var_Token.equalsIgnoreCase("triple-dashed") || var_Token.equalsIgnoreCase("triple-dot-dash") || var_Token.equalsIgnoreCase("triple-dot-dash") || var_Token.equalsIgnoreCase("triple-dot-dot-dash") || var_Token.equalsIgnoreCase("triple-wave") || var_Token.equalsIgnoreCase("groove") || var_Token.equalsIgnoreCase("ridge") || var_Token.equalsIgnoreCase("inset") || var_Token.equalsIgnoreCase("outset")) {
                this.processAttributeBorderEndStyle(var_Token);
                continue;
            }
            if (var_Token.equalsIgnoreCase("hairline") || var_Token.equalsIgnoreCase("extra-thin") || var_Token.equalsIgnoreCase("thin") || var_Token.equalsIgnoreCase("medium") || var_Token.equalsIgnoreCase("thick") || var_Token.equalsIgnoreCase("extra-thick") || AFMLAttribute__Abstract.isAFMLAttributeLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributeEMLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributePercentage(var_Token)) {
                this.processAttributeBorderEndThickness(var_Token);
                continue;
            }
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-end shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderStart_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            this.processAttributeBorderStartColor("-default-");
            this.processAttributeBorderStartStyle("-default-");
            this.processAttributeBorderStartThickness("-default-");
            return;
        }
        StringTokenizer var_shorthand = new StringTokenizer(in_attributeValue, " ,");
        while (var_shorthand.hasMoreTokens()) {
            String var_Token = var_shorthand.nextToken();
            if (AFMLAttribute__Abstract.isAFMLAttributeColor(in_attributeValue)) {
                this.processAttributeBorderStartColor(var_Token);
                continue;
            }
            if (var_Token.equalsIgnoreCase("solid") || var_Token.equalsIgnoreCase("dotted") || var_Token.equalsIgnoreCase("dashed") || var_Token.equalsIgnoreCase("dot-dash") || var_Token.equalsIgnoreCase("dot-dash") || var_Token.equalsIgnoreCase("dot-dot-dash") || var_Token.equalsIgnoreCase("wave") || var_Token.equalsIgnoreCase("double") || var_Token.equalsIgnoreCase("double-dotted") || var_Token.equalsIgnoreCase("double-dashed") || var_Token.equalsIgnoreCase("double-dot-dash") || var_Token.equalsIgnoreCase("double-dot-dash") || var_Token.equalsIgnoreCase("double-dot-dot-dash") || var_Token.equalsIgnoreCase("double-wave") || var_Token.equalsIgnoreCase("triple") || var_Token.equalsIgnoreCase("triple-dotted") || var_Token.equalsIgnoreCase("triple-dashed") || var_Token.equalsIgnoreCase("triple-dot-dash") || var_Token.equalsIgnoreCase("triple-dot-dash") || var_Token.equalsIgnoreCase("triple-dot-dot-dash") || var_Token.equalsIgnoreCase("triple-wave") || var_Token.equalsIgnoreCase("groove") || var_Token.equalsIgnoreCase("ridge") || var_Token.equalsIgnoreCase("inset") || var_Token.equalsIgnoreCase("outset")) {
                this.processAttributeBorderStartStyle(var_Token);
                continue;
            }
            if (var_Token.equalsIgnoreCase("hairline") || var_Token.equalsIgnoreCase("extra-thin") || var_Token.equalsIgnoreCase("thin") || var_Token.equalsIgnoreCase("medium") || var_Token.equalsIgnoreCase("thick") || var_Token.equalsIgnoreCase("extra-thick") || AFMLAttribute__Abstract.isAFMLAttributeLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributeEMLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributePercentage(var_Token)) {
                this.processAttributeBorderStartThickness(var_Token);
                continue;
            }
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-start shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderAfterColor(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromColor(AFMLAttribute__TypeId.Area_BorderAfterColor, in_attributeValue, "use-current-color", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-after-color: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderBeforeColor(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromColor(AFMLAttribute__TypeId.Area_BorderBeforeColor, in_attributeValue, "use-current-color", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-before-color: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderEndColor(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromColor(AFMLAttribute__TypeId.Area_BorderEndColor, in_attributeValue, "use-current-color", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-end-color: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderStartColor(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromColor(AFMLAttribute__TypeId.Area_BorderStartColor, in_attributeValue, "use-current-color", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-start-color: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderAfterThickness(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("hairline")) {
            in_attributeValue = "0.1pt";
        } else if (in_attributeValue.equalsIgnoreCase("extra-thin")) {
            in_attributeValue = "0.5pt";
        } else if (in_attributeValue.equalsIgnoreCase("thin")) {
            in_attributeValue = "0.75pt";
        } else if (in_attributeValue.equalsIgnoreCase("medium")) {
            in_attributeValue = "1.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("thick")) {
            in_attributeValue = "2.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("extra-thick")) {
            in_attributeValue = "4.0pt";
        }
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_BorderAfterThickness, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-after-thickness: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderBeforeThickness(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("hairline")) {
            in_attributeValue = "0.1pt";
        } else if (in_attributeValue.equalsIgnoreCase("extra-thin")) {
            in_attributeValue = "0.5pt";
        } else if (in_attributeValue.equalsIgnoreCase("thin")) {
            in_attributeValue = "0.75pt";
        } else if (in_attributeValue.equalsIgnoreCase("medium")) {
            in_attributeValue = "1.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("thick")) {
            in_attributeValue = "2.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("extra-thick")) {
            in_attributeValue = "4.0pt";
        }
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_BorderBeforeThickness, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-before-thickness: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderEndThickness(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("hairline")) {
            in_attributeValue = "0.1pt";
        } else if (in_attributeValue.equalsIgnoreCase("extra-thin")) {
            in_attributeValue = "0.5pt";
        } else if (in_attributeValue.equalsIgnoreCase("thin")) {
            in_attributeValue = "0.75pt";
        } else if (in_attributeValue.equalsIgnoreCase("medium")) {
            in_attributeValue = "1.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("thick")) {
            in_attributeValue = "2.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("extra-thick")) {
            in_attributeValue = "4.0pt";
        }
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_BorderEndThickness, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-end-thickness: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderStartThickness(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("hairline")) {
            in_attributeValue = "0.1pt";
        } else if (in_attributeValue.equalsIgnoreCase("extra-thin")) {
            in_attributeValue = "0.5pt";
        } else if (in_attributeValue.equalsIgnoreCase("thin")) {
            in_attributeValue = "0.75pt";
        } else if (in_attributeValue.equalsIgnoreCase("medium")) {
            in_attributeValue = "1.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("thick")) {
            in_attributeValue = "2.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("extra-thick")) {
            in_attributeValue = "4.0pt";
        }
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_BorderStartThickness, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-start-thickness: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderAfterStyle(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromBorderStyle(AFMLAttribute__TypeId.Area_BorderAfterStyle, AFMLAttribute__TypeId.Area_BorderAfterSeparation, AFMLAttribute__TypeId.Area_BorderAfterCount, in_attributeValue, "solid", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-after-style: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderBeforeStyle(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromBorderStyle(AFMLAttribute__TypeId.Area_BorderBeforeStyle, AFMLAttribute__TypeId.Area_BorderBeforeSeparation, AFMLAttribute__TypeId.Area_BorderBeforeCount, in_attributeValue, "solid", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-before-style: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderEndStyle(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromBorderStyle(AFMLAttribute__TypeId.Area_BorderEndStyle, AFMLAttribute__TypeId.Area_BorderEndSeparation, AFMLAttribute__TypeId.Area_BorderEndCount, in_attributeValue, "solid", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-end-style: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBorderStartStyle(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromBorderStyle(AFMLAttribute__TypeId.Area_BorderStartStyle, AFMLAttribute__TypeId.Area_BorderStartSeparation, AFMLAttribute__TypeId.Area_BorderStartCount, in_attributeValue, "solid", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for border-start-style: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeFlowAssignmentTableName(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!in_attributeValue.equalsIgnoreCase("-default-") && !this.internalApplyBasicAttributeFromName(AFMLAttribute__TypeId.Binding_FlowAssignmentTableName, in_attributeValue, "-required-", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for flow-assignment-table-name: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeFlowAssignmentTableNameReference(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!in_attributeValue.equalsIgnoreCase("-default-") && !this.internalApplyBasicAttributeFromName(AFMLAttribute__TypeId.Binding_FlowAssignmentTableNameReference, in_attributeValue, "-required-", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for flow-assignment-table-name-reference: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeFlowName(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!in_attributeValue.equalsIgnoreCase("-default-") && !this.internalApplyBasicAttributeFromName(AFMLAttribute__TypeId.Binding_FlowName, in_attributeValue, "-required-", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for flow-name: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeFlowNameReference(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!in_attributeValue.equalsIgnoreCase("-default-") && !this.internalApplyBasicAttributeFromName(AFMLAttribute__TypeId.Binding_FlowNameReference, in_attributeValue, "-required-", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for flow-name-reference: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeFont_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter, AFMLExceptionUnsupportedFeature {
        this.processAttributeFontFamily("serif");
        this.processAttributeFontSize("medium");
        this.processAttributeFontStretch("normal");
        this.processAttributeFontStyle("normal");
        this.processAttributeFontWeight("normal");
        this.processAttributeFontVariant("normal");
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            return;
        }
        StringBuffer var_FamilyNameStringBuffer = new StringBuffer();
        StringTokenizer var_commaDelimited = new StringTokenizer(in_attributeValue, ",");
        while (var_commaDelimited.hasMoreTokens()) {
            String var_commaToken = var_commaDelimited.nextToken().trim();
            boolean var_IsCommaDelimited = true;
            StringTokenizer var_spaceDelimited = new StringTokenizer(var_commaToken, " ");
            while (var_spaceDelimited.hasMoreTokens()) {
                String var_Token = var_spaceDelimited.nextToken().trim();
                boolean var_foundSizeAndLineHeightToken = false;
                int i = 0;
                for (i = 0; i < var_Token.length(); ++i) {
                    if (var_Token.charAt(i) != '/') continue;
                    String var_beforeSlash = var_Token.substring(0, i);
                    String var_afterSlash = var_Token.substring(i + 1, var_Token.length());
                    if (AFMLAttribute__Abstract.isAFMLAttributeLength(var_beforeSlash) || AFMLAttribute__Abstract.isAFMLAttributeEMLength(var_beforeSlash) || AFMLAttribute__Abstract.isAFMLAttributePercentageOrFactor(var_beforeSlash) || var_beforeSlash.equalsIgnoreCase("ultrasmall") || var_beforeSlash.equalsIgnoreCase("ultra-small") || var_beforeSlash.equalsIgnoreCase("extraextrasmall") || var_beforeSlash.equalsIgnoreCase("extra-extra-small") || var_beforeSlash.equalsIgnoreCase("xx-small") || var_beforeSlash.equalsIgnoreCase("extrasmall") || var_beforeSlash.equalsIgnoreCase("extra-small") || var_beforeSlash.equalsIgnoreCase("x-small") || var_beforeSlash.equalsIgnoreCase("small") || var_beforeSlash.equalsIgnoreCase("medium") || var_beforeSlash.equalsIgnoreCase("large") || var_beforeSlash.equalsIgnoreCase("x-large") || var_beforeSlash.equalsIgnoreCase("extra-large") || var_beforeSlash.equalsIgnoreCase("extralarge") || var_beforeSlash.equalsIgnoreCase("xx-large") || var_beforeSlash.equalsIgnoreCase("extra-extra-large") || var_beforeSlash.equalsIgnoreCase("extraextralarge") || var_beforeSlash.equalsIgnoreCase("ultra-large") || var_beforeSlash.equalsIgnoreCase("ultralarge") || var_beforeSlash.equalsIgnoreCase("larger") || var_beforeSlash.equalsIgnoreCase("smaller")) {
                        this.processAttributeFontSize(var_beforeSlash);
                    }
                    if (AFMLAttribute__Abstract.isAFMLAttributeLength(var_afterSlash) || AFMLAttribute__Abstract.isAFMLAttributeEMLength(var_afterSlash) || AFMLAttribute__Abstract.isAFMLAttributePercentageOrFactor(var_afterSlash) || AFMLAttribute__Abstract.isAFMLAttributeNumber(var_afterSlash) || AFMLAttribute__Abstract.isAFMLAttributeInteger(var_afterSlash) || var_afterSlash.equalsIgnoreCase("normal")) {
                        this.processAttributeLineHeight_Shorthand(var_afterSlash);
                    }
                    var_foundSizeAndLineHeightToken = true;
                    break;
                }
                if (var_foundSizeAndLineHeightToken) continue;
                if (var_Token.equalsIgnoreCase("100") || var_Token.equalsIgnoreCase("200") || var_Token.equalsIgnoreCase("300") || var_Token.equalsIgnoreCase("400") || var_Token.equalsIgnoreCase("500") || var_Token.equalsIgnoreCase("600") || var_Token.equalsIgnoreCase("700") || var_Token.equalsIgnoreCase("800") || var_Token.equalsIgnoreCase("900") || var_Token.equalsIgnoreCase("hair") || var_Token.equalsIgnoreCase("hairline") || var_Token.equalsIgnoreCase("extra-thin") || var_Token.equalsIgnoreCase("extrathin") || var_Token.equalsIgnoreCase("x-thin") || var_Token.equalsIgnoreCase("xthin") || var_Token.equalsIgnoreCase("thin") || var_Token.equalsIgnoreCase("ultra-light") || var_Token.equalsIgnoreCase("ultralight") || var_Token.equalsIgnoreCase("extra-extra-light") || var_Token.equalsIgnoreCase("extraextralight") || var_Token.equalsIgnoreCase("xx-light") || var_Token.equalsIgnoreCase("xxlight") || var_Token.equalsIgnoreCase("extra-light") || var_Token.equalsIgnoreCase("extralight") || var_Token.equalsIgnoreCase("x-light") || var_Token.equalsIgnoreCase("xlight") || var_Token.equalsIgnoreCase("light") || var_Token.equalsIgnoreCase("demi-light") || var_Token.equalsIgnoreCase("demilight") || var_Token.equalsIgnoreCase("semi-light") || var_Token.equalsIgnoreCase("semilight") || var_Token.equalsIgnoreCase("book") || var_Token.equalsIgnoreCase("regular") || var_Token.equalsIgnoreCase("demi") || var_Token.equalsIgnoreCase("demi-bold") || var_Token.equalsIgnoreCase("demibold") || var_Token.equalsIgnoreCase("semi") || var_Token.equalsIgnoreCase("semi-bold") || var_Token.equalsIgnoreCase("semibold") || var_Token.equalsIgnoreCase("bold") || var_Token.equalsIgnoreCase("extra-bold") || var_Token.equalsIgnoreCase("extrabold") || var_Token.equalsIgnoreCase("x-bold") || var_Token.equalsIgnoreCase("xbold") || var_Token.equalsIgnoreCase("heavy") || var_Token.equalsIgnoreCase("black") || var_Token.equalsIgnoreCase("ultra-bold") || var_Token.equalsIgnoreCase("ultrabold") || var_Token.equalsIgnoreCase("extra-extra-bold") || var_Token.equalsIgnoreCase("extraextrabold") || var_Token.equalsIgnoreCase("xx-bold") || var_Token.equalsIgnoreCase("xxbold") || var_Token.equalsIgnoreCase("extra-black") || var_Token.equalsIgnoreCase("extrablack") || var_Token.equalsIgnoreCase("x-black") || var_Token.equalsIgnoreCase("xblack") || var_Token.equalsIgnoreCase("ultra-black") || var_Token.equalsIgnoreCase("ultrablack") || var_Token.equalsIgnoreCase("extra-extra-black") || var_Token.equalsIgnoreCase("extraextrablack") || var_Token.equalsIgnoreCase("xx-black") || var_Token.equalsIgnoreCase("xxblack")) {
                    this.processAttributeFontWeight(var_Token);
                    continue;
                }
                if (AFMLAttribute__Abstract.isAFMLAttributeLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributeEMLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributePercentage(var_Token) || var_Token.equalsIgnoreCase("ultrasmall") || var_Token.equalsIgnoreCase("ultra-small") || var_Token.equalsIgnoreCase("extraextrasmall") || var_Token.equalsIgnoreCase("extra-extra-small") || var_Token.equalsIgnoreCase("xx-small") || var_Token.equalsIgnoreCase("extrasmall") || var_Token.equalsIgnoreCase("extra-small") || var_Token.equalsIgnoreCase("x-small") || var_Token.equalsIgnoreCase("small") || var_Token.equalsIgnoreCase("medium") || var_Token.equalsIgnoreCase("large") || var_Token.equalsIgnoreCase("x-large") || var_Token.equalsIgnoreCase("extra-large") || var_Token.equalsIgnoreCase("extralarge") || var_Token.equalsIgnoreCase("xx-large") || var_Token.equalsIgnoreCase("ultra-large") || var_Token.equalsIgnoreCase("ultralarge") || var_Token.equalsIgnoreCase("extra-extra-large") || var_Token.equalsIgnoreCase("extraextralarge") || var_Token.equalsIgnoreCase("larger") || var_Token.equalsIgnoreCase("smaller")) {
                    this.processAttributeFontSize(var_Token);
                    continue;
                }
                if (var_Token.equalsIgnoreCase("ultra-condensed") || var_Token.equalsIgnoreCase("ultracondensed") || var_Token.equalsIgnoreCase("extra-extra-condensed") || var_Token.equalsIgnoreCase("extraextracondensed") || var_Token.equalsIgnoreCase("xx-condensed") || var_Token.equalsIgnoreCase("xxcondensed") || var_Token.equalsIgnoreCase("ultra-compressed") || var_Token.equalsIgnoreCase("ultracompressed") || var_Token.equalsIgnoreCase("extra-extra-compressed") || var_Token.equalsIgnoreCase("extraextracompressed") || var_Token.equalsIgnoreCase("xxcompressed") || var_Token.equalsIgnoreCase("xx-compressed") || var_Token.equalsIgnoreCase("extranarrow") || var_Token.equalsIgnoreCase("extra-narrow") || var_Token.equalsIgnoreCase("x-narrow") || var_Token.equalsIgnoreCase("xnarrow") || var_Token.equalsIgnoreCase("extra-condensed") || var_Token.equalsIgnoreCase("extracondensed") || var_Token.equalsIgnoreCase("x-condensed") || var_Token.equalsIgnoreCase("xcondensed") || var_Token.equalsIgnoreCase("extra-compressed") || var_Token.equalsIgnoreCase("extracompressed") || var_Token.equalsIgnoreCase("x-compressed") || var_Token.equalsIgnoreCase("xcompressed") || var_Token.equalsIgnoreCase("narrow") || var_Token.equalsIgnoreCase("condensed") || var_Token.equalsIgnoreCase("compressed") || var_Token.equalsIgnoreCase("semi-condensed") || var_Token.equalsIgnoreCase("semicondensed") || var_Token.equalsIgnoreCase("demi-condensed") || var_Token.equalsIgnoreCase("demicondensed") || var_Token.equalsIgnoreCase("semi-compressed") || var_Token.equalsIgnoreCase("semicompressed") || var_Token.equalsIgnoreCase("demi-compressed") || var_Token.equalsIgnoreCase("demicompressed") || var_Token.equalsIgnoreCase("semi-expanded") || var_Token.equalsIgnoreCase("semiexpanded") || var_Token.equalsIgnoreCase("demi-expanded") || var_Token.equalsIgnoreCase("demiexpanded") || var_Token.equalsIgnoreCase("semi-extended") || var_Token.equalsIgnoreCase("semiextended") || var_Token.equalsIgnoreCase("demi-extended") || var_Token.equalsIgnoreCase("demiextended") || var_Token.equalsIgnoreCase("expanded") || var_Token.equalsIgnoreCase("extended") || var_Token.equalsIgnoreCase("extra-expanded") || var_Token.equalsIgnoreCase("extraexpanded") || var_Token.equalsIgnoreCase("x-expanded") || var_Token.equalsIgnoreCase("xexpanded") || var_Token.equalsIgnoreCase("extra-extended") || var_Token.equalsIgnoreCase("extraextended") || var_Token.equalsIgnoreCase("x-extended") || var_Token.equalsIgnoreCase("xextended") || var_Token.equalsIgnoreCase("wide") || var_Token.equalsIgnoreCase("ultra-expanded") || var_Token.equalsIgnoreCase("ultraexpanded") || var_Token.equalsIgnoreCase("extra-extra-expanded") || var_Token.equalsIgnoreCase("extraextraexpanded") || var_Token.equalsIgnoreCase("xx-expanded") || var_Token.equalsIgnoreCase("xxexpanded") || var_Token.equalsIgnoreCase("ultra-extended") || var_Token.equalsIgnoreCase("ultraextended") || var_Token.equalsIgnoreCase("extra-extra-extended") || var_Token.equalsIgnoreCase("extraextraextended") || var_Token.equalsIgnoreCase("xx-extended") || var_Token.equalsIgnoreCase("xxextended") || var_Token.equalsIgnoreCase("extrawide") || var_Token.equalsIgnoreCase("extra-wide") || var_Token.equalsIgnoreCase("x-wide") || var_Token.equalsIgnoreCase("xwide")) {
                    this.processAttributeFontStretch(var_Token);
                    continue;
                }
                if (var_Token.equalsIgnoreCase("italic") || var_Token.equalsIgnoreCase("oblique") || var_Token.equalsIgnoreCase("reverse-italic") || var_Token.equalsIgnoreCase("reverse-oblique") || var_Token.equalsIgnoreCase("backslant")) {
                    this.processAttributeFontStyle(var_Token);
                    continue;
                }
                if (var_Token.equalsIgnoreCase("small-caps")) {
                    this.processAttributeFontVariant(var_Token);
                    continue;
                }
                if (var_Token.equalsIgnoreCase("normal")) continue;
                if (var_IsCommaDelimited) {
                    if (var_FamilyNameStringBuffer.length() != 0) {
                        var_FamilyNameStringBuffer.append(',');
                    }
                    var_IsCommaDelimited = false;
                }
                if (var_FamilyNameStringBuffer.length() != 0 && var_FamilyNameStringBuffer.charAt(var_FamilyNameStringBuffer.length() - 1) != ',') {
                    var_FamilyNameStringBuffer.append(' ');
                }
                var_FamilyNameStringBuffer.append(var_Token);
            }
        }
        if (var_FamilyNameStringBuffer.length() != 0) {
            this.processAttributeFontFamily(var_FamilyNameStringBuffer.toString());
        }
    }

    public void processAttributeFontFamily(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "serif";
        }
        AFMLAttribute_String var_AFMLAttribute = new AFMLAttribute_String(AFMLAttribute__TypeId.InlineText_FontFamily, in_attributeValue, true);
        this.setAttributeOnStackTop(var_AFMLAttribute);
    }

    public void processAttributeFontForceMonospacePitch(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"normal"};
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_FontForceMonospacePitch, in_attributeValue, "normal", true, var_allowedKeywords, "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for font-force-monospace-pitch: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeFontSize(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        AFMLAttribute__Abstract var_AFMLAttribute;
        AFMLAttribute_Length var_attr;
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "medium";
        }
        if (in_attributeValue.equalsIgnoreCase("xx-small") || in_attributeValue.equalsIgnoreCase("xxsmall") || in_attributeValue.equalsIgnoreCase("extra-extra-small") || in_attributeValue.equalsIgnoreCase("extraextrasmall") || in_attributeValue.equalsIgnoreCase("ultra-small") || in_attributeValue.equalsIgnoreCase("ultrasmall")) {
            in_attributeValue = "8.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("x-small") || in_attributeValue.equalsIgnoreCase("xsmall") || in_attributeValue.equalsIgnoreCase("extra-small") || in_attributeValue.equalsIgnoreCase("extrasmall")) {
            in_attributeValue = "9.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("small")) {
            in_attributeValue = "10.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("medium")) {
            in_attributeValue = "12.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("large")) {
            in_attributeValue = "14.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("x-large") || in_attributeValue.equalsIgnoreCase("xlarge") || in_attributeValue.equalsIgnoreCase("extra-large") || in_attributeValue.equalsIgnoreCase("extralarge")) {
            in_attributeValue = "18.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("xx-large") || in_attributeValue.equalsIgnoreCase("xxlarge") || in_attributeValue.equalsIgnoreCase("extra-extra-large") || in_attributeValue.equalsIgnoreCase("extraextralarge") || in_attributeValue.equalsIgnoreCase("ultra-large") || in_attributeValue.equalsIgnoreCase("ultralarge")) {
            in_attributeValue = "24.0pt";
        }
        if (in_attributeValue.equalsIgnoreCase("larger")) {
            var_attr = (AFMLAttribute_Length)this.getStackLevel(1).getAttribute(AFMLAttribute__TypeId.InlineText_FontSize);
            double var_inheritedSize = var_attr.getLength();
            if (var_inheritedSize < 8.0) {
                in_attributeValue = "8.0pt";
            } else if (var_inheritedSize < 9.0) {
                in_attributeValue = "9.0pt";
            } else if (var_inheritedSize < 10.0) {
                in_attributeValue = "10.0pt";
            } else if (var_inheritedSize < 12.0) {
                in_attributeValue = "12.0pt";
            } else if (var_inheritedSize < 14.0) {
                in_attributeValue = "14.0pt";
            } else if (var_inheritedSize < 18.0) {
                in_attributeValue = "18.0pt";
            } else if (var_inheritedSize < 24.0) {
                in_attributeValue = "24.0pt";
            }
        } else if (in_attributeValue.equalsIgnoreCase("smaller")) {
            var_attr = (AFMLAttribute_Length)this.getStackLevel(1).getAttribute(AFMLAttribute__TypeId.InlineText_FontSize);
            double var_inheritedSize = var_attr.getLength();
            if (var_inheritedSize > 24.0) {
                in_attributeValue = "24.0pt";
            } else if (var_inheritedSize > 18.0) {
                in_attributeValue = "18.0pt";
            } else if (var_inheritedSize > 14.0) {
                in_attributeValue = "14.0pt";
            } else if (var_inheritedSize > 12.0) {
                in_attributeValue = "12.0pt";
            } else if (var_inheritedSize > 10.0) {
                in_attributeValue = "10.0pt";
            } else if (var_inheritedSize > 9.0) {
                in_attributeValue = "9.0pt";
            } else if (var_inheritedSize > 8.0) {
                in_attributeValue = "8.0pt";
            }
        }
        if (!"pt".equals("") && (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue) || AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue))) {
            if (AFMLAttribute__Abstract.convertAFMLLengthToPoints(in_attributeValue = in_attributeValue + "pt") <= 0.0) {
                in_attributeValue = "12.0pt";
            }
            var_AFMLAttribute = new AFMLAttribute_Length(AFMLAttribute__TypeId.InlineText_FontSize, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue)) {
            if (AFMLAttribute__Abstract.convertAFMLLengthToPoints(in_attributeValue) <= 0.0) {
                in_attributeValue = "12.0pt";
            }
            var_AFMLAttribute = new AFMLAttribute_Length(AFMLAttribute__TypeId.InlineText_FontSize, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeEMLength(in_attributeValue)) {
            if (AFMLAttribute__Abstract.convertAFMLEMLengthToFactor(in_attributeValue) <= 0.0) {
                in_attributeValue = "12.0pt";
            }
            var_AFMLAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_FontSize, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributePercentageOrFactor(in_attributeValue)) {
            var_AFMLAttribute = new AFMLAttribute_Percentage(AFMLAttribute__TypeId.InlineText_FontSize, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for font-size: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeFontStretch(String in_attributeValue) throws AFMLExceptionInvalidParameter, AFMLExceptionUnsupportedFeature {
        String[] var_allowedKeywords = new String[]{"ultra-condensed", "extra-condensed", "condensed", "semi-condensed", "normal", "semi-expanded", "expanded", "extra-expanded", "ultra-expanded"};
        if (in_attributeValue.equalsIgnoreCase("ultracondensed") || in_attributeValue.equalsIgnoreCase("extra-extra-condensed") || in_attributeValue.equalsIgnoreCase("extraextracondensed") || in_attributeValue.equalsIgnoreCase("xx-condensed") || in_attributeValue.equalsIgnoreCase("xxcondensed") || in_attributeValue.equalsIgnoreCase("ultra-compressed") || in_attributeValue.equalsIgnoreCase("ultracompressed") || in_attributeValue.equalsIgnoreCase("extraextracompressed") || in_attributeValue.equalsIgnoreCase("extra-extra-compressed") || in_attributeValue.equalsIgnoreCase("xxcompressed") || in_attributeValue.equalsIgnoreCase("xx-compressed") || in_attributeValue.equalsIgnoreCase("extranarrow") || in_attributeValue.equalsIgnoreCase("extra-narrow") || in_attributeValue.equalsIgnoreCase("x-narrow") || in_attributeValue.equalsIgnoreCase("xnarrow")) {
            in_attributeValue = "ultra-condensed";
        } else if (in_attributeValue.equalsIgnoreCase("extracondensed") || in_attributeValue.equalsIgnoreCase("x-condensed") || in_attributeValue.equalsIgnoreCase("xcondensed") || in_attributeValue.equalsIgnoreCase("extra-compressed") || in_attributeValue.equalsIgnoreCase("extracompressed") || in_attributeValue.equalsIgnoreCase("x-compressed") || in_attributeValue.equalsIgnoreCase("xcompressed") || in_attributeValue.equalsIgnoreCase("narrow")) {
            in_attributeValue = "extra-condensed";
        } else if (in_attributeValue.equalsIgnoreCase("compressed")) {
            in_attributeValue = "condensed";
        } else if (in_attributeValue.equalsIgnoreCase("semicondensed") || in_attributeValue.equalsIgnoreCase("demi-condensed") || in_attributeValue.equalsIgnoreCase("demicondensed") || in_attributeValue.equalsIgnoreCase("semi-compressed") || in_attributeValue.equalsIgnoreCase("semicompressed") || in_attributeValue.equalsIgnoreCase("demi-compressed") || in_attributeValue.equalsIgnoreCase("demicompressed")) {
            in_attributeValue = "semi-condensed";
        } else if (in_attributeValue.equalsIgnoreCase("semiexpanded") || in_attributeValue.equalsIgnoreCase("demi-expanded") || in_attributeValue.equalsIgnoreCase("demiexpanded") || in_attributeValue.equalsIgnoreCase("semi-extended") || in_attributeValue.equalsIgnoreCase("semiextended") || in_attributeValue.equalsIgnoreCase("demi-extended") || in_attributeValue.equalsIgnoreCase("demiextended")) {
            in_attributeValue = "semi-expanded";
        } else if (in_attributeValue.equalsIgnoreCase("extended")) {
            in_attributeValue = "expanded";
        } else if (in_attributeValue.equalsIgnoreCase("extraexpanded") || in_attributeValue.equalsIgnoreCase("x-expanded") || in_attributeValue.equalsIgnoreCase("xexpanded") || in_attributeValue.equalsIgnoreCase("extra-extended") || in_attributeValue.equalsIgnoreCase("extraextended") || in_attributeValue.equalsIgnoreCase("x-extended") || in_attributeValue.equalsIgnoreCase("xextended") || in_attributeValue.equalsIgnoreCase("wide")) {
            in_attributeValue = "extra-expanded";
        } else if (in_attributeValue.equalsIgnoreCase("ultraexpanded") || in_attributeValue.equalsIgnoreCase("extra-extra-expanded") || in_attributeValue.equalsIgnoreCase("extraextraexpanded") || in_attributeValue.equalsIgnoreCase("xx-expanded") || in_attributeValue.equalsIgnoreCase("xxexpanded") || in_attributeValue.equalsIgnoreCase("ultra-extended") || in_attributeValue.equalsIgnoreCase("ultraextended") || in_attributeValue.equalsIgnoreCase("extra-extra-extended") || in_attributeValue.equalsIgnoreCase("extraextraextended") || in_attributeValue.equalsIgnoreCase("xx-extended") || in_attributeValue.equalsIgnoreCase("xxextended") || in_attributeValue.equalsIgnoreCase("extrawide") || in_attributeValue.equalsIgnoreCase("extra-wide") || in_attributeValue.equalsIgnoreCase("x-wide") || in_attributeValue.equalsIgnoreCase("xwide")) {
            in_attributeValue = "ultra-expanded";
        }
        if (in_attributeValue.equalsIgnoreCase("narrower")) {
            AFMLAnomalies.AFMLUnsupportedFeatureStop("InvalidInput: Values wider/narrower are not currently supported for font-stretch");
        } else if (in_attributeValue.equalsIgnoreCase("wider")) {
            AFMLAnomalies.AFMLUnsupportedFeatureStop("InvalidInput: Values wider/narrower are not currently supported for font-stretch");
        }
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.InlineText_FontStretch, in_attributeValue.toLowerCase(), "normal", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for font-stretch: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeFontStyle(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"normal", "italic", "reverse-italic"};
        if (in_attributeValue.equalsIgnoreCase("oblique")) {
            in_attributeValue = "italic";
        }
        if (in_attributeValue.equalsIgnoreCase("reverse-italic") || in_attributeValue.equalsIgnoreCase("oblique") || in_attributeValue.equalsIgnoreCase("reverse-oblique")) {
            in_attributeValue = "reverse-italic";
        }
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.InlineText_FontStyle, in_attributeValue.toLowerCase(), "normal", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for font-style: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeFontVariant(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"normal", "small-caps"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.InlineText_FontVariant, in_attributeValue.toLowerCase(), "normal", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for font-variant: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeFontWeight(String in_attributeValue) throws AFMLExceptionInvalidParameter, AFMLExceptionUnsupportedFeature {
        String[] var_allowedKeywords = new String[]{"100", "200", "300", "400", "500", "600", "700", "800", "900"};
        if (in_attributeValue.equalsIgnoreCase("lighter")) {
            AFMLAnomalies.AFMLUnsupportedFeatureStop("InvalidInput: Values lighter/bolder are not currently supported for font-stretch");
        } else if (in_attributeValue.equalsIgnoreCase("bolder")) {
            AFMLAnomalies.AFMLUnsupportedFeatureStop("InvalidInput: Values lighter/bolder are not currently supported for font-stretch");
        }
        if (in_attributeValue.equalsIgnoreCase("hair") || in_attributeValue.equalsIgnoreCase("hairline") || in_attributeValue.equalsIgnoreCase("extra-thin") || in_attributeValue.equalsIgnoreCase("extrathin") || in_attributeValue.equalsIgnoreCase("x-thin") || in_attributeValue.equalsIgnoreCase("xthin") || in_attributeValue.equalsIgnoreCase("thin") || in_attributeValue.equalsIgnoreCase("ultra-light") || in_attributeValue.equalsIgnoreCase("ultralight") || in_attributeValue.equalsIgnoreCase("extra-extra-light") || in_attributeValue.equalsIgnoreCase("extraextralight") || in_attributeValue.equalsIgnoreCase("xx-light") || in_attributeValue.equalsIgnoreCase("xxlight") || in_attributeValue.equalsIgnoreCase("extra-light") || in_attributeValue.equalsIgnoreCase("extralight") || in_attributeValue.equalsIgnoreCase("x-light") || in_attributeValue.equalsIgnoreCase("xlight")) {
            in_attributeValue = "100";
        } else if (in_attributeValue.equalsIgnoreCase("light")) {
            in_attributeValue = "200";
        } else if (in_attributeValue.equalsIgnoreCase("book") || in_attributeValue.equalsIgnoreCase("demi-light") || in_attributeValue.equalsIgnoreCase("demilight") || in_attributeValue.equalsIgnoreCase("semi-light") || in_attributeValue.equalsIgnoreCase("semilight")) {
            in_attributeValue = "300";
        } else if (in_attributeValue.equalsIgnoreCase("normal") || in_attributeValue.equalsIgnoreCase("regular")) {
            in_attributeValue = "400";
        } else if (in_attributeValue.equalsIgnoreCase("medium")) {
            in_attributeValue = "500";
        } else if (in_attributeValue.equalsIgnoreCase("demi") || in_attributeValue.equalsIgnoreCase("demi-bold") || in_attributeValue.equalsIgnoreCase("demibold") || in_attributeValue.equalsIgnoreCase("semi") || in_attributeValue.equalsIgnoreCase("semi-bold") || in_attributeValue.equalsIgnoreCase("semibold")) {
            in_attributeValue = "600";
        } else if (in_attributeValue.equalsIgnoreCase("bold")) {
            in_attributeValue = "700";
        } else if (in_attributeValue.equalsIgnoreCase("extra-bold") || in_attributeValue.equalsIgnoreCase("extrabold") || in_attributeValue.equalsIgnoreCase("x-bold") || in_attributeValue.equalsIgnoreCase("xbold") || in_attributeValue.equalsIgnoreCase("heavy") || in_attributeValue.equalsIgnoreCase("black")) {
            in_attributeValue = "800";
        } else if (in_attributeValue.equalsIgnoreCase("ultra-bold") || in_attributeValue.equalsIgnoreCase("ultrabold") || in_attributeValue.equalsIgnoreCase("extra-extra-bold") || in_attributeValue.equalsIgnoreCase("extraextrabold") || in_attributeValue.equalsIgnoreCase("xx-bold") || in_attributeValue.equalsIgnoreCase("xxbold") || in_attributeValue.equalsIgnoreCase("extra-black") || in_attributeValue.equalsIgnoreCase("extrablack") || in_attributeValue.equalsIgnoreCase("x-black") || in_attributeValue.equalsIgnoreCase("xblack") || in_attributeValue.equalsIgnoreCase("ultra-black") || in_attributeValue.equalsIgnoreCase("ultrablack") || in_attributeValue.equalsIgnoreCase("extra-extra-black") || in_attributeValue.equalsIgnoreCase("extraextrablack") || in_attributeValue.equalsIgnoreCase("xx-black") || in_attributeValue.equalsIgnoreCase("xxblack")) {
            in_attributeValue = "900";
        }
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.InlineText_FontWeight, in_attributeValue.toLowerCase(), "400", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for font-weight: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeInlineProgressionDimension_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        double var_length;
        String[] var_allowedKeywords = new String[]{"auto"};
        if (AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue) && (var_length = AFMLAttribute__Abstract.convertAFMLLengthToPoints(in_attributeValue)) <= 0.0) {
            in_attributeValue = "auto";
        }
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Layout_InlineProgressionDimensionMinimum, AFMLAttribute__TypeId.Layout_InlineProgressionDimensionOptimum, AFMLAttribute__TypeId.Layout_InlineProgressionDimensionMaximum, in_attributeValue, "auto", "auto", "auto", false, var_allowedKeywords, "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for inline-progression-dimension (width): \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGraphic_GraphicContentHeight(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"auto"};
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Graphic_GraphicContentHeight, in_attributeValue, "auto", false, var_allowedKeywords, "pt", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-content-height: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGraphic_GraphicContentWidth(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"auto"};
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Graphic_GraphicContentWidth, in_attributeValue, "auto", false, var_allowedKeywords, "pt", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-content-width: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGraphic_GraphicScaleToFitEnable(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromBoolean(AFMLAttribute__TypeId.Graphic_GraphicScaleToFitEnable, in_attributeValue.toLowerCase(), "disable", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-scale-to-fit-enable: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGraphic_GraphicScaleToFitMaximum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"any"};
        if (!this.internalApplyBasicAttributeFromKeywordIntegerNumberOrPercent(AFMLAttribute__TypeId.Graphic_GraphicScaleToFitMaximum, in_attributeValue, "any", false, var_allowedKeywords, false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-scale-to-fit-maximum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGraphic_GraphicScaleToFitMinimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"any"};
        if (!this.internalApplyBasicAttributeFromKeywordIntegerNumberOrPercent(AFMLAttribute__TypeId.Graphic_GraphicScaleToFitMinimum, in_attributeValue, "any", false, var_allowedKeywords, false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-scale-to-fit-minimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGraphic_GraphicScaleToFitStrategy(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"fit-maximum", "fit-minimum", "fit-height", "fit-width", "fit-both", "do-not-scale"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Graphic_GraphicScaleToFitStrategy, in_attributeValue, "fit-maximum", false, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-scaling-to-fit-strategy: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGraphic_GraphicScalingAllowedHeightFactors(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"any"};
        if (!this.internalApplyBasicAttributeFromKeywordIntegerNumberOrPercent(AFMLAttribute__TypeId.Graphic_GraphicScalingAllowedHeightFactors, in_attributeValue, "any", false, var_allowedKeywords, false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-scaling-allowed-height-factors: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGraphic_GraphicScalingAllowedWidthFactors(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"any"};
        if (!this.internalApplyBasicAttributeFromKeywordIntegerNumberOrPercent(AFMLAttribute__TypeId.Graphic_GraphicScalingAllowedWidthFactors, in_attributeValue, "any", false, var_allowedKeywords, false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-scaling-allowed-width-factors: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeBelowBaselineAdjustmentFactor(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "1.0";
        }
        AFMLAttribute_Number var_AFMLAttribute = new AFMLAttribute_Number(AFMLAttribute__TypeId.BelowBaselineAdjustmentFactor, in_attributeValue, true);
        this.setAttributeOnStackTop(var_AFMLAttribute);
    }

    public void processAttributeGraphic_GraphicScalingAspectRatio(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"uniform", "non-uniform"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Graphic_GraphicScalingAspectRatio, in_attributeValue, "uniform", false, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-scaling-aspect-ratio: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGraphic_GraphicScalingMethod(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"auto", "integer-pixels", "resample-any-method"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Graphic_GraphicScalingMethod, in_attributeValue, "auto", false, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-scaling-method: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGraphic_GraphicSource(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "-required-";
        }
        if (in_attributeValue.equalsIgnoreCase("")) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-source: \"" + in_attributeValue + "\"");
        }
        AFMLAttribute_String var_AFMLAttribute = new AFMLAttribute_String(AFMLAttribute__TypeId.Graphic_GraphicSource, in_attributeValue, false);
        this.setAttributeOnStackTop(var_AFMLAttribute);
    }

    public void processAttributeGraphic_GraphicSourcePage(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromInteger(AFMLAttribute__TypeId.Graphic_GraphicSourcePage, in_attributeValue, "1", false, false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-source-page: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGraphic_GraphicSourceType(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "auto";
        }
        if (in_attributeValue.equalsIgnoreCase("")) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-source-type: \"" + in_attributeValue + "\"");
        }
        AFMLAttribute_String var_AFMLAttribute = new AFMLAttribute_String(AFMLAttribute__TypeId.Graphic_GraphicSourceType, in_attributeValue, false);
        this.setAttributeOnStackTop(var_AFMLAttribute);
    }

    public void processAttributeGraphic_InternalGraphicContentDataKey(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-") || in_attributeValue.equalsIgnoreCase("none") || in_attributeValue.equalsIgnoreCase("-none-")) {
            in_attributeValue = "-none-";
        }
        if (in_attributeValue.equalsIgnoreCase("")) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for graphic-key (internal): \"" + in_attributeValue + "\"");
        }
        AFMLAttribute_String var_AFMLAttribute = new AFMLAttribute_String(AFMLAttribute__TypeId.Graphic_InternalGraphicContentDataKey, in_attributeValue, false);
        this.setAttributeOnStackTop(var_AFMLAttribute);
    }

    public void processAttributeGridDivisionIndicators_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            this.processAttributeGridDivisionIndicatorsColor("-default-");
            this.processAttributeGridDivisionIndicatorsStyle("-default-");
            this.processAttributeGridDivisionIndicatorsThickness("-default-");
            return;
        }
        StringTokenizer var_shorthand = new StringTokenizer(in_attributeValue, " ,");
        while (var_shorthand.hasMoreTokens()) {
            String var_Token = var_shorthand.nextToken();
            if (AFMLAttribute__Abstract.isAFMLAttributeColor(in_attributeValue)) {
                this.processAttributeGridDivisionIndicatorsColor(var_Token);
            }
            if (var_Token.equalsIgnoreCase("solid") || var_Token.equalsIgnoreCase("dotted") || var_Token.equalsIgnoreCase("dashed") || var_Token.equalsIgnoreCase("dot-dash") || var_Token.equalsIgnoreCase("dot-dash") || var_Token.equalsIgnoreCase("dot-dot-dash") || var_Token.equalsIgnoreCase("wave") || var_Token.equalsIgnoreCase("double") || var_Token.equalsIgnoreCase("double-dotted") || var_Token.equalsIgnoreCase("double-dashed") || var_Token.equalsIgnoreCase("double-dot-dash") || var_Token.equalsIgnoreCase("double-dot-dash") || var_Token.equalsIgnoreCase("double-dot-dot-dash") || var_Token.equalsIgnoreCase("double-wave") || var_Token.equalsIgnoreCase("triple") || var_Token.equalsIgnoreCase("triple-dotted") || var_Token.equalsIgnoreCase("triple-dashed") || var_Token.equalsIgnoreCase("triple-dot-dash") || var_Token.equalsIgnoreCase("triple-dot-dash") || var_Token.equalsIgnoreCase("triple-dot-dot-dash") || var_Token.equalsIgnoreCase("triple-wave") || var_Token.equalsIgnoreCase("groove") || var_Token.equalsIgnoreCase("ridge") || var_Token.equalsIgnoreCase("inset") || var_Token.equalsIgnoreCase("outset")) {
                this.processAttributeGridDivisionIndicatorsStyle(var_Token);
                continue;
            }
            if (var_Token.equalsIgnoreCase("hairline") || var_Token.equalsIgnoreCase("extra-thin") || var_Token.equalsIgnoreCase("thin") || var_Token.equalsIgnoreCase("medium") || var_Token.equalsIgnoreCase("thick") || var_Token.equalsIgnoreCase("extra-thick") || AFMLAttribute__Abstract.isAFMLAttributeLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributeEMLength(var_Token) || AFMLAttribute__Abstract.isAFMLAttributePercentage(var_Token)) {
                this.processAttributeGridDivisionIndicatorsThickness(var_Token);
                continue;
            }
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for grid-divisions-thickness (width): \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGridDivisionIndicatorsColor(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromColor(AFMLAttribute__TypeId.Area_GridDivisionIndicatorsColor, in_attributeValue, "use-current-color", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for grid-divisions-color: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGridDivisionIndicatorsStyle(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromBorderStyle(AFMLAttribute__TypeId.Area_GridDivisionIndicatorsStyle, AFMLAttribute__TypeId.Area_GridDivisionIndicatorsSeparation, AFMLAttribute__TypeId.Area_GridDivisionIndicatorsCount, in_attributeValue, "solid", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for grid-divisions-style: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeGridDivisionIndicatorsThickness(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("hairline")) {
            in_attributeValue = "0.1pt";
        } else if (in_attributeValue.equalsIgnoreCase("extra-thin")) {
            in_attributeValue = "0.5pt";
        } else if (in_attributeValue.equalsIgnoreCase("thin")) {
            in_attributeValue = "0.75pt";
        } else if (in_attributeValue.equalsIgnoreCase("medium")) {
            in_attributeValue = "1.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("thick")) {
            in_attributeValue = "2.0pt";
        } else if (in_attributeValue.equalsIgnoreCase("extra-thick")) {
            in_attributeValue = "4.0pt";
        }
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_GridDivisionIndicatorsThickness, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for grid-divisions-thickness: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeIndentEnd(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.BlockText_IndentEnd, in_attributeValue, "0.0pt", true, new String[0], "pt", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for indent-end: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeIndentFirst(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.BlockText_IndentFirst, in_attributeValue, "0.0pt", true, new String[0], "pt", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for indent-first (text-indent): \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeIndentStart(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.BlockText_IndentStart, in_attributeValue, "0.0pt", true, new String[0], "pt", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for leader-length.maximum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLeaderPattern_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "space";
        }
        AFMLAttribute_EMLength var_AFMLLeaderThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_LeaderRuleThickness, "0.0264em", true);
        this.setAttributeOnStackTop(var_AFMLLeaderThicknessAttribute);
        AFMLAttribute_EMLength var_AFMLLeaderPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_LeaderRulePosition_Horizontal, "0.0264em", true);
        this.setAttributeOnStackTop(var_AFMLLeaderPositionAttribute);
        AFMLAttribute_EMLength var_AFMLLeaderSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_LeaderRuleSeparation, "-0.165em", true);
        this.setAttributeOnStackTop(var_AFMLLeaderSeparationAttribute);
        if (in_attributeValue.equalsIgnoreCase("space")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LeaderRuleStyle, "none", true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("solid")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LeaderRuleStyle, "solid", true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            AFMLAttribute_Integer var_AFMLLeaderCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_LeaderRuleCount, 1, true);
            this.setAttributeOnStackTop(var_AFMLLeaderCountAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("double") || in_attributeValue.equalsIgnoreCase("double-solid")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LeaderRuleStyle, "solid", true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            AFMLAttribute_Integer var_AFMLLeaderCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_LeaderRuleCount, 2, true);
            this.setAttributeOnStackTop(var_AFMLLeaderCountAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("triple") || in_attributeValue.equalsIgnoreCase("triple-solid")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LeaderRuleStyle, "solid", true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            AFMLAttribute_Integer var_AFMLLeaderCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_LeaderRuleCount, 3, true);
            this.setAttributeOnStackTop(var_AFMLLeaderCountAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("dotted") || in_attributeValue.equalsIgnoreCase("dots")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LeaderRuleStyle, "dotted", true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            AFMLAttribute_Integer var_AFMLLeaderCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_LeaderRuleCount, 1, true);
            this.setAttributeOnStackTop(var_AFMLLeaderCountAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("double-dotted") || in_attributeValue.equalsIgnoreCase("double-dots")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LeaderRuleStyle, "dotted", true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            AFMLAttribute_Integer var_AFMLLeaderCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_LeaderRuleCount, 2, true);
            this.setAttributeOnStackTop(var_AFMLLeaderCountAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("triple-dotted") || in_attributeValue.equalsIgnoreCase("triple-dots")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LeaderRuleStyle, "dotted", true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            AFMLAttribute_Integer var_AFMLLeaderCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_LeaderRuleCount, 3, true);
            this.setAttributeOnStackTop(var_AFMLLeaderCountAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("dashed") || in_attributeValue.equalsIgnoreCase("dashes")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LeaderRuleStyle, "dashed", true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            AFMLAttribute_Integer var_AFMLLeaderCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_LeaderRuleCount, 1, true);
            this.setAttributeOnStackTop(var_AFMLLeaderCountAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("double-dashed") || in_attributeValue.equalsIgnoreCase("double-dashes")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LeaderRuleStyle, "dashed", true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            AFMLAttribute_Integer var_AFMLLeaderCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_LeaderRuleCount, 2, true);
            this.setAttributeOnStackTop(var_AFMLLeaderCountAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("triple-dashed") || in_attributeValue.equalsIgnoreCase("triple-dashes")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LeaderRuleStyle, "dashed", true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
            AFMLAttribute_Integer var_AFMLLeaderCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_LeaderRuleCount, 3, true);
            this.setAttributeOnStackTop(var_AFMLLeaderCountAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for text-leader shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeInlineText_SmallCapsPresetMethod(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"typographic-preferred", "use-font-glyphs", "use-OTF-feature", "use-preset-size"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.InlineText_SmallCapsPresetMethod, in_attributeValue, "use-preset-size", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for smallcaps-preset-method: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeInlineText_SmallCapsPresetSize(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_SmallCapsPresetSize, in_attributeValue, "60.0%", true, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for smallcaps-preset-size-x: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeInlineText_SubscriptPresetMethod(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"typographic-preferred", "use-font-glyphs", "use-OTF-feature", "use-preset-size-and-shift", "use-preset-shift"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.InlineText_SubscriptPresetMethod, in_attributeValue, "use-preset-size-and-shift", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for subscript-preset-method: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeInlineText_SubscriptPresetSize(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_SubscriptPresetSize, in_attributeValue, "60.0%", true, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for subscript-preset-size-x: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeInlineText_SubscriptPresetShift(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_SubscriptPresetShift, in_attributeValue, "-15.0%", true, new String[0], "pt", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for subscript-preset-shift-x: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeInlineText_SuperscriptPresetMethod(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"typographic-preferred", "use-font-glyphs", "use-OTF-feature", "use-preset-size-and-shift", "use-preset-shift"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.InlineText_SuperscriptPresetMethod, in_attributeValue, "use-preset-size-and-shift", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for superscript-preset-method: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeInlineText_SuperscriptPresetSize(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_SuperscriptPresetSize, in_attributeValue, "60.0%", true, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for superscript-preset-size-x: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeInlineText_SuperscriptPresetShift(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_SuperscriptPresetShift, in_attributeValue, "31.0%", true, new String[0], "pt", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for superscript-preset-shift-x: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLeaderLength_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_LeaderLengthMinimum, AFMLAttribute__TypeId.InlineText_LeaderLengthOptimum, AFMLAttribute__TypeId.InlineText_LeaderLengthMaximum, in_attributeValue, "0.0pt", "12.0pt", "100.0%", true, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for leader-length-shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLeaderLengthMaximum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_LeaderLengthMaximum, in_attributeValue, "100%", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for leader-length.maximum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLeaderLengthMinimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_LeaderLengthMinimum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for leader-length.minimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLeaderLengthOptimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_LeaderLengthOptimum, in_attributeValue, "12.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for leader-length.optimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationLetterspacing_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplySpaceAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_JustificationLetterspacingMinimum, AFMLAttribute__TypeId.InlineText_JustificationLetterspacingOptimum, AFMLAttribute__TypeId.InlineText_JustificationLetterspacingMaximum, AFMLAttribute__TypeId.InlineText_JustificationLetterspacingPrecedence, AFMLAttribute__TypeId.InlineText_JustificationLetterspacingConditionality, in_attributeValue, "-5.0%", "0.0pt", "50.0%", "force", "discard", true, new String[0], "pt", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for letterspacing shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationLetterspacingConditionality(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "discard";
        }
        if (in_attributeValue.equalsIgnoreCase("retain") || in_attributeValue.equalsIgnoreCase("discard")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_JustificationLetterspacingConditionality, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for letterspacing.conditionality: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationLetterspacingMaximum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_JustificationLetterspacingMaximum, in_attributeValue, "50%", true, new String[0], "pt", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for wordspacing.maximum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationLetterspacingMinimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_JustificationLetterspacingMinimum, in_attributeValue, "200%", true, new String[0], "pt", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for letterspacing.minimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationLetterspacingOptimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_JustificationLetterspacingOptimum, in_attributeValue, "-5.0%", true, new String[0], "pt", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for letterspacing.optimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationLetterspacingPrecedence(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "force";
        }
        if (in_attributeValue.equalsIgnoreCase("force")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_JustificationLetterspacingPrecedence, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue)) {
            AFMLAttribute_Number var_AFMLMinimumAttribute = new AFMLAttribute_Number(AFMLAttribute__TypeId.InlineText_JustificationLetterspacingPrecedence, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLMinimumAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_JustificationLetterspacingPrecedence, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for letterspacing.precedence: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationStrategy(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "wordspace-preferred-unlimited";
        }
        if (in_attributeValue.equalsIgnoreCase("letterspace-only") || in_attributeValue.equalsIgnoreCase("letterspace-only-unlimited") || in_attributeValue.equalsIgnoreCase("letterspace-preferred") || in_attributeValue.equalsIgnoreCase("letterspace-preferred-unlimited") || in_attributeValue.equalsIgnoreCase("wordspace-only") || in_attributeValue.equalsIgnoreCase("wordspace-only-unlimited") || in_attributeValue.equalsIgnoreCase("wordspace-preferred") || in_attributeValue.equalsIgnoreCase("wordspace-preferred-unlimited") || in_attributeValue.equalsIgnoreCase("proportional") || in_attributeValue.equalsIgnoreCase("proportional-unlimited") || in_attributeValue.equalsIgnoreCase("letterspace-preferred") || in_attributeValue.equalsIgnoreCase("letterspace-preferred")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_JustificationStrategy, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for JustificationStrategy: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationWordspacing_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplySpaceAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_JustificationWordspacingMinimum, AFMLAttribute__TypeId.InlineText_JustificationWordspacingOptimum, AFMLAttribute__TypeId.InlineText_JustificationWordspacingMaximum, AFMLAttribute__TypeId.InlineText_JustificationWordspacingPrecedence, AFMLAttribute__TypeId.InlineText_JustificationWordspacingConditionality, in_attributeValue, "50.0%", "100.0%", "200.0%", "force", "discard", true, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for letterspacing shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationWordspacingConditionality(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "discard";
        }
        if (in_attributeValue.equalsIgnoreCase("retain") || in_attributeValue.equalsIgnoreCase("discard")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_JustificationWordspacingConditionality, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for wordspacing.conditionality: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationWordspacingMaximum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_JustificationWordspacingMaximum, in_attributeValue, "200%", true, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for wordspacing.maximum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationWordspacingMinimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_JustificationWordspacingMinimum, in_attributeValue, "200%", true, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for wordspacing.minimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationWordspacingOptimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_JustificationWordspacingOptimum, in_attributeValue, "200%", true, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for wordspacing.optimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeJustificationWordspacingPrecedence(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "force";
        }
        if (in_attributeValue.equalsIgnoreCase("force")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_JustificationWordspacingPrecedence, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue)) {
            AFMLAttribute_Number var_AFMLMinimumAttribute = new AFMLAttribute_Number(AFMLAttribute__TypeId.InlineText_JustificationWordspacingPrecedence, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLMinimumAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_JustificationWordspacingPrecedence, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for wordspacing.precedence: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLineHeight_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-") || in_attributeValue.equalsIgnoreCase("normal") || in_attributeValue.equalsIgnoreCase("auto")) {
            in_attributeValue = "1.2em";
        }
        if (!this.internalApplySpaceAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.InlineText_LineHeightMinimum, AFMLAttribute__TypeId.InlineText_LineHeightOptimum, AFMLAttribute__TypeId.InlineText_LineHeightMaximum, AFMLAttribute__TypeId.InlineText_LineHeightPrecedence, AFMLAttribute__TypeId.InlineText_LineHeightConditionality, in_attributeValue, "1.2em", "1.2em", "1.2em", "force", "retain", true, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for line-height shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLineHeightConditionality(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "retain";
        }
        if (in_attributeValue.equalsIgnoreCase("retain") || in_attributeValue.equalsIgnoreCase("discard")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LineHeightConditionality, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for line-height.conditionality: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLineHeightMaximum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-") || in_attributeValue.equalsIgnoreCase("normal")) {
            in_attributeValue = "1.2em";
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue)) {
            AFMLAttribute_Length var_AFMLAttribute = new AFMLAttribute_Length(AFMLAttribute__TypeId.InlineText_LineHeightMaximum, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeEMLength(in_attributeValue)) {
            AFMLAttribute_EMLength var_AFMLAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_LineHeightMaximum, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributePercentage(in_attributeValue)) {
            AFMLAttribute_Percentage var_AFMLAttribute = new AFMLAttribute_Percentage(AFMLAttribute__TypeId.InlineText_LineHeightMaximum, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for line-height.maximum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLineHeightMinimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-") || in_attributeValue.equalsIgnoreCase("normal")) {
            in_attributeValue = "1.2em";
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue)) {
            AFMLAttribute_Length var_AFMLAttribute = new AFMLAttribute_Length(AFMLAttribute__TypeId.InlineText_LineHeightMinimum, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeEMLength(in_attributeValue)) {
            AFMLAttribute_EMLength var_AFMLAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_LineHeightMinimum, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributePercentage(in_attributeValue)) {
            AFMLAttribute_Percentage var_AFMLAttribute = new AFMLAttribute_Percentage(AFMLAttribute__TypeId.InlineText_LineHeightMinimum, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for line-height.minimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLineHeightOptimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-") || in_attributeValue.equalsIgnoreCase("normal")) {
            in_attributeValue = "1.2em";
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue)) {
            AFMLAttribute_Length var_AFMLAttribute = new AFMLAttribute_Length(AFMLAttribute__TypeId.InlineText_LineHeightOptimum, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeEMLength(in_attributeValue)) {
            AFMLAttribute_EMLength var_AFMLAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_LineHeightOptimum, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributePercentage(in_attributeValue)) {
            AFMLAttribute_Percentage var_AFMLAttribute = new AFMLAttribute_Percentage(AFMLAttribute__TypeId.InlineText_LineHeightOptimum, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for line-height.optimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLineHeightPrecedence(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "force";
        }
        if (in_attributeValue.equalsIgnoreCase("force")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LineHeightPrecedence, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue)) {
            AFMLAttribute_Number var_AFMLMinimumAttribute = new AFMLAttribute_Number(AFMLAttribute__TypeId.InlineText_LineHeightPrecedence, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLMinimumAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_LineHeightPrecedence, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for line-height.precedence: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLineHeightPrecedenceOverride(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "use-ascent-plus-half-leading";
        }
        if (in_attributeValue.equalsIgnoreCase("use-ascent-plus-half-leading")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LineHeightPrecedenceOverride, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("use-font-size")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LineHeightPrecedenceOverride, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for line-height-precedence-override: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeLocale_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        StringTokenizer var_langComponents = new StringTokenizer(in_attributeValue, "-_");
        int var_numComponents = var_langComponents.countTokens();
        String var_variantsList = "";
        String var_keywordsList = "";
        this.processAttributeLocaleLanguageInternal("auto");
        this.processAttributeLocaleCountryInternal("auto");
        this.processAttributeLocaleScriptInternal("auto");
        this.processAttributeLocaleVariantInternal("auto");
        this.processAttributeLocaleKeywordsInternal("auto");
        if (var_numComponents > 0) {
            String var_languageIn = var_langComponents.nextToken();
            --var_numComponents;
            this.processAttributeLocaleLanguageInternal(var_languageIn);
        }
        while (var_numComponents > 0) {
            String var_tokenIn = var_langComponents.nextToken();
            --var_numComponents;
            if (var_tokenIn.length() == 2 && !Character.isDigit(var_tokenIn.charAt(0)) && !Character.isDigit(var_tokenIn.charAt(1)) || var_tokenIn.length() == 3 && !Character.isDigit(var_tokenIn.charAt(0)) && !Character.isDigit(var_tokenIn.charAt(1)) && !Character.isDigit(var_tokenIn.charAt(2))) {
                this.processAttributeLocaleCountryInternal(var_tokenIn);
                continue;
            }
            if (var_tokenIn.length() == 3 && !Character.isDigit(var_tokenIn.charAt(0)) && !Character.isDigit(var_tokenIn.charAt(1)) && !Character.isDigit(var_tokenIn.charAt(2))) continue;
            if (!(var_tokenIn.length() != 4 || Character.isDigit(var_tokenIn.charAt(0)) || Character.isDigit(var_tokenIn.charAt(1)) || Character.isDigit(var_tokenIn.charAt(2)) || Character.isDigit(var_tokenIn.charAt(3)))) {
                this.processAttributeLocaleScriptInternal(var_tokenIn);
                continue;
            }
            if (var_tokenIn.length() >= 4 && Character.isDigit(var_tokenIn.charAt(0)) || var_tokenIn.length() >= 5 && !Character.isDigit(var_tokenIn.charAt(0))) {
                if (!var_variantsList.equalsIgnoreCase("")) {
                    var_variantsList = var_variantsList + "-";
                }
                var_variantsList = var_variantsList + var_tokenIn;
                continue;
            }
            if ((var_tokenIn.length() != 1 || Character.isDigit(var_tokenIn.charAt(0))) && var_tokenIn.charAt(0) != '@') continue;
            boolean var_moreKeywords = true;
            while (var_moreKeywords) {
                var_keywordsList = var_keywordsList + var_tokenIn;
                if (var_numComponents > 0) {
                    var_tokenIn = "-" + var_langComponents.nextToken();
                    --var_numComponents;
                    continue;
                }
                var_moreKeywords = false;
            }
            var_numComponents = 0;
        }
        if (!var_variantsList.equalsIgnoreCase("")) {
            this.processAttributeLocaleVariantInternal(var_variantsList);
        }
        if (!var_keywordsList.equalsIgnoreCase("")) {
            this.processAttributeLocaleKeywordsInternal(var_keywordsList);
        }
        this.processAttributeLocaleCanonical();
    }

    public void processAttributeLocaleCanonical() throws AFMLExceptionInvalidParameter {
        String var_language = this.getAttributeFromStackTop(AFMLAttribute__TypeId.InlineText_LocaleLanguage).toString();
        String var_script = this.getAttributeFromStackTop(AFMLAttribute__TypeId.InlineText_LocaleScript).toString();
        String var_country = this.getAttributeFromStackTop(AFMLAttribute__TypeId.InlineText_LocaleCountry).toString();
        String var_variant = this.getAttributeFromStackTop(AFMLAttribute__TypeId.InlineText_LocaleVariant).toString();
        String var_keywords = this.getAttributeFromStackTop(AFMLAttribute__TypeId.InlineText_LocaleKeywords).toString();
        boolean var_scriptWasReset = false;
        boolean var_countryWasReset = false;
        if (var_language.equalsIgnoreCase("az")) {
            if (var_script.equalsIgnoreCase("-unset-") || var_script.equalsIgnoreCase("auto")) {
                if (!var_country.equalsIgnoreCase("-unset-") && !var_country.equalsIgnoreCase("auto")) {
                    if (var_country.equalsIgnoreCase("AF") || var_country.equalsIgnoreCase("IQ") || var_country.equalsIgnoreCase("IR") || var_country.equalsIgnoreCase("SY")) {
                        var_script = "Arab";
                        var_scriptWasReset = true;
                    } else if (var_country.equalsIgnoreCase("AZ")) {
                        var_script = "Latn";
                        var_scriptWasReset = true;
                    } else if (!var_country.equalsIgnoreCase("")) {
                        var_script = "Latn";
                        var_scriptWasReset = true;
                    }
                }
            } else if (var_country.equalsIgnoreCase("-unset-") || var_country.equalsIgnoreCase("auto")) {
                if (var_script.equalsIgnoreCase("Arab")) {
                    var_country = "IR";
                    var_countryWasReset = true;
                } else if (var_script.equalsIgnoreCase("Latn")) {
                    var_country = "AZ";
                    var_countryWasReset = true;
                } else if (var_script.equalsIgnoreCase("Cyrl") || !var_script.equalsIgnoreCase("")) {
                    var_country = "AZ";
                    var_countryWasReset = true;
                }
            }
        } else if (var_language.equalsIgnoreCase("be")) {
            if (var_script.equalsIgnoreCase("-unset-") || var_script.equalsIgnoreCase("auto")) {
                var_script = "Cyrl";
                var_scriptWasReset = true;
            }
            if (var_country.equalsIgnoreCase("-unset-") || var_country.equalsIgnoreCase("auto")) {
                var_country = "BY";
                var_countryWasReset = true;
            }
        } else if (var_language.equalsIgnoreCase("bs")) {
            if (var_script.equalsIgnoreCase("-unset-") || var_script.equalsIgnoreCase("auto")) {
                var_script = "Latn";
                var_scriptWasReset = true;
            }
            if (var_country.equalsIgnoreCase("-unset-") || var_country.equalsIgnoreCase("auto")) {
                var_country = "BA";
                var_countryWasReset = true;
            }
        } else if (var_language.equalsIgnoreCase("mn")) {
            if (var_script.equalsIgnoreCase("-unset-") || var_script.equalsIgnoreCase("auto")) {
                var_script = "Cyrl";
                var_scriptWasReset = true;
            }
            if (var_country.equalsIgnoreCase("-unset-") || var_country.equalsIgnoreCase("auto")) {
                var_country = "MN";
                var_countryWasReset = true;
            }
        } else if (var_language.equalsIgnoreCase("sh")) {
            if (var_script.equalsIgnoreCase("-unset-") || var_script.equalsIgnoreCase("auto")) {
                var_script = "Latn";
                var_scriptWasReset = true;
            }
            if (var_country.equalsIgnoreCase("-unset-") || var_country.equalsIgnoreCase("auto")) {
                var_country = "YU";
                var_countryWasReset = true;
            }
        } else if (var_language.equalsIgnoreCase("sr")) {
            if (var_script.equalsIgnoreCase("-unset-") || var_script.equalsIgnoreCase("auto")) {
                var_script = "Cyrl";
                var_scriptWasReset = true;
            }
            if (var_country.equalsIgnoreCase("-unset-") || var_country.equalsIgnoreCase("auto")) {
                var_country = "RS";
                var_countryWasReset = true;
            }
        } else if (!var_language.equalsIgnoreCase("tg")) {
            if (var_language.equalsIgnoreCase("uz")) {
                if (var_script.equalsIgnoreCase("-unset-") || var_script.equalsIgnoreCase("auto")) {
                    if (!var_country.equalsIgnoreCase("-unset-") && !var_country.equalsIgnoreCase("auto")) {
                        if (var_country.equalsIgnoreCase("AF")) {
                            var_script = "Arab";
                            var_scriptWasReset = true;
                        } else if (var_country.equalsIgnoreCase("CN") || var_country.equalsIgnoreCase("TM") || var_country.equalsIgnoreCase("TR")) {
                            var_script = "Latn";
                            var_scriptWasReset = true;
                        } else if (var_country.equalsIgnoreCase("UZ") || !var_country.equalsIgnoreCase("")) {
                            var_script = "Cyrl";
                            var_scriptWasReset = true;
                        }
                    }
                } else if (var_country.equalsIgnoreCase("-unset-") || var_country.equalsIgnoreCase("auto")) {
                    if (var_script.equalsIgnoreCase("Arab")) {
                        var_country = "AF";
                        var_countryWasReset = true;
                    } else if (var_script.equalsIgnoreCase("Latn")) {
                        var_country = "TM";
                        var_countryWasReset = true;
                    } else if (var_script.equalsIgnoreCase("Cyrl") || !var_script.equalsIgnoreCase("")) {
                        var_country = "UZ";
                        var_countryWasReset = true;
                    }
                }
            } else if (var_language.equalsIgnoreCase("zh")) {
                if (var_script.equalsIgnoreCase("-unset-") || var_script.equalsIgnoreCase("auto")) {
                    if (!var_country.equalsIgnoreCase("-unset-") && !var_country.equalsIgnoreCase("auto")) {
                        if (var_country.equalsIgnoreCase("TW") || var_country.equalsIgnoreCase("HK") || var_country.equalsIgnoreCase("MO")) {
                            var_script = "Hant";
                            var_scriptWasReset = true;
                        } else if (var_country.equalsIgnoreCase("CN") || var_country.equalsIgnoreCase("SG")) {
                            var_script = "Hans";
                            var_scriptWasReset = true;
                        }
                    }
                } else if (var_country.equalsIgnoreCase("-unset-") || var_country.equalsIgnoreCase("auto")) {
                    if (var_script.equalsIgnoreCase("Hant")) {
                        var_country = "HK";
                        var_countryWasReset = true;
                    } else if (var_script.equalsIgnoreCase("Hans")) {
                        var_country = "CN";
                        var_countryWasReset = true;
                    }
                }
            }
        }
        if (var_scriptWasReset) {
            // empty if block
        }
        if (var_countryWasReset) {
            // empty if block
        }
        StringBuffer var_canonical = new StringBuffer();
        if (var_language.length() >= 2 && var_language.length() <= 3) {
            var_canonical.append(var_language);
        }
        if (var_script.length() == 4 && !var_script.equalsIgnoreCase("auto") && !var_script.equalsIgnoreCase("none")) {
            if (var_canonical.length() != 0) {
                var_canonical.append('_');
            }
            var_canonical.append(var_script);
        }
        if (var_country.length() >= 2 && var_country.length() <= 3) {
            if (var_canonical.length() != 0) {
                var_canonical.append('_');
            }
            var_canonical.append(var_country);
        }
        if (!(var_variant.length() < 4 || var_variant.equalsIgnoreCase("-unset-") || var_variant.equalsIgnoreCase("auto") || var_variant.equalsIgnoreCase("none"))) {
            if (var_canonical.length() != 0) {
                var_canonical.append('_');
            }
            var_canonical.append(var_variant);
        }
        if (!(var_keywords.length() < 4 || var_keywords.equalsIgnoreCase("-unset-") || var_keywords.equalsIgnoreCase("auto") || var_keywords.equalsIgnoreCase("none"))) {
            if (var_canonical.length() != 0) {
                var_canonical.append('_');
            }
            var_canonical.append(var_keywords);
        }
        if (var_canonical.length() == 0) {
            var_canonical.append("en_US");
        }
        AFMLAttribute_Keyword var_AFMLLocaleCanonicalAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LocaleCanonical, var_canonical.toString(), true);
        this.setAttributeOnStackTop(var_AFMLLocaleCanonicalAttribute);
    }

    public void processAttributeLocaleCountry(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        this.processAttributeLocaleCountryInternal(in_attributeValue);
        this.processAttributeLocaleCanonical();
    }

    private void processAttributeLocaleCountryInternal(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String var_countryOut = "-unset-";
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "auto";
        }
        if (in_attributeValue.equalsIgnoreCase("UK")) {
            var_countryOut = "GB";
        }
        if (in_attributeValue.equalsIgnoreCase("-unset-")) {
            var_countryOut = "-unset-";
        } else if (in_attributeValue.equalsIgnoreCase("auto")) {
            var_countryOut = "auto";
        } else if (in_attributeValue.equalsIgnoreCase("none")) {
            var_countryOut = "none";
        } else if (in_attributeValue.length() >= 2 && in_attributeValue.length() <= 3) {
            var_countryOut = in_attributeValue.toUpperCase();
        } else {
            var_countryOut = "auto";
            this.processAttributeLocaleScript(in_attributeValue);
        }
        AFMLAttribute_Keyword var_AFMLCountryAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LocaleCountry, var_countryOut, true);
        this.setAttributeOnStackTop(var_AFMLCountryAttribute);
    }

    public void processAttributeLocaleKeywords(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        this.processAttributeLocaleKeywordsInternal(in_attributeValue);
        this.processAttributeLocaleCanonical();
    }

    private void processAttributeLocaleKeywordsInternal(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "auto";
        }
        if (!(in_attributeValue.equalsIgnoreCase("-unset-") || in_attributeValue.equalsIgnoreCase("auto") || in_attributeValue.equalsIgnoreCase("none") || in_attributeValue.length() < 4)) {
            in_attributeValue = in_attributeValue.toUpperCase();
        }
        AFMLAttribute_Keyword var_AFMLScriptAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LocaleKeywords, in_attributeValue, true);
        this.setAttributeOnStackTop(var_AFMLScriptAttribute);
    }

    public void processAttributeLocaleLanguage(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        this.processAttributeLocaleLanguageInternal(in_attributeValue);
        this.processAttributeLocaleCanonical();
    }

    private void processAttributeLocaleLanguageInternal(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String var_languageOut = "-unset-";
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "auto";
        }
        var_languageOut = in_attributeValue.equalsIgnoreCase("-unset-") ? "-unset-" : (in_attributeValue.equalsIgnoreCase("auto") ? "auto" : (in_attributeValue.equalsIgnoreCase("none") ? "none" : (in_attributeValue.length() >= 2 && in_attributeValue.length() <= 3 ? in_attributeValue.toLowerCase() : "auto")));
        AFMLAttribute_Keyword var_AFMLLanguageAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LocaleLanguage, var_languageOut, true);
        this.setAttributeOnStackTop(var_AFMLLanguageAttribute);
    }

    public void processAttributeLocaleScript(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        this.processAttributeLocaleScriptInternal(in_attributeValue);
        this.processAttributeLocaleCanonical();
    }

    private void processAttributeLocaleScriptInternal(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String var_scriptOut = "-unset-";
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "auto";
        }
        if (in_attributeValue.equalsIgnoreCase("-unset-")) {
            var_scriptOut = "-unset-";
        } else if (in_attributeValue.equalsIgnoreCase("auto")) {
            var_scriptOut = "auto";
        } else if (in_attributeValue.equalsIgnoreCase("none")) {
            var_scriptOut = "none";
        } else if (in_attributeValue.length() == 4) {
            var_scriptOut = in_attributeValue.substring(0, 1).toUpperCase() + in_attributeValue.substring(1).toLowerCase();
        } else {
            var_scriptOut = "auto";
            this.processAttributeLocaleVariant(in_attributeValue);
        }
        AFMLAttribute_Keyword var_AFMLScriptAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LocaleScript, var_scriptOut, true);
        this.setAttributeOnStackTop(var_AFMLScriptAttribute);
    }

    public void processAttributeLocaleVariant(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        this.processAttributeLocaleVariantInternal(in_attributeValue);
        this.processAttributeLocaleCanonical();
    }

    public void processAttributeLocaleVariantInternal(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "auto";
        }
        if (!(in_attributeValue.equalsIgnoreCase("-unset-") || in_attributeValue.equalsIgnoreCase("auto") || in_attributeValue.equalsIgnoreCase("none") || in_attributeValue.length() < 4)) {
            in_attributeValue = in_attributeValue.toLowerCase();
        }
        AFMLAttribute_Keyword var_AFMLScriptAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_LocaleVariant, in_attributeValue, true);
        this.setAttributeOnStackTop(var_AFMLScriptAttribute);
    }

    public void processAttributeMargin_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "0.0pt";
        }
        StringTokenizer var_shorthand = new StringTokenizer(in_attributeValue, " ,");
        int i = 1;
        while (var_shorthand.hasMoreTokens()) {
            String var_Token = var_shorthand.nextToken();
            switch (i) {
                case 1: {
                    this.processAttributeMarginBottom(var_Token);
                    this.processAttributeMarginLeft(var_Token);
                    this.processAttributeMarginRight(var_Token);
                    this.processAttributeMarginTop(var_Token);
                    break;
                }
                case 2: {
                    this.processAttributeMarginLeft(var_Token);
                    this.processAttributeMarginRight(var_Token);
                    break;
                }
                case 3: {
                    this.processAttributeMarginBottom(var_Token);
                    break;
                }
                case 4: {
                    this.processAttributeMarginLeft(var_Token);
                }
            }
            ++i;
        }
    }

    public void processAttributeMarginBottom(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_MarginAfterMinimum, AFMLAttribute__TypeId.Area_MarginAfterOptimum, AFMLAttribute__TypeId.Area_MarginAfterMaximum, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for margin-bottom, margin-after: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeMarginLeft(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_MarginStartMinimum, AFMLAttribute__TypeId.Area_MarginStartOptimum, AFMLAttribute__TypeId.Area_MarginStartMaximum, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for margin-left, margin-start: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeMarginRight(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_MarginEndMinimum, AFMLAttribute__TypeId.Area_MarginEndOptimum, AFMLAttribute__TypeId.Area_MarginEndMaximum, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for margin-right, margin-end: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeMarginTop(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_MarginBeforeMinimum, AFMLAttribute__TypeId.Area_MarginBeforeOptimum, AFMLAttribute__TypeId.Area_MarginBeforeMaximum, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for margin-top, margin-before: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeMasterName(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!in_attributeValue.equalsIgnoreCase("-default-") && !this.internalApplyBasicAttributeFromName(AFMLAttribute__TypeId.Binding_MasterName, in_attributeValue, "-required-", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for master-name: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeMasterNameReference(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!in_attributeValue.equalsIgnoreCase("-default-") && !this.internalApplyBasicAttributeFromName(AFMLAttribute__TypeId.Binding_MasterNameReference, in_attributeValue, "-required-", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for master-name-reference: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeOverflow(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"auto", "visible", "hidden", "scroll", "error-if-overflow", "repeat", "shrink-to-fit", "shrink-or-grow-to-fit"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Layout_Overflow, in_attributeValue.toLowerCase(), "auto", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for overflow: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeCollapsibleTrailingSpaces(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"true", "false"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Collapsible_Trailing_Spaces, in_attributeValue.toLowerCase(), "true", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for collapsibleTrailingSpaces: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeDeleteTrailingSpaces(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"true", "false"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Delete_Trailing_Spaces, in_attributeValue.toLowerCase(), "false", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for deleteTrailingSpaces: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeIncludeTrailingSpacesToComputeFontSize(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"true", "false"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Include_Trailing_Spaces_To_Compute_Font_Size, in_attributeValue.toLowerCase(), "false", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for includeTrailingSpacesToComputeFontSize: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributePadding_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "0.0pt";
        }
        StringTokenizer var_shorthand = new StringTokenizer(in_attributeValue, " ,");
        int i = 1;
        while (var_shorthand.hasMoreTokens()) {
            String var_Token = var_shorthand.nextToken();
            switch (i) {
                case 1: {
                    this.processAttributePaddingAfter(var_Token);
                    this.processAttributePaddingStart(var_Token);
                    this.processAttributePaddingEnd(var_Token);
                    this.processAttributePaddingBefore(var_Token);
                    break;
                }
                case 2: {
                    this.processAttributePaddingStart(var_Token);
                    this.processAttributePaddingEnd(var_Token);
                    break;
                }
                case 3: {
                    this.processAttributePaddingAfter(var_Token);
                    break;
                }
                case 4: {
                    this.processAttributePaddingStart(var_Token);
                }
            }
            ++i;
        }
    }

    public void processAttributePaddingAfter(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_PaddingAfterMinimum, AFMLAttribute__TypeId.Area_PaddingAfterOptimum, AFMLAttribute__TypeId.Area_PaddingAfterMaximum, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for padding-after: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributePaddingBefore(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_PaddingBeforeMinimum, AFMLAttribute__TypeId.Area_PaddingBeforeOptimum, AFMLAttribute__TypeId.Area_PaddingBeforeMaximum, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for padding-before: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributePaddingEnd(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_PaddingEndMinimum, AFMLAttribute__TypeId.Area_PaddingEndOptimum, AFMLAttribute__TypeId.Area_PaddingEndMaximum, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for padding-end: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributePaddingStart(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyRangeAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_PaddingStartMinimum, AFMLAttribute__TypeId.Area_PaddingStartOptimum, AFMLAttribute__TypeId.Area_PaddingStartMaximum, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for padding-start: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributePageOrdinalWithinSequence(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "any";
        }
        if (in_attributeValue.equalsIgnoreCase("any") || in_attributeValue.equalsIgnoreCase("all")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Binding_PageOrdinalWithinSequence, "any", false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.Binding_PageOrdinalWithinSequence, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for page-ordinal-within-sequence: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributePropertySetName(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!in_attributeValue.equalsIgnoreCase("-default-") && !this.internalApplyBasicAttributeFromName(AFMLAttribute__TypeId.Binding_PropertySetName, in_attributeValue, "-required-", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for property-set-name: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributePropertySetNameReference(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!in_attributeValue.equalsIgnoreCase("-default-") && !this.internalApplyBasicAttributeFromName(AFMLAttribute__TypeId.Binding_PropertySetNameReference, in_attributeValue, "-required-", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for property-set-name-reference: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeReferenceOrientation(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"0", "90", "180", "270"};
        if (!in_attributeValue.equalsIgnoreCase("-default-")) {
            double var_angleDouble = Double.parseDouble(in_attributeValue);
            int var_angle = (int)Math.round(var_angleDouble);
            if ((double)var_angle != var_angleDouble) {
                AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for reference-orientation: \"" + in_attributeValue + "\" (Must be integer multiple of 90)");
            }
            if (var_angle < 0 || var_angle >= 360) {
                while (var_angle < 0) {
                    var_angle += 360;
                }
                while (var_angle >= 360) {
                    var_angle -= 360;
                }
                in_attributeValue = Integer.toString(var_angle);
            }
        }
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Layout_ReferenceOrientation, in_attributeValue.toLowerCase(), "0", false, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for reference-orientation: \"" + in_attributeValue + "\" (Must be integer multiple of 90)");
        }
    }

    public void processAttributeRegionName(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!in_attributeValue.equalsIgnoreCase("-default-") && !this.internalApplyBasicAttributeFromName(AFMLAttribute__TypeId.Binding_RegionName, in_attributeValue, "-required-", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for region-name: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeRegionNameReference(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!in_attributeValue.equalsIgnoreCase("-default-") && !this.internalApplyBasicAttributeFromName(AFMLAttribute__TypeId.Binding_RegionNameReference, in_attributeValue, "-required-", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for region-name-reference: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeRelativePositionDXOffset(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "0.0pt";
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue)) {
            AFMLAttribute_Length var_AFMLDXOffsetAttribute = new AFMLAttribute_Length(AFMLAttribute__TypeId.Layout_RelativePositionDXOffset, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLDXOffsetAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for relative-position-dx: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeRelativePositionDYOffset(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "0.0pt";
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue)) {
            AFMLAttribute_Length var_AFMLDYOffsetAttribute = new AFMLAttribute_Length(AFMLAttribute__TypeId.Layout_RelativePositionDYOffset, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLDYOffsetAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for relative-position-dy: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSelector_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        this.processAttributeSelectorBlankOrNotBlank("-default-");
        this.processAttributeSelectorMaximumRepeats("-default-");
        this.processAttributeSelectorMinimumRepeats("-default-");
        this.processAttributeSelectorOddOrEven("-default-");
        this.processAttributeSelectorOddOrEvenStrategy("-default-");
        this.processAttributeSelectorPagePosition("-default-");
        this.processAttributeSelectorPagePositionExplicit("-default-");
        this.processAttributeSelectorPagePositionStrategy("-default-");
        if (in_attributeValue.equalsIgnoreCase("only") || in_attributeValue.equalsIgnoreCase("only-any") || in_attributeValue.equalsIgnoreCase("onlyAny")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("any");
            this.processAttributeSelectorPagePosition("only");
        } else if (in_attributeValue.equalsIgnoreCase("first") || in_attributeValue.equalsIgnoreCase("first-any") || in_attributeValue.equalsIgnoreCase("firstAny")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("any");
            this.processAttributeSelectorPagePosition("first");
        } else if (in_attributeValue.equalsIgnoreCase("last") || in_attributeValue.equalsIgnoreCase("last-any") || in_attributeValue.equalsIgnoreCase("lastAny")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("any");
            this.processAttributeSelectorPagePosition("last");
        } else if (in_attributeValue.equalsIgnoreCase("rest") || in_attributeValue.equalsIgnoreCase("rest-any") || in_attributeValue.equalsIgnoreCase("restAny")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("any");
            this.processAttributeSelectorPagePosition("rest");
        } else if (in_attributeValue.equalsIgnoreCase("odd") || in_attributeValue.equalsIgnoreCase("odd-any") || in_attributeValue.equalsIgnoreCase("oddAny")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("odd");
            this.processAttributeSelectorPagePosition("any");
        } else if (in_attributeValue.equalsIgnoreCase("even") || in_attributeValue.equalsIgnoreCase("even-any") || in_attributeValue.equalsIgnoreCase("evenAny")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("even");
            this.processAttributeSelectorPagePosition("any");
        } else if (in_attributeValue.equalsIgnoreCase("blank") || in_attributeValue.equalsIgnoreCase("blank-any") || in_attributeValue.equalsIgnoreCase("blankAny")) {
            this.processAttributeSelectorBlankOrNotBlank("blank");
            this.processAttributeSelectorOddOrEven("any");
            this.processAttributeSelectorPagePosition("any");
        } else if (in_attributeValue.equalsIgnoreCase("only-odd") || in_attributeValue.equalsIgnoreCase("onlyOdd")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("odd");
            this.processAttributeSelectorPagePosition("only");
        } else if (in_attributeValue.equalsIgnoreCase("first-odd") || in_attributeValue.equalsIgnoreCase("firstOdd")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("odd");
            this.processAttributeSelectorPagePosition("first");
        } else if (in_attributeValue.equalsIgnoreCase("last-any") || in_attributeValue.equalsIgnoreCase("lastOdd")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("odd");
            this.processAttributeSelectorPagePosition("last");
        } else if (in_attributeValue.equalsIgnoreCase("rest-any") || in_attributeValue.equalsIgnoreCase("restOdd")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("odd");
            this.processAttributeSelectorPagePosition("rest");
        } else if (in_attributeValue.equalsIgnoreCase("blank-odd") || in_attributeValue.equalsIgnoreCase("blankOdd")) {
            this.processAttributeSelectorBlankOrNotBlank("blank");
            this.processAttributeSelectorOddOrEven("odd");
            this.processAttributeSelectorPagePosition("any");
        } else if (in_attributeValue.equalsIgnoreCase("only-even") || in_attributeValue.equalsIgnoreCase("onlyEven")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("even");
            this.processAttributeSelectorPagePosition("only");
        } else if (in_attributeValue.equalsIgnoreCase("first-even") || in_attributeValue.equalsIgnoreCase("firstEven")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("even");
            this.processAttributeSelectorPagePosition("first");
        } else if (in_attributeValue.equalsIgnoreCase("last-even") || in_attributeValue.equalsIgnoreCase("lastEven")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("even");
            this.processAttributeSelectorPagePosition("last");
        } else if (in_attributeValue.equalsIgnoreCase("rest-even") || in_attributeValue.equalsIgnoreCase("restEven")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("even");
            this.processAttributeSelectorPagePosition("rest");
        } else if (in_attributeValue.equalsIgnoreCase("blank-even") || in_attributeValue.equalsIgnoreCase("blankEven")) {
            this.processAttributeSelectorBlankOrNotBlank("blank");
            this.processAttributeSelectorOddOrEven("even");
            this.processAttributeSelectorPagePosition("any");
        } else if (in_attributeValue.equalsIgnoreCase("any")) {
            this.processAttributeSelectorBlankOrNotBlank("any");
            this.processAttributeSelectorOddOrEven("any");
            this.processAttributeSelectorPagePosition("any");
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for page-position-strategy: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSelectorBlankOrNotBlank(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"any", "blank", "not-blank"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Selector_BlankOrNotBlank, in_attributeValue.toLowerCase(), "any", false, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for blank-or-not-blank: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSelectorMaximumRepeats(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "no-limit";
        }
        if (in_attributeValue.equalsIgnoreCase("no-limit")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Selector_MaximumRepeats, in_attributeValue.toLowerCase(), false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.Selector_MaximumRepeats, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for maximum-repeats: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSelectorMinimumRepeats(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "0";
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.Selector_MinimumRepeats, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for minimum-repeats: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSelectorOddOrEven(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"any", "odd", "even"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Selector_OddOrEven, in_attributeValue.toLowerCase(), "any", false, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for odd-or-even: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSelectorOddOrEvenStrategy(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"use-page-number", "use-ordinal-position-within-document", "use-ordinal-position-within-page-sequence", "use-ordinal-position-within-selection-rule"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Selector_OddOrEvenStrategy, in_attributeValue.toLowerCase(), "use-ordinal-position-within-document", false, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for odd-or-even-strategy: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSelectorPagePosition(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"any", "only", "first", "last", "rest"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Selector_PagePosition, in_attributeValue.toLowerCase(), "any", false, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for page-position: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSelectorPagePositionExplicit(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "none";
        }
        if (in_attributeValue.equalsIgnoreCase("none") || in_attributeValue.equalsIgnoreCase("use-ordinal-position-within-page-sequence") || in_attributeValue.equalsIgnoreCase("use-ordinal-position-within-selection-rule")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Selector_PagePositionExplicit, in_attributeValue.toLowerCase(), false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.Selector_PagePositionExplicit, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for page-position-explicit: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSelectorPagePositionStrategy(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"use-page-number", "use-ordinal-position-within-document", "use-ordinal-position-within-page-sequence", "use-ordinal-position-within-selection-rule"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Selector_PagePositionStrategy, in_attributeValue.toLowerCase(), "use-ordinal-position-within-page-sequence", false, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for page-position-strategy: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSequenceForcePageCount(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"auto", "even", "odd", "end-on-even", "end-on-odd", "no-force"};
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "auto";
        }
        if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            if (!this.internalApplyBasicAttributeFromInteger(AFMLAttribute__TypeId.Sequence_ForcePageCount, in_attributeValue, "1", false, false)) {
                AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for force-page-count: \"" + in_attributeValue + "\"");
            }
        } else if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Sequence_ForcePageCount, in_attributeValue.toLowerCase(), "auto", false, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for force-page-count: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSequenceInitialPageNumber(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "auto";
        }
        if (in_attributeValue.equalsIgnoreCase("auto") || in_attributeValue.equalsIgnoreCase("auto-odd") || in_attributeValue.equalsIgnoreCase("auto-even")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Sequence_InitialPageNumber, in_attributeValue.toLowerCase(), false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.Sequence_InitialPageNumber, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for initial-page-number: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceAfter_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplySpaceAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceAfterMinimum, AFMLAttribute__TypeId.Area_SpaceAfterOptimum, AFMLAttribute__TypeId.Area_SpaceAfterMaximum, AFMLAttribute__TypeId.Area_SpaceAfterPrecedence, AFMLAttribute__TypeId.Area_SpaceAfterConditionality, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", "0", "discard", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-after shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceAfterConditionality(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "discard";
        }
        if (in_attributeValue.equalsIgnoreCase("retain") || in_attributeValue.equalsIgnoreCase("discard")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Area_SpaceAfterConditionality, in_attributeValue.toLowerCase(), false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-after.conditionality: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceAfterMaximum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceAfterMaximum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-after.maximum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceAfterMinimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceAfterMinimum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-after.minimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceAfterOptimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceAfterOptimum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-after.optimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceAfterPrecedence(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "0.0";
        }
        if (in_attributeValue.equalsIgnoreCase("force")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Area_SpaceAfterPrecedence, in_attributeValue.toLowerCase(), false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue)) {
            AFMLAttribute_Number var_AFMLMinimumAttribute = new AFMLAttribute_Number(AFMLAttribute__TypeId.Area_SpaceAfterPrecedence, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLMinimumAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.Area_SpaceAfterPrecedence, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-after.precedence: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceBefore_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplySpaceAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceBeforeMinimum, AFMLAttribute__TypeId.Area_SpaceBeforeOptimum, AFMLAttribute__TypeId.Area_SpaceBeforeMaximum, AFMLAttribute__TypeId.Area_SpaceBeforePrecedence, AFMLAttribute__TypeId.Area_SpaceBeforeConditionality, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", "0", "discard", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-before shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceBeforeConditionality(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "discard";
        }
        if (in_attributeValue.equalsIgnoreCase("retain") || in_attributeValue.equalsIgnoreCase("discard")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Area_SpaceBeforeConditionality, in_attributeValue.toLowerCase(), false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-before.conditionality: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceBeforeMaximum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceBeforeMaximum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-before.maximum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceBeforeMinimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceBeforeMinimum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-before.minimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceBeforeOptimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceBeforeOptimum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-before.optimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceBeforePrecedence(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "0.0";
        }
        if (in_attributeValue.equalsIgnoreCase("force")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Area_SpaceBeforePrecedence, in_attributeValue.toLowerCase(), false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue)) {
            AFMLAttribute_Number var_AFMLMinimumAttribute = new AFMLAttribute_Number(AFMLAttribute__TypeId.Area_SpaceBeforePrecedence, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLMinimumAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.Area_SpaceBeforePrecedence, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-before.precedence: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceEnd_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplySpaceAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceEndMinimum, AFMLAttribute__TypeId.Area_SpaceEndOptimum, AFMLAttribute__TypeId.Area_SpaceEndMaximum, AFMLAttribute__TypeId.Area_SpaceEndPrecedence, AFMLAttribute__TypeId.Area_SpaceEndConditionality, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", "0", "discard", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-end shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceEndConditionality(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "discard";
        }
        if (in_attributeValue.equalsIgnoreCase("retain") || in_attributeValue.equalsIgnoreCase("discard")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Area_SpaceEndConditionality, in_attributeValue.toLowerCase(), false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-end.conditionality: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceEndMaximum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceEndMaximum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-end.maximum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceEndMinimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceEndMinimum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-end.minimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceEndOptimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceEndOptimum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-end.optimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceEndPrecedence(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "0.0";
        }
        if (in_attributeValue.equalsIgnoreCase("force")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Area_SpaceEndPrecedence, in_attributeValue.toLowerCase(), false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue)) {
            AFMLAttribute_Number var_AFMLMinimumAttribute = new AFMLAttribute_Number(AFMLAttribute__TypeId.Area_SpaceEndPrecedence, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLMinimumAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.Area_SpaceEndPrecedence, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-end.precedence: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceStart_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplySpaceAttributeSetFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceStartMinimum, AFMLAttribute__TypeId.Area_SpaceStartOptimum, AFMLAttribute__TypeId.Area_SpaceStartMaximum, AFMLAttribute__TypeId.Area_SpaceStartPrecedence, AFMLAttribute__TypeId.Area_SpaceStartConditionality, in_attributeValue, "0.0pt", "0.0pt", "0.0pt", "0", "discard", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-start shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceStartConditionality(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "discard";
        }
        if (in_attributeValue.equalsIgnoreCase("retain") || in_attributeValue.equalsIgnoreCase("discard")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Area_SpaceStartConditionality, in_attributeValue.toLowerCase(), false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-start.conditionality: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceStartMaximum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceStartMaximum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-start.maximum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceStartMinimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceStartMinimum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-start.minimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceStartOptimum(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.Area_SpaceStartOptimum, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-start.optimum: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeSpaceStartPrecedence(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "0.0";
        }
        if (in_attributeValue.equalsIgnoreCase("force")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Area_SpaceStartPrecedence, in_attributeValue.toLowerCase(), false);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeNumber(in_attributeValue)) {
            AFMLAttribute_Number var_AFMLMinimumAttribute = new AFMLAttribute_Number(AFMLAttribute__TypeId.Area_SpaceStartPrecedence, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLMinimumAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.Area_SpaceStartPrecedence, in_attributeValue, false);
            this.setAttributeOnStackTop(var_AFMLMinimumAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for space-start.precedence: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeStyle(String in_attributeValue) throws AFMLExceptionInvalidParameter, AFMLExceptionUnsupportedFeature {
        String var_propertyValue;
        String var_propertyName;
        int initialIndex = 0;
        int endIndex = 0;
        int colonIndex = 0;
        while ((endIndex = in_attributeValue.indexOf(59, initialIndex)) >= 0) {
            colonIndex = in_attributeValue.indexOf(58, initialIndex);
            var_propertyName = in_attributeValue.substring(initialIndex, colonIndex).trim();
            var_propertyValue = in_attributeValue.substring(colonIndex + 1, endIndex).trim();
            this.processAttributeStyleProperties(var_propertyName, var_propertyValue);
            initialIndex = endIndex + 1;
        }
        if (initialIndex < in_attributeValue.length()) {
            colonIndex = in_attributeValue.indexOf(58, initialIndex);
            var_propertyName = in_attributeValue.substring(initialIndex, colonIndex).trim();
            var_propertyValue = in_attributeValue.substring(colonIndex + 1).trim();
            this.processAttributeStyleProperties(var_propertyName, var_propertyValue);
        }
    }

    private void processAttributeStyleProperties(String var_propertyName, String var_propertyValue) throws AFMLExceptionInvalidParameter, AFMLExceptionUnsupportedFeature {
        if (var_propertyName.equalsIgnoreCase("background-color")) {
            this.processAttributeBackgroundColor(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border")) {
            this.processAttributeBorder_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-after")) {
            this.processAttributeBorderAfter_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-after-color")) {
            this.processAttributeBorderAfterColor(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-after-style")) {
            this.processAttributeBorderAfterStyle(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-after-thickness")) {
            this.processAttributeBorderAfterThickness(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-before")) {
            this.processAttributeBorderBefore_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-before-color")) {
            this.processAttributeBorderBeforeColor(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-before-style")) {
            this.processAttributeBorderBeforeStyle(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-before-thickness")) {
            this.processAttributeBorderBeforeThickness(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-end")) {
            this.processAttributeBorderEnd_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-end-color")) {
            this.processAttributeBorderEndColor(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-end-style")) {
            this.processAttributeBorderEndStyle(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-end-thickness")) {
            this.processAttributeBorderEndThickness(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-start")) {
            this.processAttributeBorderStart_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-start-color")) {
            this.processAttributeBorderStartColor(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-start-style")) {
            this.processAttributeBorderStartStyle(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("border-start-thickness")) {
            this.processAttributeBorderStartThickness(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("color")) {
            this.processAttributeTextFillColor(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("xml:lang") || var_propertyName.equalsIgnoreCase("xml-lang") || var_propertyName.equalsIgnoreCase("lang") || var_propertyName.equalsIgnoreCase("locale")) {
            this.processAttributeLocale_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("language") || var_propertyName.equalsIgnoreCase("locale-language") || var_propertyName.equalsIgnoreCase("locale.language")) {
            this.processAttributeLocaleLanguage(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("country") || var_propertyName.equalsIgnoreCase("locale-country") || var_propertyName.equalsIgnoreCase("locale.country")) {
            this.processAttributeLocaleCountry(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("script") || var_propertyName.equalsIgnoreCase("locale-script") || var_propertyName.equalsIgnoreCase("locale.script")) {
            this.processAttributeLocaleScript(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("locale-variant") || var_propertyName.equalsIgnoreCase("locale.variant")) {
            this.processAttributeLocaleVariant(var_propertyName);
        } else if (var_propertyName.equalsIgnoreCase("locale-keywords") || var_propertyName.equalsIgnoreCase("locale.keywords")) {
            this.processAttributeLocaleKeywords(var_propertyName);
        } else if (var_propertyName.equalsIgnoreCase("direction")) {
            this.processAttributeBidiDirection(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("unicode-bidi")) {
            this.processAttributeBidiUnicodeBidi(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("font")) {
            this.processAttributeFont_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("font-family")) {
            this.processAttributeFontFamily(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("font-force-monospace-pitch")) {
            this.processAttributeFontForceMonospacePitch(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("font-size")) {
            this.processAttributeFontSize(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("font-stretch")) {
            this.processAttributeFontStretch(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("font-style")) {
            this.processAttributeFontStyle(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("font-variant")) {
            this.processAttributeFontVariant(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("font-weight")) {
            this.processAttributeFontWeight(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("leader-pattern") || var_propertyName.equalsIgnoreCase("leader-style")) {
            this.processAttributeLeaderPattern_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("leader-length")) {
            this.processAttributeLeaderLength_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("leader-length.maximum")) {
            this.processAttributeLeaderLengthMaximum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("leader-length.minimum")) {
            this.processAttributeLeaderLengthMinimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("leader-length.optimum")) {
            this.processAttributeLeaderLengthOptimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("margin")) {
            this.processAttributeMargin_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("margin-bottom")) {
            this.processAttributeMarginBottom(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("margin-left")) {
            this.processAttributeMarginLeft(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("margin-right")) {
            this.processAttributeMarginRight(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("margin-top")) {
            this.processAttributeMarginTop(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("padding")) {
            this.processAttributePadding_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("padding-after")) {
            this.processAttributePaddingAfter(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("padding-start")) {
            this.processAttributePaddingStart(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("padding-end")) {
            this.processAttributePaddingEnd(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("padding-before")) {
            this.processAttributePaddingBefore(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("padding-bottom")) {
            this.processAttributePaddingAfter(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("padding-left")) {
            this.processAttributePaddingStart(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("padding-right")) {
            this.processAttributePaddingEnd(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("padding-top")) {
            this.processAttributePaddingBefore(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("below-baseline-adjustment-factor")) {
            this.processAttributeBelowBaselineAdjustmentFactor(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("tab-interval")) {
            this.processAttributeTabInterval(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("tab-stops")) {
            this.processAttributeTabStops_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("xfa-tab-stops")) {
            this.processAttributeXfaTabStops_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("text-align") || var_propertyName.equalsIgnoreCase("inline-align")) {
            this.processAttributeTextAlign(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("text-decoration")) {
            this.processAttributeTextDecoration_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("text-decoration.underline")) {
            this.processAttributeTextDecorationUnderline_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("text-decoration.overline")) {
            this.processAttributeTextDecorationOverline_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("text-decoration.line-through")) {
            this.processAttributeTextDecorationLineThrough_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("line-height")) {
            this.processAttributeLineHeight_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("line-height.maximum")) {
            this.processAttributeLineHeightMaximum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("line-height.minimum")) {
            this.processAttributeLineHeightMinimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("line-height.optimum")) {
            this.processAttributeLineHeightOptimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("line-height.conditionality")) {
            this.processAttributeLineHeightConditionality(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("line-height.precedence")) {
            this.processAttributeLineHeightPrecedence(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("line-height-precedence-override")) {
            this.processAttributeLineHeightPrecedenceOverride(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("letterspacing") || "LATEST".equals(this.textFormatterCompatibility) && var_propertyName.equalsIgnoreCase("letter-spacing")) {
            this.processAttributeJustificationLetterspacing_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("letterspacing.maximum")) {
            this.processAttributeJustificationLetterspacingMaximum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("letterspacing.minimum")) {
            this.processAttributeJustificationLetterspacingMinimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("letterspacing.optimum")) {
            this.processAttributeJustificationLetterspacingOptimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("letterspacing.conditionality")) {
            this.processAttributeJustificationLetterspacingConditionality(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("letterspacing.precedence")) {
            this.processAttributeJustificationLetterspacingPrecedence(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("wordspacing")) {
            this.processAttributeJustificationWordspacing_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("wordspacing.maximum")) {
            this.processAttributeJustificationWordspacingMaximum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("wordspacing.minimum")) {
            this.processAttributeJustificationWordspacingMinimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("wordspacing.optimum")) {
            this.processAttributeJustificationWordspacingOptimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("wordspacing.conditionality")) {
            this.processAttributeJustificationWordspacingConditionality(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("wordspacing.precedence")) {
            this.processAttributeJustificationWordspacingPrecedence(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("justification-strategy")) {
            this.processAttributeJustificationStrategy(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-after")) {
            this.processAttributeSpaceAfter_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-after.maximum")) {
            this.processAttributeSpaceAfterMaximum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-after.minimum")) {
            this.processAttributeSpaceAfterMinimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-after.optimum")) {
            this.processAttributeSpaceAfterOptimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-after.conditionality")) {
            this.processAttributeSpaceAfterConditionality(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-after.precedence")) {
            this.processAttributeSpaceAfterPrecedence(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-before")) {
            this.processAttributeSpaceBefore_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-before.maximum")) {
            this.processAttributeSpaceBeforeMaximum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-before.minimum")) {
            this.processAttributeSpaceBeforeMinimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-before.optimum")) {
            this.processAttributeSpaceBeforeOptimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-before.conditionality")) {
            this.processAttributeSpaceBeforeConditionality(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-before.precedence")) {
            this.processAttributeSpaceBeforePrecedence(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-end")) {
            this.processAttributeSpaceEnd_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-end.maximum")) {
            this.processAttributeSpaceEndMaximum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-end.minimum")) {
            this.processAttributeSpaceEndMinimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-end.optimum")) {
            this.processAttributeSpaceEndOptimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-end.conditionality")) {
            this.processAttributeSpaceEndConditionality(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-end.precedence")) {
            this.processAttributeSpaceEndPrecedence(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-start")) {
            this.processAttributeSpaceStart_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-start.maximum")) {
            this.processAttributeSpaceStartMaximum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-start.minimum")) {
            this.processAttributeSpaceStartMinimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-start.optimum")) {
            this.processAttributeSpaceStartOptimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-start.conditionality")) {
            this.processAttributeSpaceStartConditionality(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space-start.precedence")) {
            this.processAttributeSpaceStartPrecedence(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("start-indent") || var_propertyName.equalsIgnoreCase("indent-start")) {
            this.processAttributeIndentStart(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("end-indent") || var_propertyName.equalsIgnoreCase("indent-end")) {
            this.processAttributeIndentEnd(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("text-indent") || var_propertyName.equalsIgnoreCase("indent-first")) {
            this.processAttributeIndentFirst(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("text-valign") || var_propertyName.equalsIgnoreCase("display-align") || var_propertyName.equalsIgnoreCase("block-align")) {
            this.processAttributeBlockVAlign(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("vertical-align") || var_propertyName.equalsIgnoreCase("baseline-shift")) {
            this.processAttributeVerticalAlign_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("xfa-ligatures") || var_propertyName.equalsIgnoreCase("ligature-strategy") || var_propertyName.equalsIgnoreCase("text-ligatures")) {
            this.processAttributeTextLigatures(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("xfa:spacerun") || var_propertyName.equalsIgnoreCase("spacerun") || var_propertyName.equalsIgnoreCase("xfa-spacerun")) {
            this.processAttributeXFASpaceRun_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("space") || var_propertyName.equalsIgnoreCase("xml:space") || var_propertyName.equalsIgnoreCase("xml-space")) {
            this.processAttributeXMLSpace_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("xfa-tab-count") || var_propertyName.equalsIgnoreCase("tab-stop-index")) {
            this.processAttributeTabStopIndex(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("wrap-option")) {
            this.processAttributeWrapOption(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("block-progression-dimension") || var_propertyName.equalsIgnoreCase("height") || var_propertyName.equalsIgnoreCase("page-height")) {
            this.processAttributeBlockProgressionDimension_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("inline-progression-dimension") || var_propertyName.equalsIgnoreCase("width") || var_propertyName.equalsIgnoreCase("page-width")) {
            this.processAttributeInlineProgressionDimension_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("overflow")) {
            this.processAttributeOverflow(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("collapsible-trailing-spaces")) {
            this.processAttributeCollapsibleTrailingSpaces(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("delete-trailing-spaces")) {
            this.processAttributeDeleteTrailingSpaces(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("include-trailing-spaces-to-compute-font-size")) {
            this.processAttributeIncludeTrailingSpacesToComputeFontSize(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("region-name")) {
            this.processAttributeRegionName(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("region-name-reference")) {
            this.processAttributeRegionNameReference(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("master-selector")) {
            this.processAttributeSelector_Shorthand(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("blank-or-not-blank")) {
            this.processAttributeSelectorBlankOrNotBlank(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("maximum-repeats")) {
            this.processAttributeSelectorMaximumRepeats(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("minimum-repeats")) {
            this.processAttributeSelectorMinimumRepeats(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("odd-or-even")) {
            this.processAttributeSelectorOddOrEven(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("odd-or-even-strategy")) {
            this.processAttributeSelectorOddOrEvenStrategy(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("page-position")) {
            this.processAttributeSelectorPagePosition(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("page-position-explicit")) {
            this.processAttributeSelectorPagePositionExplicit(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("page-position-strategy")) {
            this.processAttributeSelectorPagePositionStrategy(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("reference-orientation")) {
            this.processAttributeReferenceOrientation(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("writing-mode")) {
            this.processAttributeWritingMode(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("force-page-count")) {
            this.processAttributeSequenceForcePageCount(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("initial-page-number")) {
            this.processAttributeSequenceInitialPageNumber(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("external-destination")) {
            this.processAttributeUI_ExternalDestination(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-content-height")) {
            this.processAttributeGraphic_GraphicContentHeight(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-content-width")) {
            this.processAttributeGraphic_GraphicContentWidth(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-scale-to-fit-enable")) {
            this.processAttributeGraphic_GraphicScaleToFitEnable(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-scale-to-fit.maximum")) {
            this.processAttributeGraphic_GraphicScaleToFitMaximum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-scale-to-fit.minimum")) {
            this.processAttributeGraphic_GraphicScaleToFitMinimum(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-scale-to-fit-strategy")) {
            this.processAttributeGraphic_GraphicScaleToFitStrategy(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-scaling-allowed-height")) {
            this.processAttributeGraphic_GraphicScalingAllowedHeightFactors(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-scaling-allowed-width")) {
            this.processAttributeGraphic_GraphicScalingAllowedWidthFactors(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-scaling-aspect-ratio")) {
            this.processAttributeGraphic_GraphicScalingAspectRatio(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-scaling-method")) {
            this.processAttributeGraphic_GraphicScalingMethod(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-source")) {
            this.processAttributeGraphic_GraphicSource(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-source-page")) {
            this.processAttributeGraphic_GraphicSourcePage(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("graphic-source-type")) {
            this.processAttributeGraphic_GraphicSourceType(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("internal-graphic-content-data-key")) {
            this.processAttributeGraphic_InternalGraphicContentDataKey(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("list-style-type")) {
            this.processAttributeListStyleType(var_propertyValue);
        } else if (var_propertyName.equalsIgnoreCase("xfaVersion")) {
            this.processAttributeXFAVersion(var_propertyValue);
        }
    }

    public void processAttributeXFAVersion(String var_propertyValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromInteger(AFMLAttribute__TypeId.XFATemplateVersion, var_propertyValue, "0", true, false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for ListLevel: \"" + var_propertyValue + "\"");
        }
    }

    public void processAttributeTabInterval(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!in_attributeValue.equalsIgnoreCase("-default-")) {
            AFMLAttribute__Abstract var_AFMLTabRulerAttribute = this.getAttributeFromStackTop(AFMLAttribute__TypeId.BlockText_TabRuler);
            if (AFMLAttribute__TypeId.BlockText_TabRuler != var_AFMLTabRulerAttribute.getAttributeTypeId()) {
                ArrayList<AFMLAttribute_TabStop> tabstops = new ArrayList<AFMLAttribute_TabStop>();
                var_AFMLTabRulerAttribute = new AFMLAttribute_TabRuler(AFMLAttribute__TypeId.BlockText_TabRuler, AFMLAttribute__Abstract.convertAFMLLengthToPoints(in_attributeValue), tabstops, false);
            } else {
                ((AFMLAttribute_TabRuler)var_AFMLTabRulerAttribute).setInterval(AFMLAttribute__Abstract.convertAFMLLengthToPoints(in_attributeValue));
            }
            this.setAttributeOnStackTop(var_AFMLTabRulerAttribute);
        }
    }

    public void processAttributeTabStopIndex(String in_attributeValue) throws AFMLExceptionInvalidParameter, AFMLExceptionUnsupportedFeature {
        if (!in_attributeValue.equalsIgnoreCase("-default-")) {
            AFMLAnomalies.AFMLUnsupportedFeatureStop("InvalidInput: xfa-tab-count property is not currently supported");
        }
    }

    private List<String> processRule(String in_attributeValue) {
        int startIndex = in_attributeValue.indexOf(40);
        int lastIndex = in_attributeValue.lastIndexOf(41);
        in_attributeValue = in_attributeValue.substring(startIndex + 1, lastIndex);
        return this.splitTabStopParams(in_attributeValue);
    }

    private AFMLAttribute_Leader processLeader(String in_attributeValue) {
        int last_index;
        if (null == in_attributeValue) {
            return new AFMLAttribute_Leader(" ", null, 0.0, "none", 0.0);
        }
        String inPattern = " ";
        String inStyle = null;
        double inThickness = 1.0;
        String inAlignment = "none";
        double inPatternWidth = 0.0;
        int start_index = in_attributeValue.indexOf(40);
        List<String> attributevalueValues = this.splitTabStopParams(in_attributeValue = in_attributeValue.substring(start_index + 1, last_index = in_attributeValue.lastIndexOf(41)));
        inPattern = attributevalueValues.get(0);
        if (inPattern.equalsIgnoreCase("SPACE")) {
            if (1 < attributevalueValues.size() && !attributevalueValues.get(1).contains("(")) {
                inAlignment = attributevalueValues.get(1);
                if (2 < attributevalueValues.size()) {
                    inPatternWidth = AFMLAttribute__Abstract.convertAFMLLengthToPoints(attributevalueValues.get(2));
                }
            } else {
                if (2 < attributevalueValues.size()) {
                    inAlignment = attributevalueValues.get(2);
                }
                if (3 < attributevalueValues.size()) {
                    inPatternWidth = AFMLAttribute__Abstract.convertAFMLLengthToPoints(attributevalueValues.get(3));
                }
            }
            inPattern = " ";
        } else if (inPattern.equalsIgnoreCase("DOTS")) {
            if (1 < attributevalueValues.size() && !attributevalueValues.get(1).contains("(")) {
                inAlignment = attributevalueValues.get(1);
                if (2 < attributevalueValues.size()) {
                    inPatternWidth = AFMLAttribute__Abstract.convertAFMLLengthToPoints(attributevalueValues.get(2));
                }
            } else {
                if (2 < attributevalueValues.size()) {
                    inAlignment = attributevalueValues.get(2);
                }
                if (3 < attributevalueValues.size()) {
                    inPatternWidth = AFMLAttribute__Abstract.convertAFMLLengthToPoints(attributevalueValues.get(3));
                }
            }
            inPattern = ".";
        } else if (inPattern.equalsIgnoreCase("RULE")) {
            if (1 < attributevalueValues.size()) {
                List<String> values = this.processRule(attributevalueValues.get(1));
                inStyle = values.get(0);
                if (1 < values.size()) {
                    inThickness = AFMLAttribute__Abstract.convertAFMLLengthToPoints(values.get(1));
                }
            }
            if (2 < attributevalueValues.size()) {
                inAlignment = attributevalueValues.get(2);
            }
            if (3 < attributevalueValues.size()) {
                inPatternWidth = AFMLAttribute__Abstract.convertAFMLLengthToPoints(attributevalueValues.get(3));
            }
            inPattern = " ";
        } else if (inPattern.equalsIgnoreCase("USE-CONTENT")) {
            if (1 < attributevalueValues.size()) {
                inPattern = attributevalueValues.get(1);
                start_index = inPattern.indexOf(40);
                last_index = inPattern.lastIndexOf(41);
                inPattern = inPattern.substring(start_index + 1, last_index);
                inPattern = inPattern.trim();
                ArrayList<String> matchList = new ArrayList<String>();
                Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
                Matcher regexMatcher = regex.matcher(inPattern);
                while (regexMatcher.find()) {
                    if (regexMatcher.group(1) != null) {
                        matchList.add(regexMatcher.group(1));
                        continue;
                    }
                    if (regexMatcher.group(2) != null) {
                        matchList.add(regexMatcher.group(2));
                        continue;
                    }
                    matchList.add(regexMatcher.group());
                }
                inPattern = (String)matchList.get(0);
                inPattern = inPattern.replace("'", "");
            }
            if (2 < attributevalueValues.size()) {
                inAlignment = attributevalueValues.get(2);
            }
            if (3 < attributevalueValues.size()) {
                inPatternWidth = AFMLAttribute__Abstract.convertAFMLLengthToPoints(attributevalueValues.get(3));
            }
        }
        return new AFMLAttribute_Leader(inPattern, inStyle, inThickness, inAlignment, inPatternWidth);
    }

    private List<String> splitTabStopParams(String input) {
        int i;
        input = input.trim();
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '(') {
                StringBuilder sb = new StringBuilder();
                int openCount = 0;
                int closeCount = 0;
                boolean singleQuoteCount = true;
                do {
                    if (input.charAt(i) == '\'') {
                        singleQuoteCount = !singleQuoteCount;
                    } else if (singleQuoteCount && input.charAt(i) == '(') {
                        ++openCount;
                    } else if (singleQuoteCount && input.charAt(i) == ')') {
                        ++closeCount;
                    }
                    sb.append(input.charAt(i));
                    ++i;
                } while (closeCount < openCount);
                list.add(sb.toString());
                continue;
            }
            int spaceIndex = input.indexOf(" ", i);
            String value = spaceIndex > -1 ? input.substring(i, spaceIndex) : input.substring(i);
            list.add(value);
            i += value.length();
        }
        for (i = 0; i < list.size(); ++i) {
            if (!((String)list.get(i)).equalsIgnoreCase("PT") && !((String)list.get(i)).equalsIgnoreCase("PC") && !((String)list.get(i)).equalsIgnoreCase("TW") && !((String)list.get(i)).equalsIgnoreCase("MP") && !((String)list.get(i)).equalsIgnoreCase("PP") && !((String)list.get(i)).equalsIgnoreCase("PI") && !((String)list.get(i)).equalsIgnoreCase("DI") && !((String)list.get(i)).equalsIgnoreCase("CI") && !((String)list.get(i)).equalsIgnoreCase("IN") && !((String)list.get(i)).equalsIgnoreCase("FT") && !((String)list.get(i)).equalsIgnoreCase("YD") && !((String)list.get(i)).equalsIgnoreCase("CM") && !((String)list.get(i)).equalsIgnoreCase("MM") && !((String)list.get(i)).equalsIgnoreCase("ME") && !((String)list.get(i)).equalsIgnoreCase("M.")) continue;
            list.remove(i);
        }
        return list;
    }

    private int getStartIndex(String input, int content_index) {
        int start_index = 0;
        char[] charArray = input.toCharArray();
        for (int i = content_index; i < charArray.length; ++i) {
            if (charArray[i] != '(') continue;
            start_index = i;
            break;
        }
        return start_index;
    }

    private int getLastIndex(String input, int content_index) {
        int last_index = 0;
        int count = 0;
        char[] charArray = input.toCharArray();
        boolean singleQuoteCount = true;
        for (int i = content_index; i < charArray.length; ++i) {
            if (input.charAt(i) == '\'') {
                singleQuoteCount = !singleQuoteCount;
                continue;
            }
            if (singleQuoteCount && charArray[i] == '(') {
                ++count;
                continue;
            }
            if (!singleQuoteCount || charArray[i] != ')' || 0 != --count) continue;
            last_index = i;
            break;
        }
        return last_index;
    }

    private String processInputString(String input) {
        String result = null;
        if (!input.contains("use-content")) {
            input = input.replaceAll("\\)", " \\) ");
            input = input.replaceAll("\\(", " \\( ");
            result = input = input.replaceAll("\\s+", " ");
        } else {
            int contentIndex = 0;
            int nextContentIndex = 0;
            contentIndex = input.indexOf("use-content", 0);
            nextContentIndex = input.indexOf("use-content", contentIndex + 1);
            while (-1 != contentIndex) {
                int startIndex = this.getStartIndex(input, contentIndex);
                int lastIndex = this.getLastIndex(input, contentIndex);
                if (-1 != startIndex && -1 != lastIndex) {
                    String str1 = input.substring(0, startIndex);
                    String str2 = input.substring(startIndex, lastIndex + 1);
                    String str3 = null;
                    if (-1 == nextContentIndex) {
                        str3 = input.substring(lastIndex + 1);
                        input = null;
                    } else {
                        str3 = input.substring(lastIndex + 1, nextContentIndex);
                        input = input.substring(nextContentIndex);
                    }
                    str1 = str1.replaceAll("\\)", " \\) ");
                    str1 = str1.replaceAll("\\(", " \\( ");
                    str3 = str3.replaceAll("\\)", " \\) ");
                    str3 = str3.replaceAll("\\(", " \\( ");
                    str1 = str1.replaceAll("\\s+", " ");
                    str3 = str3.replaceAll("\\s+", " ");
                    String str = str1 + str2 + str3;
                    result = null == result ? str : result + str;
                }
                if (null != input) {
                    contentIndex = input.indexOf("use-content", 0);
                    nextContentIndex = input.indexOf("use-content", contentIndex + 1);
                    continue;
                }
                contentIndex = -1;
                nextContentIndex = -1;
            }
        }
        return result;
    }

    public boolean validateLeaderParams(AFMLAttribute_Leader var_leader) {
        String inStyle = var_leader.getStyle();
        if (!(null == inStyle || inStyle.equalsIgnoreCase("DOTTED") || inStyle.equalsIgnoreCase("DASHED") || inStyle.equalsIgnoreCase("SOLID") || inStyle.equalsIgnoreCase("NONE"))) {
            return false;
        }
        String inAlignment = var_leader.getAlignment();
        return null == inAlignment || inAlignment.equalsIgnoreCase("PAGE") || inAlignment.equalsIgnoreCase("NONE");
    }

    public void sortTabStops(List<AFMLAttribute_TabStop> tabstops) {
        Collections.sort(tabstops, new Comparator<AFMLAttribute_TabStop>(){

            @Override
            public int compare(AFMLAttribute_TabStop x, AFMLAttribute_TabStop y) {
                double yPosition;
                double xPosition = x.getPosition();
                if (xPosition < (yPosition = y.getPosition())) {
                    return -1;
                }
                if (xPosition > yPosition) {
                    return 1;
                }
                return 0;
            }
        });
        AFMLAttribute_TabStop first = null;
        AFMLAttribute_TabStop second = null;
        for (int i = 1; i < tabstops.size(); ++i) {
            first = tabstops.get(i - 1);
            second = tabstops.get(i);
            if (first.getPosition() != second.getPosition()) continue;
            tabstops.remove(i - 1);
            --i;
        }
    }

    public void processAttributeXfaTabStops_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter, AFMLExceptionUnsupportedFeature {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            return;
        }
        in_attributeValue = this.processInputString(in_attributeValue);
        List<String> attributevalueValues = this.splitTabStopParams(in_attributeValue);
        ArrayList<AFMLAttribute_TabStop> tabstops = new ArrayList<AFMLAttribute_TabStop>();
        for (int i = 0; i < attributevalueValues.size(); i += 2) {
            double varPosition;
            AFMLAttribute_Leader varLeader;
            String varAlignment = attributevalueValues.get(i);
            if (attributevalueValues.get(i + 1).equalsIgnoreCase("LEADER")) {
                varLeader = this.processLeader(attributevalueValues.get(i + 2));
                if (!this.validateLeaderParams(varLeader)) {
                    AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: leader parameters");
                }
                varPosition = AFMLAttribute__Abstract.convertAFMLLengthToPoints(attributevalueValues.get(i + 3));
                i += 2;
            } else {
                varLeader = this.processLeader(null);
                varPosition = AFMLAttribute__Abstract.convertAFMLLengthToPoints(attributevalueValues.get(i + 1));
            }
            AFMLAttribute_TabStop var_AFMLTabStop = new AFMLAttribute_TabStop(AFMLAttribute__TypeId.BlockText_TabStop, varPosition, varLeader, varAlignment, false);
            tabstops.add(var_AFMLTabStop);
        }
        this.sortTabStops(tabstops);
        AFMLAttribute__Abstract var_AFMLTabRuler = this.getAttributeFromStackTop(AFMLAttribute__TypeId.BlockText_TabRuler);
        if (AFMLAttribute__TypeId.BlockText_TabRuler != var_AFMLTabRuler.getAttributeTypeId()) {
            var_AFMLTabRuler = new AFMLAttribute_TabRuler(AFMLAttribute__TypeId.BlockText_TabRuler, 0.0, tabstops, false);
        } else {
            ((AFMLAttribute_TabRuler)var_AFMLTabRuler).setTabstops(tabstops);
        }
        this.setAttributeOnStackTop(var_AFMLTabRuler);
    }

    public void processAttributeTabStops_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter, AFMLExceptionUnsupportedFeature {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            return;
        }
        in_attributeValue = this.processInputString(in_attributeValue);
        List<String> attributevalueValues = this.splitTabStopParams(in_attributeValue);
        ArrayList<AFMLAttribute_TabStop> tabstops = new ArrayList<AFMLAttribute_TabStop>();
        for (int i = 0; i < attributevalueValues.size(); i += 2) {
            double varPosition;
            AFMLAttribute_Leader varLeader;
            String varAlignment = attributevalueValues.get(i);
            if (attributevalueValues.get(i + 1).equalsIgnoreCase("LEADER")) {
                varLeader = this.processLeader(null);
                varPosition = AFMLAttribute__Abstract.convertAFMLLengthToPoints(attributevalueValues.get(i + 3));
                i += 2;
            } else {
                varLeader = this.processLeader(null);
                varPosition = AFMLAttribute__Abstract.convertAFMLLengthToPoints(attributevalueValues.get(i + 1));
            }
            AFMLAttribute_TabStop var_AFMLTabStop = new AFMLAttribute_TabStop(AFMLAttribute__TypeId.BlockText_TabStop, varPosition, varLeader, varAlignment, false);
            tabstops.add(var_AFMLTabStop);
        }
        this.sortTabStops(tabstops);
        AFMLAttribute__Abstract var_AFMLTabRuler = this.getAttributeFromStackTop(AFMLAttribute__TypeId.BlockText_TabRuler);
        if (AFMLAttribute__TypeId.BlockText_TabRuler != var_AFMLTabRuler.getAttributeTypeId()) {
            var_AFMLTabRuler = new AFMLAttribute_TabRuler(AFMLAttribute__TypeId.BlockText_TabRuler, 0.0, tabstops, false);
        } else {
            ((AFMLAttribute_TabRuler)var_AFMLTabRuler).setTabstops(tabstops);
        }
        this.setAttributeOnStackTop(var_AFMLTabRuler);
    }

    public void processAttributeTextAlign(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "start";
        } else if (in_attributeValue.equalsIgnoreCase("left")) {
            in_attributeValue = "start";
        } else if (in_attributeValue.equalsIgnoreCase("right")) {
            in_attributeValue = "end";
        }
        String var_AlignLast = in_attributeValue;
        if (in_attributeValue.equalsIgnoreCase("justify") || in_attributeValue.equalsIgnoreCase("justify-start") || in_attributeValue.equalsIgnoreCase("justify-left")) {
            in_attributeValue = "justify";
            var_AlignLast = "start";
        } else if (in_attributeValue.equalsIgnoreCase("justify-center")) {
            in_attributeValue = "justify";
            var_AlignLast = "center";
        } else if (in_attributeValue.equalsIgnoreCase("justify-end") || in_attributeValue.equalsIgnoreCase("justify-right")) {
            in_attributeValue = "justify";
            var_AlignLast = "end";
        } else if (in_attributeValue.equalsIgnoreCase("justify-inside")) {
            in_attributeValue = "justify";
            var_AlignLast = "inside";
        } else if (in_attributeValue.equalsIgnoreCase("justify-outside")) {
            in_attributeValue = "justify";
            var_AlignLast = "outside";
        } else if (in_attributeValue.equalsIgnoreCase("justify-all")) {
            in_attributeValue = "justify";
            var_AlignLast = "justify";
        }
        String[] var_allowedKeywords = new String[]{"start", "center", "end", "justify", "inside", "outside"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.BlockText_TextAlign, in_attributeValue.toLowerCase(), "start", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for text-align: \"" + in_attributeValue + "\"");
        }
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.BlockText_TextAlignLast, var_AlignLast.toLowerCase(), "start", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for text-align: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeTextDecoration_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        this.processAttributeTextDecorationLineThrough_Shorthand("auto");
        this.processAttributeTextDecorationOverline_Shorthand("auto");
        this.processAttributeTextDecorationUnderline_Shorthand("auto");
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "none";
        }
        if ("LATEST".equals(this.textFormatterCompatibility)) {
            in_attributeValue = in_attributeValue.replaceAll("double\\s*word", "double-word");
        }
        StringTokenizer var_shorthand = new StringTokenizer(in_attributeValue, " ,");
        while (var_shorthand.hasMoreTokens()) {
            String var_Token = var_shorthand.nextToken();
            if (in_attributeValue.equalsIgnoreCase("none")) {
                this.processAttributeTextDecorationLineThrough_Shorthand("none");
                this.processAttributeTextDecorationOverline_Shorthand("none");
                this.processAttributeTextDecorationUnderline_Shorthand("none");
                continue;
            }
            if (var_Token.equalsIgnoreCase("line-through") || var_Token.equalsIgnoreCase("double-line-through") || var_Token.equalsIgnoreCase("triple-line-through") || var_Token.equalsIgnoreCase("word-line-through") || var_Token.equalsIgnoreCase("word-double-line-through") || var_Token.equalsIgnoreCase("double-word-line-through") || var_Token.equalsIgnoreCase("no-line-through")) {
                this.processAttributeTextDecorationLineThrough_Shorthand(var_Token);
                continue;
            }
            if (var_Token.equalsIgnoreCase("overline") || var_Token.equalsIgnoreCase("double-overline") || var_Token.equalsIgnoreCase("triple-overline") || var_Token.equalsIgnoreCase("word-overline") || var_Token.equalsIgnoreCase("word-double-overline") || var_Token.equalsIgnoreCase("double-word-overline") || var_Token.equalsIgnoreCase("no-overline")) {
                this.processAttributeTextDecorationOverline_Shorthand(var_Token);
                continue;
            }
            if (var_Token.equalsIgnoreCase("underline") || var_Token.equalsIgnoreCase("no-underline") || var_Token.equalsIgnoreCase("word") || var_Token.equalsIgnoreCase("double") || var_Token.equalsIgnoreCase("word double") || var_Token.equalsIgnoreCase("double word") || var_Token.equalsIgnoreCase("word-double") || var_Token.equalsIgnoreCase("double-word")) {
                this.processAttributeTextDecorationUnderline_Shorthand(var_Token);
                continue;
            }
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for text-decoration shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeTextDecorationLineThrough_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "auto";
        }
        if (!in_attributeValue.equalsIgnoreCase("auto")) {
            if (in_attributeValue.equalsIgnoreCase("line-through")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughEnable, "line-through", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughCount, 1, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughScoreSpaces, "enable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughThickness, "0.0264em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughPosition_Horizontal, "-0.264em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughSeparation, "-0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("double-line-through")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughEnable, "line-through", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughCount, 2, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughScoreSpaces, "enable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughThickness, "0.0198em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughPosition_Horizontal, "-0.264em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughSeparation, "-0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("triple-line-through")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughEnable, "line-through", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughCount, 3, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughScoreSpaces, "enable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughThickness, "0.0198em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughPosition_Horizontal, "-0.264em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughSeparation, "-0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("word-line-through")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughEnable, "line-through", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughCount, 1, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughScoreSpaces, "disable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughThickness, "0.0264em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughPosition_Horizontal, "-0.264em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughSeparation, "-0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("double-word-line-through") || in_attributeValue.equalsIgnoreCase("word-double-line-through")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughEnable, "line-through", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughCount, 2, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughScoreSpaces, "disable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughThickness, "0.0198em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughPosition_Horizontal, "-0.264em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughSeparation, "-0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("no-line-through") || in_attributeValue.equalsIgnoreCase("none")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationLineThroughEnable, "no-line-through", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
            } else {
                AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for text-decoration-line-through shorthand: \"" + in_attributeValue + "\"");
            }
        }
    }

    public void processAttributeTextDecorationOverline_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "auto";
        }
        if (!in_attributeValue.equalsIgnoreCase("auto")) {
            if (in_attributeValue.equalsIgnoreCase("overline")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineEnable, "overline", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineCount, 1, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineScoreSpaces, "enable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineThickness, "0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlinePosition_Horizontal, "0.826em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineSeparation, "0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("double-overline")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineEnable, "overline", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineCount, 2, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineScoreSpaces, "enable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineThickness, "0.0198em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlinePosition_Horizontal, "0.826em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineSeparation, "0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("triple-overline")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineEnable, "overline", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineCount, 3, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineScoreSpaces, "enable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineThickness, "0.0198em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlinePosition_Horizontal, "0.826em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineSeparation, "0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("word-overline")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineEnable, "overline", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineCount, 1, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineScoreSpaces, "disable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineThickness, "0.0264em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlinePosition_Horizontal, "0.826em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineSeparation, "0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("double-word-overline") || in_attributeValue.equalsIgnoreCase("word-double-overline")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineEnable, "overline", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineCount, 2, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineScoreSpaces, "disable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineThickness, "0.0198em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlinePosition_Horizontal, "0.826em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineSeparation, "0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("no-overline") || in_attributeValue.equalsIgnoreCase("none")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationOverlineEnable, "no-overline", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
            } else {
                AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for text-decoration-overline shorthand: \"" + in_attributeValue + "\"");
            }
        }
    }

    public void processAttributeTextDecorationUnderline_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "auto";
        }
        if (!in_attributeValue.equalsIgnoreCase("auto")) {
            if (in_attributeValue.equalsIgnoreCase("underline")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineEnable, "underline", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineCount, 1, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineScoreSpaces, "enable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineThickness, "0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlinePosition_Horizontal, "0.132em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineSeparation, "0.165em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("double")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineEnable, "underline", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineCount, 2, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineScoreSpaces, "enable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineThickness, "0.0264em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlinePosition_Horizontal, "0.132em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineSeparation, "0.165em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("triple")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineEnable, "underline", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineCount, 3, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineScoreSpaces, "enable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineThickness, "0.0264em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlinePosition_Horizontal, "0.132em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineSeparation, "0.165em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("word")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineEnable, "underline", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineCount, 1, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineScoreSpaces, "disable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineThickness, "0.0528em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlinePosition_Horizontal, "0.132em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineSeparation, "0.165em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("double word") || in_attributeValue.equalsIgnoreCase("word double") || in_attributeValue.equalsIgnoreCase("double-word") || in_attributeValue.equalsIgnoreCase("word-double")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineEnable, "underline", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
                AFMLAttribute_Integer var_AFMLDecorationCountAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineCount, 2, true);
                this.setAttributeOnStackTop(var_AFMLDecorationCountAttribute);
                AFMLAttribute_Keyword var_AFMLDecorationScoreAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineScoreSpaces, "disable", true);
                this.setAttributeOnStackTop(var_AFMLDecorationScoreAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationThicknessAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineThickness, "0.0264em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationThicknessAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationPositionAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlinePosition_Horizontal, "0.132em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationPositionAttribute);
                AFMLAttribute_EMLength var_AFMLDecorationSeparationAttribute = new AFMLAttribute_EMLength(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineSeparation, "0.165em", true);
                this.setAttributeOnStackTop(var_AFMLDecorationSeparationAttribute);
            } else if (in_attributeValue.equalsIgnoreCase("no-underline") || in_attributeValue.equalsIgnoreCase("none")) {
                AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.InlineText_TextDecorationUnderlineEnable, "no-underline", true);
                this.setAttributeOnStackTop(var_AFMLAttribute);
            } else {
                AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for text-decoration-underline shorthand: \"" + in_attributeValue + "\"");
            }
        }
    }

    public void processAttributeTextFillColor(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("transparent")) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for text-fill-color: \"" + in_attributeValue + "\"");
        }
        if (!this.internalApplyBasicAttributeFromColor(AFMLAttribute__TypeId.InlineText_TextFillColor, in_attributeValue, "black", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for text-fill-color: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeTextLigatures(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"none", "minimum", "common"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.InlineText_FontOTFDiscretionaryLigatures, in_attributeValue.toLowerCase(), "minimum", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for text-ligatures: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeTextStrokeColor(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromColor(AFMLAttribute__TypeId.InlineText_TextStrokeColor, in_attributeValue, "transparent", true)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for text-strokecolor: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeUI_ExternalDestination(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-") || in_attributeValue.equalsIgnoreCase("none")) {
            in_attributeValue = "-none-";
        }
        AFMLAttribute_String var_AFMLExternalDestinationAttribute = new AFMLAttribute_String(AFMLAttribute__TypeId.UI_ExternalDestination, in_attributeValue, true);
        this.setAttributeOnStackTop(var_AFMLExternalDestinationAttribute);
    }

    public void processAttributeUI_InternalDestinationPDFBBoxBottom(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "none";
        }
        if (in_attributeValue.equalsIgnoreCase("none")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.UI_InternalDestinationPDFBBoxBottom, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue)) {
            AFMLAttribute_Length var_AFMLAttribute = new AFMLAttribute_Length(AFMLAttribute__TypeId.UI_InternalDestinationPDFBBoxBottom, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for ui_internal-destination-pdf-bbox.bottom: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeUI_InternalDestinationPDFBBoxLeft(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "none";
        }
        if (in_attributeValue.equalsIgnoreCase("none")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.UI_InternalDestinationPDFBBoxLeft, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue)) {
            AFMLAttribute_Length var_AFMLAttribute = new AFMLAttribute_Length(AFMLAttribute__TypeId.UI_InternalDestinationPDFBBoxLeft, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for ui_internal-destination-pdf-bbox.left: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeUI_InternalDestinationPDFBBoxRight(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "none";
        }
        if (in_attributeValue.equalsIgnoreCase("none")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.UI_InternalDestinationPDFBBoxRight, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue)) {
            AFMLAttribute_Length var_AFMLAttribute = new AFMLAttribute_Length(AFMLAttribute__TypeId.UI_InternalDestinationPDFBBoxRight, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for ui_internal-destination-pdf-bbox.right: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeUI_InternalDestinationPDFBBoxTop(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "none";
        }
        if (in_attributeValue.equalsIgnoreCase("none")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.UI_InternalDestinationPDFBBoxTop, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue)) {
            AFMLAttribute_Length var_AFMLAttribute = new AFMLAttribute_Length(AFMLAttribute__TypeId.UI_InternalDestinationPDFBBoxTop, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for ui_internal-destination-pdf-bbox.top: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeUI_InternalDestinationPDFPageIndex(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "none";
        }
        if (in_attributeValue.equalsIgnoreCase("none")) {
            AFMLAttribute_Keyword var_AFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.UI_InternalDestinationPDFPageIndex, in_attributeValue.toLowerCase(), true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else if (AFMLAttribute__Abstract.isAFMLAttributeInteger(in_attributeValue)) {
            AFMLAttribute_Integer var_AFMLAttribute = new AFMLAttribute_Integer(AFMLAttribute__TypeId.UI_InternalDestinationPDFPageIndex, in_attributeValue, true);
            this.setAttributeOnStackTop(var_AFMLAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for ui_internal-destination-pdf-page-index: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeVerticalAlign_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            this.processAttributeBaselineShift("-default-");
            this.processAttributeBlockVAlign("-default-");
            return;
        }
        if (in_attributeValue.equalsIgnoreCase("base") || in_attributeValue.equalsIgnoreCase("baseline") || in_attributeValue.equalsIgnoreCase("sub") || in_attributeValue.equalsIgnoreCase("subscript") || in_attributeValue.equalsIgnoreCase("sup") || in_attributeValue.equalsIgnoreCase("super") || in_attributeValue.equalsIgnoreCase("superscript") || AFMLAttribute__Abstract.isAFMLAttributeLength(in_attributeValue) || AFMLAttribute__Abstract.isAFMLAttributeEMLength(in_attributeValue) || AFMLAttribute__Abstract.isAFMLAttributePercentageOrFactor(in_attributeValue)) {
            this.processAttributeBaselineShift(in_attributeValue);
        } else if (in_attributeValue.equalsIgnoreCase("top") || in_attributeValue.equalsIgnoreCase("bottom") || in_attributeValue.equalsIgnoreCase("before") || in_attributeValue.equalsIgnoreCase("middle") || in_attributeValue.equalsIgnoreCase("middle-ascent") || in_attributeValue.equalsIgnoreCase("middle-capital") || in_attributeValue.equalsIgnoreCase("center") || in_attributeValue.equalsIgnoreCase("after") || in_attributeValue.equalsIgnoreCase("spread") || in_attributeValue.equalsIgnoreCase("distribute") || in_attributeValue.equalsIgnoreCase("text-top") || in_attributeValue.equalsIgnoreCase("text-bottom")) {
            this.processAttributeBlockVAlign(in_attributeValue);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for vertical-align shorthand: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeWrapOption(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"wrap", "no-wrap", "soft-wrap", "emergency"};
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "wrap";
        }
        if (in_attributeValue.equalsIgnoreCase("character") || in_attributeValue.equalsIgnoreCase("char-wrap")) {
            in_attributeValue = "soft-wrap";
        }
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.InlineText_WrapOption, in_attributeValue.toLowerCase(), "wrap", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for wrap-option: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeWritingMode(String in_attributeValue) throws AFMLExceptionInvalidParameter, AFMLExceptionUnsupportedFeature {
        String[] var_allowedKeywords = new String[]{"auto", "lr-tb", "rl-tb", "tb-lr", "tb-rl", "lr-bt", "rl-bt", "bt-lr", "bt-rl", "lr-alternating-rl-tb", "lr-alternating-rl_bt", "lr-inverting-rl-tb", "lr-inverting-rl_bt", "tb-lr-in-lr-pairs"};
        if (in_attributeValue.equalsIgnoreCase("-default-") || in_attributeValue.equalsIgnoreCase("auto")) {
            in_attributeValue = "lr-tb";
        }
        if (in_attributeValue.equalsIgnoreCase("tb-lr") || in_attributeValue.equalsIgnoreCase("tb-rl") || in_attributeValue.equalsIgnoreCase("lr-bt") || in_attributeValue.equalsIgnoreCase("rl-bt") || in_attributeValue.equalsIgnoreCase("bt-lr") || in_attributeValue.equalsIgnoreCase("bt-rl") || in_attributeValue.equalsIgnoreCase("lr-alternating-rl-tb") || in_attributeValue.equalsIgnoreCase("lr-alternating-rl_bt") || in_attributeValue.equalsIgnoreCase("lr-inverting-rl-tb") || in_attributeValue.equalsIgnoreCase("lr-inverting-rl_bt") || in_attributeValue.equalsIgnoreCase("tb-lr-in-lr-pairs")) {
            AFMLAnomalies.AFMLUnsupportedFeatureStop("InvalidInput: non-supported value for writing-mode: \"" + in_attributeValue + "\"");
            in_attributeValue = "lr-tb";
        }
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Layout_WritingMode, in_attributeValue.toLowerCase(), "lr-tb", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for writing-mode: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeXFASpaceRun_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "no";
        }
        if (in_attributeValue.equalsIgnoreCase("yes")) {
            AFMLAttribute_Keyword var_LinefeedAFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_LinefeedTreatment, "treat-as-space", true);
            this.setAttributeOnStackTop(var_LinefeedAFMLAttribute);
            AFMLAttribute_Keyword var_AFMLWhiteSpaceCollapseAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_WhiteSpaceCollapse, "false", true);
            this.setAttributeOnStackTop(var_AFMLWhiteSpaceCollapseAttribute);
            AFMLAttribute_Keyword var_AFMLWhiteSpaceTreatmentAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_WhiteSpaceTreatment, "preserve", true);
            this.setAttributeOnStackTop(var_AFMLWhiteSpaceTreatmentAttribute);
            AFMLAttribute_Keyword var_AFMLNonbreakingSpaceTreatmentAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_NonbreakingSpaceTreatment, "treat-as-space", true);
            this.setAttributeOnStackTop(var_AFMLNonbreakingSpaceTreatmentAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("no")) {
            AFMLAttribute_Keyword var_LinefeedAFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_LinefeedTreatment, "treat-as-space", true);
            this.setAttributeOnStackTop(var_LinefeedAFMLAttribute);
            AFMLAttribute_Keyword var_AFMLWhiteSpaceCollapseAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_WhiteSpaceCollapse, "true", true);
            this.setAttributeOnStackTop(var_AFMLWhiteSpaceCollapseAttribute);
            AFMLAttribute_Keyword var_AFMLWhiteSpaceTreatmentAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_WhiteSpaceTreatment, "preserve", true);
            this.setAttributeOnStackTop(var_AFMLWhiteSpaceTreatmentAttribute);
            AFMLAttribute_Keyword var_AFMLNonbreakingSpaceTreatmentAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_NonbreakingSpaceTreatment, "preserve", true);
            this.setAttributeOnStackTop(var_AFMLNonbreakingSpaceTreatmentAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for xfa-spacerun: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeXMLSpace_Shorthand(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (in_attributeValue.equalsIgnoreCase("-default-")) {
            in_attributeValue = "default";
        }
        if (in_attributeValue.equalsIgnoreCase("preserve")) {
            AFMLAttribute_Keyword var_LinefeedAFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_LinefeedTreatment, "preserve", true);
            this.setAttributeOnStackTop(var_LinefeedAFMLAttribute);
            AFMLAttribute_Keyword var_AFMLWhiteSpaceCollapseAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_WhiteSpaceCollapse, "false", true);
            this.setAttributeOnStackTop(var_AFMLWhiteSpaceCollapseAttribute);
            AFMLAttribute_Keyword var_AFMLWhiteSpaceTreatmentAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_WhiteSpaceTreatment, "preserve", true);
            this.setAttributeOnStackTop(var_AFMLWhiteSpaceTreatmentAttribute);
            AFMLAttribute_Keyword var_AFMLNonbreakingSpaceTreatmentAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_NonbreakingSpaceTreatment, "preserve", true);
            this.setAttributeOnStackTop(var_AFMLNonbreakingSpaceTreatmentAttribute);
        } else if (in_attributeValue.equalsIgnoreCase("default")) {
            AFMLAttribute_Keyword var_LinefeedAFMLAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_LinefeedTreatment, "treat-as-space", true);
            this.setAttributeOnStackTop(var_LinefeedAFMLAttribute);
            AFMLAttribute_Keyword var_AFMLWhiteSpaceCollapseAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_WhiteSpaceCollapse, "true", true);
            this.setAttributeOnStackTop(var_AFMLWhiteSpaceCollapseAttribute);
            AFMLAttribute_Keyword var_AFMLWhiteSpaceTreatmentAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_WhiteSpaceTreatment, "preserve", true);
            this.setAttributeOnStackTop(var_AFMLWhiteSpaceTreatmentAttribute);
            AFMLAttribute_Keyword var_AFMLNonbreakingSpaceTreatmentAttribute = new AFMLAttribute_Keyword(AFMLAttribute__TypeId.Control_NonbreakingSpaceTreatment, "preserve", true);
            this.setAttributeOnStackTop(var_AFMLNonbreakingSpaceTreatmentAttribute);
        } else {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for xml:space: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributePreserveOldBehavior(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"true", "false"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.Preserve_Old_Behavior, in_attributeValue.toLowerCase(), "true", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for PreserveOldBehavior: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeListStyleType(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"disc", "circle", "square", "none"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.List_Style_Type, in_attributeValue.toLowerCase(), "disc", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for ListStyleType: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeListContainerType(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"ordered", "unordered"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.List_Container_Type, in_attributeValue.toLowerCase(), "unordered", true, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for ListStyleType: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeListLevelNumber(int in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromInteger(AFMLAttribute__TypeId.List_Level_Number, Integer.toString(in_attributeValue), "0", true, false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for ListLevel: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeListTagGap(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.List_TagGap, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for list_tag_gap: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeListIndent(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        if (!this.internalApplyBasicAttributeFromKeywordLengthEMLengthPercent(AFMLAttribute__TypeId.List_Indent, in_attributeValue, "0.0pt", false, new String[0], "pt", false)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for list_indent: \"" + in_attributeValue + "\"");
        }
    }

    public void processAttributeListBreakAnchor(String in_attributeValue) throws AFMLExceptionInvalidParameter {
        String[] var_allowedKeywords = new String[]{"true", "false"};
        if (!this.internalApplyBasicAttributeFromKeyword(AFMLAttribute__TypeId.List_Break_Anchor, in_attributeValue.toLowerCase(), "false", false, var_allowedKeywords)) {
            AFMLAnomalies.AFMLInvalidParameterStop("InvalidInput: Illegal value for ListBreakAnchor: \"" + in_attributeValue + "\"");
        }
    }
}

