/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.infontformatting.IndicFormatter;

final class BengaliFormatter
extends IndicFormatter {
    BengaliFormatter() {
    }

    @Override
    protected int splitVowelsAndNormalize(AttributedRun run, int start, int limit) {
        block4: while (start < limit) {
            int usv = run.elementAt(start);
            switch (usv) {
                case 2507: {
                    run.replace(start, new int[]{2503, 2494});
                    ++limit;
                    start += 2;
                    continue block4;
                }
                case 2508: {
                    run.replace(start, new int[]{2503, 2519});
                    ++limit;
                    start += 2;
                    continue block4;
                }
            }
            ++start;
        }
        return limit;
    }

    @Override
    protected int nukta() {
        return 2492;
    }

    @Override
    protected int virama() {
        return 2509;
    }

    protected boolean isSatelliteWhenInitial(int usv) {
        return usv == 2480;
    }

    @Override
    protected boolean isConsonant(int usv) {
        return 2453 <= usv && usv <= 2489 || 2524 <= usv && usv <= 2529 || 2544 <= usv && usv <= 2544 || 9676 == usv;
    }

    @Override
    protected boolean hasNukta(int usv) {
        return 2524 == usv || 2525 == usv || 2527 == usv;
    }

    @Override
    protected int removeNukta(int usv) {
        switch (usv) {
            case 2524: {
                return 2465;
            }
            case 2525: {
                return 2466;
            }
            case 2527: {
                return 2479;
            }
        }
        return usv;
    }

    @Override
    protected boolean isMark(int usv) {
        return 2494 <= usv && usv <= 2508 || 2530 <= usv && usv <= 2531 || 2433 <= usv && usv <= 2435 || 2519 <= usv && usv <= 2519;
    }

    @Override
    protected boolean isIndependentVowel(int usv) {
        return 2437 <= usv && usv <= 2452 || 2530 <= usv && usv <= 2531 || 9676 == usv;
    }

    @Override
    protected IndicFormatter.Position getPosition(int usv) {
        switch (usv) {
            case 2495: 
            case 2503: 
            case 2504: {
                return IndicFormatter.Position.left;
            }
            case 2433: {
                return IndicFormatter.Position.topOther;
            }
            case 2497: 
            case 2498: 
            case 2499: 
            case 2500: 
            case 2530: 
            case 2531: {
                return IndicFormatter.Position.bottom;
            }
            case 2377: 
            case 2378: 
            case 2379: 
            case 2380: 
            case 2494: 
            case 2496: {
                return IndicFormatter.Position.rightMatra;
            }
            case 2434: 
            case 2435: 
            case 2519: {
                return IndicFormatter.Position.rightOther;
            }
        }
        return IndicFormatter.Position.any;
    }

    @Override
    protected IndicFormatter.Shape rephLike(int usv) {
        if (2480 == usv) {
            return IndicFormatter.Shape.rephCons;
        }
        return IndicFormatter.Shape.any;
    }

    @Override
    protected boolean subjoins(int usv) {
        return usv == 2480 || usv == 2544 || usv == 2476;
    }

    @Override
    protected boolean postjoins(int usv) {
        return usv == 2479;
    }

    @Override
    protected boolean postjoinsIndependentVowels(int usv) {
        return usv == 2479;
    }
}

