/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.font.opentype.VerticalOriginFetcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public final class Vorg
extends Table
implements VerticalOriginFetcher {
    protected Vorg(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
    }

    int getDefaultVOrigin() throws InvalidFontException {
        return this.data.getint16(4);
    }

    @Override
    public int getVOrigin(int gid) throws InvalidFontException {
        int max = this.data.getuint16(6);
        int min = 0;
        while (min < max) {
            int mid = (min + max) / 2;
            int midGid = this.data.getuint16(8 + 4 * mid);
            if (gid < midGid) {
                max = mid;
                continue;
            }
            if (midGid < gid) {
                min = mid + 1;
                continue;
            }
            return this.data.getint16(8 + 4 * mid + 2);
        }
        return this.getDefaultVOrigin();
    }

    static void subsetAndStream(Subset subset, Map tables, VerticalOriginFetcher fetcher) throws InvalidFontException, UnsupportedFontException {
        int numGlyphs = subset.getNumGlyphs();
        int[] vorgs = new int[numGlyphs];
        int[] vorgsCopied = new int[numGlyphs];
        for (int i = 0; i < numGlyphs; ++i) {
            int fullGid = subset.getFullGid(i);
            vorgs[i] = fetcher.getVOrigin(fullGid);
        }
        System.arraycopy(vorgs, 0, vorgsCopied, 0, vorgs.length);
        Arrays.sort(vorgs);
        int newDefaultOrig = vorgs[0];
        int mostCommonVorgCount = 1;
        int thisVorgCount = 1;
        for (int i = 1; i < numGlyphs; ++i) {
            if (vorgs[i] == vorgs[i - 1]) {
                if (++thisVorgCount <= mostCommonVorgCount) continue;
                mostCommonVorgCount = thisVorgCount;
                newDefaultOrig = vorgs[i];
                continue;
            }
            thisVorgCount = 1;
        }
        int nonDefaultCount = 0;
        for (int i = 0; i < numGlyphs; ++i) {
            if (vorgs[i] == newDefaultOrig) continue;
            ++nonDefaultCount;
        }
        OTByteArray.OTByteArrayBuilder newData = OTByteArray.getOTByteArrayBuilderInstance(8 + 4 * nonDefaultCount);
        newData.setuint16(0, 1);
        newData.setuint16(2, 0);
        newData.setint16(4, newDefaultOrig);
        newData.setuint16(6, nonDefaultCount);
        int currentNonDefault = 0;
        for (int i = 0; i < vorgsCopied.length && currentNonDefault < nonDefaultCount; ++i) {
            if (vorgsCopied[i] == newDefaultOrig) continue;
            newData.setuint16(8 + currentNonDefault * 4, i);
            newData.setuint16(8 + currentNonDefault * 4 + 2, vorgsCopied[i]);
            ++currentNonDefault;
        }
        tables.put(new Integer(1448038983), newData);
    }

    void stream(Map tables) throws InvalidFontException {
        OTByteArray.OTByteArrayBuilder newData = this.getDataAsByteArray();
        tables.put(new Integer(1448038983), newData);
    }
}

