/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CFFFont;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.Header;
import com.adobe.fontengine.font.cff.Index;
import com.adobe.fontengine.font.cff.NameIndex;
import com.adobe.fontengine.font.cff.NameKeyedFont;
import com.adobe.fontengine.font.cff.StringIndex;
import com.adobe.fontengine.font.cff.SyntheticFont;
import java.io.IOException;

final class FontSet {
    protected final CFFByteArray data;
    protected final Header header;
    protected final NameIndex nameIndex;
    protected final Index topDictIndex;
    protected final StringIndex stringIndex;
    protected final CharStrings globalSubrs;
    public final CFFFont[] fonts;

    public FontSet(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        int i;
        this.data = new CFFByteArray(buffer);
        if (buffer.getSize() < 4) {
            throw new InvalidFontException("CFFFontSet too small");
        }
        int offset = 0;
        this.header = new Header(this.data, offset);
        offset += this.header.size();
        int majorVersion = this.header.getMajorVersion();
        if (majorVersion != 1) {
            throw new UnsupportedFontException("CFFFontSet major version " + majorVersion + " not supported");
        }
        this.nameIndex = new NameIndex(this.data, offset);
        this.topDictIndex = new Index(this.data, offset += this.nameIndex.size());
        this.stringIndex = new StringIndex(this.data, offset += this.topDictIndex.size());
        this.globalSubrs = new CharStrings(this.data, offset += this.stringIndex.size());
        this.fonts = new CFFFont[this.nameIndex.getCount()];
        Dict[] syntheticTopDicts = new Dict[this.nameIndex.getCount()];
        int[] syntheticBases = new int[this.nameIndex.getCount()];
        for (i = 0; i < this.fonts.length; ++i) {
            String name = this.nameIndex.getNthName(i);
            if (name.length() != 0 && name.charAt(0) == '\u0000') continue;
            Dict topDict = new Dict(this.data, this.topDictIndex.offsetOf(i), this.topDictIndex.sizeOf(i), this.stringIndex);
            Dict.ROSValue rosOp = topDict.get(Dict.Key.ROS, false);
            if (rosOp != null) {
                this.fonts[i] = new CIDKeyedFont(this.stringIndex, this.globalSubrs, name, topDict, this.data, null);
                continue;
            }
            Dict.IntegerValue syntheticBaseOp = topDict.get(Dict.Key.SyntheticBase, false);
            if (syntheticBaseOp != null) {
                syntheticTopDicts[i] = topDict;
                syntheticBases[i] = syntheticBaseOp.value;
                continue;
            }
            this.fonts[i] = new NameKeyedFont(this.stringIndex, this.globalSubrs, name, topDict, this.data, null);
        }
        for (i = 0; i < this.fonts.length; ++i) {
            if (syntheticTopDicts[i] == null) continue;
            this.fonts[i] = new SyntheticFont(this.stringIndex, this.fonts[syntheticBases[i]], this.nameIndex.getNthName(i), syntheticTopDicts[i], this.data, null);
        }
    }
}

