/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OrigFontType;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.StringIndex;
import com.adobe.fontengine.font.postscript.PostscriptTokenParser;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Dict {
    private final Map m;
    private static final String[] floatNibbles = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", "E", "E-", "", "-"};
    private static final Map defaultDict;

    Dict(CFFByteArray data, int offset, int size, StringIndex stringIndex) throws InvalidFontException {
        this.m = new LinkedHashMap();
        ValueStack s = new ValueStack();
        int o = offset;
        int limit = offset + size;
        block6: while (o < limit) {
            int b0 = data.getcard8(o);
            ++o;
            switch (b0) {
                case 12: {
                    b0 = data.getcard8(o);
                    ++o;
                    if (b0 < Key.extendedKeys.length && Key.extendedKeys[b0] != null) {
                        this.m.put(Key.extendedKeys[b0], Key.extendedKeys[b0].parse(s, stringIndex));
                        continue block6;
                    }
                    s.count = 0;
                    continue block6;
                }
                case 28: {
                    s.pushInt(data.getint16(o));
                    o += 2;
                    continue block6;
                }
                case 29: {
                    s.pushInt(data.getint32(o));
                    o += 4;
                    continue block6;
                }
                case 30: {
                    StringBuffer sb = new StringBuffer();
                    boolean done = false;
                    while (!done) {
                        int b1 = data.getcard8(o);
                        ++o;
                        if (b1 == 255) {
                            done = true;
                            continue;
                        }
                        if ((b1 & 0xF) == 15) {
                            sb.append(floatNibbles[b1 >> 4]);
                            done = true;
                            continue;
                        }
                        if (b1 >> 4 == 15) {
                            throw new InvalidFontException("CFF/Dict bad floating point number format");
                        }
                        sb.append(floatNibbles[b1 >> 4]);
                        sb.append(floatNibbles[b1 & 0xF]);
                    }
                    s.pushDouble(sb.toString());
                    continue block6;
                }
            }
            if (b0 < Key.nonExtendedKeys.length && Key.nonExtendedKeys[b0] != null) {
                this.m.put(Key.nonExtendedKeys[b0], Key.nonExtendedKeys[b0].parse(s, stringIndex));
                continue;
            }
            if (32 <= b0 && b0 <= 246) {
                s.pushInt(b0 - 139);
                continue;
            }
            if (247 <= b0 && b0 <= 250) {
                int b1 = data.getcard8(o);
                ++o;
                s.pushInt((b0 - 247) * 256 + b1 + 108);
                continue;
            }
            if (241 <= b0 && b0 <= 254) {
                int b1 = data.getcard8(o);
                ++o;
                s.pushInt(-(b0 - 251) * 256 - b1 - 108);
                continue;
            }
            s.count = 0;
        }
        if (s.count != 0) {
            throw new InvalidFontException("CFF/Dict stack not empty");
        }
    }

    Dict(Map m) throws InvalidFontException {
        this.m = new LinkedHashMap(m.size(), 1.0f);
        for (Object o : m.keySet()) {
            if (!(o instanceof Key)) {
                throw new InvalidFontException("Invalid key " + o);
            }
            Key key = (Key)o;
            if (!key.compatibleValue(o = m.get(o))) {
                throw new InvalidFontException("Invalid value for " + key);
            }
            this.m.put(key, o);
        }
    }

    private double[] deltaEncode(double[] original) {
        double[] delta = new double[original.length];
        double diff = 0.0;
        for (int i = 0; i < delta.length; ++i) {
            delta[i] = original[i] - diff;
            diff = original[i];
        }
        return delta;
    }

    public Dict(double[] blues, double[] otherBlues, double[] familyBlues, double[] familyOtherBlues, Double blueScale, Double blueShift, Integer bluefuzz, Double stdHW, Double stdVW, double[] stemSnapH, double[] stemSnapV, Boolean forceBold, Integer langGroup, Double expansionFactor, Integer initRandSeed, Double nominalWidth, Double defaultWidth) {
        this.m = new LinkedHashMap();
        if (nominalWidth != null && nominalWidth != 0.0) {
            this.m.put(Key.nominalWidthX, new NumbersValue(nominalWidth));
            if (defaultWidth != null && defaultWidth != 0.0) {
                this.m.put(Key.defaultWidthX, new NumbersValue(defaultWidth));
            }
        }
        if (blues != null) {
            this.m.put(Key.BlueValues, new NumbersValue(this.deltaEncode(blues)));
        }
        if (forceBold != null && forceBold.equals(Boolean.TRUE)) {
            this.m.put(Key.ForceBold, new NumbersValue(1));
        }
        if (langGroup != null && langGroup.doubleValue() != 0.0) {
            this.m.put(Key.LanguageGroup, new NumbersValue(langGroup));
        }
        if (expansionFactor != null && expansionFactor != 0.06) {
            this.m.put(Key.ExpansionFactor, new NumbersValue(expansionFactor));
        }
        if (initRandSeed != null && initRandSeed.doubleValue() != 0.0) {
            this.m.put(Key.initialRandomSeed, new NumbersValue(initRandSeed));
        }
        if (otherBlues != null) {
            this.m.put(Key.OtherBlues, new NumbersValue(this.deltaEncode(otherBlues)));
        }
        if (familyBlues != null) {
            this.m.put(Key.FamilyBlues, new NumbersValue(this.deltaEncode(familyBlues)));
        }
        if (familyOtherBlues != null) {
            this.m.put(Key.FamilyOtherBlues, new NumbersValue(this.deltaEncode(familyOtherBlues)));
        }
        if (blueScale != null) {
            this.m.put(Key.BlueScale, new NumbersValue(blueScale));
        }
        if (blueShift != null && blueShift != 7.0) {
            this.m.put(Key.BlueShift, new NumbersValue(blueShift));
        }
        if (bluefuzz != null && bluefuzz.doubleValue() != 1.0) {
            this.m.put(Key.BlueFuzz, new NumbersValue(bluefuzz));
        }
        if (stdHW != null) {
            this.m.put(Key.StdHW, new NumbersValue(stdHW));
        }
        if (stdVW != null) {
            this.m.put(Key.StdVW, new NumbersValue(stdVW));
        }
        if (stemSnapH != null) {
            this.m.put(Key.StemSnapH, new NumbersValue(this.deltaEncode(stemSnapH)));
        }
        if (stemSnapV != null) {
            this.m.put(Key.StemSnapV, new NumbersValue(this.deltaEncode(stemSnapV)));
        }
    }

    public Dict(Matrix matrix) {
        this.m = new LinkedHashMap();
        if (matrix != null) {
            this.m.put(Key.FontMatrix, new NumbersValue(matrix));
        }
    }

    public Dict(String registry, String ordering, int supplement, String version, String notice, String copyright, String fullname, String fontname, String familyName, String weight, Boolean fixedPitch, Double italicAngle, Double underlinePosition, Double underlineThickness, Integer paintType, Integer uniqueID, Rect bbox, Double strokewidth, int[] xuid, String postscript, Integer fsType, int[] baseFontBlend, String baseFontName, Matrix fontMatrix) throws InvalidFontException {
        this.m = new LinkedHashMap();
        if (registry != null && ordering != null) {
            this.m.put(Key.ROS, new ROSValue(registry, ordering, supplement));
        }
        if (fontname != null) {
            this.m.put(Key.FontName, new StringValue(fontname));
        }
        if (fsType != null) {
            String fsString = "/FSType " + fsType.toString() + " def";
            if (postscript != null) {
                this.m.put(Key.PostScript, new StringValue(postscript + " " + fsString));
            } else {
                this.m.put(Key.PostScript, new StringValue(fsString));
            }
        } else if (postscript != null) {
            this.m.put(Key.PostScript, new StringValue(postscript));
        }
        if (version != null) {
            this.m.put(Key.version, new StringValue(version));
        }
        if (notice != null) {
            this.m.put(Key.Notice, new StringValue(notice));
        }
        if (copyright != null) {
            this.m.put(Key.Copyright, new StringValue(copyright));
        }
        if (xuid != null) {
            this.m.put(Key.XUID, new NumbersValue(xuid));
        }
        if (baseFontBlend != null) {
            this.m.put(Key.BaseFontBlend, new NumbersValue(baseFontBlend));
        }
        if (bbox != null) {
            this.m.put(Key.FontBBox, new NumbersValue(bbox));
        }
        if (fullname != null) {
            this.m.put(Key.FullName, new StringValue(fullname));
        }
        if (familyName != null) {
            this.m.put(Key.FamilyName, new StringValue(familyName));
        }
        if (weight != null) {
            this.m.put(Key.Weight, new StringValue(weight));
        }
        if (italicAngle != null && italicAngle != 0.0) {
            this.m.put(Key.ItalicAngle, new NumbersValue(italicAngle));
        }
        if (underlinePosition != null && underlinePosition != -100.0) {
            this.m.put(Key.UnderlinePosition, new NumbersValue(underlinePosition));
        }
        if (underlineThickness != null && underlineThickness != 50.0) {
            this.m.put(Key.UnderlineThickness, new NumbersValue(underlineThickness));
        }
        if (paintType != null && paintType.doubleValue() != 0.0) {
            this.m.put(Key.PaintType, new NumbersValue(paintType));
        }
        if (uniqueID != null) {
            this.m.put(Key.UniqueID, new NumbersValue(uniqueID));
        }
        if (strokewidth != null && strokewidth != 0.0) {
            this.m.put(Key.StrokeWidth, new NumbersValue(strokewidth));
        }
        if (baseFontName != null) {
            this.m.put(Key.BaseFontName, new StringValue(baseFontName));
        }
        if (fontMatrix != null) {
            this.m.put(Key.FontMatrix, new NumbersValue(fontMatrix));
        }
    }

    OrigFontType getOrigFontType() {
        StringValue v = this.get(Key.PostScript, true);
        if (v != null) {
            return PostscriptTokenParser.getOrigFontType(v.value);
        }
        return null;
    }

    Integer getFSType() {
        StringValue v = this.get(Key.PostScript, true);
        if (v != null) {
            return PostscriptTokenParser.getFSType(v.value);
        }
        return null;
    }

    ROS getROS() {
        ROSValue v = this.get(Key.ROS, true);
        if (v != null) {
            return v.ros;
        }
        return null;
    }

    IntegerValue get(IntegerKey key, boolean useDefault) {
        IntegerValue v = (IntegerValue)this.m.get(key);
        if (v == null && useDefault) {
            v = (IntegerValue)defaultDict.get(key);
        }
        return v;
    }

    StringValue get(StringKey key, boolean useDefault) {
        StringValue v = (StringValue)this.m.get(key);
        if (v == null && useDefault) {
            v = (StringValue)defaultDict.get(key);
        }
        return v;
    }

    NumbersValue get(NumbersKey key, boolean useDefault) {
        NumbersValue v = (NumbersValue)this.m.get(key);
        if (v == null && useDefault) {
            v = (NumbersValue)defaultDict.get(key);
        }
        return v;
    }

    ROSValue get(ROSKey key, boolean useDefault) {
        ROSValue v = (ROSValue)this.m.get(key);
        if (v == null && useDefault) {
            v = (ROSValue)defaultDict.get(key);
        }
        return v;
    }

    OffsetValue get(OffsetKey key, boolean useDefault) {
        OffsetValue v = (OffsetValue)this.m.get(key);
        if (v == null && useDefault) {
            v = (OffsetValue)defaultDict.get(key);
        }
        return v;
    }

    OffsetSizeValue get(OffsetSizeKey key, boolean useDefault) {
        OffsetSizeValue v = (OffsetSizeValue)this.m.get(key);
        if (v == null && useDefault) {
            v = (OffsetSizeValue)defaultDict.get(key);
        }
        return v;
    }

    void collectStrings(List strings) {
        for (Value v : this.m.values()) {
            v.collectStrings(strings);
        }
    }

    void stream(CFFByteArray.CFFByteArrayBuilder bb, List strings, Key[] keys) throws InvalidFontException {
        for (int i = 0; i < keys.length; ++i) {
            Value v = (Value)this.m.get(keys[i]);
            if (v == null) continue;
            v.stream(bb, strings);
            keys[i].stream(bb);
        }
    }

    void streamValue(CFFByteArray.CFFByteArrayBuilder bb, List strings, Key key) throws InvalidFontException {
        Value v = (Value)this.m.get(key);
        if (v != null) {
            v.stream(bb, strings);
            key.stream(bb);
        }
    }

    static void streamKeyVal(CFFByteArray.CFFByteArrayBuilder bb, IntegerKey key, int value) {
        Dict.streamInt(bb, value);
        key.stream(bb);
    }

    static void streamKeyVal(CFFByteArray.CFFByteArrayBuilder bb, StringKey key, String value, List strings) {
        Dict.streamInt(bb, strings.indexOf(value));
        key.stream(bb);
    }

    private static void streamInt(CFFByteArray.CFFByteArrayBuilder bb, int n) {
        if (-107 <= n && n <= 107) {
            bb.addCard8(n + 139);
        } else if (108 <= n && n <= 1131) {
            bb.addCard8((n - 108) / 256 + 247);
            bb.addCard8((n - 108) % 256);
        } else if (-1131 <= n && n <= -108) {
            bb.addCard8((-108 - n) / 256 + 251);
            bb.addCard8((-108 - n) % 256);
        } else if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
            bb.addCard8(28);
            bb.addCard16(n);
        } else {
            bb.addCard8(29);
            bb.addCard32(n);
        }
    }

    private static void streamDouble(CFFByteArray.CFFByteArrayBuilder bb, Double d) throws InvalidFontException {
        int i = d.intValue();
        if ((double)i == d) {
            Dict.streamInt(bb, i);
            return;
        }
        Dict.streamDouble(bb, d.toString());
    }

    private static void streamDouble(CFFByteArray.CFFByteArrayBuilder bb, String s) throws InvalidFontException {
        bb.addCard8(30);
        int b = 0;
        boolean topNibble = true;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '0': {
                    b = (byte)(b | 0 << (topNibble ? 4 : 0));
                    break;
                }
                case '1': {
                    b = (byte)(b | 1 << (topNibble ? 4 : 0));
                    break;
                }
                case '2': {
                    b = (byte)(b | 2 << (topNibble ? 4 : 0));
                    break;
                }
                case '3': {
                    b = (byte)(b | 3 << (topNibble ? 4 : 0));
                    break;
                }
                case '4': {
                    b = (byte)(b | 4 << (topNibble ? 4 : 0));
                    break;
                }
                case '5': {
                    b = (byte)(b | 5 << (topNibble ? 4 : 0));
                    break;
                }
                case '6': {
                    b = (byte)(b | 6 << (topNibble ? 4 : 0));
                    break;
                }
                case '7': {
                    b = (byte)(b | 7 << (topNibble ? 4 : 0));
                    break;
                }
                case '8': {
                    b = (byte)(b | 8 << (topNibble ? 4 : 0));
                    break;
                }
                case '9': {
                    b = (byte)(b | 9 << (topNibble ? 4 : 0));
                    break;
                }
                case '.': {
                    b = (byte)(b | 10 << (topNibble ? 4 : 0));
                    break;
                }
                case 'E': {
                    int code = 11;
                    if (i < s.length() - 1 && s.charAt(i + 1) == '-') {
                        code = 12;
                        ++i;
                    }
                    b = (byte)(b | code << (topNibble ? 4 : 0));
                    break;
                }
                case '-': {
                    b = (byte)(b | 14 << (topNibble ? 4 : 0));
                    break;
                }
                default: {
                    throw new InvalidFontException("CFF: invalid float number");
                }
            }
            if (!topNibble) {
                bb.addCard8(b);
                b = 0;
            }
            topNibble = !topNibble;
        }
        if (topNibble) {
            bb.addCard8(255);
        } else {
            bb.addCard8(b | 0xF);
        }
    }

    static {
        NumbersValue numberZero = new NumbersValue(0);
        NumbersValue numberOne = new NumbersValue(1);
        NumbersValue numberTwo = new NumbersValue(2);
        OffsetValue offsetZero = new OffsetValue(0);
        NumbersValue booleanFalse = new NumbersValue(0);
        defaultDict = new HashMap();
        defaultDict.put(Key.isFixedPitch, booleanFalse);
        defaultDict.put(Key.ItalicAngle, numberZero);
        defaultDict.put(Key.UnderlinePosition, new NumbersValue(-100));
        defaultDict.put(Key.UnderlineThickness, new NumbersValue(50));
        defaultDict.put(Key.PaintType, numberTwo);
        defaultDict.put(Key.CharstringType, numberTwo);
        try {
            defaultDict.put(Key.FontMatrix, new NumbersValue(new Object[]{"0.001", "0", "0", "0.001", "0", "0"}));
            defaultDict.put(Key.FontBBox, new NumbersValue(new Object[]{"0", "0", "0", "0"}));
        }
        catch (InvalidFontException e) {
            // empty catch block
        }
        defaultDict.put(Key.StrokeWidth, numberZero);
        defaultDict.put(Key.charset, offsetZero);
        defaultDict.put(Key.Encoding, offsetZero);
        defaultDict.put(Key.BlueScale, new NumbersValue("0.039625"));
        defaultDict.put(Key.BlueShift, new NumbersValue(7));
        defaultDict.put(Key.BlueFuzz, numberOne);
        defaultDict.put(Key.ForceBold, booleanFalse);
        defaultDict.put(Key.LanguageGroup, numberZero);
        defaultDict.put(Key.ExpansionFactor, new NumbersValue("0.06"));
        defaultDict.put(Key.initialRandomSeed, numberZero);
        defaultDict.put(Key.defaultWidthX, numberZero);
        defaultDict.put(Key.nominalWidthX, numberZero);
        defaultDict.put(Key.CIDFontVersion, numberZero);
        defaultDict.put(Key.CIDFontRevision, numberZero);
        defaultDict.put(Key.CIDFontType, numberZero);
        defaultDict.put(Key.CIDCount, new NumbersValue(8720));
        defaultDict.put(Key.ForceBoldThreshold, numberZero);
    }

    private static class ValueStack {
        int count = 0;
        Object[] values = new Object[48];

        private ValueStack() {
        }

        void pushInt(int i) throws InvalidFontException {
            if (this.count == this.values.length) {
                throw new InvalidFontException("CFF Dict stack overflow");
            }
            this.values[this.count] = new Integer(i);
            ++this.count;
        }

        void pushDouble(String s) throws InvalidFontException {
            if (this.count == this.values.length) {
                throw new InvalidFontException("CFF Dict stack overflow");
            }
            this.values[this.count] = s;
            ++this.count;
        }

        int popInt() throws InvalidFontException {
            if (this.count == 0) {
                throw new InvalidFontException("empty CFF Dict stack");
            }
            --this.count;
            if (this.values[this.count] instanceof Integer) {
                return (Integer)this.values[this.count];
            }
            try {
                return (int)Double.parseDouble((String)this.values[this.count]);
            }
            catch (NumberFormatException e) {
                throw new InvalidFontException("Invalid number on stack", e);
            }
        }

        Object popValue() throws InvalidFontException {
            if (this.count == 0) {
                throw new InvalidFontException("empty CFF Dict statck");
            }
            --this.count;
            return this.values[this.count];
        }
    }

    static class StringKey
    extends Key {
        StringKey(int a, int b, String s) {
            super(a, b, s);
        }

        StringKey(int a, String s) {
            super(a, s);
        }

        @Override
        public Value parse(ValueStack s, StringIndex stringIndex) throws InvalidFontException {
            return new StringValue(s, stringIndex);
        }

        @Override
        public boolean compatibleValue(Object o) {
            return o instanceof StringValue;
        }
    }

    static class ROSKey
    extends Key {
        ROSKey(int a, int b, String s) {
            super(a, b, s);
        }

        ROSKey(int a, String s) {
            super(a, s);
        }

        @Override
        public Value parse(ValueStack stack, StringIndex stringIndex) throws InvalidFontException {
            return new ROSValue(stack, stringIndex);
        }

        @Override
        public boolean compatibleValue(Object o) {
            return o instanceof ROSValue;
        }
    }

    static class OffsetSizeKey
    extends Key {
        OffsetSizeKey(int a, int b, String s) {
            super(a, b, s);
        }

        OffsetSizeKey(int a, String s) {
            super(a, s);
        }

        @Override
        public Value parse(ValueStack s, StringIndex stringIndex) throws InvalidFontException {
            return new OffsetSizeValue(s);
        }

        public int streamDummyValue(CFFByteArray.CFFByteArrayBuilder bb) {
            int marker = bb.getSize();
            bb.addCard8(29);
            bb.addCard32(0);
            bb.addCard8(29);
            bb.addCard32(0);
            super.stream(bb);
            return marker;
        }

        public void fixOffset(CFFByteArray.CFFByteArrayBuilder bb, int marker, int offset) {
            bb.setCard32(marker + 6, offset);
        }

        public void fixSize(CFFByteArray.CFFByteArrayBuilder bb, int marker, int size) {
            bb.setCard32(marker + 1, size);
        }

        @Override
        public boolean compatibleValue(Object o) {
            return o instanceof OffsetSizeValue;
        }
    }

    static class OffsetKey
    extends Key {
        OffsetKey(int a, int b, String s) {
            super(a, b, s);
        }

        OffsetKey(int a, String s) {
            super(a, s);
        }

        @Override
        public Value parse(ValueStack s, StringIndex stringIndex) throws InvalidFontException {
            return new OffsetValue(s);
        }

        public int streamDummyValue(CFFByteArray.CFFByteArrayBuilder bb) {
            int marker = bb.getSize();
            bb.addCard8(29);
            bb.addCard32(0);
            this.stream(bb);
            return marker;
        }

        public void fixOffset(CFFByteArray.CFFByteArrayBuilder bb, int marker, int offset) {
            bb.setCard32(marker + 1, offset);
        }

        @Override
        public boolean compatibleValue(Object o) {
            return o instanceof OffsetValue;
        }
    }

    static class NumbersKey
    extends Key {
        final int stackDepth;

        NumbersKey(int a, int b, String s, int stackDepth) {
            super(a, b, s);
            this.stackDepth = stackDepth;
        }

        NumbersKey(int a, String s, int stackDepth) {
            super(a, s);
            this.stackDepth = stackDepth;
        }

        @Override
        public Value parse(ValueStack s, StringIndex stringIndex) throws InvalidFontException {
            return new NumbersValue(s, this.stackDepth);
        }

        @Override
        public boolean compatibleValue(Object o) {
            if (!(o instanceof NumbersValue)) {
                return false;
            }
            if (this.stackDepth != -1) {
                NumbersValue v = (NumbersValue)o;
                return v.values.length == this.stackDepth;
            }
            return true;
        }
    }

    static class IntegerKey
    extends Key {
        IntegerKey(int a, int b, String s) {
            super(a, b, s);
        }

        IntegerKey(int a, String s) {
            super(a, s);
        }

        @Override
        public Value parse(ValueStack s, StringIndex stringIndex) throws InvalidFontException {
            return new IntegerValue(s);
        }

        @Override
        public boolean compatibleValue(Object o) {
            return o instanceof IntegerValue;
        }
    }

    static abstract class Key {
        private final String name;
        private final int opcode1;
        private final int opcode2;
        private static final Key[] nonExtendedKeys = new Key[27];
        private static final Key[] extendedKeys = new Key[39];
        static final StringKey version = new StringKey(0, "version");
        static final StringKey Notice = new StringKey(1, "Notice");
        static final StringKey FullName = new StringKey(2, "FullName");
        static final StringKey FamilyName = new StringKey(3, "FamilyName");
        static final StringKey Weight = new StringKey(4, "Weight");
        static final NumbersKey FontBBox = new NumbersKey(5, "FontBBox", 4);
        static final NumbersKey BlueValues = new NumbersKey(6, "BlueValues", -1);
        static final NumbersKey OtherBlues = new NumbersKey(7, "OtherBlues", -1);
        static final NumbersKey FamilyBlues = new NumbersKey(8, "FamilyBlues", -1);
        static final NumbersKey FamilyOtherBlues = new NumbersKey(9, "FamilyOtherBlues", -1);
        static final NumbersKey StdHW = new NumbersKey(10, "StdHW", 1);
        static final NumbersKey StdVW = new NumbersKey(11, "StdVW", 1);
        static final NumbersKey UniqueID = new NumbersKey(13, "UniqueID", 1);
        static final NumbersKey XUID = new NumbersKey(14, "XUID", -1);
        static final OffsetKey charset = new OffsetKey(15, "charset");
        static final OffsetKey Encoding = new OffsetKey(16, "Encoding");
        static final OffsetKey CharStrings = new OffsetKey(17, "CharStrings");
        static final OffsetSizeKey Private = new OffsetSizeKey(18, "Private");
        static final OffsetKey Subrs = new OffsetKey(19, "Subrs");
        static final NumbersKey defaultWidthX = new NumbersKey(20, "defaultWidthX", 1);
        static final NumbersKey nominalWidthX = new NumbersKey(21, "nominalWidthX", 1);
        static final StringKey Copyright = new StringKey(12, 0, "Copyright");
        static final NumbersKey isFixedPitch = new NumbersKey(12, 1, "isFixedPitch", 1);
        static final NumbersKey ItalicAngle = new NumbersKey(12, 2, "ItalicAngle", 1);
        static final NumbersKey UnderlinePosition = new NumbersKey(12, 3, "UnderlinePosition", 1);
        static final NumbersKey UnderlineThickness = new NumbersKey(12, 4, "UnderlineThickness", 1);
        static final NumbersKey PaintType = new NumbersKey(12, 5, "PainType", 1);
        static final NumbersKey CharstringType = new NumbersKey(12, 6, "CharstringType", 1);
        static final NumbersKey FontMatrix = new NumbersKey(12, 7, "FontMatrix", 6);
        static final NumbersKey StrokeWidth = new NumbersKey(12, 8, "StrokeWidth", 1);
        static final NumbersKey BlueScale = new NumbersKey(12, 9, "BlueScale", 1);
        static final NumbersKey BlueShift = new NumbersKey(12, 10, "BlueShift", 1);
        static final NumbersKey BlueFuzz = new NumbersKey(12, 11, "BlueFuzz", 1);
        static final NumbersKey StemSnapH = new NumbersKey(12, 12, "StemSnapH", -1);
        static final NumbersKey StemSnapV = new NumbersKey(12, 13, "StemSnapV", -1);
        static final NumbersKey ForceBold = new NumbersKey(12, 14, "ForceBold", 1);
        static final NumbersKey ForceBoldThreshold = new NumbersKey(12, 15, "ForceBoldThreshold", 1);
        static final NumbersKey LanguageGroup = new NumbersKey(12, 17, "LanguageGroup", 1);
        static final NumbersKey ExpansionFactor = new NumbersKey(12, 18, "ExpansionFactor", 1);
        static final NumbersKey initialRandomSeed = new NumbersKey(12, 19, "initialRandomSeed", 1);
        static final IntegerKey SyntheticBase = new IntegerKey(12, 20, "SyntheticBase");
        static final StringKey PostScript = new StringKey(12, 21, "PostScript");
        static final StringKey BaseFontName = new StringKey(12, 22, "BaseFontName");
        static final NumbersKey BaseFontBlend = new NumbersKey(12, 23, "BaseFontBlend", -1);
        static final ROSKey ROS = new ROSKey(12, 30, "ROS");
        static final NumbersKey CIDFontVersion = new NumbersKey(12, 31, "CIDFontVersion", 1);
        static final NumbersKey CIDFontRevision = new NumbersKey(12, 32, "CIDFontRevision", 1);
        static final NumbersKey CIDFontType = new NumbersKey(12, 33, "CIDFontType", 1);
        static final IntegerKey CIDCount = new IntegerKey(12, 34, "CIDCount");
        static final NumbersKey UIDBase = new NumbersKey(12, 35, "UIDBase", 1);
        static final OffsetKey FDArray = new OffsetKey(12, 36, "FDArray");
        static final OffsetKey FDSelect = new OffsetKey(12, 37, "FDSelect");
        static final StringKey FontName = new StringKey(12, 38, "FontName");

        private Key(int opcode, String name) {
            this.opcode1 = opcode;
            this.opcode2 = -1;
            this.name = name;
            Key.nonExtendedKeys[opcode] = this;
        }

        private Key(int opcode1, int opcode2, String name) {
            this.opcode1 = opcode1;
            this.opcode2 = opcode2;
            this.name = name;
            Key.extendedKeys[opcode2] = this;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)obj;
            return this.name.equals(otherKey.name) && this.opcode1 == otherKey.opcode1 && this.opcode2 == otherKey.opcode2;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }

        int opCodeLength() {
            if (this.opcode2 == -1) {
                return 1;
            }
            return 2;
        }

        void stream(CFFByteArray.CFFByteArrayBuilder bb) {
            bb.addCard8(this.opcode1);
            if (this.opcode2 != -1) {
                bb.addCard8(this.opcode2);
            }
        }

        abstract Value parse(ValueStack var1, StringIndex var2) throws InvalidFontException;

        abstract boolean compatibleValue(Object var1);
    }

    static class IntegerValue
    implements Value {
        public final int value;

        public IntegerValue(ValueStack s) throws InvalidFontException {
            this.value = s.popInt();
        }

        public IntegerValue(int n) {
            this.value = n;
        }

        @Override
        public void collectStrings(List strings) {
        }

        @Override
        public void stream(CFFByteArray.CFFByteArrayBuilder bb, List strings) {
            Dict.streamInt(bb, this.value);
        }
    }

    static class ROSValue
    implements Value {
        public final ROS ros;

        public ROSValue(ValueStack s, StringIndex stringIndex) throws InvalidFontException {
            int supplement = s.popInt();
            String ordering = stringIndex.getString(s.popInt());
            String registry = stringIndex.getString(s.popInt());
            this.ros = new ROS(registry, ordering, supplement);
        }

        public ROSValue(String registry, String ordering, int supplement) {
            this.ros = new ROS(registry, ordering, supplement);
        }

        @Override
        public void collectStrings(List strings) {
            if (strings.indexOf(this.ros.registry) == -1) {
                strings.add(this.ros.registry);
            }
            if (strings.indexOf(this.ros.ordering) == -1) {
                strings.add(this.ros.ordering);
            }
        }

        @Override
        public void stream(CFFByteArray.CFFByteArrayBuilder bb, List strings) {
            Dict.streamInt(bb, strings.indexOf(this.ros.registry));
            Dict.streamInt(bb, strings.indexOf(this.ros.ordering));
            Dict.streamInt(bb, this.ros.supplement);
        }
    }

    static class OffsetSizeValue
    implements Value {
        public final int size;
        public int offset;

        public OffsetSizeValue(ValueStack s) throws InvalidFontException {
            this.offset = s.popInt();
            this.size = s.popInt();
        }

        @Override
        public void collectStrings(List strings) {
        }

        @Override
        public void stream(CFFByteArray.CFFByteArrayBuilder bb, List strings) {
        }
    }

    static class OffsetValue
    implements Value {
        public final int offset;

        public OffsetValue(ValueStack s) throws InvalidFontException {
            this.offset = s.popInt();
        }

        public OffsetValue(int offset) {
            this.offset = offset;
        }

        @Override
        public void collectStrings(List strings) {
        }

        @Override
        public void stream(CFFByteArray.CFFByteArrayBuilder bb, List strings) {
        }
    }

    static class NumbersValue
    implements Value {
        public final Object[] values;

        public NumbersValue(ValueStack s, int numberOfElements) {
            if (numberOfElements == -1) {
                numberOfElements = s.count;
            }
            this.values = new Object[numberOfElements];
            try {
                for (int i = numberOfElements - 1; i >= 0; --i) {
                    this.values[i] = s.popValue();
                }
            }
            catch (InvalidFontException invalidFontException) {
                // empty catch block
            }
        }

        public NumbersValue(Object[] values) throws InvalidFontException {
            this.values = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] instanceof Integer || values[i] instanceof String || values[i] instanceof Double)) {
                    throw new InvalidFontException("invalid value");
                }
                this.values[i] = values[i];
            }
        }

        public NumbersValue(int[] values) {
            this.values = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.values[i] = new Integer(values[i]);
            }
        }

        public NumbersValue(double[] values) {
            this.values = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.values[i] = new Double(values[i]);
            }
        }

        public NumbersValue(Double d) {
            this.values = new Object[]{d};
        }

        public NumbersValue(Integer i) {
            this.values = new Object[]{i};
        }

        public NumbersValue(int i) {
            this.values = new Object[]{new Integer(i)};
        }

        public NumbersValue(String s) {
            this.values = new Object[]{s};
        }

        public NumbersValue(Matrix m) {
            this.values = new Object[]{new Double(m.a), new Double(m.b), new Double(m.c), new Double(m.d), new Double(m.tx), new Double(m.ty)};
        }

        public NumbersValue(Rect bbox) {
            this.values = new Object[]{new Double(bbox.xmin), new Double(bbox.ymin), new Double(bbox.xmax), new Double(bbox.ymax)};
        }

        @Override
        public void collectStrings(List strings) {
        }

        @Override
        public void stream(CFFByteArray.CFFByteArrayBuilder bb, List strings) throws InvalidFontException {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] instanceof Integer) {
                    Dict.streamInt(bb, (Integer)this.values[i]);
                    continue;
                }
                if (this.values[i] instanceof String) {
                    Dict.streamDouble(bb, (String)this.values[i]);
                    continue;
                }
                double d = (Double)this.values[i];
                int val = (int)d;
                if ((double)val == d) {
                    Dict.streamInt(bb, val);
                    continue;
                }
                Dict.streamDouble(bb, (Double)this.values[i]);
            }
        }

        public int getCount() {
            return this.values.length;
        }

        public double[] getValuesAsDouble() {
            double[] result = new double[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                result[i] = this.values[i] instanceof Integer ? (double)((Integer)this.values[i]).intValue() : (this.values[i] instanceof String ? Double.parseDouble((String)this.values[i]) : (Double)this.values[i]);
            }
            return result;
        }

        public int[] getValuesAsInt() {
            int[] result = new int[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                result[i] = this.values[i] instanceof Integer ? (Integer)this.values[i] : (this.values[i] instanceof String ? Integer.parseInt((String)this.values[i]) : ((Double)this.values[i]).intValue());
            }
            return result;
        }

        public double getFirstValueAsDouble() {
            if (this.values[0] instanceof Integer) {
                return ((Integer)this.values[0]).intValue();
            }
            if (this.values[0] instanceof String) {
                return Double.parseDouble((String)this.values[0]);
            }
            return (Double)this.values[0];
        }
    }

    static class StringValue
    implements Value {
        public final String value;

        public StringValue(ValueStack s, StringIndex stringIndex) throws InvalidFontException {
            this.value = stringIndex.getString(s.popInt());
        }

        public StringValue(String s) {
            this.value = s;
        }

        @Override
        public void collectStrings(List strings) {
            if (strings.indexOf(this.value) == -1) {
                strings.add(this.value);
            }
        }

        @Override
        public void stream(CFFByteArray.CFFByteArrayBuilder bb, List strings) {
            Dict.streamInt(bb, strings.indexOf(this.value));
        }
    }

    static interface Value {
        public void collectStrings(List var1);

        public void stream(CFFByteArray.CFFByteArrayBuilder var1, List var2) throws InvalidFontException;
    }
}

