/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import java.io.IOException;

final class CFFByteArray
extends FontByteArray {
    private CFFByteArray(int size) {
        super(size);
    }

    public CFFByteArray(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer, false);
    }

    protected static final CFFByteArrayBuilder getCFFByteArrayBuilderInstance() {
        return new CFFByteArrayBuilder();
    }

    protected static final CFFByteArrayBuilder getCFFByteArrayBuilderInstance(int size) {
        return new CFFByteArrayBuilder(size);
    }

    protected final int getcard8(int offset) throws InvalidFontException {
        if (offset < 0 || offset >= this.getSize()) {
            throw new InvalidFontException("Invalid index");
        }
        return this.getRawByte(offset);
    }

    protected final int getint8(int offset) throws InvalidFontException {
        if (offset < 0 || offset >= this.getSize()) {
            throw new InvalidFontException("Invalid index");
        }
        return this.getSignedRawByte(offset);
    }

    protected final int getcard16(int offset) throws InvalidFontException {
        return this.getcard8(offset) << 8 | this.getcard8(offset + 1);
    }

    protected final int getint16(int offset) throws InvalidFontException {
        return this.getint8(offset) << 8 | this.getcard8(offset + 1);
    }

    protected final int getcard24(int offset) throws InvalidFontException {
        return this.getcard8(offset) << 16 | this.getcard8(offset + 1) << 8 | this.getcard8(offset + 2);
    }

    protected final long getcard32(int offset) throws InvalidFontException {
        return this.getcard8(offset) << 24 | this.getcard8(offset + 1) << 16 | this.getcard8(offset + 2) << 8 | this.getcard8(offset + 3);
    }

    protected final int getint32(int offset) throws InvalidFontException {
        return this.getint8(offset) << 24 | this.getcard8(offset + 1) << 16 | this.getcard8(offset + 2) << 8 | this.getcard8(offset + 3);
    }

    protected int getOffSize(int offset) throws InvalidFontException {
        return this.getcard8(offset);
    }

    protected int getOffset(int offset, int offSize, String exceptionMsg) throws UnsupportedFontException, InvalidFontException {
        switch (offSize) {
            case 1: {
                return this.getcard8(offset);
            }
            case 2: {
                return this.getcard16(offset);
            }
            case 3: {
                return this.getcard24(offset);
            }
        }
        if (this.getcard8(offset) > 127) {
            throw new UnsupportedFontException(exceptionMsg);
        }
        return (int)this.getcard32(offset);
    }

    static final class CFFByteArrayBuilder
    extends FontByteArray.FontByteArrayBuilder {
        protected CFFByteArrayBuilder() {
            super(new CFFByteArray(1024));
        }

        protected CFFByteArrayBuilder(int size) {
            super(new CFFByteArray(size));
        }

        protected void addCard32(int n) {
            this.appendRawByte((byte)(n >> 24 & 0xFF));
            this.appendRawByte((byte)(n >> 16 & 0xFF));
            this.appendRawByte((byte)(n >> 8 & 0xFF));
            this.appendRawByte((byte)(n & 0xFF));
        }

        protected void addCard24(int n) {
            this.appendRawByte((byte)(n >> 16 & 0xFF));
            this.appendRawByte((byte)(n >> 8 & 0xFF));
            this.appendRawByte((byte)(n & 0xFF));
        }

        protected void addCard16(int n) {
            this.appendRawByte((byte)(n >> 8 & 0xFF));
            this.appendRawByte((byte)(n & 0xFF));
        }

        protected void addCard8(int n) {
            this.appendRawByte((byte)(n & 0xFF));
        }

        protected void addOffset(int offsetSize, int offset) {
            if (offsetSize == 1) {
                this.addCard8(offset);
            } else if (offsetSize == 2) {
                this.addCard16(offset);
            } else if (offsetSize == 3) {
                this.addCard24(offset);
            } else {
                this.addCard32(offset);
            }
        }

        protected void setCard32(int pos, int n) {
            this.setRawByte(pos++, (byte)(n >> 24 & 0xFF));
            this.setRawByte(pos++, (byte)(n >> 16 & 0xFF));
            this.setRawByte(pos++, (byte)(n >> 8 & 0xFF));
            this.setRawByte(pos++, (byte)(n & 0xFF));
        }

        protected void addBytes(byte[] b, int offset, int count) {
            this.append(b, offset, count);
        }

        protected void addBytes(CFFByteArray ba, int offset, int count) throws InvalidFontException {
            this.append(ba, offset, count);
        }

        protected CFFByteArray toCFFByteArray() {
            CFFByteArray retvalue = (CFFByteArray)this.byteArray;
            this.byteArray = null;
            return retvalue;
        }
    }
}

