/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.dynamodb.exceptions;

import coldfusion.cloud.aws.dynamodb.casesensitive.CFHandleCaseSensitiveReturn;
import java.util.Map;

public class CFDynamoDbValidationFailedException
extends RuntimeException {
    private String exceptionMessage;
    private String exceptionCause;
    private String exceptionName;
    private String exceptionCode;
    private String serviceName;
    private Object invalidValue;
    private String key;
    private String apiName;
    private Map exceptionDetails;

    public CFDynamoDbValidationFailedException(String key, Object invalidValue, String apiName) {
        this.invalidValue = invalidValue == null ? new String("NULL") : invalidValue;
        this.apiName = apiName;
        this.key = key;
        this.serviceName = "DynamoDb";
        this.exceptionCause = "An Exception occured while performing " + apiName + " dynamo operation.";
        this.exceptionName = this.getClass().getSimpleName();
        this.exceptionCode = "ValidationFailedException";
        this.exceptionMessage = "Validation failed for key :" + this.key + ". Invalid value \"" + this.invalidValue.toString() + "\" encountered for key : " + this.key + ".";
        this.buildExceptionDetails();
    }

    @Override
    public String getMessage() {
        return this.exceptionMessage;
    }

    public Map getExceptionDetails() {
        return this.exceptionDetails;
    }

    private void buildExceptionDetails() {
        this.exceptionDetails = CFHandleCaseSensitiveReturn.getReturnObject();
        this.exceptionDetails.put("ExceptionMessage", this.exceptionMessage);
        this.exceptionDetails.put("ExceptionCause", this.exceptionCause);
        this.exceptionDetails.put("ExceptionName", this.exceptionName);
        this.exceptionDetails.put("ExceptionCode", this.exceptionCode);
        this.exceptionDetails.put("ServiceName", this.serviceName);
    }
}

