/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob;

import coldfusion.azure.blob.AzureBlobService;
import coldfusion.azure.blob.ContainerAsRootReference;
import coldfusion.azure.blob.ContainerReference;
import coldfusion.azure.blob.config.BlobCloudConfig;
import coldfusion.azure.blob.consumer.CreateContainerRequestConsumer;
import coldfusion.azure.blob.consumer.DeleteContainerRequestConsumer;
import coldfusion.azure.blob.consumer.GenerateContainerSasRequestConsumer;
import coldfusion.azure.blob.exception.AzureBlobApiException;
import coldfusion.azure.blob.request.AbstractAzureBlobRequest;
import coldfusion.azure.blob.request.CreateContainerRequest;
import coldfusion.azure.blob.request.DeleteContainerRequest;
import coldfusion.azure.blob.request.GenerateSasRequest;
import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.CloudMonitoringUtil;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.jsp.PageContext;

@GenerateCFNamedInvoke
public class AzureBlobServiceImpl
implements AzureBlobService,
NamedInvokable {
    private Logger logger = CFLogs.SERVER_LOG;
    private CloudBlobClient client;
    private OperationContext context;
    private ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.AZURE_BLOB.name());
    private static InvokeNamedMethodInvocationMap<AzureBlobServiceImpl> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public AzureBlobServiceImpl(CloudBlobClient blobClient, BlobCloudConfig serviceConfig) {
        this.client = blobClient;
        if (Objects.nonNull(serviceConfig.getOptions())) {
            this.client.setDefaultRequestOptions(serviceConfig.getOptions());
        }
        this.context = serviceConfig.getOpContext();
    }

    @Override
    public ContainerAsRootReference root(String root) {
        RequestMonitorEventProcessor.onFunctionStart((String)"root", (boolean)true);
        String statusCode = "Success";
        try {
            CloudBlobContainer container = this.client.getContainerReference(root);
            ContainerAsRootReference containerAsRootReference = new ContainerAsRootReference(container, this.client, this.context);
            return containerAsRootReference;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while getting container reference ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(AzureBlobServiceImpl.class, (String)"containerNotFound"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"root", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public ContainerAsRootReference root(String root, boolean createIfNotExists) {
        RequestMonitorEventProcessor.onFunctionStart((String)"root", (boolean)true);
        String statusCode = "Success";
        try {
            CloudBlobContainer container = this.client.getContainerReference(root);
            if (createIfNotExists && !container.exists()) {
                container.create();
            }
            ContainerAsRootReference containerAsRootReference = new ContainerAsRootReference(container, this.client, this.context);
            return containerAsRootReference;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while getting container reference ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(AzureBlobServiceImpl.class, (String)"containerNotFound"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"root", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    @Override
    public ContainerAsRootReference createRoot(Map createStruct) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createRoot", (boolean)true);
        String statusCode = "Success";
        try {
            CreateContainerRequest request = new CreateContainerRequest();
            this.filler.fillObject((Object)request, createStruct, (ConsumerMap)new CreateContainerRequestConsumer());
            CloudBlobContainer container = this.client.getContainerReference(request.getContainer());
            if (container.exists()) {
                this.logger.error((Object)(request.getContainer() + " Container Already Exists."));
                throw new ValidationException(request.getContainer() + " Container Already Exists.");
            }
            container.create(request.getPublicAccessType(), request.getOptions(), this.getOperationContext(request));
            ContainerAsRootReference containerAsRootReference = new ContainerAsRootReference(container, this.client, this.context);
            return containerAsRootReference;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while getting container reference ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(AzureBlobServiceImpl.class, (String)"containerNotFound"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createRoot", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public ContainerReference container(String containerName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"container", (boolean)true);
        String statusCode = "Success";
        try {
            CloudBlobContainer container = this.client.getContainerReference(containerName);
            ContainerReference containerReference = new ContainerReference(container, this.client, this.context);
            return containerReference;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while getting container reference ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(AzureBlobServiceImpl.class, (String)"containerNotFound"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"container", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public ContainerReference container(String containerName, boolean createIfNotExists) {
        RequestMonitorEventProcessor.onFunctionStart((String)"container", (boolean)true);
        String statusCode = "Success";
        try {
            CloudBlobContainer container = this.client.getContainerReference(containerName);
            if (createIfNotExists && !container.exists()) {
                container.create();
            }
            ContainerReference containerReference = new ContainerReference(container, this.client, this.context);
            return containerReference;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while getting container reference ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(AzureBlobServiceImpl.class, (String)"containerNotFound"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"container", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public ContainerReference createContainer(Map createStruct) {
        RequestMonitorEventProcessor.onFunctionStart((String)"createContainer", (boolean)true);
        String statusCode = "Success";
        try {
            CreateContainerRequest request = new CreateContainerRequest();
            this.filler.fillObject((Object)request, createStruct, (ConsumerMap)new CreateContainerRequestConsumer());
            CloudBlobContainer container = this.client.getContainerReference(request.getContainer());
            if (container.exists()) {
                this.logger.error((Object)(request.getContainer() + " Container Already Exists."));
                throw new ValidationException(request.getContainer() + " Container Already Exists.");
            }
            container.create(request.getPublicAccessType(), request.getOptions(), this.getOperationContext(request));
            ContainerReference containerReference = new ContainerReference(container, this.client, this.context);
            return containerReference;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while getting container reference ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(AzureBlobServiceImpl.class, (String)"containerNotFound"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"createContainer", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    private OperationContext getOperationContext(AbstractAzureBlobRequest request) {
        return Objects.nonNull(request.getOpContext()) ? request.getOpContext() : this.context;
    }

    @Override
    public List<Struct> listAll() {
        RequestMonitorEventProcessor.onFunctionStart((String)"listAll", (boolean)true);
        LinkedList<Struct> result = new LinkedList<Struct>();
        try {
            Iterable containers = this.client.listContainers();
            containers.forEach(container -> {
                Struct containerStruct = new Struct();
                containerStruct.put((Object)"name", (Object)container.getName());
                result.add(containerStruct);
            });
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while listing container", (Throwable)e);
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listAll", (String)"get", (Object)"listAllContainerError", (TagAttributeList)this.tagAttributeList);
            throw new AzureBlobApiException(RB.getString(AzureBlobService.class, (String)"listAllContainerError"), e);
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"listAll", null, null, (TagAttributeList)this.tagAttributeList);
        return result;
    }

    @Override
    public Struct delete(Object container) {
        if (container instanceof Struct) {
            return this.delete((Map)((Struct)container));
        }
        return this.delete(String.valueOf(container));
    }

    private Struct delete(String rootName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"delete", (boolean)true);
        String statusCode = "Success";
        try {
            this.client.getContainerReference(rootName).delete();
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"success");
            Struct struct = structResponse;
            return struct;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while deleting container", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(AzureBlobServiceImpl.class, (String)"containerDeleteError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"delete", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    private Struct delete(Map struct) {
        RequestMonitorEventProcessor.onFunctionStart((String)"delete", (boolean)true);
        String statusCode = "Success";
        try {
            DeleteContainerRequest request = new DeleteContainerRequest();
            this.filler.fillObject((Object)request, struct, (ConsumerMap)new DeleteContainerRequestConsumer());
            this.client.getContainerReference(request.getContainer()).delete(request.getAccessCondition(), request.getOptions(), this.getOperationContext(request));
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"success");
            Struct struct2 = structResponse;
            return struct2;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while deleting container", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(AzureBlobServiceImpl.class, (String)"containerDeleteError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"delete", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct generateSas(Map sasRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"generateSas", (boolean)true);
        String statusCode = "Success";
        CloudBlobContainer container = null;
        GenerateSasRequest request = new GenerateSasRequest();
        try {
            this.filler.fillObject((Object)request, sasRequest, (ConsumerMap)new GenerateContainerSasRequestConsumer());
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling azure-blob in generateSas, request : " + request.toString()));
            container = this.client.getContainerReference(request.getContainerName());
            String sas = container.generateSharedAccessSignature(request.getPolicy(), request.getGroupPolicyIdentifier(), request.getIpRange(), request.getProtocols());
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to azure-blob ingenerateSas is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"sas", (Object)sas);
            response.put((Object)"status", (Object)"success");
            Struct struct = response;
            return struct;
        }
        catch (StorageException | URISyntaxException | InvalidKeyException e) {
            this.logger.error((Object)"Error occurred in generateSas : ", e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(AzureBlobServiceImpl.class, (String)"generateSasError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in generateSas : ", (Throwable)e);
            statusCode = "Failure";
            throw new AzureBlobApiException(RB.getString(AzureBlobServiceImpl.class, (String)"generateSasError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"generateSas", null, (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        return NamedMethodInvoker2.invoke((Object)this, args);
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"root", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"root"}, args);
                    return obj.root(Cast._String((Object)argColl.get((Object)"root")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"root", "createIfNotExists"}, args);
                    return obj.root(Cast._String((Object)argColl.get((Object)"root")), Cast._boolean((Object)argColl.get((Object)"createIfNotExists")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("root", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createRoot", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"createStruct"}, args);
                    return obj.createRoot((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"createStruct"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createRoot", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"container", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"containerName"}, args);
                    return obj.container(Cast._String((Object)argColl.get((Object)"containerName")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"containerName", "createIfNotExists"}, args);
                    return obj.container(Cast._String((Object)argColl.get((Object)"containerName")), Cast._boolean((Object)argColl.get((Object)"createIfNotExists")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("container", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createContainer", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"createStruct"}, args);
                    return obj.createContainer((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"createStruct"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createContainer", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listAll", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listAll();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listAll", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"delete", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"container"}, args);
                    return obj.delete(argColl.get((Object)"container"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("delete", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"generateSas", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"sasRequest"}, args);
                    return obj.generateSas((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"sasRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("generateSas", obj);
        });
    }
}

