/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.orm.ORMUtils;
import coldfusion.orm.hibernate.CFCMetadataImpl;
import coldfusion.orm.hibernate.HibernateSessionManager;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class CriteriaBuilder {
    private CFCMetadataImpl cfcMetadata;
    private Criteria criteria;

    public CriteriaBuilder(CFCMetadataImpl cfcMetadata, String datasource) {
        this.cfcMetadata = cfcMetadata;
        String entityName = cfcMetadata.getEntityName();
        Session session = HibernateSessionManager.getInstance().getSession(datasource);
        this.criteria = session.createCriteria(entityName);
    }

    public void addFields(Map fieldNameVsValues) {
        Set fields = fieldNameVsValues.entrySet();
        for (Map.Entry field : fields) {
            this.addField((String)field.getKey(), field.getValue());
        }
    }

    public void addField(String fieldName, Object fieldValue) {
        String propertyName = this.cfcMetadata.getPropertyName(fieldName);
        if (propertyName == null) {
            throw new PropertyNotFoundException(fieldName);
        }
        Class typeClass = this.cfcMetadata.getPropertyType(fieldName);
        if ((fieldValue = ORMUtils.getTypedValue(fieldValue, typeClass)) == null) {
            this.criteria.add(Restrictions.isNull((String)propertyName));
        } else {
            this.criteria.add((Criterion)Restrictions.eq((String)propertyName, (Object)fieldValue));
        }
    }

    public void addOrderBy(String orderBy, boolean ignoreCase) {
        String[] orderByEntries;
        for (String orderByEntry : orderByEntries = orderBy.split(",")) {
            String sortOrder;
            String col;
            int index = (orderByEntry = orderByEntry.trim()).indexOf(32);
            if (index != -1) {
                col = orderByEntry.substring(0, index).trim();
                sortOrder = orderByEntry.substring(index + 1).trim();
            } else {
                col = orderByEntry;
                sortOrder = "asc";
            }
            this.addSortOption(col, sortOrder, ignoreCase);
        }
    }

    public void addSortOption(String sortColumn, String sortOrder, boolean ignoreCase) {
        String sortCol = this.cfcMetadata.getPropertyName(sortColumn);
        if (sortCol == null) {
            throw new PropertyNotFoundException(sortColumn);
        }
        Order order = sortOrder.equalsIgnoreCase("desc") ? Order.desc((String)sortCol) : Order.asc((String)sortCol);
        if (ignoreCase) {
            order.ignoreCase();
        }
        this.criteria.addOrder(order);
    }

    public void addOptions(Map options) {
        Object cacheable;
        Object timeout;
        int offsetVal;
        Object offset;
        int maxVal;
        Object max = options.get("maxResults");
        if (max != null && (maxVal = Cast._int(max)) > -1) {
            this.criteria.setMaxResults(maxVal);
        }
        if ((offset = options.get("offset")) != null && (offsetVal = Cast._int(offset)) > -1) {
            this.criteria.setFirstResult(offsetVal);
        }
        if ((timeout = options.get("timeout")) != null) {
            this.criteria.setTimeout(Cast._int(timeout));
        }
        if ((cacheable = options.get("cacheable")) != null) {
            this.criteria.setCacheable(Cast._boolean(cacheable));
            String cacheRegion = (String)options.get("cachename");
            if (cacheRegion != null && cacheRegion.length() != 0) {
                this.criteria.setCacheRegion(cacheRegion);
            }
        }
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public static class PropertyNotFoundException
    extends ApplicationException {
        public String name;

        public PropertyNotFoundException(String name) {
            this.name = name;
        }
    }
}

