/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf.types;

import macromedia.swf.SwfEncoder;

public class Rect {
    public int xMin;
    public int xMax;
    public int yMin;
    public int yMax;

    public Rect(int width, int height) {
        this.xMax = width;
        this.yMax = height;
        this.nbits();
    }

    public Rect() {
    }

    public Rect(int xMin, int xMax, int yMin, int yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
    }

    public String toString() {
        return "" + (this.xMax - this.xMin) + 'x' + (this.yMax - this.yMin);
    }

    public int nbits() {
        int maxCoord = SwfEncoder.maxNum(this.xMin, this.xMax, this.yMin, this.yMax);
        return SwfEncoder.minBits(maxCoord, 1);
    }

    public int getWidth() {
        return this.xMax - this.xMin;
    }

    public int getHeight() {
        return this.yMax - this.yMin;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object instanceof Rect) {
            Rect rect = (Rect)object;
            if (rect.xMin == this.xMin && rect.xMax == this.xMax && rect.yMin == this.yMin && rect.yMax == this.yMax) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode += 1000003 * this.xMin;
        hashCode += 1000003 * this.xMax;
        hashCode += 1000003 * this.yMin;
        return hashCode += 1000003 * this.yMax;
    }
}

