/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf.debug;

import macromedia.swf.Action;
import macromedia.swf.ActionHandler;

public class RegisterRecord
extends Action {
    public int[] registerNumbers;
    public String[] variableNames;
    public int offset;
    int next;

    public RegisterRecord(int offset, int numRegisters) {
        super(258);
        int size = numRegisters;
        this.registerNumbers = new int[size];
        this.variableNames = new String[size];
        this.offset = offset;
        this.next = 0;
    }

    public void addRegister(int regNbr, String variableName) {
        this.registerNumbers[this.next] = regNbr;
        this.variableNames[this.next] = variableName;
        ++this.next;
    }

    public int indexOf(int regNbr) {
        int at = -1;
        int i = 0;
        while (at < 0 && i < this.registerNumbers.length) {
            if (this.registerNumbers[i] == regNbr) {
                at = i;
            }
            ++i;
        }
        return at;
    }

    public void visit(ActionHandler h) {
        h.registerRecord(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.offset);
        sb.append(" ");
        int i = 0;
        while (i < this.registerNumbers.length) {
            sb.append("$" + this.registerNumbers[i] + "='" + this.variableNames[i] + "' ");
            ++i;
        }
        return sb.toString();
    }

    public boolean equals(Object object) {
        boolean isIt = object instanceof RegisterRecord;
        if (isIt) {
            RegisterRecord other = (RegisterRecord)object;
            isIt = super.equals(other);
            int i = 0;
            while (isIt && i < this.registerNumbers.length) {
                isIt = other.registerNumbers[i] == this.registerNumbers[i] && other.variableNames[i] == this.variableNames[i] ? isIt : false;
                ++i;
            }
        }
        return isIt;
    }
}

