/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf.builder.tags;

import java.awt.Color;
import java.io.IOException;
import macromedia.swf.builder.tags.FontBuilder;
import macromedia.swf.builder.tags.TagBuilder;
import macromedia.swf.tags.DefineEditText;
import macromedia.swf.tags.DefineTag;
import macromedia.swf.types.Rect;
import macromedia.util.SwfUtils;

public class EditTextBuilder
implements TagBuilder {
    private DefineEditText tag = new DefineEditText();
    private FontBuilder fontBuilder;

    public EditTextBuilder(FontBuilder builder, float height, boolean useOutlines, boolean readOnly, boolean noSelect) {
        this.tag.height = (int)Math.rint(height * 20.0f);
        if (builder != null) {
            this.fontBuilder = builder;
            this.tag.hasFont = true;
        }
        this.tag.useOutlines = useOutlines;
        this.tag.readOnly = readOnly;
        this.tag.noSelect = noSelect;
    }

    public DefineTag build() {
        this.tag.font = this.fontBuilder.tag;
        if (this.tag.varName == null) {
            this.tag.varName = "";
        }
        if (this.tag.initialText == null) {
            this.tag.initialText = "";
        }
        if (this.tag.bounds == null) {
            this.tag.bounds = new Rect();
        }
        return this.tag;
    }

    public void setAutoSize(boolean b) {
        this.tag.autoSize = b;
    }

    public void setBorder(boolean b) {
        this.tag.border = b;
    }

    public void setVarName(String var) {
        this.tag.varName = var;
    }

    public void setMaxLength(int max) {
        this.tag.hasMaxLength = true;
        this.tag.maxLength = max;
    }

    public void setHtml(boolean b) {
        this.tag.html = b;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.tag.hasTextColor = true;
            this.tag.color = SwfUtils.colorToInt((Color)color);
        }
    }

    public void setLayout(int align, int leftMargin, int rightMargin, int indent, int leading) {
        this.tag.hasLayout = true;
        if (align < 0 || align > 3) {
            throw new RuntimeException("Invalid alignment.");
        }
        this.tag.align = align;
        this.tag.leftMargin = leftMargin;
        this.tag.rightMargin = rightMargin;
        this.tag.ident = indent;
        this.tag.leading = leading;
    }

    public void setBounds(Rect r) {
        this.tag.bounds = r;
    }

    public void setInitialText(String text) throws IOException {
        if (text != null) {
            this.tag.hasText = true;
            this.tag.initialText = text;
            if (this.tag.bounds == null) {
                this.tag.bounds.yMax *= 3;
                this.tag.bounds.xMax *= 2;
            }
        }
    }
}

