/*
 * Decompiled with CFR 0.152.
 */
package macromedia.fonts;

import macromedia.fonts.FontFace;
import macromedia.swf.types.GlyphEntry;
import macromedia.util.IntMapLRUCache;

public abstract class CachedFontFace
extends FontFace {
    protected final int style;
    public static final short GLYPH_CACHE_PURGE = 10;
    public final GlyphCache glyphCache;

    protected CachedFontFace(int maxCachedGlyphs, int style) {
        this.style = style;
        this.glyphCache = new GlyphCache(this, maxCachedGlyphs / 5, maxCachedGlyphs, 10);
    }

    protected abstract GlyphEntry createGlyphEntry(char var1);

    protected abstract GlyphEntry createGlyphEntry(char var1, char var2);

    static class GlyphCache
    extends IntMapLRUCache {
        private CachedFontFace fontFace;

        GlyphCache(CachedFontFace face, int initialSize, int maxSize, int purgeSize) {
            super(initialSize, maxSize, purgeSize);
            this.fontFace = face;
        }

        public Object fetch(int key) {
            char c = (char)key;
            if (this.fontFace.canDisplay(c)) {
                return this.fontFace.createGlyphEntry(c, c);
            }
            return null;
        }
    }
}

