/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.ejalbert;

import com.zerog.util.TemporaryDirectory;
import com.zerog.util.ZGUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class LaunchUnixBrowser
implements Runnable {
    public static final int RETURN_SUCCESS = 0;
    public static final int RETURN_FAILED = 1;
    public static final int RETURN_NOEXEC = 2;
    public static final int RETURN_BADPLATFORM = 3;
    public static final int RETURN_INVALID = -1;
    private String browser;
    private String url;
    private int returnCode;
    private static String NL = "\n";
    private static StringBuffer text = null;

    public LaunchUnixBrowser(String browser, String url) {
        this.setBrowser(browser);
        url = url.replaceAll("\\s", "%20");
        this.setUrl(url);
        this.returnCode = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!ZGUtil.UNIX) {
            LaunchUnixBrowser.debug("can't run a shell script on non unix platform.");
            this.returnCode = 3;
            return;
        }
        String method = "LaunchUnixBrowser::run()- ";
        LaunchUnixBrowser.debug(method + "launching '" + this.getBrowser() + "' @ '" + this.getUrl() + "'");
        File script = null;
        try {
            script = LaunchUnixBrowser.getScriptFile();
            LaunchUnixBrowser.debug(method + "scriptfile is '" + script.getAbsolutePath() + "'");
            LaunchUnixBrowser.writeScript(script);
            LaunchUnixBrowser.debug(method + "script script, executing Runtime.exec()");
            this.returnCode = Runtime.getRuntime().exec(new String[]{"/bin/sh", script.getAbsolutePath(), this.getBrowser(), this.getUrl()}).waitFor();
            LaunchUnixBrowser.debug(method + "Runtime.exec() finished, return code: " + this.returnCode);
        }
        catch (IOException e) {
            this.returnCode = 2;
            LaunchUnixBrowser.error(e.getClass().getName() + ": " + e.getMessage());
        }
        catch (InterruptedException e) {
            this.returnCode = 2;
            LaunchUnixBrowser.error(e.getClass().getName() + ": " + e.getMessage());
        }
        finally {
            if (script != null) {
                script.delete();
            }
        }
    }

    private static void writeScript(File script) throws IOException {
        FileWriter scriptFile = new FileWriter(script);
        scriptFile.write(LaunchUnixBrowser.getText().toCharArray());
        scriptFile.close();
    }

    private static File getScriptFile() {
        return TemporaryDirectory.getSystemInstance().createTemporaryFile("launchBrowser", ".sh");
    }

    private static void debug(String message) {
        System.out.println(message);
    }

    private static void error(String message) {
        System.err.println(message);
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    private static String getText() {
        if (text == null) {
            text = new StringBuffer();
            text.append("#!/bin/sh").append(NL);
            text.append("BROWSER=$1").append(NL);
            text.append("URL=$2").append(NL);
            text.append("EXPR=`echo $PATH | sed 's/:/ /g'`").append(NL);
            text.append("FOUND=0").append(NL);
            text.append("for ITEM in `echo $EXPR`; do").append(NL);
            text.append(" if [ -x \"$ITEM/$BROWSER\" ]; then").append(NL);
            text.append("\t\tFOUND=1").append(NL);
            text.append("       cd $ITEM").append(NL);
            text.append("\t\tBROWSER=`echo \"$ITEM/$BROWSER\"`").append(NL);
            text.append("\t\tbreak").append(NL);
            text.append(" fi").append(NL);
            text.append("done").append(NL);
            text.append("if [ $FOUND = \"0\" ]; then").append(NL);
            text.append(" exit 1").append(NL);
            text.append("fi").append(NL);
            text.append("if [ `uname` = \"SunOS\" -o -d /etc/SuSEconfig ]; then").append(NL);
            text.append("\t$BROWSER $URL &").append(NL);
            text.append(" exit 0").append(NL);
            text.append("fi").append(NL);
            text.append("$BROWSER -remote \"openURL($URL,new-window)\"").append(NL);
            text.append("if [ $? != \"0\" ]; then").append(NL);
            text.append("\t$BROWSER -remote \"openURL($URL)\"").append(NL);
            text.append("\tif [ $? != \"0\" ]; then").append(NL);
            text.append("\t\t$BROWSER $URL &").append(NL);
            text.append("\t\texit 0").append(NL);
            text.append(" fi").append(NL);
            text.append(" exit 0").append(NL);
            text.append("fi").append(NL);
            text.append("exit 0").append(NL);
        }
        return text.toString();
    }
}

