/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.zip;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipCreator {
    private static byte[] aa = new byte[131072];
    private File ab;
    private ZipOutputStream ac = null;
    private boolean ad = true;
    private long ae = 0L;
    private Vector af = new Vector();

    public ZipCreator(File file, boolean bl) throws FileNotFoundException {
        this.ab = file;
        this.ad = bl;
        new File(file.getParent()).mkdirs();
        this.ac = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        this.ae = 0L;
    }

    public void setNotifyWhenDuplicateEntries(boolean bl) {
        this.ad = bl;
    }

    public boolean getNotifyWhenDuplicateEntries() {
        return this.ad;
    }

    public long getSize() {
        return this.ae;
    }

    public File getZipPath() {
        return this.ab;
    }

    public boolean close() {
        try {
            this.closeZip();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void closeZip() throws IOException {
        this.ac.flush();
        this.ac.closeEntry();
        this.ac.close();
    }

    public Flexeraaxv addFile(File file) throws ZipException, IOException {
        Flexeraaxu flexeraaxu = new Flexeraaxu(file.getCanonicalPath(), file);
        return this.addFile(flexeraaxu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Flexeraaxv addFile(Flexeraaxy flexeraaxy) throws ZipException, IOException {
        InputStream inputStream = flexeraaxy.aa();
        if (inputStream != null) {
            try {
                Flexeraaxv flexeraaxv = this.addInputStream(inputStream, flexeraaxy.ad());
                return flexeraaxv;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return this.aa(flexeraaxy.ad());
    }

    public void addFile(File file, long l, long l2) throws ZipException, IOException {
        Flexeraaxu flexeraaxu = new Flexeraaxu(file.getCanonicalPath(), file);
        this.addFile(flexeraaxu, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Flexeraaxv addFile(Flexeraaxy flexeraaxy, long l, long l2) throws ZipException, IOException {
        Flexeraaxy flexeraaxy2 = null;
        if (flexeraaxy instanceof Flexeraaxu) {
            flexeraaxy2 = new Flexeraaxu((Flexeraaxu)flexeraaxy, l, l2);
        } else if (flexeraaxy instanceof Flexeraaxx) {
            flexeraaxy2 = new Flexeraaxx((Flexeraaxx)flexeraaxy, l, l2);
        } else if (flexeraaxy instanceof Flexeraaxy) {
            flexeraaxy2 = flexeraaxy;
        } else {
            System.err.println("Error:- ZipCreator does not handle this type of ZGZipEntry: " + flexeraaxy.getClass().toString());
        }
        InputStream inputStream = null;
        inputStream = flexeraaxy2.aa();
        if (inputStream != null) {
            try {
                Flexeraaxv flexeraaxv = this.ab(inputStream, flexeraaxy2.ad(), l, l2, flexeraaxy.ad().getMethod() == 8);
                return flexeraaxv;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return this.aa(flexeraaxy.ad());
    }

    public void mergeInZip(ZipFile zipFile) throws ZipException, IOException {
        this.mergeInZip(zipFile, true);
    }

    public void mergeInZip(ZipFile zipFile, boolean bl) throws ZipException, IOException {
        if (zipFile.entries() != null) {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
                if (bl) {
                    zipEntry2.setMethod(8);
                } else {
                    zipEntry2.setMethod(0);
                    zipEntry2.setCrc(zipEntry.getCrc());
                    zipEntry2.setSize(zipEntry.getSize());
                }
                if (zipEntry.getTime() != -1L) {
                    zipEntry2.setTime(zipEntry.getTime());
                }
                if (zipEntry.getExtra() != null) {
                    zipEntry2.setExtra(zipEntry.getExtra());
                }
                if (zipEntry.getComment() != null) {
                    zipEntry2.setComment(zipEntry.getComment());
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                this.addInputStream(inputStream, zipEntry2);
                inputStream.close();
            }
        }
    }

    public Flexeraaxv addInputStream(InputStream inputStream, ZipEntry zipEntry) throws ZipException, IOException {
        return this.ab(inputStream, zipEntry, -1L, -1L, false);
    }

    public Flexeraaxv addInputStream(InputStream inputStream, ZipEntry zipEntry, long l) throws ZipException, IOException {
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        if (zipEntry.getExtra() != null) {
            zipEntry2.setExtra(zipEntry.getExtra());
        }
        return this.ab(inputStream, zipEntry2, 0L, l, zipEntry.getMethod() == 8);
    }

    public void addDirectoryContents(String string, File file) throws ZipException, IOException {
        String[] stringArray = file.list();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Flexeraavu flexeraavu = new Flexeraavu(file.getPath() + File.separator + stringArray[i]);
            String string2 = string.toString() + "/" + Flexeraavu.aa(flexeraavu);
            if (flexeraavu.isDirectory()) {
                this.addDirectoryContents(string, flexeraavu);
                this.addFile(flexeraavu);
                continue;
            }
            this.addFile(flexeraavu);
        }
    }

    private Flexeraaxv aa(ZipEntry zipEntry) throws IOException {
        try {
            this.ac.putNextEntry(zipEntry);
            this.ae += zipEntry.getSize();
            this.ac.closeEntry();
            return new Flexeraaxv(0L, 0L, true);
        }
        catch (ZipException zipException) {
            if (zipException.getMessage().indexOf("duplicate") != -1) {
                Flexeraavd.ai("duplicate entry (add directory): " + zipException.getMessage());
                return new Flexeraaxv(0L, 0L, true);
            }
            throw zipException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }

    public Vector getZipEntryNames() {
        return this.af;
    }

    private Flexeraaxv ab(InputStream inputStream, ZipEntry zipEntry, long l, long l2, boolean bl) throws ZipException, IOException {
        boolean bl2 = false;
        Flexeraaxv flexeraaxv = null;
        try {
            this.ac.putNextEntry(zipEntry);
            if (!(zipEntry.isDirectory() || l == 0L && l2 == 0L)) {
                flexeraaxv = l2 == -1L ? this.ac(inputStream) : this.ad(inputStream, l, l2, bl);
                this.af.add(zipEntry.getName());
                Flexeraaxv flexeraaxv2 = flexeraaxv;
                return flexeraaxv2;
            }
            Flexeraaxv flexeraaxv3 = flexeraaxv = new Flexeraaxv(0L, 0L, true);
            return flexeraaxv3;
        }
        catch (ZipException zipException) {
            if (zipException.getMessage().indexOf("duplicate") != -1) {
                Flexeraavd.ai("duplicate entry (add file): " + zipException.getMessage());
                flexeraaxv = new Flexeraaxv(0L, 0L, true);
                if (!this.ad) {
                    bl2 = true;
                    Flexeraaxv flexeraaxv4 = flexeraaxv;
                    return flexeraaxv4;
                }
            }
            throw zipException;
        }
        finally {
            this.ac.flush();
            this.ac.closeEntry();
            if (!bl2) {
                if (zipEntry.getMethod() == 0 && zipEntry.getSize() != -1L) {
                    this.ae += zipEntry.getSize();
                    flexeraaxv.ac(zipEntry.getSize());
                } else if (zipEntry.getMethod() == 8 && zipEntry.getCompressedSize() != -1L) {
                    this.ae += zipEntry.getCompressedSize();
                    flexeraaxv.ac(zipEntry.getCompressedSize());
                }
            }
        }
    }

    private Flexeraaxv ac(InputStream inputStream) throws IOException {
        long l = 0L;
        int n = inputStream.read(aa);
        while (n != -1) {
            l += (long)n;
            this.ac.write(aa, 0, n);
            n = inputStream.read(aa);
        }
        return new Flexeraaxv(l, true);
    }

    private Flexeraaxv ad(InputStream inputStream, long l, long l2, boolean bl) throws IOException {
        int n = 0;
        int n2 = 0;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = l2 - l;
        Deflater deflater = new Deflater();
        this.ac.setLevel(9);
        deflater.setLevel(9);
        int n3 = (int)Math.min(l5, 131072L);
        long l6 = inputStream.skip(l);
        if (l6 != l) {
            System.err.println("Unable to move to requested start point in file");
            throw new IOException("Unable to skip " + l + " bytes into inputstream");
        }
        do {
            if ((n = inputStream.read(aa, 0, (int)Math.min(l5, (long)n3))) >= 0) {
                this.ac.write(aa, 0, n);
                this.ac.flush();
                if (bl) {
                    deflater.reset();
                    deflater.setInput(aa, 0, n);
                    deflater.finish();
                    n2 = deflater.deflate(aa);
                    l5 -= (long)n2;
                    l3 += (long)n;
                    l4 += (long)n2;
                    continue;
                }
                l5 -= (long)n;
                l3 += (long)n;
                l4 += (long)n;
                continue;
            }
            return new Flexeraaxv(l3, l4, true);
        } while (l5 > 0L);
        return new Flexeraaxv(l3, l4, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(File file, String string) throws IOException {
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            ZipEntry zipEntry = new ZipEntry(string);
            this.addInputStream(fileInputStream, zipEntry);
        }
    }
}

