/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.io.hfs;

import com.apple.mrj.macos.libraries.InterfaceLib;
import com.apple.mrj.macos.toolbox.FSSpec;
import com.apple.mrj.macos.toolbox.MacOSError;
import com.apple.mrj.macos.toolbox.Toolbox;
import com.zerog.util.nativelib.macos.MacFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class RSRCFileInputStreamJDi2
extends InputStream
implements InterfaceLib {
    private short refNum = 0;
    private static final byte fsRdPerm = 1;
    private static final byte fsRdWrPerm = 3;
    private static final byte eofErr = -39;
    private boolean encounteredEOF = false;

    public RSRCFileInputStreamJDi2(FSSpec fSSpec) throws IOException {
        this.open(fSSpec);
    }

    public RSRCFileInputStreamJDi2(File file) throws IOException {
        this(file.getPath());
    }

    public RSRCFileInputStreamJDi2(MacFile macFile) throws IOException {
        this((File)macFile);
    }

    public RSRCFileInputStreamJDi2(String string) throws IOException {
        FSSpec fSSpec = new FSSpec(string);
        this.open(fSSpec);
    }

    private void open(FSSpec fSSpec) throws IOException {
        this.open(fSSpec.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(byte[] byArray) throws IOException {
        short[] sArray = new short[1];
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            MacOSError.checkResult(RSRCFileInputStreamJDi2.FSpOpenRF(byArray, (byte)1, sArray));
        }
        this.refNum = sArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.refNum != 0) {
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                MacOSError.checkResult(RSRCFileInputStreamJDi2.FSClose(this.refNum));
            }
            this.refNum = 0;
        }
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n != -1) {
            return byArray[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        short s;
        int[] nArray = new int[1];
        byte[] byArray2 = byArray;
        int n3 = 0;
        nArray[0] = n2;
        if (n > 0) {
            byArray2 = new byte[n2];
        }
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            s = RSRCFileInputStreamJDi2.FSRead(this.refNum, nArray, byArray2);
        }
        if (!this.encounteredEOF) {
            if (s == -39) {
                this.encounteredEOF = true;
            } else {
                MacOSError.checkResult(s);
            }
            n3 = nArray[0];
        } else {
            n3 = -1;
        }
        if (n > 0) {
            System.arraycopy(byArray2, 0, byArray, n, n2);
        }
        return n3;
    }

    private static native short FSRead(short var0, int[] var1, byte[] var2);

    private static native short FSClose(short var0);

    private static native short FSpOpenRF(byte[] var0, byte var1, short[] var2);
}

