/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.util.mrj;

import com.zerog.ia.installer.util.mrj.MRJOSType;
import com.zerog.ia.installer.util.mrj.MRJUtilsHelperException;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MRJUtilsHelper {
    private static Class eioFileManagerClass = null;
    public static final MRJOSType kSystemFolderType = new MRJOSType(1835098995);
    public static final MRJOSType kApplicationsFolderType = new MRJOSType(1634758771);
    public static final MRJOSType kDesktopFolderType = new MRJOSType(1684370283);
    public static final MRJOSType kTrashFolderType = new MRJOSType(1953657704);
    public static final MRJOSType kWhereToEmptyTrashFolderType = new MRJOSType(1701671028);
    public static final MRJOSType kPrintMonitorDocsFolderType = new MRJOSType(1886547572);
    public static final MRJOSType kStartupFolderType = new MRJOSType(1937011316);
    public static final MRJOSType kShutdownFolderType = new MRJOSType(1936221286);
    public static final MRJOSType kAppleMenuFolderType = new MRJOSType(1634561653);
    public static final MRJOSType kControlPanelFolderType = new MRJOSType(1668575852);
    public static final MRJOSType kExtensionFolderType = new MRJOSType(1702392942);
    public static final MRJOSType kFontsFolderType = new MRJOSType(1718578804);
    public static final MRJOSType kPreferencesFolderType = new MRJOSType(1886545254);
    public static final MRJOSType kChewableItemsFolderType = new MRJOSType(1718382196);
    public static final MRJOSType kTemporaryFolderType = new MRJOSType(1952804208);
    public static final MRJOSType kCachedDataFolderType = new MRJOSType(1667326824);
    public static Map<String, MRJOSType> stringToOSTypeMapping = new HashMap<String, MRJOSType>();
    private static boolean isDebug;

    private MRJUtilsHelper() {
    }

    private static void loadRequiredClasses() throws ClassNotFoundException {
        eioFileManagerClass = Class.forName("com.apple.eio.FileManager");
    }

    public static void openURL(String string) throws MRJUtilsHelperException {
        if (string == null || string.isEmpty()) {
            throw new NullPointerException("Invalid URL specified for opening");
        }
        if (eioFileManagerClass == null) {
            throw new NullPointerException("File Manager class for MRJ could not be retrieved");
        }
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        MRJUtilsHelper.callAStaticMethodViaReflection(eioFileManagerClass, "openURL", classArray, new Object[]{string});
    }

    public static File findFolder(MRJOSType mRJOSType) throws MRJUtilsHelperException, FileNotFoundException {
        Object object = MRJUtilsHelper.callAStaticMethodViaReflection(eioFileManagerClass, "findFolder", new Class[]{Integer.TYPE}, new Object[]{mRJOSType.toInt()});
        if (object != null) {
            File file = new File("" + object);
            if (file.exists()) {
                return file;
            }
            throw new FileNotFoundException("Returned file was not found");
        }
        throw new FileNotFoundException("Could not find folder");
    }

    public static File findFolder(short s, MRJOSType mRJOSType) throws MRJUtilsHelperException, FileNotFoundException {
        Object object = MRJUtilsHelper.callAStaticMethodViaReflection(eioFileManagerClass, "findFolder", new Class[]{Short.TYPE, Integer.TYPE}, new Object[]{s, mRJOSType.toInt()});
        if (object != null) {
            File file = new File("" + object);
            if (file.exists()) {
                return file;
            }
            throw new FileNotFoundException("Returned file was not found");
        }
        throw new FileNotFoundException("Could not find folder");
    }

    public static File findFolder(short s, MRJOSType mRJOSType, boolean bl) throws MRJUtilsHelperException, FileNotFoundException {
        Object object = MRJUtilsHelper.callAStaticMethodViaReflection(eioFileManagerClass, "findFolder", new Class[]{Short.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{s, mRJOSType.toInt(), bl});
        if (object != null) {
            File file = new File("" + object);
            if (file.exists()) {
                return file;
            }
            throw new FileNotFoundException("Returned file was not found");
        }
        throw new FileNotFoundException("Could not find folder");
    }

    public static MRJOSType getFileType(File file) throws MRJUtilsHelperException {
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        Object object = MRJUtilsHelper.callAStaticMethodViaReflection(eioFileManagerClass, "getFileType", classArray, new Object[]{file.getAbsolutePath()});
        if (object != null && object instanceof Integer) {
            return new MRJOSType((Integer)object);
        }
        throw new MRJUtilsHelperException("Could not get proper file type");
    }

    public static void setFileType(File file, MRJOSType mRJOSType) throws MRJUtilsHelperException {
        Class[] classArray = new Class[2];
        classArray[0] = String.class;
        classArray[1] = Integer.TYPE;
        MRJUtilsHelper.callAStaticMethodViaReflection(eioFileManagerClass, "setFileType", classArray, new Object[]{file.getAbsolutePath(), mRJOSType.toInt()});
    }

    public static void setFileCreator(File file, MRJOSType mRJOSType) throws MRJUtilsHelperException {
        Class[] classArray = new Class[2];
        classArray[0] = String.class;
        classArray[1] = Integer.TYPE;
        MRJUtilsHelper.callAStaticMethodViaReflection(eioFileManagerClass, "setFileCreator", classArray, new Object[]{file.getAbsolutePath(), mRJOSType.toInt()});
    }

    public static void setFileTypeAndCreator(File file, MRJOSType mRJOSType, MRJOSType mRJOSType2) throws MRJUtilsHelperException {
        Class[] classArray = new Class[3];
        classArray[0] = String.class;
        classArray[1] = Integer.TYPE;
        classArray[2] = Integer.TYPE;
        MRJUtilsHelper.callAStaticMethodViaReflection(eioFileManagerClass, "setFileTypeAndCreator", classArray, new Object[]{file.getAbsolutePath(), mRJOSType.toInt(), mRJOSType2.toInt()});
    }

    public static void setDefaultFileType(MRJOSType mRJOSType) {
    }

    public static void setDefaultFileCreator(MRJOSType mRJOSType) {
    }

    public static MRJOSType getFileCreator(File file) throws MRJUtilsHelperException {
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        Object object = MRJUtilsHelper.callAStaticMethodViaReflection(eioFileManagerClass, "getFileCreator", classArray, new Object[]{file.getAbsolutePath()});
        if (object != null && object instanceof Integer) {
            return new MRJOSType((Integer)object);
        }
        throw new MRJUtilsHelperException("Could not get proper file type");
    }

    private static Object callAStaticMethodViaReflection(Class clazz, String string, Class[] classArray, Object[] objectArray) throws MRJUtilsHelperException {
        try {
            Method method = clazz.getMethod(string, classArray);
            Object object = method.invoke(null, objectArray);
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (isDebug) {
                noSuchMethodException.printStackTrace();
            }
            throw new MRJUtilsHelperException(noSuchMethodException.getMessage());
        }
        catch (SecurityException securityException) {
            if (isDebug) {
                securityException.printStackTrace();
            }
            throw new MRJUtilsHelperException(securityException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            if (isDebug) {
                illegalAccessException.printStackTrace();
            }
            throw new MRJUtilsHelperException(illegalAccessException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (isDebug) {
                illegalArgumentException.printStackTrace();
            }
            throw new MRJUtilsHelperException(illegalArgumentException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (isDebug) {
                invocationTargetException.printStackTrace();
            }
            throw new MRJUtilsHelperException(invocationTargetException.getMessage());
        }
    }

    public static int OSTypeToInt(String string) {
        int n = 0;
        byte[] byArray = new byte[]{0, 0, 0, 0};
        int n2 = string.length();
        if (n2 > 0) {
            if (n2 > 4) {
                n2 = 4;
            }
            string.getBytes(0, n2, byArray, 4 - n2);
        }
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                n <<= 8;
            }
            n |= byArray[i] & 0xFF;
        }
        return n;
    }

    static {
        stringToOSTypeMapping.put("macs", kSystemFolderType);
        stringToOSTypeMapping.put("apps", kApplicationsFolderType);
        stringToOSTypeMapping.put("desk", kDesktopFolderType);
        stringToOSTypeMapping.put("trsh", kTrashFolderType);
        stringToOSTypeMapping.put("empt", kWhereToEmptyTrashFolderType);
        stringToOSTypeMapping.put("prnt", kPrintMonitorDocsFolderType);
        stringToOSTypeMapping.put("strt", kStartupFolderType);
        stringToOSTypeMapping.put("shdf", kShutdownFolderType);
        stringToOSTypeMapping.put("amnu", kAppleMenuFolderType);
        stringToOSTypeMapping.put("cach", kCachedDataFolderType);
        stringToOSTypeMapping.put("temp", kTemporaryFolderType);
        stringToOSTypeMapping.put("flnt", kChewableItemsFolderType);
        stringToOSTypeMapping.put("pref", kPreferencesFolderType);
        stringToOSTypeMapping.put("font", kFontsFolderType);
        stringToOSTypeMapping.put("extn", kExtensionFolderType);
        stringToOSTypeMapping.put("ctrl", kControlPanelFolderType);
        stringToOSTypeMapping.put("macs", kSystemFolderType);
        isDebug = true;
        try {
            MRJUtilsHelper.loadRequiredClasses();
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (isDebug) {
                classNotFoundException.printStackTrace();
            }
            System.err.println("Class com.apple.eio.FileManager failed to load, this could cause several errors in locating directory/magic folders");
        }
    }
}

