/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.util;

import com.zerog.ia.installer.util.BidiUtil;
import com.zerog.ia.installer.util.MnemonicString;
import com.zerog.util.ZGUtil;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.StringTokenizer;

public abstract class BidiUtilBase
implements BidiUtil {
    @Override
    public String applyTextOrientation(String string) {
        return this.applyTextOrientation(string, this.getPreferredOrientation());
    }

    @Override
    public Image flipImage(Image image, Component component, int n, int n2) throws InterruptedException {
        if (null == image || null == component || n < 2 || n2 < 1) {
            return image;
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 1);
        if (!mediaTracker.waitForID(1, 10000L)) {
            return image;
        }
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        if (pixelGrabber.grabPixels() && (pixelGrabber.getStatus() & 0x20) != 0) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n >> 1; ++j) {
                    int n3 = j + i * n;
                    int n4 = BidiUtilBase.aa(j, n) + i * n;
                    int n5 = nArray[n3];
                    nArray[n3] = nArray[n4];
                    nArray[n4] = n5;
                }
            }
        }
        return component.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
    }

    @Override
    public boolean isBidiLocale() {
        return !this.getPreferredOrientation().isLeftToRight();
    }

    @Override
    public ComponentOrientation getPreferredOrientation() {
        return ComponentOrientation.getOrientation(this.getDefaultLocale());
    }

    @Override
    public int resolveJustification(int n) {
        if (!this.getPreferredOrientation().isLeftToRight() && n == 0) {
            return 2;
        }
        if (!this.getPreferredOrientation().isLeftToRight() && n == 2) {
            return 0;
        }
        return n;
    }

    public static int aa(int n, int n2) {
        return n2 - n - 1;
    }

    @Override
    public ComponentOrientation getPreferredOrientation(int n) {
        switch (n) {
            case 1: {
                return ComponentOrientation.LEFT_TO_RIGHT;
            }
            case 2: {
                return ComponentOrientation.RIGHT_TO_LEFT;
            }
        }
        return this.getPreferredOrientation();
    }

    @Override
    public boolean RTL_Oriented(int n) {
        switch (n) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return !this.getPreferredOrientation().isLeftToRight();
    }

    @Override
    public String shapeString(String string, int n) {
        return string;
    }

    @Override
    public char unshapeString(char c, int n) {
        return c;
    }

    @Override
    public boolean isArabicString(String string) {
        return true;
    }

    @Override
    public String unApplyTextOrientation(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            char c = cArray[i];
            if (c == '\u202b' || c == '\u202a') continue;
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getJavaVMVendor() {
        return System.getProperty("java.vm.vendor").toLowerCase();
    }

    @Override
    public String getJavaVMVersion() {
        String string = System.getProperty("java.specification.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (!ZGUtil.isJava9AndAbove()) {
            stringTokenizer.nextToken();
        }
        return stringTokenizer.nextToken();
    }

    @Override
    public boolean isShapedString(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] < '\ufe70') continue;
            if (cArray[i] > '\ufefc') continue;
            return true;
        }
        return false;
    }

    @Override
    public StringBuffer handleBidiString(StringBuffer stringBuffer, int n, boolean bl, char c, MnemonicString mnemonicString) {
        return stringBuffer;
    }

    @Override
    public boolean isCharBeforeBiDiChar(char[] cArray, int n, int n2, boolean bl) {
        return false;
    }
}

