/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.rules;

import com.zerog.ia.installer.InstallPiece;
import com.zerog.ia.installer.Rule;
import com.zerog.ia.installer.util.ClassInfoManager;
import com.zerog.ia.installer.util.VariableFacade;
import com.zerog.ia.installer.util.VariableManager;
import com.zerog.util.IAResourceBundle;
import java.beans.Beans;
import java.util.Hashtable;

public class CompareVariable
extends Rule {
    public static final String DESCRIPTION = IAResourceBundle.getValue("Designer.Rule.CompareVariable.visualName");
    private static VariableFacade ai = VariableFacade.getInstance();
    public static final String GENERIC_RULE_DISP_STRING = "CIAV";
    public String aj = "";
    public String ak = "";
    public String al = "=";

    public CompareVariable() {
        this.generateAndSetRuleId();
    }

    public void setOperandOne(String string) {
        this.aj = string;
    }

    public void setOperandTwo(String string) {
        this.ak = string;
    }

    public void setOperands(String string, String string2) {
        this.setOperandOne(string);
        this.setOperandTwo(string2);
    }

    public void setOperation(String string) {
        this.al = string;
    }

    public String getOperandOne() {
        return this.aj;
    }

    public String getOperandTwo() {
        return this.ak;
    }

    public String getOperation() {
        return this.al;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean resolveAnswer() {
        VariableManager variableManager = VariableManager.getInstance();
        Character c = (Character)VariableManager.supportedOperations.get(this.al);
        if (this.getOperandOne().equals("")) {
            this.setOperandOne("$EMPTY_STRING$");
        }
        if (this.getOperandTwo().equals("")) {
            this.setOperandTwo("$EMPTY_STRING$");
        }
        if (this.getOperandOne() != "") {
            if (this.getOperandTwo() != "") {
                String string = ai.substitute(this.getOperandOne());
                String string2 = ai.substitute(this.getOperandTwo());
                switch (c.charValue()) {
                    case '=': {
                        return variableManager.areEqual(string, string2);
                    }
                    case '!': {
                        return variableManager.areNotEqual(string, string2);
                    }
                    case 'b': {
                        return variableManager.beginsWith(string, string2);
                    }
                    case 'e': {
                        return variableManager.endsWith(string, string2);
                    }
                    case 'c': {
                        return variableManager.subString(string, string2);
                    }
                    case 'd': {
                        if (variableManager.subString(string, string2)) return false;
                        return true;
                    }
                    case 'a': {
                        return variableManager.areEqualIgnoresCase(string, string2);
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        boolean bl = false;
        System.err.println("CompareVariable: You must set the operands before requesting an answer.");
        System.err.println(" Try using $EMPTY_STRING$ or $VARIABLE_NOT_SET$ in your rule.");
        return bl;
    }

    @Override
    public String getVisualNameSelf() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSelf(Hashtable hashtable) {
        if (!Beans.isDesignTime()) {
            return this.resolveAnswer();
        }
        return true;
    }

    public static boolean canBeDisplayed() {
        return Flexeraajj.ae(Flexeraajj.as);
    }

    @Override
    public boolean hasInstallPermissions() {
        return Flexeraajj.ae(Flexeraajj.as);
    }

    public static boolean isCompatibleWith(InstallPiece installPiece) {
        return true;
    }

    public static String[] getSerializableProperties() {
        String[] stringArray = new String[5];
        stringArray[0] = "operation";
        stringArray[1] = "operandOne";
        stringArray[2] = "operandTwo";
        stringArray[3] = "ruleId";
        stringArray[4] = "expressionID";
        return stringArray;
    }

    @Override
    public String[] getExternalizedProperties() {
        String[] stringArray = new String[2];
        stringArray[0] = "operandOne";
        stringArray[1] = "operandTwo";
        return stringArray;
    }

    @Override
    public String getGenericDisplayString() {
        return GENERIC_RULE_DISP_STRING;
    }

    static {
        ClassInfoManager.aa(CompareVariable.class, DESCRIPTION, null);
    }
}

