/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.jvmresolution;

import com.zerog.ia.installer.jvmresolution.JVMFileParseExpection;
import com.zerog.ia.installer.jvmresolution.JVMResolutionFileSpec;
import com.zerog.ia.installer.jvmresolution.JVMResolutionSpecParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;

public class JVMResolutionSpecParserImpl
implements JVMResolutionSpecParser {
    @Override
    public JVMResolutionFileSpec parseJVMFile(File file) throws FileNotFoundException, JVMFileParseExpection {
        if (file == null) {
            throw new FileNotFoundException("The .jvm file passed was null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("The .jvm file passed does not exist");
        }
        JVMResolutionFileSpec jVMResolutionFileSpec = new JVMResolutionFileSpec();
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            block4: while ((string = bufferedReader.readLine()) != null) {
                string = string.trim();
                if (string.startsWith("DESC:")) {
                    jVMResolutionFileSpec.setDescription(string.substring("DESC:".length()).trim());
                    continue;
                }
                if (string.startsWith("JVM_EXE:")) {
                    jVMResolutionFileSpec.setJvmExe(string.substring("JVM_EXE:".length()).trim());
                    continue;
                }
                if (string.startsWith("CLASSPATH_SEPARATOR:")) {
                    jVMResolutionFileSpec.setClasspathSeparator(string.substring("CLASSPATH_SEPARATOR:".length()).trim());
                    continue;
                }
                if (string.startsWith("CLASSPATH:")) {
                    jVMResolutionFileSpec.setClasspath(string.substring("CLASSPATH:".length()).trim());
                    continue;
                }
                if (string.startsWith("SYSTEM_SEPARATOR:")) {
                    jVMResolutionFileSpec.setSystemSeparator(string.substring("SYSTEM_SEPARATOR:".length()).trim());
                    continue;
                }
                if (string.startsWith("SYSTEM:")) {
                    jVMResolutionFileSpec.setSystem(string.substring("SYSTEM:".length()).trim());
                    continue;
                }
                if (string.startsWith("JVM_PROPERTIES:")) {
                    while (string != null) {
                        string = bufferedReader.readLine();
                        if (string.trim().startsWith("/:")) continue block4;
                        if (string == null) continue;
                        jVMResolutionFileSpec.addJVMProperty(string.trim());
                    }
                    continue;
                }
                if (string.startsWith("PATH_HINT:")) {
                    while (string != null) {
                        string = bufferedReader.readLine();
                        if (string.trim().startsWith("/:")) continue block4;
                        if (string == null) continue;
                        jVMResolutionFileSpec.addPathHint(string.trim());
                    }
                    continue;
                }
                if (string.startsWith("PLATFORM_HINT:")) {
                    while (string != null) {
                        string = bufferedReader.readLine();
                        if (string.trim().startsWith("/:")) continue block4;
                        if (string == null) continue;
                        jVMResolutionFileSpec.addPlatformHint(string.trim());
                    }
                    continue;
                }
                if (string.startsWith("VERBOSE_JNI:")) {
                    jVMResolutionFileSpec.setVerboseJni(string.substring("VERBOSE_JNI:".length()).trim());
                    continue;
                }
                if (string.startsWith("VERBOSE_GC:")) {
                    jVMResolutionFileSpec.setVerboseGc(string.substring("VERBOSE_GC:".length()).trim());
                    continue;
                }
                if (string.startsWith("VERBOSE_CLASS:")) {
                    jVMResolutionFileSpec.setVerboseClass(string.substring("VERBOSE_CLASS:".length()).trim());
                    continue;
                }
                if (string.startsWith("VERBOSE:")) {
                    jVMResolutionFileSpec.setVerbose(string.substring("VERBOSE:".length()).trim());
                    continue;
                }
                if (string.startsWith("VERSION:")) {
                    jVMResolutionFileSpec.setVersion(string.substring("VERSION:".length()).trim());
                    continue;
                }
                if (string.startsWith("BOOT_CLASSPATH:")) {
                    jVMResolutionFileSpec.setBootClassPath(string.substring("BOOT_CLASSPATH:".length()).trim());
                    continue;
                }
                if (string.startsWith("NO_CLASS_GC:")) {
                    jVMResolutionFileSpec.setNoClassGc(string.substring("NO_CLASS_GC:".length()).trim());
                    continue;
                }
                if (string.startsWith("INIT_JAVA_HEAP:")) {
                    jVMResolutionFileSpec.setInitJavaHeap(string.substring("INIT_JAVA_HEAP:".length()).trim());
                    continue;
                }
                if (string.startsWith("MAX_JAVA_HEAP:")) {
                    jVMResolutionFileSpec.setMaxJavaHeap(string.substring("MAX_JAVA_HEAP:".length()).trim());
                    continue;
                }
                if (string.startsWith("REDUCE_OS_SIGNALS:")) {
                    jVMResolutionFileSpec.setReduceOsSignals(string.substring("REDUCE_OS_SIGNALS:".length()).trim());
                    continue;
                }
                if (string.startsWith("CHECK_JNI:")) {
                    jVMResolutionFileSpec.setCheckJni(string.substring("CHECK_JNI:".length()).trim());
                    continue;
                }
                if (string.startsWith("RUNHPROF_HELP:")) {
                    jVMResolutionFileSpec.setRunHprofHelp(string.substring("RUNHPROF_HELP:".length()).trim());
                    continue;
                }
                if (string.startsWith("RUNHPROF_OPTION:")) {
                    jVMResolutionFileSpec.setRunHprofOption(string.substring("RUNHPROF_OPTION:".length()).trim());
                    continue;
                }
                if (string.startsWith("DEBUG:")) {
                    jVMResolutionFileSpec.setDebug(string.substring("DEBUG:".length()).trim());
                    continue;
                }
                if (string.startsWith("FUTURE:")) {
                    jVMResolutionFileSpec.setFuture(string.substring("FUTURE:".length()).trim());
                    continue;
                }
                if (string.trim().equals("")) continue;
                System.err.println("Error found while parsing line= " + string.trim());
                throw new JVMFileParseExpection("Unrecogonized tag in parsing .jvm file " + file.getAbsolutePath());
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw new JVMFileParseExpection(iOException);
        }
        catch (JVMFileParseExpection jVMFileParseExpection) {
            throw jVMFileParseExpection;
        }
        catch (NullPointerException nullPointerException) {
            throw new JVMFileParseExpection(nullPointerException);
        }
        return jVMResolutionFileSpec;
    }
}

