/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.consoles;

import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.Uninstaller;
import com.zerog.ia.installer.installpanels.ProgressActionPanel;
import com.zerog.util.ZGSys;

public class UninstallRollbackConsoleUI {
    private int percentDone = 0;
    private int progressShown = 0;
    private float rollbackStarted = 0.0f;

    public void executeConsoleAction(Installer installer) {
        Uninstaller.getInstance().uninstall(installer);
    }

    public boolean setup() {
        this.addUninstallListener();
        return true;
    }

    private void addUninstallListener() {
        Uninstaller.getInstance().addUninstallListener(new Flexeraakv(){
            private int aa;

            @Override
            public void categoryStarted(Flexeraaku flexeraaku) {
                this.aa = 0;
                UninstallRollbackConsoleUI.this.showUninstallCategoryStart();
            }

            @Override
            public void categoryPercentDone(Flexeraaku flexeraaku) {
                UninstallRollbackConsoleUI.this.incrementPercentDone(flexeraaku.aa() - this.aa);
                if (flexeraaku.aa() > this.aa) {
                    this.aa = flexeraaku.aa();
                }
            }

            @Override
            public void displayTextChanged(Flexeraaku flexeraaku) {
            }

            @Override
            public void productUninstalled(Flexeraaku flexeraaku) {
                UninstallRollbackConsoleUI.this.showUninstallProgress();
            }

            @Override
            public void exceptionOccurred(Flexeraaku flexeraaku) {
            }

            @Override
            public void uninstallerExited(Flexeraaku flexeraaku) {
                ProgressActionPanel.getInstanceIfInstantiated().progressBar.setValue(0);
                UninstallRollbackConsoleUI.this.showUninstallProgressComplete();
            }
        });
    }

    private void incrementPercentDone(int n) {
        this.percentDone += n;
        while (this.percentDone > this.progressShown) {
            if (this.progressShown % 25 == 0) {
                ZGSys.aa.println("*");
            } else {
                ZGSys.aa.print("*");
            }
            ++this.progressShown;
        }
    }

    private void showUninstallProgressComplete() {
        ZGSys.aa.println(" -]");
    }

    private void showUninstallProgress() {
        ZGSys.aa.println("*");
    }

    private void showUninstallCategoryStart() {
        ZGSys.aa.println("");
        ZGSys.aa.println("...*");
    }

    private void showUninstallProgressStart() {
        ZGSys.aa.println("[- *");
    }
}

