/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.designer.jaxb.schema;

import com.zerog.ia.designer.build.BuildSettings;
import com.zerog.ia.designer.gui.FontChooserImporter;
import com.zerog.ia.designer.jaxb.ColorSettingsType;
import com.zerog.ia.designer.jaxb.FontSettingsType;
import com.zerog.ia.designer.jaxb.IAThemeConfigurationType;
import com.zerog.ia.designer.jaxb.InnerFrameBGColorSettingsType;
import com.zerog.ia.designer.jaxb.InnerInstallerConfigType;
import com.zerog.ia.designer.jaxb.InstallerStepsConfigType;
import com.zerog.ia.designer.jaxb.ObjectFactory;
import com.zerog.ia.designer.jaxb.OuterFrameBGImageSettingsType;
import com.zerog.ia.designer.jaxb.OuterInstallerConfigType;
import com.zerog.ia.designer.jaxb.ProgressBarConfigType;
import com.zerog.ia.designer.jaxb.RuntimeButtonConfigType;
import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.util.InstallFrameConfigurator;
import com.zerog.util.IAResourceBundle;
import com.zerog.util.ZGUtil;
import com.zerog.util.zip.ZipCreator;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class Marshal_IAThemeConfig {
    public static final String BACKGROUND_IMAGE = "backgroundImage";
    private static final String IA_INSTALLED_DIR = ZGUtil.getResourceDirectory().getAbsolutePath();
    private static final String IMAGE_DEFAULTS = IA_INSTALLED_DIR + File.separator + "image_defaults" + File.separator;
    private static final String THEME_XSD_lOCATION = IA_INSTALLED_DIR + File.separator + "ia_theme_configuration" + File.separator + "ia_theme_config.xsd";
    public static final String IMAGES = "Images";
    public static final String MINIMIZE_BUTTON = "minimizeButton";
    public static final String CLOSE_BUTTON = "closeButton";
    public static final String LABEL_BACKGROUND = "labelBackground";
    public static final String IMAGES_BACKGROUND = "imagesBackground";
    public static final String CURRENT_ICON = "currentIcon";
    public static final String PREVIOUS_ICON = "previousIcon";
    public static final String UPCOMING_ICON = "upcomingIcon";
    public static final String PROGRESS_IMAGE = "progressImage";
    public static final String FONTS = "Fonts";
    public static final String INNER_FRAME = "innerFrame";
    public static final String OUTER_FRAME = "outerFrame";
    public static final String ACTIVE_FONT = "activeFont";
    public static final String COMPLETED_FONT = "completedFont";
    public static final String UPCOMING_FONT = "upcomingFont";
    public static final String FONT_FILE_FORMAT = ".ttf";
    public static final String IA_THEME_EXTN = ".ia_theme";
    private static final String TEMP_FOLDER = "temp";
    public static final String PREVIOUS_LABEL = "previousLabel";
    public static final String PRIVATE_LABEL = "privateLabel";
    public static final String IA_THEME_CONFIGURATION_FILE = "ia_theme_configuaration.xml";
    private static final String CONTENTS = "_contents";

    public static void saveIATheme(Installer installer, String[] stringArray) throws JAXBException {
        String string;
        File file;
        String string2;
        String string3 = stringArray[0];
        String string4 = string2 = string3 + File.separator + stringArray[1];
        File file2 = new File(string2);
        if (!file2.exists()) {
            file2.mkdir();
        }
        if (!(file = new File(string = file2.getAbsolutePath() + File.separator + stringArray[1] + CONTENTS)).exists()) {
            file.mkdir();
        }
        File file3 = new File(file.getAbsolutePath() + File.separator + IA_THEME_CONFIGURATION_FILE);
        Schema schema = Marshal_IAThemeConfig.addXSDSchema();
        Class[] classArray = new Class[1];
        classArray[0] = IAThemeConfigurationType.class;
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classArray);
        ObjectFactory objectFactory = new ObjectFactory();
        IAThemeConfigurationType iAThemeConfigurationType = objectFactory.createIAThemeConfigurationType();
        Marshal_IAThemeConfig.addDataOfIFC(installer, file.getAbsolutePath(), objectFactory, iAThemeConfigurationType);
        JAXBElement<IAThemeConfigurationType> jAXBElement = objectFactory.createIathemeconfiguaration(iAThemeConfigurationType);
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setSchema(schema);
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal(jAXBElement, file3);
        Marshal_IAThemeConfig.exportAsZipFile(stringArray, string4, file2);
    }

    public static void addDataOfIFC(Installer installer, String string, ObjectFactory objectFactory, IAThemeConfigurationType iAThemeConfigurationType) {
        Marshal_IAThemeConfig.addDataOfInnerInstallConfig(objectFactory, iAThemeConfigurationType, installer, string);
        Marshal_IAThemeConfig.addDataOfInstallerStepsConfig(objectFactory, iAThemeConfigurationType, installer, string);
        Marshal_IAThemeConfig.addDataOfOuterInstallConfig(objectFactory, iAThemeConfigurationType, installer, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportAsZipFile(String[] stringArray, String string, File file) {
        File file2 = null;
        try {
            file2 = new File(string + File.separator + stringArray[1] + IA_THEME_EXTN);
            if (file2.exists()) {
                Marshal_IAThemeConfig.deleteFileOrDirectory(file2);
            } else {
                file2 = new File(string + File.separator + stringArray[1] + IA_THEME_EXTN);
            }
            try (ZipCreator zipCreator = new ZipCreator(file2, false);){
                Marshal_IAThemeConfig.makeZipEntries(zipCreator, file, stringArray[1]);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Cannot create theme configuration file");
        }
    }

    private static void makeZipEntries(ZipCreator zipCreator, File file, String string) throws ZipException, IOException {
        String[] stringArray;
        for (String string2 : stringArray = file.list()) {
            if (string2.endsWith(IA_THEME_EXTN)) continue;
            String string3 = file + File.separator + string2;
            if (new File(string3).isDirectory()) {
                Marshal_IAThemeConfig.makeZipEntries(zipCreator, new File(string3), string);
                continue;
            }
            String string4 = string3.substring(string3.lastIndexOf(string + CONTENTS));
            zipCreator.addFile(new Flexeraaxu(string4, 8, -1L, new File(string3)), -1L, -1L);
        }
    }

    private static void copyImage(String string, String string2, String string3, String string4) {
        String string5 = ZGUtil.makeFileSourcePath(string3, string2);
        try {
            if (new File(string5).exists() && new File(string5).isAbsolute()) {
                Marshal_IAThemeConfig.copyFileUsingChannel(new File(new File(string5).getAbsolutePath()), new File(string), string2, string4);
            } else if (string5.startsWith("com")) {
                Marshal_IAThemeConfig.copyFileUsingChannel(new File(new File(IMAGE_DEFAULTS + string5).getAbsolutePath()), new File(string), string2, string4);
            }
        }
        catch (Exception exception) {
            System.err.println("Image not copied");
        }
    }

    private static void copyFileUsingChannel(File file, File file2, String string, String string2) throws IOException, FileNotFoundException {
        File file3 = new File(file2.getAbsolutePath() + File.separator + IMAGES);
        if (!file3.exists()) {
            file3.mkdir();
        }
        File file4 = new File(file3.getAbsolutePath() + File.separator + string2);
        File file5 = new File(file4.getAbsolutePath() + File.separator + string);
        if (!file.getAbsolutePath().equalsIgnoreCase(file5.getAbsolutePath())) {
            if (!file4.exists()) {
                file4.mkdir();
            } else if (Marshal_IAThemeConfig.deleteFileOrDirectory(file4)) {
                file4 = new File(file3.getAbsolutePath() + File.separator + string2);
                file4.mkdir();
            }
            if (!file5.exists()) {
                file5.createNewFile();
            }
            Marshal_IAThemeConfig.copyFile(file, file5);
        }
    }

    public static boolean deleteFileOrDirectory(File file) {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                Marshal_IAThemeConfig.deleteFileOrDirectory(new File(file.getAbsolutePath(), stringArray[i]));
            }
        }
        if (!file.delete()) {
            System.err.println("Unable to delete: " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2) throws FileNotFoundException, IOException {
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
    }

    private static void addDataOfOuterInstallConfig(ObjectFactory objectFactory, IAThemeConfigurationType iAThemeConfigurationType, Installer installer, String string) {
        InstallFrameConfigurator installFrameConfigurator = installer.getInstallFrameConfigurator();
        OuterInstallerConfigType outerInstallerConfigType = objectFactory.createOuterInstallerConfigType();
        OuterFrameBGImageSettingsType outerFrameBGImageSettingsType = objectFactory.createOuterFrameBGImageSettingsType();
        outerFrameBGImageSettingsType.setUseBackgroundImage(installFrameConfigurator.getUseBackgroundImage());
        String string2 = installer.getInstallFrameConfigurator().getBackgroundImageName();
        String string3 = installer.getInstallFrameConfigurator().getBackgroundImagePath();
        if (string != null) {
            outerFrameBGImageSettingsType.setFilePath(installFrameConfigurator.getBackgroundImageName());
            Marshal_IAThemeConfig.copyImage(string, string2, string3, BACKGROUND_IMAGE);
        } else {
            outerFrameBGImageSettingsType.setFilePath(string3 + string2);
        }
        OuterFrameBGImageSettingsType.ScaleToFit scaleToFit = objectFactory.createOuterFrameBGImageSettingsTypeScaleToFit();
        scaleToFit.setHeight(installFrameConfigurator.getFitBackgroundImageVertically());
        scaleToFit.setWidth(installFrameConfigurator.getFitBackgroundImageHorizontally());
        outerFrameBGImageSettingsType.setScaleToFit(scaleToFit);
        boolean bl = installFrameConfigurator.getMirrorBidiImage() == "2";
        outerFrameBGImageSettingsType.setMirrorForRTL(bl);
        outerInstallerConfigType.setBackgroundimagesettings(outerFrameBGImageSettingsType);
        FontSettingsType fontSettingsType = objectFactory.createFontSettingsType();
        fontSettingsType.setFontColor(Marshal_IAThemeConfig.getColorStringFormat(installFrameConfigurator.getTitleTextColorRGB()));
        fontSettingsType.setFontFamily(installFrameConfigurator.getTitleTextFontName());
        if (string != null) {
            Marshal_IAThemeConfig.exportFont(string, fontSettingsType, installFrameConfigurator.getTitleTextFontName(), OUTER_FRAME);
        }
        fontSettingsType.setFontSize(installFrameConfigurator.getTitleTextFontSize());
        fontSettingsType.setFontStyle(Marshal_IAThemeConfig.getFontStyle(installFrameConfigurator.getTitleTextFontStyle()));
        fontSettingsType.setUsedefault(installFrameConfigurator.getUseSystemTitleTextColorRGB());
        outerInstallerConfigType.setFontsettings(fontSettingsType);
        outerInstallerConfigType.setBeveledLogo(installFrameConfigurator.getZerogBannerUI());
        OuterInstallerConfigType.InstallerSize installerSize = objectFactory.createOuterInstallerConfigTypeInstallerSize();
        installerSize.setHeight(installFrameConfigurator.getInstallFrameHeight());
        installerSize.setWidth(installFrameConfigurator.getInstallFrameWidth());
        outerInstallerConfigType.setInstallerSize(installerSize);
        OuterInstallerConfigType.FrameLessWindow frameLessWindow = objectFactory.createOuterInstallerConfigTypeFrameLessWindow();
        frameLessWindow.setUseFrameLess(installFrameConfigurator.isDisplayFramelessWindow());
        if (string != null) {
            frameLessWindow.setMinimizeButtonPath(installFrameConfigurator.getMinimzeBttnImageName());
            Marshal_IAThemeConfig.copyImage(string, installFrameConfigurator.getMinimzeBttnImageName(), installFrameConfigurator.getMinimizeBttnImagePath(), MINIMIZE_BUTTON);
        } else {
            frameLessWindow.setMinimizeButtonPath(installFrameConfigurator.getMinimizeBttnImagePath() + installFrameConfigurator.getMinimzeBttnImageName());
        }
        if (string != null) {
            frameLessWindow.setCloseButtonPath(installFrameConfigurator.getCloseBttnImageName());
            Marshal_IAThemeConfig.copyImage(string, installFrameConfigurator.getCloseBttnImageName(), installFrameConfigurator.getCloseBttnImagePath(), CLOSE_BUTTON);
        } else {
            frameLessWindow.setCloseButtonPath(installFrameConfigurator.getCloseBttnImagePath() + installFrameConfigurator.getCloseBttnImageName());
        }
        outerInstallerConfigType.setFrameLessWindow(frameLessWindow);
        iAThemeConfigurationType.setOuterinstallerconfig(outerInstallerConfigType);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addDataOfInstallerStepsConfig(ObjectFactory objectFactory, IAThemeConfigurationType iAThemeConfigurationType, Installer installer, String string) {
        InstallerStepsConfigType installerStepsConfigType;
        InstallFrameConfigurator installFrameConfigurator;
        block22: {
            block20: {
                block21: {
                    installFrameConfigurator = installer.getInstallFrameConfigurator();
                    installerStepsConfigType = objectFactory.createInstallerStepsConfigType();
                    if (!installFrameConfigurator.isShowInstallerStepLabels()) break block20;
                    if (installFrameConfigurator.getDecorationType() == 1) break block21;
                    if (installFrameConfigurator.getDecorationType() != 2) break block20;
                }
                installerStepsConfigType.setShowInstallerSteps("yes");
                if (installFrameConfigurator.getDecorationType() == 1) {
                    installerStepsConfigType.setInstallerStepsType("images");
                    break block22;
                } else if (installFrameConfigurator.getDecorationType() == 2) {
                    installerStepsConfigType.setInstallerStepsType("listofinstallersteps");
                }
                break block22;
            }
            if (installFrameConfigurator.isShowInstallerStepLabels()) {
                installerStepsConfigType.setShowInstallerSteps("no");
                installerStepsConfigType.setInstallerStepsType("listofinstallersteps");
            } else {
                installerStepsConfigType.setShowInstallerSteps("hide");
                installerStepsConfigType.setInstallerStepsType("listofinstallersteps");
            }
        }
        installerStepsConfigType.setEnableUninstallerLabelSetting(installFrameConfigurator.getEnableUninstallerLabelSetting());
        InstallerStepsConfigType.InstallerStepsPanel installerStepsPanel = objectFactory.createInstallerStepsConfigTypeInstallerStepsPanel();
        installerStepsPanel.setBeveledBorder(installFrameConfigurator.getBevelDecoration());
        installerStepsPanel.setScaleWidth(installFrameConfigurator.getResizePanelDecorations());
        InstallerStepsConfigType.InstallerStepsPanel.Backgroundcolorsettings backgroundcolorsettings = objectFactory.createInstallerStepsConfigTypeInstallerStepsPanelBackgroundcolorsettings();
        backgroundcolorsettings.setBackgroundColorType(installFrameConfigurator.getInstallStepsBackgroundSettings().getBehavior());
        backgroundcolorsettings.setColor(Marshal_IAThemeConfig.getColorStringFormat(installFrameConfigurator.getInstallStepsBackgroundSettings().getColorRGB()));
        backgroundcolorsettings.setUseBackgroundColor(installFrameConfigurator.getUseSystemBackgroundColorForInstallLabels());
        installerStepsPanel.setBackgroundcolorsettings(backgroundcolorsettings);
        installerStepsConfigType.setInstallerStepsPanel(installerStepsPanel);
        InstallerStepsConfigType.PanelImage panelImage = objectFactory.createInstallerStepsConfigTypePanelImage();
        panelImage.setUseSpecifiedImage(installFrameConfigurator.getUseLabelBackgroundImage());
        if (string != null) {
            Marshal_IAThemeConfig.copyImage(string, installFrameConfigurator.getLabelBackgroundImageName(), installFrameConfigurator.getLabelBackgroundImagePath(), LABEL_BACKGROUND);
        }
        if (string != null) {
            Marshal_IAThemeConfig.copyImage(string, installer.getPanelImageName(), installer.getPanelImagePath(), IMAGES_BACKGROUND);
        }
        Object object = null;
        object = string != null ? (installFrameConfigurator.getDecorationType() == 2 ? installFrameConfigurator.getLabelBackgroundImageName() : installer.getPanelImageName()) : (installFrameConfigurator.getDecorationType() == 2 ? installFrameConfigurator.getLabelBackgroundImagePath() + installFrameConfigurator.getLabelBackgroundImageName() : installer.getPanelImagePath() + installer.getPanelImageName());
        panelImage.setFilePath((String)object);
        panelImage.setScaleHeight(installFrameConfigurator.isInstallerStepsScaleHeight());
        InstallerStepsConfigType.PanelImage.ConfigureLabels configureLabels = objectFactory.createInstallerStepsConfigTypePanelImageConfigureLabels();
        Vector vector = installer.getOrderedInstallLabels();
        String string2 = Marshal_IAThemeConfig.getLabelList(vector);
        configureLabels.setLabelList(string2);
        configureLabels.setAutoPopulate(((BuildSettings)installer.getBuildSettings()).getAutoPopulateLabelsOnSave());
        configureLabels.setTopOfOffset(installFrameConfigurator.getInstallerStepTopOffSetValue());
        configureLabels.setLabelTextWrap(installFrameConfigurator.getAllowLabelTextToWrap());
        configureLabels.setAllowVerticalScroll(installFrameConfigurator.getAllowVerticalScroll());
        FontSettingsType fontSettingsType = objectFactory.createFontSettingsType();
        fontSettingsType.setFontColor(Marshal_IAThemeConfig.getColorStringFormat(installFrameConfigurator.getChooseCurrentFontColorIntValue()));
        fontSettingsType.setFontFamily(installFrameConfigurator.getChooseCurrentFontName());
        if (string != null) {
            Marshal_IAThemeConfig.exportFont(string, fontSettingsType, installFrameConfigurator.getChooseCurrentFontName(), ACTIVE_FONT);
        }
        fontSettingsType.setFontSize(installFrameConfigurator.getChooseCurrentFontSize());
        fontSettingsType.setFontStyle(Marshal_IAThemeConfig.getFontStyle(installFrameConfigurator.getChooseCurrentFontStyle()));
        InstallerStepsConfigType.PanelImage.ConfigureLabels.ActiveStep activeStep = objectFactory.createInstallerStepsConfigTypePanelImageConfigureLabelsActiveStep();
        if (string != null) {
            activeStep.setIconImagePath(installFrameConfigurator.getCurrentLabelIconName());
            Marshal_IAThemeConfig.copyImage(string, installFrameConfigurator.getCurrentLabelIconName(), installFrameConfigurator.getCurrentLabelIconPath(), CURRENT_ICON);
        } else {
            activeStep.setIconImagePath(installFrameConfigurator.getCurrentLabelIconPath() + installFrameConfigurator.getCurrentLabelIconName());
        }
        activeStep.setFontsettings(fontSettingsType);
        configureLabels.setActiveStep(activeStep);
        FontSettingsType fontSettingsType2 = objectFactory.createFontSettingsType();
        fontSettingsType2.setFontColor(Marshal_IAThemeConfig.getColorStringFormat(installFrameConfigurator.getChoosePreviousFontColorIntValue()));
        fontSettingsType2.setFontFamily(installFrameConfigurator.getChoosePreviousFontName());
        if (string != null) {
            Marshal_IAThemeConfig.exportFont(string, fontSettingsType2, installFrameConfigurator.getChoosePreviousFontName(), COMPLETED_FONT);
        }
        fontSettingsType2.setFontSize(installFrameConfigurator.getChoosePreviousFontSize());
        fontSettingsType2.setFontStyle(Marshal_IAThemeConfig.getFontStyle(installFrameConfigurator.getChoosePreviousFontStyle()));
        InstallerStepsConfigType.PanelImage.ConfigureLabels.CompletedStep completedStep = objectFactory.createInstallerStepsConfigTypePanelImageConfigureLabelsCompletedStep();
        if (string != null) {
            completedStep.setIconImagePath(installFrameConfigurator.getPreviousLabelIconName());
            Marshal_IAThemeConfig.copyImage(string, installFrameConfigurator.getPreviousLabelIconName(), installFrameConfigurator.getPreviousLabelIconPath(), PREVIOUS_ICON);
        } else {
            completedStep.setIconImagePath(installFrameConfigurator.getPreviousLabelIconPath() + installFrameConfigurator.getPreviousLabelIconName());
        }
        completedStep.setFontsettings(fontSettingsType2);
        configureLabels.setCompletedStep(completedStep);
        FontSettingsType fontSettingsType3 = objectFactory.createFontSettingsType();
        fontSettingsType3.setFontColor(Marshal_IAThemeConfig.getColorStringFormat(installFrameConfigurator.getChooseFutureFontColorIntValue()));
        fontSettingsType3.setFontFamily(installFrameConfigurator.getChooseFutureFontName());
        if (string != null) {
            Marshal_IAThemeConfig.exportFont(string, fontSettingsType3, installFrameConfigurator.getChooseFutureFontName(), UPCOMING_FONT);
        }
        fontSettingsType3.setFontSize(installFrameConfigurator.getChooseFutureFontSize());
        fontSettingsType3.setFontStyle(Marshal_IAThemeConfig.getFontStyle(installFrameConfigurator.getChooseFutureFontStyle()));
        InstallerStepsConfigType.PanelImage.ConfigureLabels.UpcomingStep upcomingStep = objectFactory.createInstallerStepsConfigTypePanelImageConfigureLabelsUpcomingStep();
        if (string != null) {
            upcomingStep.setIconImagePath(installFrameConfigurator.getFutureLabelIconName());
            Marshal_IAThemeConfig.copyImage(string, installFrameConfigurator.getFutureLabelIconName(), installFrameConfigurator.getFutureLabelIconPath(), UPCOMING_ICON);
        } else {
            upcomingStep.setIconImagePath(installFrameConfigurator.getFutureLabelIconPath() + installFrameConfigurator.getFutureLabelIconName());
        }
        upcomingStep.setFontsettings(fontSettingsType3);
        configureLabels.setUpcomingStep(upcomingStep);
        panelImage.setConfigureLabels(configureLabels);
        InstallerStepsConfigType.PanelImage.ConfigureLabels configureLabels2 = objectFactory.createInstallerStepsConfigTypePanelImageConfigureLabels();
        Vector vector2 = installer.getOrderedUnInstallLabels();
        String string3 = Marshal_IAThemeConfig.getLabelList(vector2);
        configureLabels2.setLabelList(string3);
        configureLabels2.setAutoPopulate(((BuildSettings)installer.getBuildSettings()).getAutoPopulateUninstallLabelsOnSave());
        configureLabels2.setTopOfOffset(installFrameConfigurator.getUnInstallerStepTopOffSetValue());
        configureLabels2.setLabelTextWrap(installFrameConfigurator.getAllowUninstallLabelTextToWrap());
        configureLabels2.setAllowVerticalScroll(installFrameConfigurator.getAllowUninstallVerticalScroll());
        configureLabels2.setActiveStep(activeStep);
        configureLabels2.setCompletedStep(completedStep);
        configureLabels2.setUpcomingStep(upcomingStep);
        panelImage.setConfigureUninstallLabels(configureLabels2);
        InstallerStepsConfigType.ProgressLabel progressLabel = objectFactory.createInstallerStepsConfigTypeProgressLabel();
        String string4 = Marshal_IAThemeConfig.getProgressLabelType(installer, installer.getUninstallProgressLabelOption());
        progressLabel.setLabelOption(string4);
        String string5 = IAResourceBundle.getValue("UnInstallerFrame.labelStr1");
        if (installer.getUninstallProgressLabelIndex() >= 0) {
            string5 = Marshal_IAThemeConfig.getProgressLabelSelectToIndex(installer, vector2, installer.getUninstallProgressLabelIndex());
        }
        progressLabel.setLabelToSelect(string5);
        installerStepsConfigType.setProgressUninstallLabel(progressLabel);
        installerStepsConfigType.setPanelImage(panelImage);
        InstallerStepsConfigType.InstallProgressPanel installProgressPanel = objectFactory.createInstallerStepsConfigTypeInstallProgressPanel();
        installProgressPanel.setImageOption(Marshal_IAThemeConfig.getImageOptionChoice(installer));
        if (installer.getInstallProgressImagePath() != null && installer.getInstallProgressImageName() != null) {
            if (string != null) {
                Marshal_IAThemeConfig.copyImage(string, installer.getInstallProgressImageName(), installer.getInstallProgressImagePath(), PROGRESS_IMAGE);
                installProgressPanel.setFilePath(installer.getInstallProgressImageName());
            } else {
                installProgressPanel.setFilePath(installer.getInstallProgressImagePath() + installer.getInstallProgressImageName());
            }
        }
        installerStepsConfigType.setInstallProgressPanel(installProgressPanel);
        InstallerStepsConfigType.ProgressLabel progressLabel2 = objectFactory.createInstallerStepsConfigTypeProgressLabel();
        String string6 = Marshal_IAThemeConfig.getProgressLabelType(installer, installer.getInstallProgressLabelOption());
        progressLabel2.setLabelOption(string6);
        String string7 = Marshal_IAThemeConfig.getProgressLabelSelectToIndex(installer, vector, installer.getInstallProgressLabelIndex());
        progressLabel2.setLabelToSelect(string7);
        installerStepsConfigType.setProgressLabel(progressLabel2);
        iAThemeConfigurationType.setInstallerStepsConfig(installerStepsConfigType);
    }

    public static String getLabelList(Vector vector) {
        Object object = "";
        Enumeration enumeration = vector.elements();
        object = (String)enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            object = (String)object + "," + (String)enumeration.nextElement();
        }
        return object;
    }

    public static String getProgressLabelType(Installer installer, int n) {
        int n2 = n;
        String string = "";
        if (n2 == 3) {
            string = PREVIOUS_LABEL;
        } else if (n2 == 2) {
            string = PRIVATE_LABEL;
        }
        return string;
    }

    public static String getProgressLabelSelectToIndex(Installer installer, Vector vector, int n) {
        int n2 = n;
        String string = "";
        string = n2 < vector.size() && vector.get(n2) != null ? (String)vector.get(n2) : (String)vector.get(0);
        return string;
    }

    public static int getImageOptionChoice(Installer installer) {
        int n = installer.getInstallProgressImageOption();
        int n2 = 0;
        if (n == 1) {
            n2 = 0;
        } else if (n == 3) {
            n2 = 1;
        } else if (n == 0) {
            n2 = 2;
        } else if (n == 2) {
            n2 = 3;
        }
        return n2;
    }

    private static void addDataOfInnerInstallConfig(ObjectFactory objectFactory, IAThemeConfigurationType iAThemeConfigurationType, Installer installer, String string) {
        InstallFrameConfigurator installFrameConfigurator = installer.getInstallFrameConfigurator();
        InnerInstallerConfigType innerInstallerConfigType = objectFactory.createInnerInstallerConfigType();
        InnerFrameBGColorSettingsType innerFrameBGColorSettingsType = objectFactory.createInnerFrameBGColorSettingsType();
        innerFrameBGColorSettingsType.setBackgroundColor(installFrameConfigurator.getInstallPanelBackgroundSettings().getBehavior());
        int n = installFrameConfigurator.getInstallPanelBackgroundSettings().getColorRGB();
        innerFrameBGColorSettingsType.setColor(Marshal_IAThemeConfig.getColorStringFormat(n));
        innerInstallerConfigType.setBackgroundcolorsettings(innerFrameBGColorSettingsType);
        innerInstallerConfigType.setPanelborder(installFrameConfigurator.getPanelBorder());
        innerInstallerConfigType.setInnerInstallFrameBorder(installFrameConfigurator.isInnerInstallFrameBorder());
        innerInstallerConfigType.setShowStatusMessage(installFrameConfigurator.isShowStatusMessage());
        innerInstallerConfigType.setShowProgressBar(installFrameConfigurator.isShowProgressBar());
        innerInstallerConfigType.setShowIndeterminateProgressBar(installFrameConfigurator.isShowIndeterminateProgressBar());
        FontSettingsType fontSettingsType = objectFactory.createFontSettingsType();
        fontSettingsType.setFontColor(Marshal_IAThemeConfig.getColorStringFormat(installFrameConfigurator.getFontColorRGB()));
        fontSettingsType.setFontFamily(installFrameConfigurator.getFontName());
        if (string != null) {
            Marshal_IAThemeConfig.exportFont(string, fontSettingsType, installFrameConfigurator.getFontName(), INNER_FRAME);
        }
        fontSettingsType.setFontSize(installFrameConfigurator.getFontSize());
        fontSettingsType.setFontStyle(Marshal_IAThemeConfig.getFontStyle(installFrameConfigurator.getFontStyle()));
        fontSettingsType.setUsedefault(installFrameConfigurator.getUseSystemFontColorRGB());
        innerInstallerConfigType.setFontsettings(fontSettingsType);
        RuntimeButtonConfigType runtimeButtonConfigType = objectFactory.createRuntimeButtonConfigType();
        ColorSettingsType colorSettingsType = objectFactory.createColorSettingsType();
        colorSettingsType.setColor(Marshal_IAThemeConfig.getColorStringFormat(installFrameConfigurator.getRuntimePanelDisabledButtonColor()));
        int n2 = installFrameConfigurator.getRuntimePanelDisabledButtonBehavior();
        boolean bl = true;
        if (n2 == 1) {
            bl = false;
        }
        colorSettingsType.setUsedefault(bl);
        runtimeButtonConfigType.setDisableColorSettings(colorSettingsType);
        ColorSettingsType colorSettingsType2 = objectFactory.createColorSettingsType();
        colorSettingsType2.setColor(Marshal_IAThemeConfig.getColorStringFormat(installFrameConfigurator.getRuntimePanelDisplayButtonColor()));
        int n3 = installFrameConfigurator.getRuntimePanelDisplayButtonBehavior();
        boolean bl2 = true;
        if (n3 == 1) {
            bl2 = false;
        }
        colorSettingsType2.setUsedefault(bl2);
        runtimeButtonConfigType.setDisplayColorSettings(colorSettingsType2);
        ColorSettingsType colorSettingsType3 = objectFactory.createColorSettingsType();
        colorSettingsType3.setColor(Marshal_IAThemeConfig.getColorStringFormat(installFrameConfigurator.getRuntimePanelHoverButtonColor()));
        int n4 = installFrameConfigurator.getRuntimePanelHoverButtonBehavior();
        boolean bl3 = true;
        if (n4 == 1) {
            bl3 = false;
        }
        colorSettingsType3.setUsedefault(bl3);
        runtimeButtonConfigType.setHoverColorSettings(colorSettingsType3);
        ColorSettingsType colorSettingsType4 = objectFactory.createColorSettingsType();
        colorSettingsType4.setColor(Marshal_IAThemeConfig.getColorStringFormat(installFrameConfigurator.getRuntimePanelSelectedButtonColor()));
        int n5 = installFrameConfigurator.getRuntimePanelSelectedButtonBehavior();
        boolean bl4 = true;
        if (n5 == 1) {
            bl4 = false;
        }
        colorSettingsType4.setUsedefault(bl4);
        runtimeButtonConfigType.setSelectColorSettings(colorSettingsType4);
        innerInstallerConfigType.setRuntimeButtonConfig(runtimeButtonConfigType);
        ProgressBarConfigType progressBarConfigType = objectFactory.createProgressBarConfigType();
        ColorSettingsType colorSettingsType5 = objectFactory.createColorSettingsType();
        colorSettingsType5.setColor(Marshal_IAThemeConfig.getColorStringFormat(installFrameConfigurator.getProgressBarColorRGB()));
        colorSettingsType5.setUsedefault(installFrameConfigurator.isUseProgressBarColor());
        progressBarConfigType.setProgressBarColorSettings(colorSettingsType5);
        innerInstallerConfigType.setProgressBarConfig(progressBarConfigType);
        iAThemeConfigurationType.setInnerinstallerconfig(innerInstallerConfigType);
    }

    private static void exportFont(String string, FontSettingsType fontSettingsType, String string2, String string3) {
        if (!FontChooserImporter.isDefaultFontSelected(string2)) {
            String string4 = FontChooserImporter.IA_FONT_DIR + File.separator + string2.trim() + FONT_FILE_FORMAT;
            try {
                Marshal_IAThemeConfig.copyFont(string, string2, string4, string3);
            }
            catch (Exception exception) {
                fontSettingsType.setFontFamily(Flexeraare.bu.getFamily());
            }
        } else {
            File file;
            File file2 = new File(string + File.separator + FONTS);
            if (file2.exists() && (file = new File(file2.getAbsolutePath() + File.separator + string3)).exists()) {
                Marshal_IAThemeConfig.deleteFileOrDirectory(file);
            }
        }
    }

    private static void copyFont(String string, String string2, String string3, String string4) throws FileNotFoundException, IOException {
        File file = new File(string + File.separator + FONTS);
        if (!file.exists()) {
            file.mkdir();
        }
        File file2 = new File(file.getAbsolutePath() + File.separator + string4);
        File file3 = new File(file2.getAbsolutePath() + File.separator + string2.trim() + FONT_FILE_FORMAT);
        File file4 = new File(string3);
        if (!file3.getAbsolutePath().equalsIgnoreCase(file4.getAbsolutePath())) {
            if (!file2.exists()) {
                file2.mkdir();
            } else if (Marshal_IAThemeConfig.deleteFileOrDirectory(file2)) {
                file2 = new File(file.getAbsolutePath() + File.separator + string4);
                file2.mkdir();
            }
            Marshal_IAThemeConfig.copyFile(file4, file3);
        }
    }

    public static String getFontStyle(int n) {
        String string = "";
        if (n == 0) {
            string = IAResourceBundle.getValue("Designer.FontChooser.Styles.plain");
        } else if (n == 1) {
            string = IAResourceBundle.getValue("Designer.FontChooser.Styles.bold");
        } else if (n == 2) {
            string = IAResourceBundle.getValue("Designer.FontChooser.Styles.italic");
        } else if (n == 3) {
            string = IAResourceBundle.getValue("Designer.FontChooser.Styles.boldItalic");
        }
        return string;
    }

    public static String getColorStringFormat(int n) {
        Color color = new Color(n);
        String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        return string;
    }

    private static Schema addXSDSchema() {
        Schema schema = null;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schema = schemaFactory.newSchema(new File(THEME_XSD_lOCATION));
        }
        catch (SAXException sAXException) {
            System.err.println("Could not read XSD schema while exporting theme.");
        }
        return schema;
    }
}

