/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.builder;

import com.zerog.ia.installer.BuildServices;
import com.zerog.ia.installer.Builder;
import com.zerog.ia.installer.InstallPiece;
import com.zerog.ia.installer.iseries.i5OSFiles;
import com.zerog.ia.installer.util.ZGPathManager;
import com.zerog.util.ZGUtil;
import java.io.File;

public class i5OSFilesBuilder
implements Builder {
    public static final String ARCHIVE_NOT_FOUND_ERROR = "archiveNotFound";
    public static final String EXISTING_PATH_NOT_SPECIFIED = "existingPathNotSpecified";
    public static final String DESTINATION_RENAME_NOT_SPECIFIED = "destinationRenameNotSpecified";
    public static final String SOURCE_CCSID_NOT_SPECIFIED = "sourceCCSIDNotSpecified";
    public static final String TARGET_CCSID_NOT_SPECIFIED = "targetCCSIDNotSpecified";

    @Override
    public void build(BuildServices buildServices, InstallPiece installPiece) {
        i5OSFiles i5OSFiles2 = (i5OSFiles)installPiece;
        if (i5OSFiles2.getUseInstalledFile()) {
            String string = ZGPathManager.getInstance().getSubstitutedFilePath(i5OSFiles2.getRawSourceFileDir() + File.separator + i5OSFiles2.getSourceFileName());
            File file = new File(string);
            if (file.exists()) {
                buildServices.addResourceFile(file, ZGUtil.makeZipArchivePath(i5OSFiles2.getSourceFileDir(), null));
                i5OSFiles2.setFileSize(file.length());
            } else {
                buildServices.notifyFatalError(installPiece, ARCHIVE_NOT_FOUND_ERROR);
            }
        } else if (i5OSFilesBuilder.aa(i5OSFiles2.getExistingFilePath())) {
            buildServices.notifyFatalError(installPiece, EXISTING_PATH_NOT_SPECIFIED);
        }
        if (i5OSFiles2.getRenames() && i5OSFilesBuilder.aa(i5OSFiles2.getDestinationRename())) {
            buildServices.notifyFatalError(installPiece, DESTINATION_RENAME_NOT_SPECIFIED);
        }
        if (i5OSFiles2.getTextConversion()) {
            if (i5OSFilesBuilder.aa(i5OSFiles2.getSourceCcsid())) {
                buildServices.notifyFatalError(installPiece, SOURCE_CCSID_NOT_SPECIFIED);
            }
            if (i5OSFilesBuilder.aa(i5OSFiles2.getTargetCcsid())) {
                buildServices.notifyFatalError(installPiece, TARGET_CCSID_NOT_SPECIFIED);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean aa(String string) {
        if (string == null) return true;
        if (string == null) return false;
        if (!string.trim().equals("")) return false;
        return true;
    }
}

