/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.builder;

import com.zerog.ia.designer.build.BuildConfiguration;
import com.zerog.ia.designer.build.BuildTarget;
import com.zerog.ia.installer.BuildServices;
import com.zerog.ia.installer.Builder;
import com.zerog.ia.installer.InstallPiece;
import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.actions.MakeExecutable;
import com.zerog.ia.installer.util.IAStatement;
import com.zerog.util.IAResourceBundle;
import java.util.Vector;

public class MakeExecutableBuilder
implements Builder {
    @Override
    public void build(BuildServices buildServices, InstallPiece installPiece) {
        MakeExecutable makeExecutable = (MakeExecutable)installPiece;
        BuildConfiguration buildConfiguration = buildServices.getDefaultBuildConfiguration();
        makeExecutable.setBuildingMacOSXInstallers(buildConfiguration.getEnabledBuildTargets(BuildTarget.MAC_BUILD_PLATFORM).length > 0);
        makeExecutable.setBuildingPureJavaInstallers(buildConfiguration.getEnabledBuildTargets(BuildTarget.PURE_JAVA_BUILD_PLATFORM).length > 0);
        makeExecutable.setBuildingUnixInstallers(buildConfiguration.hasUnixBuildTargets());
        makeExecutable.setBuildingWindowsInstallers(buildConfiguration.getEnabledBuildTargets(BuildTarget.WINDOWS_BUILD_PLATFORM).length > 0);
        makeExecutable.setBuildingWindows64Installers(buildConfiguration.getEnabledBuildTargets(BuildTarget.WINDOWS_PURE_64BIT_BUILD_PLATFORM).length > 0);
        Installer installer = makeExecutable.getInstaller();
        if (makeExecutable.getLauncherVMBehavior() == 0 && this.aa(buildConfiguration)) {
            if (installer.getBundledJREInstall() == 4) {
                IAStatement iAStatement = new IAStatement(IAResourceBundle.getValue("Designer.MakeExecutable.launcherWillTryToUseTheSameVMButItWillNeverBeInstalledSuggestion"));
                iAStatement.setVariable("#LAUNCHER_NAME#", makeExecutable.getDestinationName());
                buildServices.updateStatus(installPiece, "launcherWillTryToUseTheSameVMButItWillNeverBeInstalled", iAStatement.toString());
                buildServices.notifyFatalError(installPiece, "launcherWillTryToUseTheSameVMButItWillNeverBeInstalled", iAStatement.toString());
            } else if (installer.getOnlyInstallBundledVMIfOneNotFoundInSystem()) {
                IAStatement iAStatement = new IAStatement(IAResourceBundle.getValue("Designer.MakeExecutable.launcherWillTryToUseTheSameVMButItMayNotBeInstalledSuggestion"));
                iAStatement.setVariable("#LAUNCHER_NAME#", makeExecutable.getDestinationName());
                buildServices.updateStatus(installPiece, "launcherWillTryToUseTheSameVMButItMayNotBeInstalled", iAStatement.toString());
                buildServices.notifyFatalError(installPiece, "launcherWillTryToUseTheSameVMButItMayNotBeInstalled", iAStatement.toString());
            }
        }
    }

    private boolean aa(BuildConfiguration buildConfiguration) {
        boolean bl = false;
        Vector vector = buildConfiguration.getBuildTargets();
        for (BuildTarget buildTarget : vector) {
            if (!buildTarget.isBuildWithVM()) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

