/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.builder;

import com.zerog.ia.designer.build.BuildSettings;
import com.zerog.ia.installer.BuildServices;
import com.zerog.ia.installer.Builder;
import com.zerog.ia.installer.InstallPiece;
import com.zerog.ia.installer.hosts.JEEHost;
import com.zerog.util.IAResourceBundle;

public class JEEHostBuilder
implements Builder {
    public static final String SERVERPATH_NOT_FOUND_ERROR = "serverpathNotSpecified";
    public static final String CONNAME_NOT_FOUND_ERROR = "connectionNameNotSpecified";
    public static final String SERVERNAME_NOT_FOUND_ERROR = "serverNameNotSpecified";
    public static final String DEPOPTION_NOT_FOUND_ERROR = "deploymentOptionNotSelected";
    public static final String DEPENDENCY_NOT_FOUND_ERROR = "dependencyNotAdded";
    public static final String HEAPSIZE_NOT_SET_ERROR = "requiredHeapSizeNotSet";

    @Override
    public void build(BuildServices buildServices, InstallPiece installPiece) {
        JEEHost jEEHost = (JEEHost)installPiece;
        if (jEEHost.getPassword().length() > 0 && !jEEHost.getAlreadyEncrypted()) {
            jEEHost.setPassword((String)Flexeraakh.aa(jEEHost.getPassword(), jEEHost.getInstaller()));
            jEEHost.setAlreadyEncrypted(true);
        }
        String string = jEEHost.getServerType();
        if (string.equals("websphere")) {
            if (jEEHost.getConnectionName().trim().equals("")) {
                buildServices.notifyFatalError(installPiece, CONNAME_NOT_FOUND_ERROR);
            } else if (!jEEHost.getLocalRemoteWebsphereDeploy() && !jEEHost.getSaveArchiveWebsphere()) {
                buildServices.notifyFatalError(installPiece, DEPOPTION_NOT_FOUND_ERROR);
            } else if (jEEHost.getLocalRemoteWebsphereDeploy()) {
                if (jEEHost.getWebsphereDependencyPath().trim().equals("")) {
                    buildServices.notifyFatalError(installPiece, DEPENDENCY_NOT_FOUND_ERROR);
                } else {
                    try {
                        BuildSettings buildSettings = (BuildSettings)installPiece.getInstaller().getBuildSettings();
                        int n = Integer.parseInt(buildSettings.getMaxHeapSize());
                        String string2 = IAResourceBundle.getValue("Designer.Dashboard.ServerHost.websphereDependencyRequiredHeapSize");
                        int n2 = Integer.parseInt(string2);
                        if (n < n2) {
                            buildServices.notifyFatalError(installPiece, HEAPSIZE_NOT_SET_ERROR);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        } else if (string.equals("tomcat")) {
            if (jEEHost.getServerName().trim().equals("")) {
                buildServices.notifyFatalError(installPiece, SERVERNAME_NOT_FOUND_ERROR);
            } else if (!(jEEHost.getLocalTomcatDeploy() || jEEHost.getRemoteTomcatDeploy() || jEEHost.getTomcatDoNotDeploy())) {
                buildServices.notifyFatalError(installPiece, DEPOPTION_NOT_FOUND_ERROR);
            }
        } else if (jEEHost.getServerPath().equals("")) {
            buildServices.notifyFatalError(installPiece, SERVERPATH_NOT_FOUND_ERROR);
        }
    }
}

